/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.info.callstack;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.database.IResultSet;
import org.tizen.dynamicanalyzer.util.Logger;

public class CallStackUnitDBTable
extends DBTable
implements IResultSet {
    private static final String TABLENAME = "CALL_STACK_UNIT";

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    public CallStackUnitDBTable() {
        this.addColumn(new DBColumn(COLUMN.PID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.FUNCTION_ID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.BINARY_ID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.PC_ADDRESS.name, "NOT NULL", "BIGINT"));
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                prep.setInt(COLUMN.PID.index + 1, (Integer)rowData.get(COLUMN.PID.index));
                prep.setInt(COLUMN.FUNCTION_ID.index + 1, (Integer)rowData.get(COLUMN.FUNCTION_ID.index));
                prep.setInt(COLUMN.BINARY_ID.index + 1, (Integer)rowData.get(COLUMN.BINARY_ID.index));
                prep.setLong(COLUMN.PC_ADDRESS.index + 1, (Long)rowData.get(COLUMN.PC_ADDRESS.index));
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }

    @Override
    public List<Object> extractDataFromResultSet(ResultSet rs) {
        ArrayList<Object> row = new ArrayList<Object>();
        try {
            row.add(rs.getInt(1));
            row.add(rs.getInt(2));
            row.add(rs.getInt(3));
            row.add(rs.getLong(4));
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
            return null;
        }
        return row;
    }

    public static enum COLUMN {
        PID(0, "PID"),
        FUNCTION_ID(1, "FUNCTION_ID"),
        BINARY_ID(2, "BINARY_ID"),
        PC_ADDRESS(3, "PC_ADDRESS");

        public final int index;
        public final String name;

        private COLUMN(int index, String name) {
            this.index = index;
            this.name = name;
        }
    }
}

