/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.interactive;

import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.swap.logparser.DataManagerRegistry;
import org.tizen.dynamicanalyzer.ui.interactive.chart.InteractiveChartView;
import org.tizen.dynamicanalyzer.ui.interactive.data.InteractiveDataManager;
import org.tizen.dynamicanalyzer.ui.interactive.table.InteractiveTableView;
import org.tizen.dynamicanalyzer.ui.timeline.calltrace.CallTraceView;
import org.tizen.dynamicanalyzer.ui.timeline.common.TimelineTableView;
import org.tizen.dynamicanalyzer.widgets.da.view.DABaseComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAContainerComposite;

public class InteractivePage
extends DAContainerComposite {
    public static final String pageID = InteractivePage.class.getName();
    public static final String chartViewID = InteractiveChartView.class.getName();
    public static final String listViewID = InteractiveTableView.class.getName();
    SashForm baseForm;
    SashForm leftForm;
    SashForm rightForm;

    public InteractivePage(Composite parent, int style) {
        super(parent, style);
        this.setTitle(AnalyzerLabels.COOLBAR_AREA_INTERACTIVE);
        this.setBackground(ColorResources.CONFIGURATION_TABLE_COVER_BACKGROUND_COLOR);
        this.setLayout((Layout)new FillLayout());
        this.baseForm = new SashForm((Composite)this, 256);
        this.baseForm.setLayout((Layout)new FillLayout());
        this.baseForm.setForeground(ColorResources.TAB_SELECTED_COLOR_START);
        ((FillLayout)this.getLayout()).marginHeight = 15;
        ((FillLayout)this.getLayout()).marginWidth = 5;
        this.leftForm = new SashForm((Composite)this.baseForm, 512);
        InteractiveChartView chartView = new InteractiveChartView((Composite)this.leftForm, 0);
        this.addView((DABaseComposite)chartView);
        InteractiveTableView tableView = new InteractiveTableView((Composite)this.leftForm, 0);
        this.addView((DABaseComposite)tableView);
        this.leftForm.setWeights(new int[]{60, 40});
        this.rightForm = new SashForm((Composite)this.baseForm, 512);
        CallTraceView apiListView = new CallTraceView((Composite)this.rightForm, 0);
        this.addView((DABaseComposite)apiListView);
        TimelineTableView tabView = new TimelineTableView((Composite)this.rightForm, 0);
        this.addView((DABaseComposite)tabView);
        this.rightForm.setWeights(new int[]{50, 50});
        this.baseForm.setWeights(new int[]{75, 25});
        this.baseForm.setSashWidth(2);
        this.leftForm.setSashWidth(2);
        this.rightForm.setSashWidth(2);
        DataManagerRegistry.registerPageDataManager(InteractiveDataManager.getInstance());
    }

    protected void onResized(int width, int height) {
        int wrate = (int)(25000.0 / (double)width);
        int hrate = (int)(23500.0 / (double)height);
        wrate = wrate > 100 ? 100 : wrate;
        int n = hrate = hrate > 100 ? 100 : hrate;
        if (wrate > 63 || hrate > 100) {
            return;
        }
        this.baseForm.setWeights(new int[]{100 - wrate, wrate});
        this.rightForm.setWeights(new int[]{100 - hrate, hrate});
    }

    public void clear() {
        super.clear();
        InteractiveDataManager.getInstance().clear();
    }
}

