/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.interactive.model;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.ui.interactive.model.VAR_TYPE;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;

public class InteractiveInfo {
    public static final int NO_SET_VARIABLE_ID = -1;
    public static final int CHECK_BEFORE_LINE = 1;
    public static final int CHECK_AFTER_LINE = 2;
    public static final int CHECK_BEFORE_AFTER_LINE = 3;
    public static final int UNSET_FUNC_ID = -1;
    private long beforeVariableID = -1L;
    private long afterVariableID = -1L;
    private VAR_TYPE type;
    private String typeName;
    private String variableName = "";
    private int sourceLineNum = 0;
    private int checkLocation = 1;
    private long sourceLineLowAddress = 0L;
    private long sourceLineHighAddress = 0L;
    private String sourceFileName = "";
    private int pointerOrder = 0;
    private int pointerSize = 4;
    private int arrayCount = 0;
    private int byteSize = 0;
    private int offset = 0;
    private int registerID;
    private long registerOffset;
    private String functionName;
    private int functionID = -1;
    private InteractiveInfo parent;
    private List<InteractiveInfo> children;
    private boolean isTarget = false;

    public int getCheckLocation() {
        return this.checkLocation;
    }

    public void setCheckLocation(int checkLocation) {
        this.checkLocation = checkLocation;
    }

    public boolean hasCheckLocation(int checkLocation) {
        int result = this.checkLocation & checkLocation;
        return result != 0;
    }

    public boolean isTarget() {
        return this.isTarget;
    }

    public void setTarget(boolean isTarget) {
        this.isTarget = isTarget;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public void increasePointerOrder() {
        ++this.pointerOrder;
    }

    public List<InteractiveInfo> getChildren() {
        return this.children;
    }

    public void setChildren(List<InteractiveInfo> children) {
        this.children = children;
    }

    public boolean isString() {
        return this.type == VAR_TYPE.CHAR && this.pointerOrder > 0;
    }

    public int getRegisterID() {
        return this.registerID;
    }

    public void setRegisterID(int registerID) {
        this.registerID = registerID;
    }

    public long getRegisterOffset() {
        return this.registerOffset;
    }

    public void setRegisterOffset(long registerOffset) {
        this.registerOffset = registerOffset;
    }

    public int getFunctionID() {
        if (this.functionID == -1) {
            this.functionID = Global.getFunctionID(this.functionName);
        }
        return this.functionID;
    }

    public void setFunctionID(int functionID) {
        this.functionID = functionID;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public long getVariableID(int checkLocation) {
        switch (checkLocation) {
            case 1: {
                return this.beforeVariableID;
            }
            case 2: {
                return this.afterVariableID;
            }
        }
        Logger.error((Object)"Impossible case!!");
        return -1L;
    }

    public void setVariableID(int checkLocation, long variableID) {
        switch (checkLocation) {
            case 1: {
                this.beforeVariableID = variableID;
                break;
            }
            case 2: {
                this.afterVariableID = variableID;
                break;
            }
            default: {
                Logger.error((Object)"Impossible case!!");
            }
        }
    }

    public VAR_TYPE getType() {
        return this.type;
    }

    public void setType(VAR_TYPE type) {
        this.type = type;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public int getSourceLineNum() {
        return this.sourceLineNum;
    }

    public void setSourceLineNum(int sourceLineNum) {
        this.sourceLineNum = sourceLineNum;
    }

    public long getSourceLineAddress(int checkLocation) {
        switch (checkLocation) {
            case 1: {
                return this.sourceLineLowAddress;
            }
            case 2: {
                return this.sourceLineHighAddress;
            }
        }
        Logger.error((Object)"Impossible case!!");
        return -1L;
    }

    public void setSourceLineAddress(int checkLocation, long sourceLineAddress) {
        switch (checkLocation) {
            case 1: {
                this.sourceLineLowAddress = sourceLineAddress;
                break;
            }
            case 2: {
                this.sourceLineHighAddress = sourceLineAddress;
                break;
            }
            default: {
                Logger.error((Object)"Impossible case!!");
            }
        }
    }

    public String getSourceFileName() {
        return this.sourceFileName;
    }

    public void setSourceFileName(String sourceFileName) {
        this.sourceFileName = sourceFileName;
    }

    public int getPointerOrder() {
        return this.pointerOrder;
    }

    public void setPointerOrder(int pointerOrder) {
        this.pointerOrder = pointerOrder;
    }

    public int getPointerSize() {
        return this.pointerSize;
    }

    public void setPointerSize(int pointerSize) {
        this.pointerSize = pointerSize;
    }

    public int getArrayCount() {
        return this.arrayCount;
    }

    public void setArrayCount(int arrayCount) {
        this.arrayCount = arrayCount;
    }

    public InteractiveInfo getParent() {
        return this.parent;
    }

    public void setParent(InteractiveInfo parent) {
        this.parent = parent;
    }

    public int getByteSize() {
        return this.byteSize;
    }

    public void setByteSize(int byteSize) {
        this.byteSize = byteSize;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getTypeNameWithPointer() {
        String string = this.typeName;
        if (string == null) {
            string = this.type.getName();
        }
        int i = 0;
        while (i < this.pointerOrder) {
            string = String.valueOf(string) + "*";
            ++i;
        }
        return string;
    }

    public String getDescription() {
        String[] splitedSourcePath = AnalyzerUtil.splitFilePath(this.sourceFileName, File.separator);
        String fileName = splitedSourcePath[splitedSourcePath.length - 1];
        if (this.arrayCount > 0) {
            return String.valueOf(this.getTypeNameWithPointer()) + " " + this.getVariableName() + " [" + this.arrayCount + "]  (" + fileName + " : " + this.sourceLineNum + ")";
        }
        return String.valueOf(this.getTypeNameWithPointer()) + " " + this.getVariableName() + "  (" + fileName + " : " + this.sourceLineNum + ")";
    }

    public boolean isStructType() {
        return this.type == VAR_TYPE.STRUCT;
    }

    public boolean isArray() {
        return this.arrayCount > 0;
    }

    public boolean isPointerType() {
        return this.pointerOrder > 0;
    }

    public boolean isPointerArray() {
        return this.isArray() && this.isPointerType();
    }

    public void getAllRelatedVariableIDs(List<Long> variableIDList, int checkLocation) {
        switch (checkLocation) {
            case 1: {
                variableIDList.add(this.beforeVariableID);
                break;
            }
            case 2: {
                variableIDList.add(this.afterVariableID);
                break;
            }
            case 3: {
                variableIDList.add(this.beforeVariableID);
                variableIDList.add(this.afterVariableID);
                break;
            }
            default: {
                Logger.error((Object)"Impossible case!!");
            }
        }
        if (this.children != null) {
            int i = 0;
            while (i < this.children.size()) {
                this.children.get(i).getAllRelatedVariableIDs(variableIDList, checkLocation);
                ++i;
            }
        }
    }

    public boolean hasVariableID(long variableID) {
        if (variableID == -1L) {
            return false;
        }
        return this.beforeVariableID == variableID || this.afterVariableID == variableID;
    }

    public List<Long> getChildrenIDs() {
        ArrayList<Long> variableIDList = new ArrayList<Long>();
        if (this.children != null) {
            int i = 0;
            while (i < this.children.size()) {
                long beforeVariableID = this.children.get(i).getVariableID(1);
                long afterVariableID = this.children.get(i).getVariableID(2);
                if (beforeVariableID != -1L) {
                    variableIDList.add(beforeVariableID);
                }
                if (afterVariableID != -1L) {
                    variableIDList.add(afterVariableID);
                }
                ++i;
            }
        }
        return variableIDList;
    }

    public boolean hasChild(long variableID, int checkLocation) {
        if (this.children != null) {
            int i = 0;
            while (i < this.children.size()) {
                if (variableID == this.children.get(i).getVariableID(checkLocation)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

