/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.kernel;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.nl.KernelPageLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.ui.kernel.KernelListTable;
import org.tizen.dynamicanalyzer.ui.kernel.data.KernelSelectionData;
import org.tizen.dynamicanalyzer.ui.widgets.table.WindowingTableColumnSizePackListener;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class KernelListView
extends DAViewComposite {
    private String[] columnNames = new String[]{KernelPageLabels.KERNEL_LIST_VIEW_INDEX, KernelPageLabels.KERNEL_LIST_VIEW_PID, KernelPageLabels.KERNEL_LIST_VIEW_TID, KernelPageLabels.KERNEL_LIST_VIEW_CORE, KernelPageLabels.KERNEL_LIST_VIEW_START_TIME, KernelPageLabels.KERNEL_LIST_VIEW_END_TIME, KernelPageLabels.KERNEL_LIST_VIEW_EXECUTION_TIME, KernelPageLabels.KERNEL_LIST_VIEW_START_PC, KernelPageLabels.KERNEL_LIST_VIEW_END_PC, KernelPageLabels.KERNEL_LIST_VIEW_FUNCTION};
    private int[] columnSizes = new int[]{40, 40, 40, 65, 80, 80, 100, 100, 100, 250};
    private int[] columnAlignment = new int[]{131072, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384};
    int[] sortTypes = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 2};
    private boolean[] columnVisibility_core;
    private boolean[] columnVisibility_function;
    KernelListTable tableComp;

    public KernelListView(Composite parent, int style) {
        super(parent, style, false);
        boolean[] blArray = new boolean[10];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        blArray[5] = true;
        blArray[6] = true;
        blArray[7] = true;
        blArray[8] = true;
        this.columnVisibility_core = blArray;
        this.columnVisibility_function = new boolean[]{true, true, true, true, true, true, true, true, true, true};
        this.tableComp = null;
        this.setLayout((Layout)new FillLayout());
        this.setTitle(KernelPageLabels.KERNEL_LIST_VIEW_NAME);
        Composite contents = this.getContentArea();
        contents.setBackground(ColorResources.WINDOW_BG_COLOR);
        contents.setLayout((Layout)new FillLayout());
        this.tableComp = new KernelListTable(contents, 0, 67586);
        this.tableComp.setSortTypes(this.sortTypes);
        this.tableComp.setColumnAlignment(this.columnAlignment);
        this.tableComp.setColumns(this.columnNames);
        this.tableComp.setColumnSize(this.columnSizes);
        this.tableComp.setColumnVisibility(this.columnVisibility_function);
        this.tableComp.setTableToolTipEnable(false);
        contents.addControlListener((ControlListener)new WindowingTableColumnSizePackListener(this.tableComp, this.columnSizes));
    }

    public void updateView(DAViewData data) {
        if (data instanceof DASelectionData) {
            DASelectionData selData = (DASelectionData)data;
            long start = selData.getStartTime();
            long end = selData.getEndTime();
            Object odata = selData.getData();
            if (odata instanceof KernelSelectionData) {
                KernelSelectionData sdata = (KernelSelectionData)odata;
                boolean isCore = sdata.getType() == 1;
                this.tableComp.setSelectedData(sdata.getData(), isCore);
                if (isCore) {
                    this.tableComp.setColumnVisibility(this.columnVisibility_core);
                } else {
                    this.tableComp.setColumnVisibility(this.columnVisibility_function);
                }
                this.tableComp.updateTable();
            }
            this.tableComp.setSelectionByTime(start, end);
            this.tableComp.updateTable();
        }
    }

    public void updateView() {
        this.tableComp.updateTable();
    }

    public void clear() {
        this.tableComp.getTable().removeAll();
        this.tableComp.clear();
    }

    public Control getControl() {
        return this.tableComp;
    }
}

