/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.kernel;

import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.shortcut.ShortCutManager;
import org.tizen.dynamicanalyzer.ui.kernel.CallFlowChartView;
import org.tizen.dynamicanalyzer.ui.kernel.ContextSwitchingChartView;
import org.tizen.dynamicanalyzer.ui.kernel.KernelListView;
import org.tizen.dynamicanalyzer.ui.kernel.KernelStatisticInfoView;
import org.tizen.dynamicanalyzer.ui.kernel.data.KernelDataManager;
import org.tizen.dynamicanalyzer.ui.timeline.common.TimelineTableView;
import org.tizen.dynamicanalyzer.widgets.da.view.DABaseComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAContainerComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DATabComposite;

public class KernelPage
extends DAContainerComposite {
    public static final String pageID = KernelPage.class.getName();
    public static final String contextViewID = ContextSwitchingChartView.class.getName();
    public static final String callflowTabID = "CallFlowTab.id";
    public static final String callflowViewID = CallFlowChartView.class.getName();
    public static final String listViewID = KernelListView.class.getName();
    public static final String statViewID = KernelStatisticInfoView.class.getName();
    SashForm baseForm;
    SashForm leftForm;
    SashForm rightForm;

    public KernelPage(Composite parent, int style) {
        super(parent, style);
        this.setTitle(AnalyzerLabels.COOLBAR_AREA_KERNEL);
        this.setData("tooltip", ShortCutManager.COOLBAR_AREA_KERNEL_TOOLTIP);
        this.setBackground(ColorResources.CONFIGURATION_TABLE_COVER_BACKGROUND_COLOR);
        this.setLayout((Layout)new FillLayout());
        this.baseForm = new SashForm((Composite)this, 256);
        this.baseForm.setLayout((Layout)new FillLayout());
        this.baseForm.setForeground(ColorResources.TAB_SELECTED_COLOR_START);
        ((FillLayout)this.getLayout()).marginHeight = 15;
        ((FillLayout)this.getLayout()).marginWidth = 5;
        this.leftForm = new SashForm((Composite)this.baseForm, 512);
        ContextSwitchingChartView kernelChartView = new ContextSwitchingChartView((Composite)this.leftForm, 0);
        this.addView((DABaseComposite)kernelChartView);
        DATabComposite lefttabView = new DATabComposite((Composite)this.leftForm, 0, false);
        this.addView(callflowTabID, (DABaseComposite)lefttabView);
        CallFlowChartView callflowView = new CallFlowChartView(lefttabView.getContentComposite(), 0);
        lefttabView.addView((DABaseComposite)callflowView, false);
        KernelListView kernelListView = new KernelListView(lefttabView.getContentComposite(), 0);
        lefttabView.addView((DABaseComposite)kernelListView, false);
        this.leftForm.setWeights(new int[]{60, 40});
        this.rightForm = new SashForm((Composite)this.baseForm, 512);
        KernelStatisticInfoView statInfo = new KernelStatisticInfoView((Composite)this.rightForm, 0);
        this.addView((DABaseComposite)statInfo);
        TimelineTableView tabView = new TimelineTableView((Composite)this.rightForm, 0);
        this.addView((DABaseComposite)tabView);
        this.rightForm.setWeights(new int[]{50, 50});
        this.baseForm.setWeights(new int[]{75, 25});
    }

    protected void onResized(int width, int height) {
        int wrate = (int)(25000.0 / (double)width);
        int hrate = (int)(23500.0 / (double)height);
        wrate = wrate > 100 ? 100 : wrate;
        int n = hrate = hrate > 100 ? 100 : hrate;
        if (wrate > 63 || hrate > 100) {
            return;
        }
        this.baseForm.setWeights(new int[]{100 - wrate, wrate});
        this.rightForm.setWeights(new int[]{100 - hrate, hrate});
    }

    public void clear() {
        super.clear();
        KernelDataManager.getInstance().clear();
    }
}

