/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.network.data;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.database.SqlConnectionManager;
import org.tizen.dynamicanalyzer.ui.network.data.type.NetworkAPIType;
import org.tizen.dynamicanalyzer.util.Logger;

public class NetworkAPIDBManager
extends DBTable {
    public static final String TABLENAME = "NETWORK_API";
    private static final String DBTYPE_TEXT = "VARCHAR(256)";
    private static final String DBTYPE_BIGTEXT = "VARCHAR(1024)";
    public static final String SEQ = "SEQUENCE_NUMBER";
    public static final String DESTINATION_ADDRESS = "DESTINATION_ADDRESS";
    public static final String FD_VALUE = "NETWORK_FD";
    public static final String API_TIME = "API_TIME";
    public static final String API_NAME_ID = "API_ID";
    public static final String ERRNO = "ERROR_NUMBER";
    public static final String PID = "PID";
    public static final String TID = "TID";
    public static final String ARGUMENT = "ARGUMENT";
    public static final String RETURN = "RETURN_VALUE";
    public static final String BYTE_SIZE = "BYTE_SIZE";
    public static final String PAYLOAD = "PAYLOAD";
    public static final String API_TYPE = "API_TYPE";
    public static final String CALLER_PC_ADDRESS = "CALLER_PC_ADDRESS";
    public static final String LIB_NAME = "CALLER_LIBRARY_NAME";
    public static final int DB_SEQ_INDEX = 0;
    public static final int DB_DESTINATION_ADDRESS_INDEX = 1;
    public static final int DB_FD_VALUE_INDEX = 2;
    public static final int DB_API_TIME_INDEX = 3;
    public static final int DB_API_NAME_ID_INDEX = 4;
    public static final int DB_ERRNO_INDEX = 5;
    public static final int DB_PID_INDEX = 6;
    public static final int DB_TID_INDEX = 7;
    public static final int DB_ARGUMENT_INDEX = 8;
    public static final int DB_RETURN_INDEX = 9;
    public static final int DB_BYTE_SIZE_INDEX = 10;
    public static final int DB_PAYLOAD_INDEX = 11;
    public static final int DB_API_TYPE_INDEX = 12;
    public static final int DB_CALLER_PC_ADDRESS_INDEX = 13;
    public static final int DB_LIB_NAME_INDEX = 14;
    private static final String SELECT_API_SERIES_QUERY = "select SEQUENCE_NUMBER,DESTINATION_ADDRESS,NETWORK_FD,API_TIME,API_ID,ERROR_NUMBER from NETWORK_API where API_TIME BETWEEN %s and %s";
    private static final String SELECT_API_TABLE_CHILD_QUERY = "select SEQUENCE_NUMBER,DESTINATION_ADDRESS,NETWORK_FD,API_TIME,API_ID,ERROR_NUMBER,PID,TID,ARGUMENT,RETURN_VALUE,BYTE_SIZE,PAYLOAD,API_TYPE,CALLER_PC_ADDRESS,CALLER_LIBRARY_NAME from NETWORK_API where DESTINATION_ADDRESS = '%s' and NETWORK_FD = '%s'";
    private static final String SELECT_API_TABLE_PARENT_QUERY = "select SEQUENCE_NUMBER,DESTINATION_ADDRESS,NETWORK_FD,API_TIME,API_ID,ERROR_NUMBER,PID,TID,ARGUMENT,RETURN_VALUE,BYTE_SIZE,PAYLOAD,API_TYPE,CALLER_PC_ADDRESS,CALLER_LIBRARY_NAME from NETWORK_API where DESTINATION_ADDRESS = '%s'";

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    public NetworkAPIDBManager() {
        this.addColumn(new DBColumn(SEQ, "PRIMARY KEY", "BIGINT"));
        this.addColumn(new DBColumn(DESTINATION_ADDRESS, "NOT NULL", DBTYPE_BIGTEXT));
        this.addColumn(new DBColumn(FD_VALUE, "NOT NULL", DBTYPE_TEXT));
        this.addColumn(new DBColumn(API_TIME, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(API_NAME_ID, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(ERRNO, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(PID, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(TID, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(ARGUMENT, "NOT NULL", DBTYPE_BIGTEXT));
        this.addColumn(new DBColumn(RETURN, "NOT NULL", DBTYPE_BIGTEXT));
        this.addColumn(new DBColumn(BYTE_SIZE, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(PAYLOAD, "NOT NULL", DBTYPE_BIGTEXT));
        this.addColumn(new DBColumn(API_TYPE, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(CALLER_PC_ADDRESS, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(LIB_NAME, "NOT NULL", "INTEGER"));
        this.setIndexColumn(3);
    }

    public void insert(List<List<Object>> insetData) {
        this.insertData(insetData);
    }

    public List<NetworkAPIType> selectAPISeries(double visibleStartTime, double visibleEndTime) {
        double selectStartTime = visibleStartTime * 1000000.0;
        double selectEndTime = visibleEndTime * 1000000.0;
        String query = String.format(SELECT_API_SERIES_QUERY, selectStartTime, selectEndTime);
        ResultSet rs = SqlConnectionManager.executeQueryRS(query);
        if (rs == null) {
            SqlConnectionManager.releaseResultSet(rs);
            return null;
        }
        ArrayList<NetworkAPIType> returnValue = new ArrayList<NetworkAPIType>();
        try {
            while (rs.next()) {
                NetworkAPIType data = new NetworkAPIType();
                data.setSeq(rs.getLong(1));
                data.setDestinationAddress(rs.getString(2));
                data.setFdStr(rs.getString(3));
                data.setTime(rs.getLong(4));
                data.setApiId(rs.getInt(5));
                data.setErrNo(rs.getLong(6));
                returnValue.add(data);
            }
            SqlConnectionManager.releaseResultSet(rs);
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
        }
        return returnValue;
    }

    public List<NetworkAPIType> selectAPITable(String address, String fd, boolean isParentChart, List<String> whereClause) {
        ResultSet rs;
        String query = null;
        query = isParentChart ? String.format(SELECT_API_TABLE_PARENT_QUERY, address.trim()) : String.format(SELECT_API_TABLE_CHILD_QUERY, address.trim(), fd.trim());
        if (whereClause != null && whereClause.size() > 0) {
            int i = 0;
            while (i < whereClause.size()) {
                query = String.valueOf(query) + " and " + whereClause.get(i);
                ++i;
            }
        }
        if ((rs = SqlConnectionManager.executeQueryRS(query)) == null) {
            SqlConnectionManager.releaseResultSet(rs);
            return null;
        }
        ArrayList<NetworkAPIType> returnValue = new ArrayList<NetworkAPIType>();
        try {
            while (rs.next()) {
                NetworkAPIType data = new NetworkAPIType();
                data.setSeq(rs.getLong(1));
                data.setDestinationAddress(rs.getString(2));
                data.setFdStr(rs.getString(3));
                data.setTime(rs.getLong(4));
                data.setApiId(rs.getInt(5));
                data.setErrNo(rs.getLong(6));
                data.setPid(rs.getInt(7));
                data.setTid(rs.getInt(8));
                data.setArgs(rs.getString(9));
                data.setReturn(rs.getString(10));
                data.setPacketMessageSize(rs.getInt(11));
                data.setPacketMessage(rs.getString(12));
                data.setFdApiType(rs.getInt(13));
                data.setCallerAddress(rs.getLong(14));
                data.setBinaryId(rs.getInt(15));
                returnValue.add(data);
            }
            SqlConnectionManager.releaseResultSet(rs);
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
        }
        return returnValue;
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                prep.setLong(1, (Long)rowData.get(0));
                prep.setString(2, (String)rowData.get(1));
                prep.setString(3, (String)rowData.get(2));
                prep.setLong(4, (Long)rowData.get(3));
                prep.setInt(5, (Integer)rowData.get(4));
                prep.setLong(6, (Long)rowData.get(5));
                prep.setInt(7, (Integer)rowData.get(6));
                prep.setInt(8, (Integer)rowData.get(7));
                prep.setString(9, (String)rowData.get(8));
                prep.setString(10, (String)rowData.get(9));
                prep.setInt(11, (Integer)rowData.get(10));
                prep.setString(12, (String)rowData.get(11));
                prep.setInt(13, (Integer)rowData.get(12));
                prep.setLong(14, (Long)rowData.get(13));
                prep.setInt(15, (Integer)rowData.get(14));
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }
}

