/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.opengl.data.DB;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.database.SqlConnectionManager;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLBufferSizeType;
import org.tizen.dynamicanalyzer.util.Logger;

public class GLBufferSizeDBTableManager
extends DBTable {
    private static final String TABLENAME = "GL_BUFFER_SIZE";
    private static final String SEQ = "SEQUENCE_NUMBER";
    private static final String CONTEXT_ID = "CONTEXT_ID";
    private static final String ARRAY_BUFFER_SIZE = "ARRAY_BUFFER_SIZE";
    private static final String ARRAY_BUFFER_USAGE = "ARRAY_BUFFER_USAGE";
    private static final String ELEMENT_ARRAY_BUFFER_SIZE = "ELEMENT_ARRAY_BUFFER_SIZE";
    private static final String ELEMENT_ARRAY_BUFFER_USAGE = "ELEMENT_ARRAY_BUFFER_USAGE";
    public static final int TABLE_SEQ_ID_INDEX = 0;
    public static final int TABLE_CONTEXT_ID_INDEX = 1;
    public static final int TABLE_ARRARY_BUFFER_SIZE_INDEX = 2;
    public static final int TABLE_ARRARY_BUFFER_USAGE_INDEX = 3;
    public static final int TABLE_ELEMENT_ARRARY_BUFFER_SIZE_INDEX = 4;
    public static final int TABLE_ELEMENT_ARRARY_BUFFER_USAGE_INDEX = 5;
    public static final int SELECT_ARRARY_BUFFER_SIZE_INDEX = 0;
    public static final int SELECT_ARRARY_BUFFER_USAGE_INDEX = 1;
    public static final int SELECT_ELEMENT_ARRARY_BUFFER_SIZE_INDEX = 2;
    public static final int SELECT_ELEMENT_ARRARY_BUFFER_USAGE_INDEX = 3;
    private static final String SELECT = "select ARRAY_BUFFER_SIZE,ARRAY_BUFFER_USAGE,ELEMENT_ARRAY_BUFFER_SIZE,ELEMENT_ARRAY_BUFFER_USAGE from GL_BUFFER_SIZE where CONTEXT_ID ='%s' and SEQUENCE_NUMBER = (select MAX(SEQUENCE_NUMBER) from GL_BUFFER_SIZE where SEQUENCE_NUMBER <= %s)";

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    public GLBufferSizeDBTableManager() {
        this.addColumn(new DBColumn(SEQ, "PRIMARY KEY", "BIGINT"));
        this.addColumn(new DBColumn(CONTEXT_ID, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(ARRAY_BUFFER_SIZE, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(ARRAY_BUFFER_USAGE, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(ELEMENT_ARRAY_BUFFER_SIZE, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(ELEMENT_ARRAY_BUFFER_USAGE, "NOT NULL", "INTEGER"));
        this.setIndexColumn(1);
    }

    public GLBufferSizeType getBufferSize(long contextID, long selectedSeq) {
        String query = String.format(SELECT, contextID, selectedSeq);
        ResultSet rs = SqlConnectionManager.executeQueryRS(query);
        if (rs == null) {
            SqlConnectionManager.releaseResultSet(rs);
            return null;
        }
        int arrayBufferSize = 0;
        int arrayBufferUsage = 0;
        int elementArrayBufferSize = 0;
        int elementArrayBufferUsage = 0;
        try {
            while (rs.next()) {
                arrayBufferSize += rs.getInt(1);
                arrayBufferUsage += rs.getInt(2);
                elementArrayBufferSize += rs.getInt(3);
                elementArrayBufferUsage += rs.getInt(4);
            }
            SqlConnectionManager.releaseResultSet(rs);
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
        }
        return new GLBufferSizeType(arrayBufferSize, arrayBufferUsage, elementArrayBufferSize, elementArrayBufferUsage);
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                prep.setLong(1, (Long)rowData.get(0));
                prep.setLong(2, (Long)rowData.get(1));
                prep.setInt(3, (Integer)rowData.get(2));
                prep.setInt(4, (Integer)rowData.get(3));
                prep.setInt(5, (Integer)rowData.get(4));
                prep.setInt(6, (Integer)rowData.get(5));
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }
}

