/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.summary.profiling;

import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.ui.info.callstack.CallStackUnit;
import org.tizen.dynamicanalyzer.ui.summary.profiling.ProfileDataMaker;
import org.tizen.dynamicanalyzer.ui.summary.profiling.ProfilingChildData;

public class ProfilingData {
    public static final int DATA_FIELD_SIZE = 10;
    public static final int SEQUENCE_INDEX = 0;
    public static final int PID_INDEX = 1;
    public static final int NAME_INDEX = 2;
    public static final int EXCOUNT_INDEX = 3;
    public static final int INCOUNT_INDEX = 4;
    public static final int CALLCOUNT_INDEX = 5;
    public static final int PARENT_INDEX = 6;
    public static final int KEY_INDEX = 7;
    public static final int INCL_ELAPSED_TIME_INDEX = 8;
    public static final int EXCL_ELAPSED_TIME_INDEX = 9;
    public static final byte TYPE_APPLICATION = 0;
    public static final byte TYPE_DEPENDENTLIBRARY = 1;
    public static final byte TYPE_FUNCTION = 2;
    public static final byte TYPE_LIBRARY = 3;
    private static int internalSeq = 0;
    private int profilingDataID = -1;
    private String name = null;
    private int exCount = 0;
    private int inCount = 0;
    private int callCount = 0;
    private String parent = null;
    private String key = null;
    private ProfilingChildData children = null;
    private long inElapsedTime = 0L;
    private long lastExeTime = 0L;
    private long exElapsedTime = 0L;
    private int lastSampleID = -1;
    private int functionId = -1;
    private ProfileDataMaker profiler = null;

    public ProfilingData(CallStackUnit inputData, boolean isParent, ProfileDataMaker profiler) {
        if (isParent) {
            this.name = inputData.getPath();
        } else {
            this.name = inputData.getFunctionName();
            this.functionId = inputData.getFunctionId();
        }
        this.profilingDataID = internalSeq++;
        this.key = inputData.getSymbol();
        this.profiler = profiler;
    }

    public ProfilingChildData getChildData() {
        if (this.children == null) {
            this.children = new ProfilingChildData(Integer.toString(this.profilingDataID), this.profiler.getPid());
            this.profiler.getChildListMap().put(Integer.toString(this.profilingDataID), this.children);
        }
        return this.children;
    }

    public ProfilingData(int profilingDataID, String name, int exCount, int inCount, int callCount, long inElapsedTime, long exElapsedTime, ProfileDataMaker profiler) {
        this.profilingDataID = profilingDataID;
        this.name = name;
        this.exCount = exCount;
        this.inCount = inCount;
        this.callCount = callCount;
        this.inElapsedTime = inElapsedTime;
        this.exElapsedTime = exElapsedTime;
        this.profiler = profiler;
    }

    public void addChild(ProfilingData child) {
        int childID = child.getProfilingDataID();
        this.getChildData().getChildren().add(childID);
    }

    public ProfileDataMaker getProfileDataMaker() {
        return this.profiler;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String parentKey) {
        this.parent = parentKey;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getExCount() {
        List<Integer> childIDs = this.getChildData().getChildren();
        if (childIDs.isEmpty()) {
            return this.exCount;
        }
        int size = childIDs.size();
        int count = 0;
        int i = 0;
        while (i < size) {
            ProfilingData data = this.profiler.getProfilingDataMap().get(childIDs.get(i));
            if (data != null) {
                count += data.getExCount();
            }
            ++i;
        }
        return this.exCount + count;
    }

    public int getSelfExCount() {
        return this.exCount;
    }

    public void addExCount() {
        ++this.exCount;
    }

    public int getInCount() {
        return this.inCount;
    }

    public void addInCount(int sampleID) {
        if (sampleID == this.lastSampleID) {
            return;
        }
        ++this.inCount;
        this.lastSampleID = sampleID;
    }

    public int getCallCount() {
        return this.callCount;
    }

    public void addCallCount() {
        ++this.callCount;
    }

    public void addElapsedTime(long time) {
        this.lastExeTime = time;
        this.inElapsedTime += time;
    }

    public long getElapsedTime() {
        return this.inElapsedTime;
    }

    public long getLastElapsedTime() {
        return this.lastExeTime;
    }

    public void addExclusiveElapsedTime(long time) {
        this.exElapsedTime += time;
    }

    public long getExclusiveElapsedTime() {
        return this.exElapsedTime;
    }

    public boolean isParent() {
        return !this.getChildData().getChildren().isEmpty();
    }

    public int getProfilingDataID() {
        return this.profilingDataID;
    }

    public int getFunctionId() {
        return this.functionId;
    }

    public static void clear() {
        internalSeq = 0;
    }

    public List<ProfilingData> getChildList() {
        ArrayList<ProfilingData> output = new ArrayList<ProfilingData>();
        List<Integer> childIDs = this.getChildData().getChildren();
        int i = 0;
        while (i < childIDs.size()) {
            ProfilingData child = this.profiler.getProfilingDataMap().get(childIDs.get(i));
            if (child != null) {
                output.add(child);
            }
            ++i;
        }
        return output;
    }
}

