/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.summary.warning;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.database.IResultSet;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.swap.model.data.ProbeCommonData;
import org.tizen.dynamicanalyzer.ui.summary.SummaryDataManager;
import org.tizen.dynamicanalyzer.ui.summary.warning.WarningCase;
import org.tizen.dynamicanalyzer.ui.summary.warning.WarningDataDBTable;
import org.tizen.dynamicanalyzer.util.Logger;

public class WarningDataMaker {
    private static int warningSeq = 1;
    private static final String query_withKeyAndCase_1 = "where %s = '";
    private static final String query_withKeyAndCase_2 = "' and %s = %s";
    private static final String query_withSeq = "where %s = %s";
    private static final String query_withTime = "where %s >= %s and %s <= %s order by %s";
    private ArrayList<List<Object>> warningDataList = new ArrayList();
    private WarningDataDBTable warningDBTable = null;

    public WarningDataMaker(WarningDataDBTable inserter) {
        this.warningDBTable = inserter;
    }

    public void insertDBWhenSave() {
        if (this.warningDataList.size() > 0) {
            List wList = (List)this.warningDataList.clone();
            this.warningDataList.clear();
            this.warningDBTable.insertData(wList);
        }
    }

    public void selectDBWhenOpen() {
        this.warningDataList.clear();
        this.warningDataList = (ArrayList)this.getWarningDataFromDB();
    }

    public ArrayList<List<Object>> getWarningDataList() {
        return this.warningDataList;
    }

    public boolean removeData(LogData input, String key, int type) {
        int size = this.warningDataList.size();
        int i = 0;
        while (i < size) {
            String fileKey = (String)this.warningDataList.get(i).get(WarningDataDBTable.COLUMN.WARNING_KEY.index);
            int warningType = (Integer)this.warningDataList.get(i).get(WarningDataDBTable.COLUMN.WARNING_CASE.index);
            if (key.equals(fileKey) && warningType == type) {
                ProbeCommonData pData = (ProbeCommonData)input;
                this.warningDataList.get(i).set(WarningDataDBTable.COLUMN.END_TIME.index, pData.getTime());
                return true;
            }
            ++i;
        }
        return false;
    }

    public void makeData(List<LogData> inputs, String key, int warningCase) {
        int size = inputs.size();
        int i = 0;
        while (i < size) {
            LogData input = inputs.get(i);
            ProbeCommonData pData = (ProbeCommonData)input;
            if (!this.sameWarningDataChecker(key, warningCase)) {
                ArrayList<Object> dbWarningData = new ArrayList<Object>();
                dbWarningData.add(warningSeq++);
                dbWarningData.add(pData.getSeq());
                dbWarningData.add(pData.getMsgID());
                dbWarningData.add(pData.getPid());
                dbWarningData.add(pData.getTid());
                dbWarningData.add(pData.getTime());
                dbWarningData.add(-1L);
                dbWarningData.add(warningCase);
                dbWarningData.add(String.valueOf(key));
                dbWarningData.add(pData.getCallerPcAddr());
                dbWarningData.add(String.valueOf(pData.getLibName()));
                this.warningDataList.add(dbWarningData);
            }
            ++i;
        }
    }

    public void add(LogData input, String key, int warningCase) {
        ProbeCommonData pData = (ProbeCommonData)input;
        if (!this.sameWarningDataChecker(key, warningCase)) {
            ArrayList<Object> dbWarningData = new ArrayList<Object>();
            dbWarningData.add(warningSeq++);
            dbWarningData.add(pData.getSeq());
            dbWarningData.add(pData.getMsgID());
            dbWarningData.add(pData.getPid());
            dbWarningData.add(pData.getTid());
            dbWarningData.add(pData.getTime());
            dbWarningData.add(-1L);
            dbWarningData.add(warningCase);
            dbWarningData.add(String.valueOf(key));
            dbWarningData.add(pData.getCallerPcAddr());
            dbWarningData.add(String.valueOf(pData.getLibName()));
            this.warningDataList.add(dbWarningData);
        }
    }

    private boolean sameWarningDataChecker(String key, int warningCase) {
        String where = String.format(query_withKeyAndCase_1, WarningDataDBTable.COLUMN.WARNING_KEY.name);
        where = String.valueOf(where) + key;
        where = String.valueOf(where) + String.format(query_withKeyAndCase_2, WarningDataDBTable.COLUMN.WARNING_CASE.name, warningCase);
        ArrayList<String> columns = new ArrayList<String>();
        columns.add(WarningDataDBTable.COLUMN.WARNING_KEY.name);
        columns.add(WarningDataDBTable.COLUMN.WARNING_CASE.name);
        DBTable table = SummaryDataManager.getInstance().getWarningDataDBTable();
        List<List<Object>> warningList = table.selectData(columns, where, new IResultSet(){

            @Override
            public List<Object> extractDataFromResultSet(ResultSet rs) {
                ArrayList<Object> row = new ArrayList<Object>();
                try {
                    row.add(rs.getString(1));
                    row.add(rs.getInt(2));
                }
                catch (SQLException e) {
                    Logger.exception((Throwable)e);
                    return null;
                }
                return row;
            }
        });
        if (warningList != null) {
            return warningList.size() > 0;
        }
        return false;
    }

    public void clear() {
        this.warningDataList.clear();
        warningSeq = 1;
    }

    public List<List<Object>> getWarningDataFromDB() {
        DBTable table = SummaryDataManager.getInstance().getWarningDataDBTable();
        ArrayList<String> columns = new ArrayList<String>();
        columns.add(WarningDataDBTable.COLUMN.RID.name);
        columns.add(WarningDataDBTable.COLUMN.SEQUENCE_NUMBER.name);
        columns.add(WarningDataDBTable.COLUMN.MESSAGE_ID.name);
        columns.add(WarningDataDBTable.COLUMN.PID.name);
        columns.add(WarningDataDBTable.COLUMN.TID.name);
        columns.add(WarningDataDBTable.COLUMN.START_TIME.name);
        columns.add(WarningDataDBTable.COLUMN.END_TIME.name);
        columns.add(WarningDataDBTable.COLUMN.WARNING_CASE.name);
        columns.add(WarningDataDBTable.COLUMN.WARNING_KEY.name);
        columns.add(WarningDataDBTable.COLUMN.CALLER_PC_ADDRESS.name);
        columns.add(WarningDataDBTable.COLUMN.CALLER_LIBRARY_NAME.name);
        return table.selectData(columns, null, new IResultSet(){

            @Override
            public List<Object> extractDataFromResultSet(ResultSet rs) {
                ArrayList<Object> row = new ArrayList<Object>();
                try {
                    row.add(rs.getInt(1));
                    row.add(rs.getLong(2));
                    row.add(rs.getInt(3));
                    row.add(rs.getInt(4));
                    row.add(rs.getInt(5));
                    row.add(rs.getLong(6));
                    row.add(rs.getLong(7));
                    row.add(rs.getInt(8));
                    row.add(rs.getString(9));
                    row.add(10L);
                    row.add(rs.getString(11));
                }
                catch (SQLException e) {
                    Logger.exception((Throwable)e);
                    return null;
                }
                return row;
            }
        });
    }

    public String getFullWarningMessageByLogSeq(long seq) {
        int size = this.warningDataList.size();
        int i = 0;
        while (i < size) {
            long sequence = (Long)this.warningDataList.get(i).get(WarningDataDBTable.COLUMN.SEQUENCE_NUMBER.index);
            if (sequence == seq) {
                String findKey = (String)this.warningDataList.get(i).get(WarningDataDBTable.COLUMN.WARNING_KEY.index);
                int warningType = (Integer)this.warningDataList.get(i).get(WarningDataDBTable.COLUMN.WARNING_CASE.index);
                return WarningCase.getFullWarningMessage(findKey, warningType);
            }
            ++i;
        }
        return "";
    }

    public List<List<Object>> getWarningDataFromDBForRange(Long startTime, Long endTime) {
        String where = String.format(query_withTime, WarningDataDBTable.COLUMN.START_TIME.name, startTime.toString(), WarningDataDBTable.COLUMN.START_TIME.name, endTime.toString(), WarningDataDBTable.COLUMN.START_TIME.name);
        DBTable table = SummaryDataManager.getInstance().getWarningDataDBTable();
        ArrayList<String> columns = new ArrayList<String>();
        columns.add(WarningDataDBTable.COLUMN.RID.name);
        columns.add(WarningDataDBTable.COLUMN.SEQUENCE_NUMBER.name);
        columns.add(WarningDataDBTable.COLUMN.MESSAGE_ID.name);
        columns.add(WarningDataDBTable.COLUMN.PID.name);
        columns.add(WarningDataDBTable.COLUMN.TID.name);
        columns.add(WarningDataDBTable.COLUMN.START_TIME.name);
        columns.add(WarningDataDBTable.COLUMN.END_TIME.name);
        columns.add(WarningDataDBTable.COLUMN.WARNING_CASE.name);
        columns.add(WarningDataDBTable.COLUMN.WARNING_KEY.name);
        columns.add(WarningDataDBTable.COLUMN.CALLER_PC_ADDRESS.name);
        columns.add(WarningDataDBTable.COLUMN.CALLER_LIBRARY_NAME.name);
        return table.selectData(columns, where, new IResultSet(){

            @Override
            public List<Object> extractDataFromResultSet(ResultSet rs) {
                ArrayList<Object> row = new ArrayList<Object>();
                try {
                    row.add(rs.getInt(1));
                    row.add(rs.getLong(2));
                    row.add(rs.getInt(3));
                    row.add(rs.getInt(4));
                    row.add(rs.getInt(5));
                    row.add(rs.getLong(6));
                    row.add(rs.getLong(7));
                    row.add(rs.getInt(8));
                    row.add(rs.getString(9));
                    row.add(rs.getLong(10));
                    row.add(rs.getString(11));
                }
                catch (SQLException e) {
                    Logger.exception((Throwable)e);
                    return null;
                }
                return row;
            }
        });
    }
}

