/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.thread;

import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.nl.ThreadPageLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.ui.range.RangeDataManager;
import org.tizen.dynamicanalyzer.ui.thread.ThreadAPIListTable;
import org.tizen.dynamicanalyzer.ui.thread.type.ThreadPageData;
import org.tizen.dynamicanalyzer.ui.timeline.TimelinePage;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.ui.widgets.DAAdvancedViewComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class ThreadAPIListView
extends DAAdvancedViewComposite {
    private ThreadPageData data;
    private long analysisStartTime = 0L;
    private long analysisEndTime = 0L;
    private long selectionStartTime = 0L;
    private long selectionEndTime = 0L;
    private int preSelectionPid = -1;
    private String[] columnNames = new String[]{ThreadPageLabels.THREAD_API_LIST_VIEW_INDEX, ThreadPageLabels.THREAD_API_LIST_VIEW_TIME, ThreadPageLabels.THREAD_API_LIST_VIEW_PID, ThreadPageLabels.THREAD_API_LIST_VIEW_THREAD_ID, ThreadPageLabels.THREAD_API_LIST_VIEW_NAME, ThreadPageLabels.THREAD_API_LIST_VIEW_PARAMETER, ThreadPageLabels.THREAD_API_LIST_VIEW_RETURN, ThreadPageLabels.THREAD_API_LIST_VIEW_ERRNO};
    private int[] columnSizes = new int[]{35, 70, 45, 45, 180, 240, 75, 100};
    private int[] columnAlignment = new int[]{131072, 16384, 16384, 16384, 16384, 16384, 16384, 16384};
    int[] sortTypes = new int[]{1, 1, 1, 1, 2, 2, 2, 2};
    ThreadAPIListTable tableComp = null;

    public ThreadAPIListView(Composite parent, int style) {
        super(parent, style, false, true);
        this.setLayout((Layout)new FillLayout());
        this.setTitle(ThreadPageLabels.THREAD_API_LIST_VEIW_TITLE);
        Composite contents = this.getContentArea();
        contents.setBackground(ColorResources.WINDOW_BG_COLOR);
        contents.setLayout((Layout)new FillLayout());
        this.tableComp = new ThreadAPIListTable(contents, 0, 68354);
        this.tableComp.setTableName("Thread API List");
        this.tableComp.setSortTypes(this.sortTypes);
        this.tableComp.setColumnAlignment(this.columnAlignment);
        this.tableComp.setColumns(this.columnNames);
        this.tableComp.setColumnSize(this.columnSizes);
        this.setTable(this.tableComp);
    }

    public void updateView() {
        if (this.data == null) {
            return;
        }
        long newAnalysisStartTime = 0L;
        long newAnalysisEndTime = 0L;
        if (RangeDataManager.getInstance().isBeingAnalyzed()) {
            newAnalysisStartTime = RangeDataManager.getInstance().getAnalysisStartTime();
            newAnalysisEndTime = RangeDataManager.getInstance().getAnalysisEndTime();
        } else {
            newAnalysisStartTime = 0L;
            newAnalysisEndTime = 0L;
        }
        if (newAnalysisStartTime != this.analysisStartTime || newAnalysisEndTime != this.analysisEndTime) {
            this.analysisStartTime = newAnalysisStartTime;
            this.analysisEndTime = newAnalysisEndTime;
            this.tableComp.updateTable();
            return;
        }
        int selectedPid = Toolbar.INSTANCE.getSelectedPid();
        if (this.preSelectionPid != -1 && this.preSelectionPid != selectedPid) {
            this.tableComp.updateTable();
        }
        this.preSelectionPid = selectedPid;
        this.tableComp.updateTable();
    }

    public void updateView(DAViewData vdata) {
        if (vdata.getViewID().equals(TimelinePage.timelineViewID)) {
            return;
        }
        if (!(vdata instanceof DASelectionData)) {
            return;
        }
        DASelectionData data = (DASelectionData)vdata;
        if (data.getData() instanceof ThreadPageData) {
            ThreadPageData pageData;
            this.data = pageData = (ThreadPageData)data.getData();
        } else if (data.getData() instanceof Integer) {
            this.data = null;
        }
        this.selectionStartTime = data.getStartTime();
        this.selectionEndTime = data.getEndTime();
        this.tableComp.getTable().removeAll();
        this.tableComp.updateTable();
        this.tableComp.setSelectionByTime(this.selectionStartTime, this.selectionEndTime);
    }

    public Control getControl() {
        return this.tableComp;
    }

    public void clear() {
        this.tableComp.getTable().removeAll();
        this.data = null;
    }

    public ThreadPageData getPageData() {
        return this.data;
    }

    public long getAnalysisStartTime() {
        return this.analysisStartTime;
    }

    public void setAnalysisStartTime(long analysisStartTime) {
        this.analysisStartTime = analysisStartTime;
    }

    public long getAnaysisEndTime() {
        return this.analysisEndTime;
    }

    public void setAnalysisEndTime(long analysisEndTime) {
        this.analysisEndTime = analysisEndTime;
    }
}

