/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.timeline;

import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.shortcut.ShortCutManager;
import org.tizen.dynamicanalyzer.ui.info.callstack.CallstackView;
import org.tizen.dynamicanalyzer.ui.info.screenshot.ScreenshotDataManager;
import org.tizen.dynamicanalyzer.ui.interactive.data.InteractiveDataManager;
import org.tizen.dynamicanalyzer.ui.summary.SummaryDataManager;
import org.tizen.dynamicanalyzer.ui.summary.profiling.FunctionUsageProfiler;
import org.tizen.dynamicanalyzer.ui.timeline.calltrace.CallTraceDataManager;
import org.tizen.dynamicanalyzer.ui.timeline.calltrace.CallTraceView;
import org.tizen.dynamicanalyzer.ui.timeline.common.TimelineChartManager;
import org.tizen.dynamicanalyzer.ui.timeline.common.TimelineChartView;
import org.tizen.dynamicanalyzer.ui.timeline.common.TimelineDataManager;
import org.tizen.dynamicanalyzer.ui.timeline.common.TimelineTableView;
import org.tizen.dynamicanalyzer.ui.widgets.table.DABaseDataPageComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DABaseComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DATabComposite;

public class TimelinePage
extends DABaseDataPageComposite {
    public static final String pageID = TimelinePage.class.getName();
    public static final String timelineViewID = TimelineChartView.class.getName();
    public static final String calltraceViewID = CallTraceView.class.getName();
    TimelineChartView timelineChartView;
    TimelineTableView timelineTableView;
    boolean wasSashCreated = false;

    public TimelinePage(Composite parent, int style) {
        super(parent, style);
        this.setTitle(AnalyzerLabels.COOLBAR_AREA_TIMELINE);
        this.setData("tooltip", ShortCutManager.COOLBAR_AREA_TIMELINE_TOOLTIP);
        this.setBackground(ColorResources.WHITE);
        this.setLayout((Layout)new FillLayout());
        this.timelineChartView = new TimelineChartView((Composite)this.topForm, 0);
        this.addView((DABaseComposite)this.timelineChartView);
        this.timelineTableView = new TimelineTableView((Composite)this.bottomLeftForm, 0);
        this.addView((DABaseComposite)this.timelineTableView);
        DATabComposite timelineCallStackTableView = new DATabComposite((Composite)this.bottomRightForm, 0, false, true);
        CallstackView callstack = new CallstackView(timelineCallStackTableView.getContentComposite(), 0);
        timelineCallStackTableView.addView((DABaseComposite)callstack, false);
        this.addView((DABaseComposite)callstack);
        this.addView((DABaseComposite)timelineCallStackTableView);
    }

    public TimelineChartView getTimelineChartView() {
        return this.timelineChartView;
    }

    public TimelineTableView getTimelineTableView() {
        return this.timelineTableView;
    }

    public void clear() {
        super.clear();
        if (Global.isGUIMode()) {
            TimelineChartManager.getInstance().clear();
        }
        TimelineDataManager.getInstance().clear();
        CallTraceDataManager.getInstance().clear();
        InteractiveDataManager.getInstance().clear();
        ScreenshotDataManager.getInstance().clear();
        FunctionUsageProfiler.getInstance().clear();
        SummaryDataManager.getInstance().clear();
    }
}

