/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.chartBoard;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.util.CommonUtil;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonClickEventListener;
import org.tizen.dynamicanalyzer.widgets.button.toggle.DACustomToggleButton;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlot;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotIntervalMarker;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotMarker;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItemList;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardManager;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardScaleRenderer;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardSelectionListener;
import org.tizen.dynamicanalyzer.widgets.chartBoard.IDAChartSeriesMaker;
import org.tizen.dynamicanalyzer.widgets.helper.ColorResources;
import org.tizen.dynamicanalyzer.widgets.helper.FontResources;
import org.tizen.dynamicanalyzer.widgets.lifecycle.LifecycleBar;
import org.tizen.dynamicanalyzer.widgets.lifecycle.LifecycleData;
import org.tizen.dynamicanalyzer.widgets.scale.DAScale;
import org.tizen.dynamicanalyzer.widgets.scale.DAScaleSelectionListener;
import org.tizen.dynamicanalyzer.widgets.timeline.DATimeline;
import org.tizen.dynamicanalyzer.widgets.timeline.DATimelineFrameRenderer;
import org.tizen.dynamicanalyzer.widgets.timeline.DATimelineTinyTimeRenderer;

public class DAChartBoard
extends Composite {
    private Composite titleComp;
    private DACustomToggleButton itemMinimizeButton;
    private DATimeline timeline;
    private LifecycleBar lifecycleBar;
    private LifecycleData defaultLifecycleData = null;
    private DefaultToolTip lifecycleBarTooltip;
    private DefaultToolTip timelineTooltip;
    private ScrolledComposite itemListScrollComp;
    private DAChartBoardItemList itemList;
    private DAScale scale;
    private Composite scrollComp;
    private ScrollBar hScroll;
    private DAChartBoardManager boardManager = null;
    private Image oldImage;
    private List<DAChartBoardSelectionListener> selectionListenrers;
    private List<DAChartPlotMarker> markers;
    private boolean isSelectable = true;
    private Font nameFont;
    protected DAChartBoardItem selectItem;
    public static final int DEFAULT_ITEM_HEIGHT = 80;
    private static final int DEFAULT_CHARTBOARD_HEADER_HEIGHT = 25;
    private static final int DEFAULT_CHARTBOARD_TITLE_BUTTON_WIDTH = 118;
    private static final int DEFAULT_CHARTBOARD_MINIMIZE_BUTTON_WIDTH = 22;
    private static final int DEFAULT_CHARTBOARD_FOOTER_HEIGHT = 18;
    private static final int DEFAULT_CHARTBOARD_SCALE_WIDTH = 192;
    public static final double ITEM_HEIGHT_RATIO_SHORT = 0.5;
    public static final double ITEM_HEIGHT_RATIO_NORMAL = 1.0;
    protected static final double ITEM_HEIGHT_RATIO_TALL = 2.0;
    private double itemHeightRatio = 1.0;
    private int interval;
    private int itemHeight = 80;
    public static final int BOARD_STYLE_TIME = 0;
    public static final int BOARD_STYLE_FRAME = 1;
    public static final int BOARD_STYLE_KERNEL = 2;
    private IDAChartSeriesMaker chartSeriesMaker;
    private DAScaleSelectionListener scaleSelectionListener = new DAScaleSelectionListener(){

        @Override
        public void widgetSelected() {
            DAChartBoard.this.boardManager.scaleChanged(DAChartBoard.this.scale.getSelection());
            if (DAChartBoard.this.chartSeriesMaker != null) {
                DAChartBoard.this.chartSeriesMaker.makeChartSeries(DAChartBoard.this.translateSecToMicroSec(DAChartBoard.this.getVisibleStartTime()), DAChartBoard.this.translateSecToMicroSec(DAChartBoard.this.getVisibleEndTime()));
            }
            DAChartBoard.this.setChartAxis();
            DAChartBoard.this.callBackScaleChanged();
        }
    };
    private SelectionListener scrollbarSelectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            int sel = DAChartBoard.this.hScroll.getSelection();
            DAChartBoard.this.boardManager.scrollbarSelectionChanged(sel);
            if (DAChartBoard.this.chartSeriesMaker != null) {
                DAChartBoard.this.chartSeriesMaker.makeChartSeries(DAChartBoard.this.translateSecToMicroSec(DAChartBoard.this.getVisibleStartTime()), DAChartBoard.this.translateSecToMicroSec(DAChartBoard.this.getVisibleEndTime()));
            }
            DAChartBoard.this.setChartAxis();
            DAChartBoard.this.callBackScrollChanged();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };
    private Listener resizeListener = new Listener(){

        public void handleEvent(Event event) {
            DAChartBoard.this.callBackSizeChanged();
        }
    };
    private MouseTrackAdapter timelineMouseTrackAdapter = new MouseTrackAdapter(){

        public void mouseHover(MouseEvent e) {
            String tooltipMessage = DAChartBoard.this.lifecycleBar.getTooltipMessage(e.x);
            if (tooltipMessage == null) {
                DAChartBoard.this.timelineTooltip.deactivate();
                DAChartBoard.this.lifecycleBarTooltip.deactivate();
            } else {
                DAChartBoard.this.timelineTooltip.setText(tooltipMessage);
                DAChartBoard.this.timelineTooltip.activate();
                DAChartBoard.this.lifecycleBarTooltip.setText(tooltipMessage);
                DAChartBoard.this.lifecycleBarTooltip.activate();
            }
        }
    };

    public DAChartBoard(Composite parent, String title, LifecycleData defaultLifecycleData) {
        this(parent, title, 0, defaultLifecycleData);
    }

    public DAChartBoard(Composite parent, String title, int[] scaleValues, LifecycleData defaultLifecycleData) {
        this(parent, title, 2, defaultLifecycleData);
        this.scale.setMaximum(scaleValues.length - 1);
        this.boardManager.setScaleValues(scaleValues);
    }

    public DAChartBoard(Composite parent, String title, int boardStyle, LifecycleData defaultLifecycleData) {
        super(parent, 0);
        this.setLayout((Layout)new FormLayout());
        this.setBackground(ColorResources.WHITE);
        this.defaultLifecycleData = defaultLifecycleData;
        this.titleComp = new Composite((Composite)this, 0);
        this.titleComp.setLayout((Layout)new FillLayout());
        this.itemMinimizeButton = new DACustomToggleButton(this, ColorResources.CHART_SIZE_TOGGLE_NORMAL_START, ColorResources.CHART_SIZE_TOGGLE_NORMAL_END, ColorResources.CHART_SIZE_TOGGLE_PUSH_START, ColorResources.CHART_SIZE_TOGGLE_PUSH_END, ColorResources.CHART_SIZE_TOGGLE_HOVER_START, ColorResources.CHART_SIZE_TOGGLE_HOVER_END, null, null, ColorResources.CHART_SIZE_TOGGLE_NORMAL_START, ColorResources.CHART_SIZE_TOGGLE_NORMAL_END, ColorResources.CHART_SIZE_TOGGLE_PUSH_START, ColorResources.CHART_SIZE_TOGGLE_PUSH_END, ColorResources.CHART_SIZE_TOGGLE_HOVER_START, ColorResources.CHART_SIZE_TOGGLE_HOVER_END, ColorResources.CHART_SIZE_TOGGLE_NORMAL_START, ColorResources.CHART_SIZE_TOGGLE_NORMAL_END);
        this.itemMinimizeButton.setOutlineColors(ColorResources.CHART_SIZE_TOGGLE_NORMAL_STROKE, ColorResources.CHART_SIZE_TOGGLE_PUSH_STROKE, ColorResources.CHART_SIZE_TOGGLE_HOVER_STROKE, null, ColorResources.CHART_SIZE_TOGGLE_NORMAL_STROKE, ColorResources.CHART_SIZE_TOGGLE_NORMAL_STROKE, ColorResources.CHART_SIZE_TOGGLE_NORMAL_STROKE, ColorResources.CHART_SIZE_TOGGLE_NORMAL_STROKE);
        this.itemMinimizeButton.setButtonImage(0, ImageResources.CHART_ALL_SIZE_RESTORE);
        this.itemMinimizeButton.setButtonImage(4, ImageResources.CHART_ALL_SIZE_MIN);
        this.itemMinimizeButton.setButtonImagePoint(new Point(3, 4));
        this.itemMinimizeButton.addClickListener(new DACustomButtonClickEventListener(){

            @Override
            public void handleClickEvent(DACustomButton button) {
                DAChartBoard.this.minimizeItem(DAChartBoard.this.itemMinimizeButton.isToggled());
            }
        });
        this.itemMinimizeButton.setVisible(false);
        if (boardStyle == 1) {
            this.interval = 1;
            this.timeline = new DATimeline(this, false);
            this.timeline.setRenderer(new DATimelineFrameRenderer());
        } else {
            this.interval = 5;
            this.timeline = new DATimeline(this, true);
            this.timelineTooltip = new DefaultToolTip((Control)this.timeline);
            this.timelineTooltip.deactivate();
            this.timeline.addMouseTrackListener((MouseTrackListener)this.timelineMouseTrackAdapter);
            this.lifecycleBar = new LifecycleBar(this);
            this.lifecycleBarTooltip = new DefaultToolTip((Control)this.lifecycleBar);
            this.lifecycleBarTooltip.deactivate();
            this.lifecycleBar.setBackground(ColorResources.GRAY_245);
            this.lifecycleBar.addMouseTrackListener((MouseTrackListener)this.timelineMouseTrackAdapter);
            this.reinitLifecycleData();
            if (boardStyle == 2) {
                this.timeline.setRenderer(new DATimelineTinyTimeRenderer());
            }
        }
        this.addListener(11, this.resizeListener);
        this.scale = new DAScale(this, 4, 0);
        this.scale.addSelectionListener(this.scaleSelectionListener);
        this.scale.setLeftImage(ImageResources.ZOOM_OUT_ICON);
        this.scale.setRightImage(ImageResources.ZOOM_IN_ICON);
        this.scale.setThumbImage(ImageResources.ZOOM_CONTROL);
        this.scale.setRenderer(new DAChartBoardScaleRenderer());
        this.scrollComp = new Composite((Composite)this, 256);
        this.scrollComp.setLayout((Layout)new FillLayout());
        this.hScroll = this.scrollComp.getHorizontalBar();
        this.hScroll.setMinimum(0);
        this.hScroll.setMaximum(0);
        this.hScroll.setSelection(0);
        this.hScroll.setIncrement(1000);
        this.hScroll.setVisible(true);
        this.hScroll.addSelectionListener(this.scrollbarSelectionListener);
        this.itemListScrollComp = new ScrolledComposite((Composite)this, 512);
        this.itemListScrollComp.getVerticalBar().setIncrement(50);
        this.itemListScrollComp.addListener(37, new Listener(){

            public void handleEvent(Event event) {
                if (event.stateMask == 262144) {
                    if (event.count > 0) {
                        DAChartBoard.this.scale.changeScale(true);
                    } else {
                        DAChartBoard.this.scale.changeScale(false);
                    }
                    DAChartBoard.this.boardManager.scaleChanged(DAChartBoard.this.scale.getSelection());
                    event.doit = false;
                }
            }
        });
        this.itemListScrollComp.addListener(26, new Listener(){

            public void handleEvent(Event event) {
                DAChartBoard.this.itemListScrollComp.setFocus();
            }
        });
        this.itemListScrollComp.setBackground(ColorResources.CHART_BOARD_BACK);
        this.itemListScrollComp.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                DAChartBoard.this.boardManager.timelineWidthChanged(DAChartBoard.this.getClientArea().width - 190);
                if (DAChartBoard.this.chartSeriesMaker != null) {
                    DAChartBoard.this.chartSeriesMaker.makeChartSeries(DAChartBoard.this.translateSecToMicroSec(DAChartBoard.this.getVisibleStartTime()), DAChartBoard.this.translateSecToMicroSec(DAChartBoard.this.getVisibleEndTime()));
                }
                DAChartBoard.this.setChartAxis();
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.itemListScrollComp.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Rectangle rt = DAChartBoard.this.getClientArea();
                e.gc.setBackground(ColorResources.WHITE);
                e.gc.setForeground(ColorResources.GRAY_170);
                e.gc.fillRectangle(rt);
                int height = (int)((double)DAChartBoard.this.itemHeight * DAChartBoard.this.itemHeightRatio);
                int nItemSize = rt.height / height + 1;
                int i = 0;
                while (i < nItemSize) {
                    e.gc.drawRectangle(rt.x, i * height - 1, 190, height);
                    e.gc.drawRectangle(190, i * height - 1, rt.width - 190, height);
                    ++i;
                }
            }
        });
        this.itemList = new DAChartBoardItemList(this);
        this.itemListScrollComp.setContent((Control)this.itemList);
        this.itemListScrollComp.setExpandHorizontal(true);
        this.itemList.setLayout((Layout)new FormLayout());
        this.itemList.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                if (DAChartBoard.this.boardManager != null) {
                    DAChartBoard.this.boardManager.timelineWidthChanged(DAChartBoard.this.itemList.getItemChartWidth());
                    DAChartBoard.this.setChartAxis();
                }
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        FormData data = new FormData();
        data.left = new FormAttachment(0, -1);
        data.top = new FormAttachment(0, 0);
        data.width = 192;
        data.height = 25;
        this.titleComp.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)this.titleComp, 0);
        data.top = new FormAttachment(0, 0);
        data.width = 0;
        data.height = 0;
        this.itemMinimizeButton.setLayoutData(data);
        if (boardStyle == 1) {
            data = new FormData();
            data.left = new FormAttachment((Control)this.itemMinimizeButton, 0);
            data.top = new FormAttachment(0, 0);
            data.right = new FormAttachment(100, 0);
            data.height = 25;
            this.timeline.setLayoutData(data);
        } else {
            data = new FormData();
            data.left = new FormAttachment((Control)this.itemMinimizeButton, 0);
            data.top = new FormAttachment(0, 0);
            data.right = new FormAttachment(100, 0);
            data.height = 18;
            this.timeline.setLayoutData(data);
            data = new FormData();
            data.left = new FormAttachment((Control)this.itemMinimizeButton, 0);
            data.right = new FormAttachment(100, 0);
            data.top = new FormAttachment((Control)this.timeline, 0);
            data.height = 7;
            this.lifecycleBar.setLayoutData(data);
        }
        if (CommonUtil.isWin()) {
            data = new FormData();
            data.left = new FormAttachment(0, 0);
            data.top = new FormAttachment((Control)this.titleComp, 0);
            data.bottom = new FormAttachment(100, -18);
            data.right = new FormAttachment(100, 0);
            this.itemListScrollComp.setLayoutData((Object)data);
            data = new FormData();
            data.left = new FormAttachment(0, 0);
            data.top = new FormAttachment((Control)this.itemListScrollComp, 0);
            data.bottom = new FormAttachment(100, 0);
            data.width = 192;
            data.height = 18;
            this.scale.setLayoutData(data);
            data = new FormData();
            data.left = new FormAttachment((Control)this.scale, 0);
            data.right = new FormAttachment(100, 0);
            data.top = new FormAttachment((Control)this.itemListScrollComp, 0);
            data.bottom = new FormAttachment(100, 0);
            data.height = 18;
            this.scrollComp.setLayoutData((Object)data);
        } else {
            data = new FormData();
            data.left = new FormAttachment(0, 0);
            data.top = new FormAttachment((Control)this.titleComp, 0);
            data.bottom = new FormAttachment(100, -15);
            data.right = new FormAttachment(100, 0);
            this.itemListScrollComp.setLayoutData((Object)data);
            data = new FormData();
            data.left = new FormAttachment(0, 0);
            data.top = new FormAttachment((Control)this.itemListScrollComp, 0);
            data.bottom = new FormAttachment(100, 0);
            data.width = 192;
            this.scale.setLayoutData(data);
            data = new FormData();
            data.left = new FormAttachment((Control)this.scale, 0);
            data.right = new FormAttachment(100, 0);
            data.top = new FormAttachment((Control)this.itemListScrollComp, 0);
            data.bottom = new FormAttachment(100, 0);
            this.scrollComp.setLayoutData((Object)data);
        }
        this.itemListScrollComp.layout();
        this.boardManager = new DAChartBoardManager(this);
    }

    public LifecycleData getDefaultLifecycleData() {
        return this.defaultLifecycleData;
    }

    public DAScale getScale() {
        return this.scale;
    }

    public DAChartBoardManager getBoardManager() {
        return this.boardManager;
    }

    private void minimizeItem(boolean minimize) {
        if (minimize) {
            this.itemHeightRatio = 0.5;
            this.itemList.minimize();
        } else {
            this.itemHeightRatio = 1.0;
            this.itemList.unMinimize();
        }
        this.itemList.setSize(this.itemListScrollComp.getClientArea().width, this.itemList.getListHeight());
        this.itemList.layout();
        this.itemListScrollComp.redraw();
    }

    public boolean isItemMinimized() {
        return this.itemMinimizeButton.isToggled();
    }

    public void setItemsHeightMode(boolean minimize) {
        if (this.itemMinimizeButton.isToggled() == minimize) {
            return;
        }
        this.itemMinimizeButton.setToggled(minimize);
        this.minimizeItem(minimize);
    }

    public int getVisibleStart() {
        if (this.hScroll == null) {
            return 0;
        }
        return this.hScroll.getSelection();
    }

    public void setVisibleStart(int val) {
        if (this.hScroll == null || this.hScroll.getSelection() == val) {
            return;
        }
        this.hScroll.setSelection(val);
        this.boardManager.scrollbarSelectionChanged(val);
    }

    public int getScaleVal() {
        if (this.scale == null) {
            return 0;
        }
        return this.scale.getSelection();
    }

    public void setScaleVal(int sel) {
        if (this.scale == null || this.scale.getSelection() == sel) {
            return;
        }
        this.scale.setSelection(sel);
        this.boardManager.scaleChanged(sel);
    }

    public void setChartSeriesMaker(IDAChartSeriesMaker chartSeriesMaker) {
        this.chartSeriesMaker = chartSeriesMaker;
    }

    private void setChartAxis() {
        this.itemList.setChartAxis(this.getVisibleStartTime(), this.getVisibleEndTime());
    }

    protected void notifyScaleChanged(int scaleVal, double thumb, double visibleStartTime) {
        this.timeline.setScale(scaleVal);
        this.timeline.setStartTime(visibleStartTime);
        this.timeline.redraw();
        if (this.lifecycleBar != null) {
            this.lifecycleBar.setScale(scaleVal);
            this.lifecycleBar.setVisibleStartTime(visibleStartTime);
            this.lifecycleBar.redraw();
        }
        this.setScrollThumb((int)(thumb * 1000.0));
        this.hScroll.setSelection((int)(visibleStartTime * 1000.0));
        this.setChartAxis();
    }

    public void setVisibleStartTime(double time) {
        this.boardManager.startTimeChanged(time);
    }

    public void setVisibleMiddleTime(double time) {
        this.boardManager.middleTimeChanged(time);
    }

    protected void notifyScrollChanged(double visibleStartTime) {
        this.timeline.setStartTime(visibleStartTime);
        this.timeline.redraw();
        if (this.lifecycleBar != null) {
            this.lifecycleBar.setVisibleStartTime(visibleStartTime);
            this.lifecycleBar.redraw();
        }
        this.setChartAxis();
    }

    protected void notifyVisibleStartTimeChanged(double visibleStartTime) {
        this.timeline.setStartTime(visibleStartTime);
        this.timeline.redraw();
        if (this.lifecycleBar != null) {
            this.lifecycleBar.setVisibleStartTime(visibleStartTime);
            this.lifecycleBar.redraw();
        }
        this.hScroll.setSelection((int)(visibleStartTime * 1000.0));
        this.setChartAxis();
    }

    public int getChartWidth() {
        Rectangle rt = this.scrollComp.getClientArea();
        if (rt == null) {
            return 0;
        }
        return rt.width;
    }

    protected void setScrollThumb(int thumb) {
        this.hScroll.setThumb(thumb);
        this.hScroll.setPageIncrement(thumb);
    }

    protected void setScrollMaximum(int maximum) {
        this.hScroll.setMaximum(maximum);
    }

    protected void setScrollSelection(int selection) {
        this.hScroll.setSelection(selection);
    }

    protected void registerItem(DAChartBoardItem item) {
        this.itemList.registerItem(item);
        int listHeight = this.itemList.getListHeight();
        this.itemList.setSize(this.itemListScrollComp.getClientArea().width, listHeight);
    }

    protected void registerItem(DAChartBoardItem item, Comparator c) {
        this.itemList.registerItem(item, c);
        int listHeight = this.itemList.getListHeight();
        this.itemList.setSize(this.itemListScrollComp.getClientArea().width, listHeight);
    }

    public DAChartBoardItemList getItemList() {
        return this.itemList;
    }

    protected void notifyResizeChild(DAChartBoardItem item) {
        if (this.itemList == null) {
            return;
        }
        this.itemList.notifyResizeChild(item);
        this.itemList.layout();
        this.itemList.setSize(this.itemListScrollComp.getClientArea().width, this.itemList.getListHeight());
    }

    public void setTotalEndTime(long time, boolean changeVisibleStartTime) {
        double endTime = (double)time / 1000000.0;
        this.boardManager.totalEndTimeChanged(endTime, changeVisibleStartTime);
        this.itemList.setChartValidX(endTime);
        this.timeline.setTotalEndTime(endTime);
        if (this.lifecycleBar != null) {
            this.lifecycleBar.setTotalEndTime(endTime);
        }
    }

    private void markerContentsClear() {
        if (this.markers == null) {
            return;
        }
        int size = this.markers.size();
        int i = 0;
        while (i < size) {
            if (this.markers.get(i) instanceof DAChartPlotIntervalMarker) {
                ((DAChartPlotIntervalMarker)this.markers.get(i)).setInterval(-1.0, -1.0);
            }
            ++i;
        }
    }

    private void reinitLifecycleData() {
        if (this.lifecycleBar != null) {
            this.lifecycleBar.clear();
            if (this.defaultLifecycleData != null) {
                this.lifecycleBar.addLifecycleData(this.defaultLifecycleData);
            }
        }
    }

    public void contentsClear() {
        this.itemList.contentsClear();
        this.setTotalEndTime(0L, true);
        this.timeline.setStartTime(0.0);
        this.reinitLifecycleData();
        if (this.oldImage != null) {
            this.oldImage = null;
        }
        if (this.selectItem != null) {
            this.selectItem = null;
        }
        this.markerContentsClear();
        this.timeline.redraw();
    }

    public void clear() {
        this.itemList.clear();
        this.itemList.setSize(0, 0);
        this.setTotalEndTime(0L, true);
        this.timeline.clear();
        this.reinitLifecycleData();
        if (this.oldImage != null) {
            this.oldImage = null;
        }
        if (this.selectItem != null) {
            this.selectItem = null;
        }
        if (this.markers != null) {
            this.markers.clear();
            this.markers = null;
        }
    }

    public double getVisibleStartTime() {
        return this.boardManager.getVisibleStartTime();
    }

    public double getVisibleEndTime() {
        return this.boardManager.getVisibleEndTime();
    }

    private void setChartBackgroundImage(DAChart chart, Image image) {
        if (chart == null) {
            return;
        }
        DAChartPlot plot = chart.getPlot();
        if (plot == null) {
            return;
        }
        plot.setBackgroundImage(image);
        chart.redraw();
    }

    protected void NotifyCallbackSelection(DAChartBoardItem item) {
        this.selectRow(item);
    }

    private void selectRow(DAChartBoardItem item) {
        if (!this.isSelectable) {
            return;
        }
        if (this.selectItem != null && this.oldImage != null) {
            this.setChartBackgroundImage(this.selectItem.getChart(), this.oldImage);
            if (item.isSelectable() || !this.selectItem.isSelectable() || this.selectItem.getChart() == null || !this.selectItem.getChart().isSelected()) {
                this.selectItem.selectItem(false);
            }
        }
        if (item == null || !item.isSelectable()) {
            return;
        }
        this.selectItem = item;
        DAChart chart = this.selectItem.getChart();
        if (chart == null) {
            return;
        }
        this.oldImage = chart.getPlot().getBackgroundImage();
        this.setChartBackgroundImage(this.selectItem.getChart(), ImageResources.CHART_BG_SELECT);
        this.selectItem.selectItem(true);
        if (this.selectionListenrers != null) {
            int i = 0;
            while (i < this.selectionListenrers.size()) {
                this.selectionListenrers.get(i).handleSelectionEvent(this.selectItem);
                ++i;
            }
        }
    }

    public void selectItem(int index) {
        int itemSize = this.itemList.getItemSize();
        if (itemSize == 0 || index >= itemSize) {
            return;
        }
        DAChartBoardItem item = this.itemList.get(index);
        this.selectRow(item);
        this.itemListScrollComp.setOrigin(0, this.itemList.getItemYPos(index));
    }

    public void selectItem(int parentIndex, int childIndex) {
        int itemSize = this.itemList.getItemSize();
        if (itemSize == 0 || parentIndex >= itemSize) {
            return;
        }
        DAChartBoardItem item = this.itemList.get(parentIndex);
        if (item == null) {
            return;
        }
        DAChartBoardItemList childItemList = item.getChildItemList();
        int childSize = childItemList.getItemSize();
        if (childSize == 0 || childIndex >= childSize) {
            return;
        }
        item.getItemCell().setFoldButtonTrue();
        DAChartBoardItem childItem = childItemList.get(childIndex);
        this.selectRow(childItem);
        int selection = this.itemList.getItemYPos(parentIndex) + childItemList.getItemYPos(childIndex);
        this.itemListScrollComp.setOrigin(0, selection);
    }

    public void addSelectionListener(DAChartBoardSelectionListener listener) {
        if (this.selectionListenrers == null) {
            this.selectionListenrers = new ArrayList<DAChartBoardSelectionListener>();
        }
        this.selectionListenrers.add(listener);
    }

    public Composite getTitleComp() {
        return this.titleComp;
    }

    public void addIntervalMarker(DAChartPlotMarker marker) {
        if (this.markers == null) {
            this.markers = new ArrayList<DAChartPlotMarker>();
        }
        this.markers.add(marker);
    }

    public List<DAChartPlotMarker> getMarkers() {
        return this.markers;
    }

    public boolean isSelectable() {
        return this.isSelectable;
    }

    public void setSelectable(boolean isSelectable) {
        this.isSelectable = isSelectable;
    }

    protected double getItemHeightRatio() {
        return this.itemHeightRatio;
    }

    public LifecycleBar getLifecycleBar() {
        return this.lifecycleBar;
    }

    private long translateSecToMicroSec(double sec) {
        return (long)(sec * 1000000.0);
    }

    public void hideItem(int index) {
        this.itemList.hideItem(index);
        this.itemList.setSize(this.itemListScrollComp.getClientArea().width, this.itemList.getListHeight());
    }

    public void showItem(int index) {
        this.itemList.showItem(index);
        this.itemList.setSize(this.itemListScrollComp.getClientArea().width, this.itemList.getListHeight());
    }

    public void showChildItem(int parentIndex, int childIndex) {
        this.itemList.showChildItem(parentIndex, childIndex);
        this.itemList.setSize(this.itemListScrollComp.getClientArea().width, this.itemList.getListHeight());
    }

    public void hideChildItem(int parentIndex, int childIndex) {
        this.itemList.hideChildItem(parentIndex, childIndex);
        this.itemList.setSize(this.itemListScrollComp.getClientArea().width, this.itemList.getListHeight());
    }

    public void showAllItems() {
        this.itemList.showAllItems();
        this.itemList.setSize(this.itemListScrollComp.getClientArea().width, this.itemList.getListHeight());
    }

    public void reArrangeItem(Integer[] a) {
        this.itemList.reArrangeItem(a);
        this.itemList.layout(true, true);
    }

    public Composite getListComposite() {
        return this.itemListScrollComp;
    }

    public DATimeline getTimeline() {
        return this.timeline;
    }

    public Font getNameFont() {
        if (this.nameFont == null) {
            this.nameFont = FontResources.CHART_ITEM_NAME_FONT;
        }
        return this.nameFont;
    }

    public void setNameFont(Font nameFont) {
        this.nameFont = nameFont;
    }

    public DAChartBoardItem getSelectItem() {
        return this.selectItem;
    }

    public void setItemHeight(int itemHeight) {
        this.itemHeight = itemHeight;
    }

    public int getItemHeight() {
        return this.itemHeight;
    }

    public void makeDefaultTitleComposite(final String title, final Font titleFont, final Color titleColor, final Color bgColorStart, final Color bgColorEnd, final Color borderColor) {
        if (this.titleComp == null) {
            return;
        }
        Composite textBoxLabel = new Composite(this.titleComp, 0);
        textBoxLabel.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Composite composite = (Composite)e.widget;
                Rectangle rect = composite.getClientArea();
                e.gc.setForeground(bgColorStart);
                e.gc.setBackground(bgColorEnd);
                e.gc.fillGradientRectangle(rect.x, rect.y, rect.width, rect.height, true);
                e.gc.setForeground(borderColor);
                e.gc.drawRectangle(rect.x, rect.y, rect.width, rect.height - 1);
                e.gc.setFont(titleFont);
                e.gc.setForeground(titleColor);
                int startX = rect.width / 2 - e.gc.textExtent((String)title).x / 2;
                int startY = rect.height / 2 - e.gc.textExtent((String)title).y / 2;
                e.gc.drawString(title, startX, startY, true);
            }
        });
    }

    protected int getInterval() {
        return this.interval;
    }

    public ScrollBar getHScrollBar() {
        return this.hScroll;
    }

    public boolean isMaximumScrolled() {
        return this.hScroll.getSelection() + this.hScroll.getThumb() >= this.hScroll.getMaximum();
    }

    protected void callBackScaleChanged() {
    }

    protected void callBackScrollChanged() {
    }

    protected void callBackSizeChanged() {
    }

    public void updateVisibleStartTime() {
        this.boardManager.updateVisibleStartTime();
    }
}

