/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.timeline;

import java.math.BigDecimal;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.tizen.dynamicanalyzer.widgets.helper.ColorResources;
import org.tizen.dynamicanalyzer.widgets.helper.Formatter;
import org.tizen.dynamicanalyzer.widgets.timeline.DATimeline;
import org.tizen.dynamicanalyzer.widgets.timeline.DATimelineTimeRenderer;

public class DATimelineTinyTimeRenderer
extends DATimelineTimeRenderer {
    private static final int MAX_STRING_GAP = 200;
    private static final int MIN_STRING_GAP = 40;
    protected static final int TIME_STRING_PIXEL_Y = 4;

    @Override
    public void draw(GC gc, DATimeline timeline) {
        Rectangle rt = timeline.getClientArea();
        gc.setFont(this.timeTickFont);
        gc.setBackground(ColorResources.TIMELINE_BG_COLOR);
        gc.fillRectangle(rt);
        gc.setForeground(ColorResources.TIMELINE_TICK_COLOR);
        gc.drawLine(0, rt.height - 1, rt.width, rt.height - 1);
        int pixelX = 0;
        this.scale = timeline.getScale();
        double oneSecondInterval = this.scale * 5;
        double startTime = timeline.getStartTime();
        int STRING_GAP = (int)oneSecondInterval;
        boolean half = true;
        if (STRING_GAP > 200) {
            int newgap = 0;
            do {
                if (newgap != 0) {
                    STRING_GAP = newgap;
                }
                if (half) {
                    newgap = STRING_GAP / 2;
                    half = false;
                    continue;
                }
                newgap = STRING_GAP / 5;
                half = true;
            } while (newgap > 40);
        } else if (STRING_GAP < 40) {
            do {
                if (half) {
                    STRING_GAP *= 2;
                    half = false;
                    continue;
                }
                STRING_GAP *= 5;
                half = true;
            } while (STRING_GAP < 40);
        }
        BigDecimal timeInterval = new BigDecimal(String.valueOf((double)STRING_GAP / oneSecondInterval));
        double firstTime = timeInterval.doubleValue() * (double)((int)(startTime / timeInterval.doubleValue()));
        pixelX = (int)(oneSecondInterval * (firstTime - startTime));
        while (pixelX < rt.width) {
            gc.drawLine(pixelX, rt.height - 6, pixelX, rt.height - 1);
            String timeString = null;
            if (firstTime - (double)((int)firstTime) == 0.0) {
                timeString = Formatter.toTimelineFormat((int)firstTime);
            } else {
                String firstTimeString = Double.toString(firstTime);
                String minorityString = firstTimeString.substring(firstTimeString.indexOf(46));
                int timeIntervalMinorityStringLength = Double.toString(timeInterval.doubleValue()).length() - 1;
                if (minorityString.length() > timeIntervalMinorityStringLength) {
                    minorityString = minorityString.substring(0, timeIntervalMinorityStringLength + 1);
                }
                while (minorityString.endsWith("0")) {
                    minorityString = minorityString.substring(0, minorityString.length() - 1);
                }
                timeString = String.valueOf(Formatter.toTimelineFormat((int)firstTime)) + minorityString;
            }
            Point p = gc.textExtent(timeString, 8);
            gc.setForeground(ColorResources.TIMELINE_NUMBER_COLOR);
            gc.drawText(timeString, pixelX - p.x / 2, 4, true);
            gc.setForeground(ColorResources.TIMELINE_TICK_COLOR);
            firstTime = new BigDecimal(String.valueOf(firstTime)).add(timeInterval).doubleValue();
            pixelX += STRING_GAP;
        }
        this.drawRangeMarkers(gc, timeline);
        if (timeline.getDrawDetailedTime()) {
            gc.drawImage(this.balloon, 0, 0, this.balloon.getBounds().width, this.balloon.getBounds().height, timeline.getDetailedTimePosition() - this.balloonHalfWidth, 0, this.balloon.getBounds().width, timeline.getBounds().height - 1);
            String time = Formatter.toTimeFormat((long)(timeline.getDetailedTime() * 1000000.0));
            gc.setForeground(ColorResources.BLACK);
            gc.setFont(this.timeBalloonFont);
            gc.drawString(time, timeline.getDetailedTimePosition() - gc.stringExtent((String)time).x / 2, gc.stringExtent((String)time).y / 2 - 4, true);
        }
    }
}

