/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassTemplate;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;

public class CPPClassTemplatePartialSpecialization
extends CPPClassTemplate
implements ICPPClassTemplatePartialSpecialization,
ICPPSpecialization {
    private ICPPTemplateArgument[] arguments;

    public CPPClassTemplatePartialSpecialization(ICPPASTTemplateId name) {
        super(name);
    }

    public ICPPTemplateArgument[] getTemplateArguments() throws DOMException {
        if (this.arguments == null) {
            this.arguments = CPPTemplates.createTemplateArgumentArray((ICPPASTTemplateId)this.getTemplateName());
        }
        return this.arguments;
    }

    public ICPPClassTemplate getPrimaryClassTemplate() {
        ICPPASTTemplateId id = (ICPPASTTemplateId)this.getTemplateName();
        return (ICPPClassTemplate)id.getTemplateName().resolveBinding();
    }

    public IBinding getSpecializedBinding() {
        return this.getPrimaryClassTemplate();
    }

    public ICPPTemplateParameterMap getTemplateParameterMap() {
        try {
            return CPPTemplates.createParameterMap(this.getPrimaryClassTemplate(), this.getTemplateArguments());
        }
        catch (DOMException dOMException) {
            return CPPTemplateParameterMap.EMPTY;
        }
    }

    protected ICPPDeferredClassInstance createDeferredInstance() throws DOMException {
        return new CPPDeferredClassInstance(this, this.getTemplateArguments(), this.getCompositeScope());
    }

    public String toString() {
        try {
            return String.valueOf(super.toString()) + ASTTypeUtil.getArgumentListString(this.getTemplateArguments(), true);
        }
        catch (DOMException e) {
            return String.valueOf(super.toString()) + '<' + e.getProblem().toString() + '>';
        }
    }

    @Deprecated
    public ObjectMap getArgumentMap() {
        return CPPTemplates.getArgumentMap(this.getPrimaryClassTemplate(), this.getTemplateParameterMap());
    }

    @Deprecated
    public IType[] getArguments() throws DOMException {
        return CPPTemplates.getArguments(this.getTemplateArguments());
    }

    public boolean isSameType(IType type) {
        if (type == this) {
            return true;
        }
        if (type instanceof ITypedef || type instanceof IIndexBinding) {
            return type.isSameType(this);
        }
        if (type instanceof ICPPClassTemplatePartialSpecialization) {
            return CPPClassTemplatePartialSpecialization.isSamePartialClassSpecialization(this, (ICPPClassTemplatePartialSpecialization)type);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isSamePartialClassSpecialization(ICPPClassTemplatePartialSpecialization lhs, ICPPClassTemplatePartialSpecialization rhs) {
        try {
            ICPPTemplateArgument[] args2;
            ICPPClassTemplate ct1 = lhs.getPrimaryClassTemplate();
            ICPPClassTemplate ct2 = rhs.getPrimaryClassTemplate();
            if (!ct1.isSameType(ct2)) {
                return false;
            }
            ICPPTemplateArgument[] args1 = lhs.getTemplateArguments();
            if (args1.length != (args2 = rhs.getTemplateArguments()).length) {
                return false;
            }
            int i = 0;
            while (true) {
                if (i >= args2.length) {
                    return true;
                }
                if (args1[i].isSameValue(args2[i])) {
                    return false;
                }
                ++i;
            }
        }
        catch (DOMException dOMException) {
            return false;
        }
    }
}

