/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.cli.utils;

import java.io.Serializable;
import java.util.Date;

public class HumanReadableTimeFormat
implements Serializable {
    private static final long serialVersionUID = 8522187457892222028L;
    long time_ms;
    private static final long MS_IN_SECOND = 1000L;
    private static final long MS_IN_MINUTE = 60000L;
    private static final long MS_IN_HOUR = 3600000L;
    private static final long MS_IN_DAY = 86400000L;

    public HumanReadableTimeFormat(Date start, Date finish) {
        this.time_ms = Math.abs(finish.getTime() - start.getTime());
    }

    public HumanReadableTimeFormat(long time_microsec) {
        this.time_ms = time_microsec / 1000L;
    }

    public String toString() {
        long diff_ms = this.time_ms;
        long days = diff_ms / 86400000L;
        long hours = (diff_ms %= 86400000L) / 3600000L;
        long minutes = (diff_ms %= 3600000L) / 60000L;
        long seconds = (diff_ms %= 60000L) / 1000L;
        diff_ms %= 1000L;
        String result = "";
        if (days != 0L) {
            result = result + days + "d ";
        }
        if (hours != 0L) {
            result = result + hours + "h ";
        }
        if (minutes != 0L) {
            result = result + minutes + "m ";
        }
        if (seconds != 0L || diff_ms != 0L) {
            result = result + String.format("%.3f", Float.valueOf((float)seconds + (float)diff_ms / 1000.0f)) + "s";
        }
        return result.trim();
    }
}

