/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.communicator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.widgets.Display;
import org.tizen.dynamicanalyzer.common.DAResult;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.common.path.PathManager;
import org.tizen.dynamicanalyzer.communicator.CommunicatorUtils;
import org.tizen.dynamicanalyzer.communicator.DeviceInfo;
import org.tizen.dynamicanalyzer.handlers.UIActionHolder;
import org.tizen.dynamicanalyzer.protocol.Protocol;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.IDeviceChangeListener;
import org.tizen.sdblib.SmartDevelopmentBridge;
import org.tizen.sdblib.util.DeviceUtil;

public class DeviceManager {
    private static SmartDevelopmentBridge sdbBridge = null;
    private static List<DeviceInfo> devices = new ArrayList<DeviceInfo>();
    private static IDeviceChangeListener deviceChanged = new IDeviceChangeListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDisconnected(IDevice device) {
            Logger.debug((Object)("device disconnected : " + device.getSerialNumber()));
            List list = devices;
            synchronized (list) {
                if (DeviceManager.onDisconnectedInternal(device)) {
                    DeviceManager.updateToolbarByDevice();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onConnected(IDevice device) {
            Logger.debug((Object)("device connected : " + device.getSerialNumber()));
            List list = devices;
            synchronized (list) {
                if (DeviceManager.onConnectedInternal(device)) {
                    DeviceManager.updateToolbarByDevice();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onChanged(IDevice device, int changeMask) {
            Logger.debug((Object)("device changed : " + device.getSerialNumber() + " : " + changeMask));
            List list = devices;
            synchronized (list) {
                if (changeMask == 1 || changeMask == 7) {
                    boolean bRemoved = DeviceManager.onDisconnectedInternal(device);
                    boolean bAdded = DeviceManager.onConnectedInternal(device);
                    if (bRemoved || bAdded) {
                        DeviceManager.updateToolbarByDevice();
                    }
                }
            }
        }
    };

    public static void init() {
        if (PathManager.SDB_PATH != null) {
            sdbBridge = SmartDevelopmentBridge.createBridge((String)PathManager.SDB_PATH);
            sdbBridge.startBridge();
            sdbBridge.waitforStart();
        }
    }

    private static boolean onDisconnectedInternal(IDevice device) {
        boolean bRemoved = false;
        DeviceInfo deviceInfo = DeviceManager.getDeviceByName(device.getSerialNumber());
        if (deviceInfo != null) {
            bRemoved = devices.remove(deviceInfo);
            deviceInfo.getCommunicator().disconnect();
        }
        return bRemoved;
    }

    private static boolean onConnectedInternal(IDevice device) {
        DAResult result;
        boolean bAdded = false;
        DeviceInfo devInfo = new DeviceInfo(device);
        for (DeviceInfo dinfo : devices) {
            if (!dinfo.isSameDevice(devInfo)) continue;
            return true;
        }
        if (SettingDataManager.INSTANCE.isPlatformDA()) {
            devInfo.setAvailabilityOfRoot(CommunicatorUtils.enableRoot(device));
        }
        if ((result = devInfo.getCommunicator().connect()).isSuccess()) {
            String devProtocol = devInfo.getCommunicator().getProtocolVersion();
            if (devProtocol != null) {
                try {
                    double versionNum = Double.parseDouble(devProtocol);
                    if (versionNum >= Protocol.VERSION_42.getVersionNum()) {
                        Logger.debug((Object)"set Memps Available");
                        devInfo.setMempAvailable(true);
                    }
                }
                catch (Exception exception) {
                    Logger.debug((Object)("protocol version - " + devProtocol));
                }
            }
            devices.add(devInfo);
            bAdded = true;
        } else if (result.equals(new DAResult(DAResult.ErrorCode.ERR_NOT_SUPPORTED))) {
            Logger.warning((Object)("Cannot found some components: " + result.getMessage()));
            result.setDetailMessage(String.valueOf(devInfo.getIDevice().getDeviceName()) + ", " + devInfo.getIDevice().getSerialNumber());
            UIActionHolder.getUIAction().showWarning(result);
        } else {
            Logger.warning((Object)("Cannot connect with swap manager : " + result.getMessage()));
            result.setDetailMessage(String.valueOf(devInfo.getIDevice().getDeviceName()) + ", " + devInfo.getIDevice().getSerialNumber());
            UIActionHolder.getUIAction().showWarning(result);
        }
        return bAdded;
    }

    private static void updateToolbarByDevice() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!Toolbar.INSTANCE.updateDeviceCombo(null)) {
                    Toolbar.INSTANCE.updateAppCombo(true);
                }
            }
        });
    }

    public static void addDeviceListener() {
        SmartDevelopmentBridge.addDeviceChangeListener((IDeviceChangeListener)deviceChanged);
    }

    public static void removeDeviceListener() {
        SmartDevelopmentBridge.removeDeviceChangeListener((IDeviceChangeListener)deviceChanged);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadDevices() {
        if (sdbBridge != null) {
            List<DeviceInfo> list = devices;
            synchronized (list) {
                IDevice[] devices = sdbBridge.getDevices();
                int size = devices.length;
                int i = 0;
                while (i < size) {
                    if (DeviceUtil.isOnline((IDevice)devices[i])) {
                        DeviceManager.onConnectedInternal(devices[i]);
                    }
                    ++i;
                }
            }
        } else {
            Logger.debug((Object)"sdbbridge is null!");
        }
    }

    public static List<DeviceInfo> getDevicesOnSdb() {
        ArrayList<DeviceInfo> sdbDevices = new ArrayList<DeviceInfo>();
        if (sdbBridge != null) {
            IDevice[] devices = sdbBridge.getDevices();
            int size = devices.length;
            int i = 0;
            while (i < size) {
                if (DeviceUtil.isOnline((IDevice)devices[i])) {
                    sdbDevices.add(new DeviceInfo(devices[i]));
                }
                ++i;
            }
        } else {
            Logger.debug((Object)"sdbbridge is null!");
        }
        return sdbDevices;
    }

    public static List<DeviceInfo> getDevices() {
        return Collections.unmodifiableList(devices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DeviceInfo getDeviceByName(String name) {
        List<DeviceInfo> list = devices;
        synchronized (list) {
            for (DeviceInfo device : devices) {
                if (!device.getIDevice().getSerialNumber().equals(name)) continue;
                return device;
            }
        }
        return null;
    }

    public static boolean isDeviceConnected() {
        return !devices.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean onDeviceSelected(String serial) {
        boolean bret = true;
        if (serial == null || serial.isEmpty()) {
            Global.setCurrentDeviceInfo(null);
        } else {
            boolean bFound = false;
            List<DeviceInfo> list = devices;
            synchronized (list) {
                for (DeviceInfo device : devices) {
                    if (!serial.equals(device.getIDevice().getSerialNumber())) continue;
                    Global.setCurrentDeviceInfo(device);
                    bFound = true;
                    break;
                }
            }
            if (!bFound) {
                bret = false;
            }
        }
        return bret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAll() {
        List<DeviceInfo> list = devices;
        synchronized (list) {
            for (DeviceInfo device : devices) {
                device.getCommunicator().disconnect();
            }
        }
    }
}

