/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.protocol.p30;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DAResult;
import org.tizen.dynamicanalyzer.common.ElfSymbolExtractor;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.common.path.PathManager;
import org.tizen.dynamicanalyzer.communicator.AckMessage;
import org.tizen.dynamicanalyzer.communicator.BaseCommunicator;
import org.tizen.dynamicanalyzer.communicator.CommunicatorUtils;
import org.tizen.dynamicanalyzer.communicator.DeviceInfo;
import org.tizen.dynamicanalyzer.communicator.ISerializable;
import org.tizen.dynamicanalyzer.communicator.ProcessAdditionalInfo;
import org.tizen.dynamicanalyzer.communicator.ProtocolParser;
import org.tizen.dynamicanalyzer.communicator.ProtocolSerializer;
import org.tizen.dynamicanalyzer.communicator.SubCommunicator;
import org.tizen.dynamicanalyzer.communicator.UnsupportedProtocolException;
import org.tizen.dynamicanalyzer.constant.CommonConstants;
import org.tizen.dynamicanalyzer.control.ApplistManager;
import org.tizen.dynamicanalyzer.control.IProgress;
import org.tizen.dynamicanalyzer.model.AddrSymbolPair;
import org.tizen.dynamicanalyzer.model.DATime;
import org.tizen.dynamicanalyzer.nl.UserErrorWarningLabels;
import org.tizen.dynamicanalyzer.project.AppInfo;
import org.tizen.dynamicanalyzer.project.BinaryInfo;
import org.tizen.dynamicanalyzer.project.DeviceStatusInfo;
import org.tizen.dynamicanalyzer.project.PackageInfo;
import org.tizen.dynamicanalyzer.protocol.p30.ApplicationInst30;
import org.tizen.dynamicanalyzer.protocol.p30.FunctionInst30;
import org.tizen.dynamicanalyzer.protocol.p30.LibraryInst30;
import org.tizen.dynamicanalyzer.protocol.p30.ProtocolConfig30;
import org.tizen.dynamicanalyzer.protocol.p30.ProtocolFilter30;
import org.tizen.dynamicanalyzer.setting.FlatFeature;
import org.tizen.dynamicanalyzer.setting.FlatPreferences;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.swap.communicator.SwapErrorCode;
import org.tizen.dynamicanalyzer.util.ByteUtil;
import org.tizen.dynamicanalyzer.util.CommonUtil;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.sdblib.IShellOutputReceiver;
import org.tizen.sdblib.receiver.MultiLineReceiver;
import org.tizen.sdblib.service.SyncResult;

public class Communicator30
extends SubCommunicator {
    private Socket dataSocket = null;

    public Communicator30(BaseCommunicator parent) {
        super(parent);
    }

    @Override
    public Socket getDataSocket(int index) {
        return this.dataSocket;
    }

    @Override
    public DAResult connect() {
        int localPort = this.parent.getLocalPort();
        DAResult result = this.createDataSocket(localPort);
        if (!result.isSuccess()) {
            Logger.warning((Object)result.toString());
            return new DAResult(DAResult.ErrorCode.ERR_DATA_SOCKET_CREATION_FAIL);
        }
        result = this.sendTargetInfoMessage(null);
        if (!result.isSuccess()) {
            Logger.warning((Object)result.toString());
            return result;
        }
        this.parent.getDevice().getDeviceStatusInfo().setApiNameMap(this.getApiMap());
        result = this.sendConfigurationMessage(null);
        if (result.isSuccess()) {
            this.parent.getDevice().setConfigSuccess(true);
        } else {
            Logger.warning((Object)result.toString());
        }
        return result;
    }

    @Override
    public DAResult disconnect() {
        if (this.dataSocket != null) {
            try {
                this.dataSocket.close();
            }
            catch (IOException iOException) {
                Logger.warning((Object)"Failed to close data socket");
            }
        }
        return new DAResult(DAResult.ErrorCode.SUCCESS);
    }

    protected DAResult createDataSocket(int localPort) {
        DAResult result = new DAResult(DAResult.ErrorCode.SUCCESS);
        Socket dataSock = null;
        try {
            dataSock = new Socket("127.0.0.1", localPort);
            dataSock.setSoTimeout(1000);
            dataSock.setReuseAddress(true);
            dataSock.setTcpNoDelay(true);
        }
        catch (UnknownHostException e) {
            result = new DAResult(DAResult.ErrorCode.ERR_EXCEPTION_OCCURRED);
            result.setDetailMessage(e.getMessage());
            Logger.exception((Throwable)e);
        }
        catch (SocketException e) {
            result = new DAResult(DAResult.ErrorCode.ERR_EXCEPTION_OCCURRED);
            result.setDetailMessage(e.getMessage());
            Logger.exception((Throwable)e);
        }
        catch (IOException e) {
            result = new DAResult(DAResult.ErrorCode.ERR_EXCEPTION_OCCURRED);
            result.setDetailMessage(e.getMessage());
            Logger.exception((Throwable)e);
        }
        if (result.isSuccess()) {
            this.dataSocket = dataSock;
            AnalyzerManager.setDataSocketClosed(false);
        }
        return result;
    }

    @Override
    public DAResult sendTargetInfoMessage(IProgress progress) {
        byte[] pbyte;
        Logger.debug((Object)"Send target info...");
        ProtocolSerializer ps = new ProtocolSerializer();
        ps.setMessageID(7);
        byte[] msg = ps.toByteArray();
        AckMessage result = this.parent.handleControlMessage(msg);
        if (result != null && result.isSuccess() && result.isCorrectID(4103) && (pbyte = result.getPayload()) != null) {
            ProtocolParser parser = new ProtocolParser(pbyte);
            DeviceStatusInfo tInfo = this.parent.getDevice().getDeviceStatusInfo();
            parser.getInt();
            tInfo.setSystemMemorySize(parser.getLong());
            tInfo.setStorageSize(parser.getLong());
            tInfo.setBluetoothSupport(parser.getInt());
            tInfo.setGpsSupport(parser.getInt());
            tInfo.setWifiSupport(parser.getInt());
            tInfo.setCameraCount(parser.getInt());
            tInfo.setNetworkType(parser.getString());
            tInfo.setMaxBrightness(parser.getInt());
            tInfo.setCpuCount(parser.getInt());
            int numberOfDevice = parser.getInt();
            tInfo.setDeviceCount(numberOfDevice);
            String deviceList = "";
            int i = 0;
            while (i < numberOfDevice) {
                deviceList = String.valueOf(deviceList) + parser.getString();
                if (i + 1 != numberOfDevice) {
                    deviceList = String.valueOf(deviceList) + ",";
                }
                ++i;
            }
            tInfo.setDevices(deviceList);
            return new DAResult(DAResult.ErrorCode.SUCCESS);
        }
        return new DAResult(DAResult.ErrorCode.ERR_TARGET_INFO_GET_FAIL);
    }

    protected Map<Integer, String> getApiMap() {
        DeviceInfo device = this.parent.getDevice();
        final ArrayList lines = new ArrayList();
        CommunicatorUtils.execShellCommand(device.getIDevice(), "/usr/bin/profile_command getprobemap", (IShellOutputReceiver)new MultiLineReceiver(){

            public void processNewLines(String[] newlines) {
                int i = 0;
                while (i < newlines.length) {
                    lines.add(newlines[i]);
                    ++i;
                }
            }
        });
        TreeMap<Integer, String> apiMap = new TreeMap<Integer, String>();
        apiMap.put(0, "Unknown API");
        if (lines.size() > 0 && !((String)lines.get(0)).contains("Unknown option") && !((String)lines.get(0)).contains("usage:")) {
            int i = 0;
            while (i < lines.size()) {
                String input = (String)lines.get(i);
                String[] splitLine = input.trim().split(" ", 2);
                if (splitLine.length > 1) {
                    int index = Integer.parseInt(splitLine[0]);
                    apiMap.put(index, splitLine[1]);
                } else {
                    Logger.debug((Object)"api map parsing is wrong");
                }
                ++i;
            }
        }
        return apiMap;
    }

    @Override
    public DAResult sendConfigurationMessage(IProgress progress) {
        ProtocolSerializer ps = new ProtocolSerializer();
        ps.setMessageID(4);
        Set<FlatFeature> selectedFeatures = SettingDataManager.INSTANCE.getSelectedFlatFeatureSet();
        Set<FlatPreferences> selectedPreferences = SettingDataManager.INSTANCE.getSelectedPreferenceSet();
        byte[] featureFlag = ProtocolConfig30.getFlatFeatureFlagValue(selectedFeatures, selectedPreferences);
        ps.putByteArray(featureFlag);
        Logger.debug(selectedFeatures);
        int systemPeriod = SettingDataManager.INSTANCE.getPreferenceValue(FlatPreferences.SYSTEM_SAMPLING_RATE);
        int samplingPeriod = SettingDataManager.INSTANCE.getPreferenceValue(FlatPreferences.FUNCTION_SAMPLING_RATE);
        ps.putInt(systemPeriod);
        ps.putInt(samplingPeriod);
        byte[] msg = ps.toByteArray();
        AckMessage result = this.parent.handleControlMessage(msg);
        if (result != null && result.isSuccess() && result.isCorrectID(4100)) {
            return new DAResult(DAResult.ErrorCode.SUCCESS);
        }
        return new DAResult(DAResult.ErrorCode.ERR_CONFIG_FAILED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DAResult sendTraceStartMessage(IProgress progress) throws InterruptedException {
        ProtocolSerializer ps = new ProtocolSerializer();
        ps.setMessageID(2);
        AppInfo curApp = Global.getCurrentApplication();
        if (SettingDataManager.INSTANCE.isFlatFeatureSelected(FlatFeature.UI_HIERARCHY_ANALYSIS) && curApp.getAppType().equals("webapp")) {
            Logger.error((Object)"Web application can not traced with UI_HIERARCHY_ANALYSIS feature enabled");
            return new DAResult(DAResult.ErrorCode.ERR_WEB_APP_WITH_UIHV);
        }
        if (!this.serializeApplicationInst(ps)) {
            Logger.error((Object)"cannot get application inst");
            return new DAResult(DAResult.ErrorCode.ERR_MSG_START_FAIL);
        }
        ps.putInt(0);
        byte[] msg = ps.toByteArray();
        AckMessage result = this.parent.handleControlMessage(msg, progress);
        if (result != null && result.isCorrectID(4098) && result.isSuccess()) {
            ProtocolParser pp = new ProtocolParser(result.getPayload());
            pp.getInt();
            int sec = pp.getInt();
            int nano = pp.getInt();
            Object object = AnalyzerManager.waitStartAck;
            synchronized (object) {
                Global.getProject().checkAndSetProfilingStartTime(new DATime(sec, nano));
                AnalyzerManager.waitStartAck.notifyAll();
            }
            return new DAResult(DAResult.ErrorCode.SUCCESS);
        }
        return new DAResult(DAResult.ErrorCode.ERR_MSG_START_FAIL);
    }

    protected boolean serializeApplicationInst(ProtocolSerializer ps) {
        DeviceInfo dev = this.parent.getDevice();
        AppInfo curApp = Global.getCurrentApplication();
        PackageInfo curPkg = dev.getPkgInfoByPkgID(curApp.getPackageID());
        List<AppInfo> apps = curPkg.getAppInfos();
        ArrayList<ApplicationInst30> appInstList = new ArrayList<ApplicationInst30>();
        if (curPkg.getPackageId().equals("da.id.dummy.app.running")) {
            Map<Integer, String> map = apps.get(0).getRunningProcesses();
            if (map != null && map.size() > 0) {
                for (Map.Entry<Integer, String> entry : map.entrySet()) {
                    BinaryInfo binInfo = Global.getProject().getDeviceStatusInfo().getBinaryInfo(entry.getValue());
                    String temppath = binInfo.getTempBinaryPath();
                    if (temppath == null) continue;
                    ApplicationInst30 appInst = new ApplicationInst30();
                    appInst.setApplicationType(2);
                    appInst.setApplicationID(entry.getKey().toString());
                    appInst.setExecutablePath(entry.getValue());
                    List<AddrSymbolPair> symbols = apps.get(0).getSymbols(temppath);
                    appInst.setFunctionInstList(this.getFunctionInstList(symbols));
                    appInstList.add(appInst);
                }
            }
        } else if (curPkg.getPackageId().equals("da.id.dummy.app.systemwide")) {
            ApplicationInst30 applicationInst30 = new ApplicationInst30();
            applicationInst30.setApplicationType(2);
            applicationInst30.setApplicationID("");
            applicationInst30.setExecutablePath("");
            appInstList.add(applicationInst30);
        } else {
            for (AppInfo appInfo : apps) {
                List<AddrSymbolPair> symbols;
                List<ISerializable> functionInstList;
                BinaryInfo binInfo;
                String temppath;
                if (ApplistManager.isInBlackList(appInfo) || (temppath = (binInfo = Global.getProject().getDeviceStatusInfo().getBinaryInfo(appInfo.getExecBinaryPath())).getTempBinaryPath()) == null || (functionInstList = this.getFunctionInstList(symbols = appInfo.getSymbols(temppath))).isEmpty()) continue;
                ApplicationInst30 appInst = new ApplicationInst30();
                if (appInfo.equals(curApp)) {
                    String appType = appInfo.getInfo(AppInfo.PROPERTY.APPTYPE.index);
                    if (appType.contains("c++")) {
                        appInst.setApplicationType(1);
                        appInst.setApplicationID(appInfo.getAppID());
                    } else if (appType.contains("webapp")) {
                        appInst.setApplicationType(4);
                        appInst.setApplicationID(appInfo.getAppID());
                    } else if (appType.contains("capp")) {
                        appInst.setApplicationType(1);
                        appInst.setApplicationID(appInfo.getAppID());
                    } else {
                        appInst.setApplicationType(3);
                        appInst.setApplicationID("");
                    }
                } else {
                    appInst.setApplicationType(2);
                    appInst.setApplicationID("");
                }
                appInst.setExecutablePath(appInfo.getExecPath());
                appInst.setFunctionInstList(functionInstList);
                appInstList.add(appInst);
            }
        }
        ps.putInt(appInstList.size());
        for (ISerializable iSerializable : appInstList) {
            iSerializable.serialize(ps);
        }
        return appInstList.size() != 0;
    }

    protected List<ISerializable> getFunctionInstList(List<AddrSymbolPair> symbols) {
        ArrayList<ISerializable> functionInstList = new ArrayList<ISerializable>();
        int size = symbols == null ? 0 : symbols.size();
        int i = 0;
        while (i < size) {
            AddrSymbolPair addrSymbol = symbols.get(i);
            String symbol = addrSymbol.getSymbol();
            if (!ProtocolFilter30.isInBlacklistFunctionInst(symbol)) {
                FunctionInst30 functionInst = new FunctionInst30();
                functionInst.setAddr(addrSymbol.getAddr());
                functionInst.setArgs(this.getFunctionArgs(symbol));
                functionInstList.add(functionInst);
            }
            ++i;
        }
        return functionInstList;
    }

    @Override
    public DAResult sendTraceStopMessage(IProgress progress) {
        ProtocolSerializer ps = new ProtocolSerializer();
        ps.setMessageID(3);
        byte[] msg = ps.toByteArray();
        AckMessage result = this.parent.handleControlMessage(msg);
        if (result != null && result.isSuccess() && result.isCorrectID(4099)) {
            AnalyzerManager.setStopAckArrived(true);
            return new DAResult(DAResult.ErrorCode.SUCCESS);
        }
        return new DAResult(DAResult.ErrorCode.ERR_MSG_STOP_FAIL);
    }

    @Override
    public DAResult sendInstrumentAddMessage(IProgress progress, List<String> paths) {
        return this.sendIntrumentMessage(true, paths);
    }

    @Override
    public DAResult sendInstrumentRemoveMessage(IProgress progress, List<String> paths) {
        return this.sendIntrumentMessage(false, paths);
    }

    /*
     * WARNING - void declaration
     */
    protected DAResult sendIntrumentMessage(boolean isAdd, List<String> paths) {
        void var7_8;
        ProtocolSerializer ps = new ProtocolSerializer();
        if (isAdd) {
            ps.setMessageID(8);
        } else {
            ps.setMessageID(9);
        }
        DeviceInfo dev = this.parent.getDevice();
        ArrayList<LibraryInst30> libInstList = new ArrayList<LibraryInst30>();
        int count = paths.size();
        boolean bl = false;
        while (var7_8 < count) {
            String localPath;
            ElfSymbolExtractor symbolExtractor;
            String binaryPath = paths.get((int)var7_8);
            BinaryInfo binInfo = dev.getDeviceStatusInfo().getBinaryInfo(binaryPath);
            if (binInfo != null && (symbolExtractor = new ElfSymbolExtractor()).makeSymbol(localPath = binInfo.getTempBinaryPath())) {
                List<AddrSymbolPair> symbols = symbolExtractor.getAddrSymbolPairs();
                List<ISerializable> functionInstList = this.getFunctionInstList(symbols);
                LibraryInst30 newInst = new LibraryInst30();
                newInst.setPath(binaryPath);
                newInst.setFunctionInstList(functionInstList);
                libInstList.add(newInst);
            }
            ++var7_8;
        }
        if (libInstList.isEmpty()) {
            Logger.warning((Object)"Failed to send instrumentation : there is no available binary");
            return new DAResult(DAResult.ErrorCode.ERR_SWAP_INSTRUMENTATION_FAIL);
        }
        ps.putInt(libInstList.size());
        for (ISerializable iSerializable : libInstList) {
            iSerializable.serialize(ps);
        }
        byte[] byArray = ps.toByteArray();
        AckMessage result = this.parent.handleControlMessage(byArray);
        int ackMsg = isAdd ? 4104 : 4105;
        if (result != null && result.isCorrectID(ackMsg) && result.isSuccess()) {
            return new DAResult(DAResult.ErrorCode.SUCCESS);
        }
        return new DAResult(DAResult.ErrorCode.ERR_SWAP_INSTRUMENTATION_FAIL);
    }

    @Override
    public DAResult sendBinaryInfoMessage(IProgress progress, List<String> binPaths) {
        ProtocolSerializer ps = new ProtocolSerializer();
        ps.setMessageID(5);
        int binCount = binPaths.size();
        ps.putInt(binCount);
        int i = 0;
        while (i < binCount) {
            String targetPath = binPaths.get(i);
            ps.putString(targetPath);
            ++i;
        }
        byte[] msg = ps.toByteArray();
        AckMessage result = this.parent.handleControlMessage(msg);
        if (result != null && result.isCorrectID(4101) && (result.isSuccess() || result.getReturnCode() == SwapErrorCode.ERR_WRONG_MESSAGE_DATA.getErrorNumber() && result.getPayloadLength() > 4)) {
            return this.parseBinaryInfo(result.getPayload(), binPaths);
        }
        return new DAResult(DAResult.ErrorCode.ERR_BIN_INFO_GET_FAIL);
    }

    protected DAResult parseBinaryInfo(byte[] payload, List<String> targetPaths) {
        DAResult ret = new DAResult(DAResult.ErrorCode.SUCCESS);
        StringBuffer detailErrorMsg = new StringBuffer();
        ProtocolParser parser = new ProtocolParser(payload);
        parser.getInt();
        DeviceInfo curDevice = this.parent.getDevice();
        int count = parser.getInt();
        int i = 0;
        while (i < count) {
            String targetPath = targetPaths.get(i);
            BinaryInfo binInfo = curDevice.getDeviceStatusInfo().getBinaryInfo(targetPath);
            int binaryType = parser.getInt();
            String localBinaryPath = parser.getString().trim();
            String md5sum = parser.getString();
            binInfo.setType(binaryType);
            binInfo.setMd5sumValue(md5sum);
            binInfo.setTempBinaryPath(null);
            if (binaryType < 0) {
                if (detailErrorMsg.length() != 0) {
                    detailErrorMsg.append(CommonConstants.NEW_LINE);
                }
                if (binaryType == -1) {
                    detailErrorMsg.append(String.valueOf(UserErrorWarningLabels.ERROR_NONEXIST_BINARY) + "(" + targetPath + ")");
                } else if (binaryType == -2) {
                    detailErrorMsg.append(String.valueOf(UserErrorWarningLabels.ERROR_NONELF_BINARY) + "(" + targetPath + ")");
                }
                ret = new DAResult(DAResult.ErrorCode.ERR_BIN_INFO_GET_FAIL);
            } else {
                DAResult result = this.checkDirtyOfBinary(binInfo, localBinaryPath);
                if (!result.isSuccess()) {
                    ret = result;
                }
            }
            ++i;
        }
        if (ret.equals((Object)DAResult.ErrorCode.ERR_BIN_INFO_GET_FAIL)) {
            ret.setDetailMessage(detailErrorMsg.toString());
        }
        return ret;
    }

    protected DAResult checkDirtyOfBinary(BinaryInfo binInfo, String localBinaryPath) {
        DAResult result = new DAResult(DAResult.ErrorCode.SUCCESS);
        String targetPath = binInfo.getTargetBinaryPath();
        String[] splitLocalBinaryPath = localBinaryPath.split(Pattern.quote(File.separator));
        if (splitLocalBinaryPath.length < 3 || !new File(localBinaryPath).exists()) {
            localBinaryPath = String.valueOf(PathManager.DA_TEMP_FOLDER_PATH) + File.separator + this.getFileName(targetPath);
            result = this.pullTheFile(targetPath, localBinaryPath);
            if (result.isSuccess()) {
                binInfo.setTempBinaryPath(localBinaryPath);
            }
        } else {
            String localHashCode = null;
            try {
                Runtime rt = Runtime.getRuntime();
                Process process = rt.exec(new String[]{this.getMd5Command(), localBinaryPath});
                process.waitFor();
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                BufferedReader error = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                String line = reader.readLine();
                String errorStr = error.readLine();
                if (line == null) {
                    Logger.warning((Object)("host md5sum get failed : " + errorStr));
                } else {
                    if (CommonUtil.isWin()) {
                        line = line.replace("\\", "");
                    }
                    localHashCode = this.parseMd5Result(line);
                }
            }
            catch (IOException e) {
                Logger.exception((Throwable)e);
            }
            catch (InterruptedException e) {
                Logger.exception((Throwable)e);
            }
            if (localHashCode == null || localHashCode.compareTo(binInfo.getMd5sumValue()) != 0) {
                localBinaryPath = String.valueOf(PathManager.DA_TEMP_FOLDER_PATH) + File.separator + this.getFileName(targetPath);
                result = this.pullTheFile(targetPath, localBinaryPath);
                if (result.isSuccess()) {
                    binInfo.setTempBinaryPath(localBinaryPath);
                }
            } else {
                binInfo.setTempBinaryPath(localBinaryPath);
            }
        }
        return result;
    }

    protected DAResult pullTheFile(String from, String to) {
        DeviceInfo curDev = this.parent.getDevice();
        SyncResult res = CommunicatorUtils.pull(curDev.getIDevice(), from, to);
        if (res != null && !res.isOk() && SettingDataManager.INSTANCE.isPlatformDA()) {
            if (!curDev.isRootAvailable()) {
                return new DAResult(DAResult.ErrorCode.ERR_BY_SECURITY);
            }
            if (!CommunicatorUtils.becomeSuperUser(curDev.getIDevice(), true)) {
                return new DAResult(DAResult.ErrorCode.ERR_BY_SECURITY);
            }
            res = CommunicatorUtils.pull(curDev.getIDevice(), from, to);
            CommunicatorUtils.becomeSuperUser(curDev.getIDevice(), false);
        }
        if (res != null && res.isOk()) {
            Logger.debug((Object)("binary copy success : " + from));
            return new DAResult(DAResult.ErrorCode.SUCCESS);
        }
        Logger.warning((Object)("Failed to get " + from));
        DAResult ret = new DAResult(DAResult.ErrorCode.ERR_DOWNLOAD_FILE_FAILED);
        if (!curDev.getIDevice().isRoot()) {
            ret = new DAResult(DAResult.ErrorCode.ERR_DOWNLOAD_FILE_FAILED_DUETO_SECURITY);
        }
        ret.setDetailMessage("(Failed to download: " + from + ")");
        return ret;
    }

    protected String getMd5Command() {
        String cmd = null;
        if (CommonUtil.isLinux()) {
            cmd = "/usr/bin/md5sum";
        } else if (CommonUtil.isMac()) {
            cmd = "/sbin/md5";
        } else if (CommonUtil.isWin()) {
            cmd = String.valueOf(PathManager.DA_TOOL_FOLDER_PATH) + File.separator + "md5sum.exe";
        } else {
            Logger.warning((Object)"Unknown host OS!\n");
        }
        return cmd;
    }

    protected String parseMd5Result(String line) {
        String md5value = null;
        String[] splitResult = line.trim().split(" ");
        if (CommonUtil.isLinux()) {
            md5value = new String(splitResult[0]);
        } else if (CommonUtil.isMac()) {
            md5value = new String(splitResult[splitResult.length - 1]);
        } else if (CommonUtil.isWin()) {
            md5value = new String(splitResult[0]);
        } else {
            Logger.warning((Object)"Unknown host OS!\n");
        }
        return md5value;
    }

    protected String getFileName(String fullPath) {
        if (fullPath == null || fullPath.isEmpty()) {
            return null;
        }
        String[] splitPath = fullPath.split("/");
        return new String(splitPath[splitPath.length - 1]);
    }

    @Override
    public DAResult sendKeepAliveMessage(IProgress progress) {
        ProtocolSerializer ps = new ProtocolSerializer();
        ps.setMessageID(1);
        byte[] msg = ps.toByteArray();
        AckMessage result = this.parent.handleControlMessage(msg);
        if (result != null && result.isCorrectID(4097) && result.isSuccess()) {
            return new DAResult(DAResult.ErrorCode.SUCCESS);
        }
        return new DAResult(DAResult.ErrorCode.ERR_KEEP_ALIVE);
    }

    protected byte[] getFunctionArgs(String symbol) {
        int start = symbol.indexOf("(");
        int end = symbol.indexOf(")");
        byte[] byArray = new byte[3];
        byArray[0] = 112;
        byArray[2] = 110;
        byte[] emptyRet = byArray;
        if (start < 0 || end < 0) {
            return emptyRet;
        }
        String argStr = symbol.substring(start + 1, end).trim();
        if (argStr.isEmpty()) {
            return emptyRet;
        }
        String[] args = argStr.split(",");
        byte[] ret = new byte[args.length + 2];
        ret[args.length + 1] = 0;
        ret[0] = 112;
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            int index = arg.indexOf(" ");
            if (index > 0) {
                arg = arg.substring(0, index - 1);
            }
            ret[i + 1] = (byte)this.getArgType(arg);
            ++i;
        }
        byte[] test = new byte[]{110};
        ret = ByteUtil.getByte((Object[])new Object[]{ret, test});
        return ret;
    }

    protected char getArgType(String input) {
        if (input.equals("int")) {
            return 'd';
        }
        if (input.equals("char")) {
            return 'c';
        }
        if (input.equals("long")) {
            return 'x';
        }
        if (input.equals("float")) {
            return 'f';
        }
        if (input.equals("double")) {
            return 'w';
        }
        if (input.equals("bool")) {
            return 'b';
        }
        return 'p';
    }

    @Override
    public DAResult sendScreenshotMessage(IProgress progress) {
        ProtocolSerializer ps = new ProtocolSerializer();
        ps.setMessageID(16);
        byte[] msg = ps.toByteArray();
        AckMessage result = this.parent.handleControlMessage(msg, 0, false, null);
        if (result != null && result.isSuccess()) {
            return new DAResult(DAResult.ErrorCode.SUCCESS);
        }
        return new DAResult(DAResult.ErrorCode.ERR_SCREENSHOT_GET_FAIL);
    }

    @Override
    public DAResult sendProcessAddInfoMessage(IProgress progress, List<Integer> pids, Map<Integer, ProcessAdditionalInfo> infoMap) {
        infoMap.clear();
        int pidcount = pids.size();
        if (pidcount > 0) {
            ProtocolSerializer ps = new ProtocolSerializer();
            ps.setMessageID(17);
            ps.putInt(pidcount);
            int i = 0;
            while (i < pidcount) {
                int pid = pids.get(i);
                ps.putInt(pid);
                ++i;
            }
            byte[] msg = ps.toByteArray();
            AckMessage result = this.parent.handleControlMessage(msg, 1000);
            if (result != null && result.isCorrectID(4113) && (result.isSuccess() || result.getPayloadLength() > 4)) {
                ProtocolParser parser = new ProtocolParser(result.getPayload());
                parser.getInt();
                int count = parser.getInt();
                int i2 = 0;
                while (i2 < count) {
                    int pid = parser.getInt();
                    String cmdname = parser.getString();
                    ProcessAdditionalInfo procinfo = new ProcessAdditionalInfo();
                    procinfo.setProcessName(cmdname);
                    infoMap.put(pid, procinfo);
                    ++i2;
                }
            }
        }
        if (infoMap.isEmpty()) {
            return new DAResult(DAResult.ErrorCode.ERR_PROCESS_ADD_INFO_GET_FAIL);
        }
        return new DAResult(DAResult.ErrorCode.SUCCESS);
    }

    @Override
    public DAResult sendProbeMapMessage(IProgress progress) throws UnsupportedProtocolException {
        throw new UnsupportedProtocolException();
    }

    @Override
    public DAResult sendUIHierarchyMessage(IProgress progress, int requestOption) throws InterruptedException, UnsupportedProtocolException {
        throw new UnsupportedProtocolException();
    }

    @Override
    public DAResult sendUIScreenshotMessage(IProgress progress, long uiObjectAddress) throws InterruptedException, UnsupportedProtocolException {
        throw new UnsupportedProtocolException();
    }

    @Override
    public DAResult sendUIHierarchyCancelMessage(IProgress progress) throws InterruptedException, UnsupportedProtocolException {
        throw new UnsupportedProtocolException();
    }

    @Override
    public DAResult sendRealPathMessage(IProgress progress, String path) throws InterruptedException, UnsupportedProtocolException {
        String command = "/usr/bin/profile_command readlink " + path;
        final ArrayList readlinkResult = new ArrayList();
        CommunicatorUtils.execShellCommand(this.parent.getDevice().getIDevice(), command, (IShellOutputReceiver)new MultiLineReceiver(){

            public void processNewLines(String[] appLines) {
                int i = 0;
                while (i < appLines.length) {
                    readlinkResult.add(appLines[i]);
                    ++i;
                }
            }
        });
        if (readlinkResult.size() == 1) {
            BinaryInfo binInfo = this.parent.getDevice().getDeviceStatusInfo().getBinaryInfo(path);
            binInfo.setRealPath((String)readlinkResult.get(0));
            return new DAResult(DAResult.ErrorCode.SUCCESS);
        }
        return new DAResult(DAResult.ErrorCode.ERR_MSG_SEND_FAIL);
    }
}

