/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.file;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.widgets.Composite;
import org.tizen.dynamicanalyzer.communicator.DACommunicator;
import org.tizen.dynamicanalyzer.constant.CommonConstants;
import org.tizen.dynamicanalyzer.nl.FilePageLabels;
import org.tizen.dynamicanalyzer.nl.TimelineChartLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.ui.common.PopupRangeAnalysisMenuItemOnChartListener;
import org.tizen.dynamicanalyzer.ui.common.TimeLineChartKeyListener;
import org.tizen.dynamicanalyzer.ui.common.TimelineChartMouseEventListener;
import org.tizen.dynamicanalyzer.ui.common.TimelineChartMouseTrackAdapter;
import org.tizen.dynamicanalyzer.ui.file.FileChart;
import org.tizen.dynamicanalyzer.ui.file.FileChartRenderer;
import org.tizen.dynamicanalyzer.ui.file.FilePage;
import org.tizen.dynamicanalyzer.ui.file.manager.FileDataMaker;
import org.tizen.dynamicanalyzer.ui.file.manager.FileDataManager;
import org.tizen.dynamicanalyzer.ui.file.model.FileAccess;
import org.tizen.dynamicanalyzer.ui.file.model.FileAccessor;
import org.tizen.dynamicanalyzer.ui.file.model.FileSelectedData;
import org.tizen.dynamicanalyzer.ui.file.model.FileStatus;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.ui.widgets.DADefaultChartBoard;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.dynamicanalyzer.utils.Formatter;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlot;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotTooltip;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartRenderer;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeries;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoard;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenu;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenuItem;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenuListener;

public class FileChartBoard
extends DADefaultChartBoard {
    private List<FileChart> chartList = new ArrayList<FileChart>();
    private FileDataManager fileChartManager = FileDataManager.getInstance();
    private FileDataMaker dataMaker;
    private int parentChartIndex = -1;
    private int preSelectionPID = -1;
    private Map<Integer, int[]> chartIndexMap = new HashMap<Integer, int[]>();
    private Map<Integer, Integer> childChartCount = new HashMap<Integer, Integer>();
    public static final int FILE_NAME_MAX_LENGTH = 12;
    public static final int FILE_NAME_SHOW_LINENUM = 2;
    public static final int PROCESS_NAME_MAX_LENGTH = 16;
    public static final int PROCESS_NAME_SHOW_LINENUM = 1;
    public static final int MAX_LINE = 10;

    public FileChartBoard(Composite parent, String title) {
        super(parent, title);
        this.dataMaker = this.fileChartManager.getFileChartDataMaker();
    }

    protected void callBackScaleChanged() {
        super.callBackScaleChanged();
        this.updateChart();
    }

    protected void callBackScrollChanged() {
        super.callBackScrollChanged();
        this.updateChart();
    }

    protected void callBackSizeChanged() {
        this.layout(true, true);
        super.callBackSizeChanged();
    }

    public void updateChart() {
        this.clearSeries();
        this.addNewFileChartRows();
        this.updateStatusSeries();
        this.updateAccessSeries();
        this.chartFilteringByPId();
    }

    public void clear() {
        super.clear();
        this.chartList.clear();
    }

    public void clearSeries() {
        if (this.chartList == null) {
            return;
        }
        for (FileChart chart : this.chartList) {
            chart.clearSeries();
        }
    }

    private void chartFilteringByPId() {
        if (this.getItemList() == null) {
            return;
        }
        int selectedPID = Toolbar.INSTANCE.getSelectedPid();
        if (this.preSelectionPID == selectedPID) {
            return;
        }
        HashMap<Integer, Integer> hideCount = new HashMap<Integer, Integer>();
        for (FileChart chart : this.chartList) {
            if (chart.isParentChart()) continue;
            int[] index = this.getChartIndex(chart.getFileAccessor().getAccessorId());
            int parentIndex = index[0];
            int childIndex = index[1];
            int childCount = 0;
            int hideNum = 1;
            if (selectedPID == 0) {
                this.showAllItems();
                this.preSelectionPID = selectedPID;
                return;
            }
            if (chart.getFileAccessor().getPid() == selectedPID) {
                this.showChildItem(parentIndex, childIndex);
                continue;
            }
            if (this.childChartCount.get(parentIndex) != null) {
                childCount = this.childChartCount.get(parentIndex);
            } else {
                Logger.warning((Object)("Parent chart does not exist:" + parentIndex));
            }
            if (hideCount.get(parentIndex) == null) {
                hideCount.put(parentIndex, hideNum);
            } else {
                hideNum = (Integer)hideCount.get(parentIndex);
                hideCount.put(parentIndex, hideNum++);
            }
            if (childCount == hideNum) {
                this.hideItem(parentIndex);
                continue;
            }
            this.hideChildItem(parentIndex, childIndex);
        }
        this.preSelectionPID = selectedPID;
    }

    private void addNewFileChartRows() {
        FileChart parent = null;
        FileChart child = null;
        String filePath = null;
        boolean isTarget = false;
        int fileId = 0;
        List<FileAccessor> accessorList = this.dataMaker.getFileAccessorList();
        if (accessorList == null) {
            return;
        }
        for (FileAccessor accessor : accessorList) {
            filePath = accessor.getFilePath();
            fileId = accessor.getFileId();
            isTarget = accessor.isTarget();
            parent = this.getParentChart(fileId);
            if (parent == null) {
                ++this.parentChartIndex;
                parent = new FileChart(filePath, fileId);
                child = new FileChart(accessor, this.parentChartIndex, isTarget);
                parent.addChild(child);
                parent.setChartIndex(this.parentChartIndex);
                this.createChartItem(null, parent);
                this.createChartItem(parent, child);
                this.chartList.add(parent);
                this.chartList.add(child);
                this.putChartIndextoMap(child, parent);
                continue;
            }
            child = parent.getChildChart(accessor);
            if (child != null) continue;
            child = new FileChart(accessor, parent.getChartIndex(), isTarget);
            parent.addChild(child);
            this.createChartItem(parent, child);
            this.chartList.add(child);
            this.putChartIndextoMap(child, parent);
        }
    }

    private void createChartItem(FileChart parent, FileChart fileChart) {
        DAChart chart;
        DAChartBoardItem item;
        if (parent != null) {
            DAChartBoardItem parentItem = parent.getItem();
            StringBuffer title = new StringBuffer();
            int pid = fileChart.getFileAccessor().getPid();
            String processName = null;
            String porcessInfo = "(PID:" + fileChart.getFileAccessor().getPid() + ", TID:" + fileChart.getFileAccessor().getTid() + ")";
            processName = fileChart.getFileAccessor().isTarget() ? AnalyzerUtil.getProcessName(fileChart.getFileAccessor().getPid()) : DACommunicator.getProcessName(pid);
            if (processName != null) {
                title.append(String.valueOf(processName) + CommonConstants.NEW_LINE + porcessInfo);
            } else {
                title.append("unKnown process" + CommonConstants.NEW_LINE + porcessInfo);
            }
            String name = this.splitTitle(title.toString(), 16, false, 1);
            String fullName = this.splitTitle(title.toString(), 16, false, 10);
            item = new DAChartBoardItem(parentItem, name, fullName);
            chart = item.getChart();
            item.setData((Object)new FileSelectedData(fileChart.getFileAccessor(), false));
            if (!fileChart.isTarget()) {
                item.setSelectable(false);
            }
            this.initFileChart(chart, false);
        } else {
            String fileName = fileChart.getFileName();
            String title = this.splitTitle(fileName, 12, true, 2);
            String fullName = this.splitTitle(fileName, 12, true, 10);
            item = new DAChartBoardItem((DAChartBoard)this, title, fullName);
            item.setData((Object)new FileSelectedData(fileChart.getFileId(), true));
            chart = item.getChart();
            this.initFileChart(chart, true);
        }
        fileChart.setItem(item);
        chart.redraw();
    }

    private void updateStatusSeries() {
        if (this.chartList.size() > 0) {
            List<FileStatus> statusList = this.getVisibleStatusList();
            for (FileChart chart : this.chartList) {
                if (!chart.isParentChart()) continue;
                chart.updateStatusSeries(statusList);
            }
        }
    }

    private void updateAccessSeries() {
        if (this.chartList.size() > 0) {
            List<FileAccess> accessList = this.getVisibleAccessList();
            for (FileChart chart : this.chartList) {
                if (chart.isParentChart()) continue;
                chart.updateAccessSeries(accessList);
            }
        }
    }

    private FileChart getParentChart(int id) {
        for (FileChart chart : this.chartList) {
            if (chart.getFileId() != id || !chart.isParentChart()) continue;
            return chart;
        }
        return null;
    }

    private List<FileStatus> getVisibleStatusList() {
        return this.dataMaker.getFileStatusList();
    }

    private List<FileAccess> getVisibleAccessList() {
        ArrayList<FileAccess> data = new ArrayList<FileAccess>();
        List<FileAccess> accessList = this.dataMaker.getFileAccessList();
        int i = 0;
        while (i < accessList.size()) {
            FileAccess access = accessList.get(i);
            double startTime = Formatter.longTimeToDoubleTime(access.getStartTime());
            double endTime = Formatter.longTimeToDoubleTime(access.getEndTime());
            double visibleStartTime = this.getVisibleStartTime();
            double visibleEndTime = this.getVisibleEndTime();
            if (startTime >= visibleStartTime && startTime <= visibleEndTime) {
                data.add(access);
            } else if (endTime >= visibleStartTime && endTime >= visibleEndTime) {
                data.add(access);
            } else if (startTime <= visibleStartTime && endTime <= visibleEndTime) {
                data.add(access);
            } else if (endTime <= 0.0) {
                data.add(access);
            }
            ++i;
        }
        return data;
    }

    private void putChartIndextoMap(FileChart childChart, FileChart parentChart) {
        int parentIndex = parentChart.getChartIndex();
        int childIndex = parentChart.getLastChildChartIndex();
        this.chartIndexMap.put(childChart.getFileAccessor().getAccessorId(), new int[]{parentIndex, childIndex});
        if (this.childChartCount.get(parentIndex) == null) {
            this.childChartCount.put(parentIndex, 1);
        } else {
            int num = this.childChartCount.get(parentIndex);
            this.childChartCount.put(parentIndex, num + 1);
        }
    }

    public int[] getChartIndex(int accessorId) {
        if (this.chartIndexMap.containsKey(accessorId)) {
            return this.chartIndexMap.get(accessorId);
        }
        Logger.error((Object)("couldn't find index:" + accessorId));
        return new int[2];
    }

    private String splitTitle(String name, int maxLen, boolean isParent, int line) {
        String titleString = "";
        String[] title = null;
        int len = name.length();
        if (!isParent) {
            title = name.split("\n");
            name = title[0];
            len = name.length();
        }
        if (len > maxLen) {
            int startIndex = 0;
            int endIndex = maxLen;
            int i = 1;
            while (i < line + 1) {
                String slice = name.substring(startIndex, endIndex);
                titleString = String.valueOf(titleString) + slice + CommonConstants.NEW_LINE;
                String spare = name.substring(endIndex);
                if (i < line && spare.length() < maxLen) {
                    titleString = String.valueOf(titleString) + spare;
                    break;
                }
                if (i == line && spare.length() > 0) {
                    titleString = String.valueOf(titleString.substring(0, titleString.length() - 3)) + "...";
                }
                startIndex += maxLen;
                endIndex += maxLen;
                ++i;
            }
        } else {
            titleString = name;
        }
        if (!isParent) {
            titleString = String.valueOf(titleString) + CommonConstants.NEW_LINE + title[1];
        }
        return titleString;
    }

    private void initFileChart(DAChart chart, boolean isParent) {
        if (chart == null) {
            return;
        }
        DAChartPlot plot = chart.getPlot();
        chart.setChartRenderer((DAChartRenderer)new FileChartRenderer());
        if (isParent) {
            DAChartSeries statusSeries = new DAChartSeries(FilePageLabels.FILE_CHART_SERIES, 16, ColorResources.WHITE);
            chart.addSeries(statusSeries);
            plot.setBackgroundImage(ImageResources.BG_GRADIENT);
        } else {
            DAChartSeries lockSeries = new DAChartSeries(FilePageLabels.FILE_CHART_LOCK, 16, ColorResources.YELLOW);
            chart.addSeries(lockSeries);
            DAChartSeries accessSeries = new DAChartSeries(FilePageLabels.FILE_CHART_ACCESS, 16, ColorResources.WHITE);
            chart.addSeries(accessSeries);
            plot.setBackgroundImage(ImageResources.BG_CHILD_GRADIENT);
        }
        plot.setAutoHeightRange(DAChartPlot.AutoRangeType.MANUAL);
        plot.setAxisFont(FontResources.CHART_AXIS_FONT);
        plot.setAxisRangeY(0.0, 101.0);
        plot.setAxisRangeX(this.getVisibleStartTime(), this.getVisibleEndTime());
        DAChartPlotTooltip tooltip = new DAChartPlotTooltip(-1.0);
        tooltip.setFont(FontResources.CHART_TOOLTIP_FONT);
        plot.setTooltip(tooltip);
        DAPopupMenu popupMenu = new DAPopupMenu((Composite)chart);
        popupMenu.setFont(FontResources.CONTEXT_MENU_ITEM_FONT);
        DAPopupMenuItem analysisItem = new DAPopupMenuItem(popupMenu);
        analysisItem.setText(TimelineChartLabels.RANGE_CONTEXT_ANALYSIS);
        analysisItem.addListener((DAPopupMenuListener)new PopupRangeAnalysisMenuItemOnChartListener(analysisItem, this, chart));
        TimelineChartMouseEventListener timelineChartMouseEventListener = new TimelineChartMouseEventListener(popupMenu, this.getTimeline(), FilePage.pageID);
        chart.addMouseListener((MouseListener)timelineChartMouseEventListener);
        chart.addMouseMoveListener((MouseMoveListener)timelineChartMouseEventListener);
        chart.addMouseTrackListener((MouseTrackListener)new TimelineChartMouseTrackAdapter(this.getTimeline()));
        TimeLineChartKeyListener timelineKeyListener = new TimeLineChartKeyListener(this);
        chart.addKeyListener((KeyListener)timelineKeyListener);
        plot.setMarkers(this.getMarkers());
    }

    public int getChartSize() {
        return this.chartList.size();
    }

    public List<FileChart> getChartList() {
        return this.chartList;
    }
}

