/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.info.screenshot;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.ui.info.screenshot.ScreenshotDataManager;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonClickEventListener;
import org.tizen.dynamicanalyzer.widgets.da.base.DAMessageBox;
import org.tizen.dynamicanalyzer.widgets.helper.ColorResources;

public class ScreenshotDialog
extends DAMessageBox {
    private static boolean opened = false;
    private final int DIALOG_WIDTH_MARGIN = 12;
    private final int DIALOG_HEIGHT_MARGIN = 65;
    private Image image = null;
    private String fileName = null;
    private int index = -1;
    private DACustomButton nextButton = null;
    private DACustomButton prevButton = null;
    private Label imageLabel = null;
    private double imageWidth = 0.0;
    private double imageHeight = 0.0;

    public ScreenshotDialog(Shell parentShell) {
        super(parentShell);
    }

    private void createButtons() {
        this.nextButton = new DACustomButton((Composite)this.shell, ImageResources.DA_IMAGEVIEWER_ARROW_R_NOR, ImageResources.DA_IMAGEVIEWER_ARROW_R_SEL, ImageResources.DA_IMAGEVIEWER_ARROW_R_NOR, ImageResources.DA_IMAGEVIEWER_ARROW_R_DIM);
        this.nextButton.setBackground(ColorResources.WHITE);
        this.nextButton.addClickListener(new DACustomButtonClickEventListener(){

            public void handleClickEvent(DACustomButton button) {
                ScreenshotDialog.this.setNextImage();
                ScreenshotDialog.this.updateDialog();
            }
        });
        this.prevButton = new DACustomButton((Composite)this.shell, ImageResources.DA_IMAGEVIEWER_ARROW_L_NOR, ImageResources.DA_IMAGEVIEWER_ARROW_L_SEL, ImageResources.DA_IMAGEVIEWER_ARROW_L_NOR, ImageResources.DA_IMAGEVIEWER_ARROW_L_DIM);
        this.prevButton.setBackground(ColorResources.WHITE);
        this.prevButton.addClickListener(new DACustomButtonClickEventListener(){

            public void handleClickEvent(DACustomButton button) {
                ScreenshotDialog.this.setPrevImage();
                ScreenshotDialog.this.updateDialog();
            }
        });
        FormData data = new FormData();
        data.left = new FormAttachment(100, -23);
        data.bottom = new FormAttachment(100, -5);
        data.width = 13;
        data.height = 24;
        this.nextButton.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 10);
        data.bottom = new FormAttachment(100, -5);
        data.width = 13;
        data.height = 24;
        this.prevButton.setLayoutData((Object)data);
        this.updateButtonStatus();
    }

    private void normalizeImageSize() {
        this.imageWidth = this.image.getBounds().width;
        this.imageHeight = this.image.getBounds().height;
        if (this.image.getBounds().width > 360) {
            double rate = 360.0 / (double)this.image.getBounds().width;
            this.imageWidth *= rate;
            this.imageHeight *= rate;
        }
    }

    private void updateButtonStatus() {
        if (this.index == 0) {
            this.prevButton.setEnabled(false);
        } else {
            this.prevButton.setEnabled(true);
        }
        if (this.index == ScreenshotDataManager.getInstance().getImageList().size() - 1) {
            this.nextButton.setEnabled(false);
        } else {
            this.nextButton.setEnabled(true);
        }
    }

    private void updateDialog() {
        this.shell.setText(this.fileName);
        this.imageLabel.setImage(this.resizeImage(this.image, (int)this.imageWidth, (int)this.imageHeight));
        this.updateButtonStatus();
    }

    protected boolean run() {
        if (opened) {
            return false;
        }
        this.normalizeImageSize();
        this.shell.setSize((int)this.imageWidth + 12, (int)this.imageHeight + 65);
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setText(this.fileName);
        this.shell.setBackground(ColorResources.WHITE);
        this.imageLabel = new Label((Composite)this.shell, 0x40000000);
        this.imageLabel.setBackground(ColorResources.WHITE);
        this.imageLabel.setImage(this.resizeImage(this.image, (int)this.imageWidth, (int)this.imageHeight));
        FormData imageFormData = new FormData();
        imageFormData.top = new FormAttachment(0, 3);
        imageFormData.left = new FormAttachment(0, 3);
        this.imageLabel.setLayoutData((Object)imageFormData);
        this.createButtons();
        return true;
    }

    private Image resizeImage(Image image, int width, int height) {
        Image scaled = new Image((Device)Display.getDefault(), width, height);
        GC gc = new GC((Drawable)scaled);
        gc.setAntialias(1);
        gc.setInterpolation(2);
        gc.drawImage(image, 0, 0, image.getBounds().width, image.getBounds().height, 0, 0, width, height);
        return scaled;
    }

    public void loadScreenshotData(int index) {
        this.index = index;
        this.image = ScreenshotDataManager.getInstance().getImage(index);
        this.fileName = ScreenshotDataManager.getInstance().getfileName(index);
    }

    private void setNextImage() {
        if (this.index + 1 < ScreenshotDataManager.getInstance().getImageList().size()) {
            ++this.index;
            this.image = ScreenshotDataManager.getInstance().getImage(this.index);
            this.fileName = ScreenshotDataManager.getInstance().getfileName(this.index);
        }
    }

    private void setPrevImage() {
        if (this.index > 0) {
            --this.index;
            this.image = ScreenshotDataManager.getInstance().getImage(this.index);
            this.fileName = ScreenshotDataManager.getInstance().getfileName(this.index);
        }
    }
}

