/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.interactive.data;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.util.Logger;

public class InteractiveVariableDBTable
extends DBTable {
    private static final String TABLENAME = "CHECKPOINT_VARIABLE";
    private static final int MAX_NAME_LEN = 128;
    private static final int MAX_TYPE_LEN = 64;
    public static final String BEFORE_VARIABLE_ID = "BEFORE_VARIABLE_ID";
    public static final String AFTER_VARIABLE_ID = "AFTER_VARIABLE_ID";
    public static final String CHECK_LOCATION = "CHECK_LOCATION";
    public static final String VARIABLE_TYPE = "VARIABLE_TYPE";
    public static final String VARIABLE_TYPE_NAME = "VARIABLE_TYPE_NAME";
    public static final String VARIABLE_NAME = "VARIABLE_NAME";
    public static final String FUNCTION_ID = "FUNCTION_ID";
    public static final String SOURCE_LINE_NUMBER = "SOURCE_LINE_NUMBER";
    public static final String SOURCE_FILE_NAME = "SOURCE_FILE_NAME";
    public static final String POINTER_ORDER = "POINTER_ORDER";
    public static final String POINTER_SIZE = "POINTER_SIZE";
    public static final String ARRAY_COUNT = "ARRAY_COUNT";
    public static final String BYTE_SIZE = "BYTE_SIZE";
    public static final String OFFSET = "OFFSET";
    public static final String IS_TARGET = "IS_TARGET";
    public static final String CHILDREN_VARIABLE_ID = "CHILDREN_VARIABLE_ID";

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    public InteractiveVariableDBTable() {
        this.addColumn(new DBColumn(BEFORE_VARIABLE_ID, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(AFTER_VARIABLE_ID, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(CHECK_LOCATION, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(VARIABLE_TYPE, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(VARIABLE_TYPE_NAME, "", "VARCHAR", 64));
        this.addColumn(new DBColumn(VARIABLE_NAME, "NOT NULL", "VARCHAR", 128));
        this.addColumn(new DBColumn(FUNCTION_ID, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(SOURCE_LINE_NUMBER, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(SOURCE_FILE_NAME, "NOT NULL", "VARCHAR", 128));
        this.addColumn(new DBColumn(POINTER_ORDER, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(POINTER_SIZE, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(ARRAY_COUNT, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(BYTE_SIZE, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(OFFSET, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(IS_TARGET, "NOT NULL", "BOOLEAN"));
        this.addColumn(new DBColumn(CHILDREN_VARIABLE_ID, "", "BIGINT ARRAY"));
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                int index = 1;
                prep.setLong(index++, (Long)rowData.get(COLUMN.BEFORE_VARIABLE_ID.ordinal()));
                prep.setLong(index++, (Long)rowData.get(COLUMN.AFTER_VARIABLE_ID.ordinal()));
                prep.setInt(index++, (Integer)rowData.get(COLUMN.CHECK_LOCATION.ordinal()));
                prep.setInt(index++, (Integer)rowData.get(COLUMN.VARIABLE_TYPE.ordinal()));
                String name = (String)rowData.get(COLUMN.VARIABLE_TYPE_NAME.ordinal());
                if (name != null && name.length() > 64) {
                    Logger.warning((Object)("Overflow occurs VARIABLE_TYPE_NAME in InteractiveVariableDBTable : " + name));
                    name = name.substring(0, 128);
                }
                prep.setString(index++, name);
                name = (String)rowData.get(COLUMN.VARIABLE_NAME.ordinal());
                if (name != null && name.length() > 128) {
                    Logger.warning((Object)("Overflow occurs VARIABLE_NAME in InteractiveVariableDBTable : " + name));
                    name = name.substring(0, 128);
                }
                prep.setString(index++, name);
                prep.setInt(index++, (Integer)rowData.get(COLUMN.FUNCTION_ID.ordinal()));
                prep.setInt(index++, (Integer)rowData.get(COLUMN.SOURCE_LINE_NUMBER.ordinal()));
                name = (String)rowData.get(COLUMN.SOURCE_FILE_NAME.ordinal());
                if (name != null && name.length() > 128) {
                    Logger.warning((Object)("Overflow occurs SOURCE_FILE_NAME in InteractiveVariableDBTable : " + name));
                    name = name.substring(0, 128);
                }
                prep.setString(index++, name);
                prep.setInt(index++, (Integer)rowData.get(COLUMN.POINTER_ORDER.ordinal()));
                prep.setInt(index++, (Integer)rowData.get(COLUMN.POINTER_SIZE.ordinal()));
                prep.setInt(index++, (Integer)rowData.get(COLUMN.ARRAY_COUNT.ordinal()));
                prep.setInt(index++, (Integer)rowData.get(COLUMN.BYTE_SIZE.ordinal()));
                prep.setInt(index++, (Integer)rowData.get(COLUMN.OFFSET.ordinal()));
                prep.setBoolean(index++, (Boolean)rowData.get(COLUMN.IS_TARGET.ordinal()));
                this.setArrayToPreparedStatement(COLUMN.CHILDREN_VARIABLE_ID.ordinal(), "BIGINT", prep, rowData);
            }
            catch (SQLException e) {
                Logger.error((Object)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }

    @Override
    public List<Object> extractDataFromResultSet(ResultSet rs) {
        ArrayList<Object> row = new ArrayList<Object>();
        try {
            int index = 1;
            row.add(rs.getLong(index++));
            row.add(rs.getLong(index++));
            row.add(rs.getInt(index++));
            row.add(rs.getInt(index++));
            row.add(rs.getString(index++));
            row.add(rs.getString(index++));
            row.add(rs.getInt(index++));
            row.add(rs.getInt(index++));
            row.add(rs.getString(index++));
            row.add(rs.getInt(index++));
            row.add(rs.getInt(index++));
            row.add(rs.getInt(index++));
            row.add(rs.getInt(index++));
            row.add(rs.getInt(index++));
            row.add(rs.getBoolean(index++));
            row.add(this.getArrayFromResultSet(rs, index++, 0L));
        }
        catch (SQLException e) {
            Logger.error((Object)e);
            return null;
        }
        return row;
    }

    public static enum COLUMN {
        BEFORE_VARIABLE_ID,
        AFTER_VARIABLE_ID,
        CHECK_LOCATION,
        VARIABLE_TYPE,
        VARIABLE_TYPE_NAME,
        VARIABLE_NAME,
        FUNCTION_ID,
        SOURCE_LINE_NUMBER,
        SOURCE_FILE_NAME,
        POINTER_ORDER,
        POINTER_SIZE,
        ARRAY_COUNT,
        BYTE_SIZE,
        OFFSET,
        IS_TARGET,
        CHILDREN_VARIABLE_ID;

    }
}

