/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory;

import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.nl.MemoryPageLabels;
import org.tizen.dynamicanalyzer.setting.FlatPreferences;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.ui.memory.MemoryPage;
import org.tizen.dynamicanalyzer.ui.memory.table.MemoryPersistentAllocationsTable;
import org.tizen.dynamicanalyzer.ui.memory.table.MemoryPersistentAllocationsTableIndex;
import org.tizen.dynamicanalyzer.widgets.da.view.DAHidableViewComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class MemoryPersistentAllocationsTableView
extends DAHidableViewComposite {
    private MemoryPersistentAllocationsTable tableComp = null;
    private boolean onlyLeaks = false;

    public MemoryPersistentAllocationsTableView(Composite parent, int style, boolean onlyLeaks) {
        super(parent, style, false, MemoryPageLabels.STREAMING_NOT_SUPPORTED);
        this.onlyLeaks = onlyLeaks;
        this.setTitle(onlyLeaks ? MemoryPageLabels.MEMORY_LEAKS_VIEW_TITLE : MemoryPageLabels.MEMORY_ALLOCATION_TRACE_VIEW_TITLE);
        this.ID = onlyLeaks ? MemoryPage.leaksViewID : MemoryPage.persistentAllocsViewID;
        this.tableComp = new MemoryPersistentAllocationsTable(this.getContentArea(), 0, 68352, onlyLeaks);
        this.setDataComposite(this.tableComp);
    }

    public void updateView() {
        boolean cur;
        boolean pref;
        if (!this.onlyLeaks && (pref = SettingDataManager.INSTANCE.isPreferenceSelected(FlatPreferences.LEAK_SANITIZER)) != (cur = this.tableComp.getColumnVisibility()[MemoryPersistentAllocationsTableIndex.LEAK.getIndex()])) {
            this.setLeakColumnVisible(pref);
            this.tableComp.cleanColumnsWeights();
            this.tableComp.resizeColumns(this.getSize().x);
        }
        if (DAState.isRunning()) {
            if (!this.isHidden() && !this.tableComp.isSelectionPerformed()) {
                this.hide();
            }
        } else if (this.isHidden()) {
            this.show();
            this.tableComp.updateTable();
        }
    }

    public void updateView(final DAViewData vdata) {
        this.tableComp.taskQueueSize = this.tableComp.taskQueueSize + 1;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                this.subRun();
                ((MemoryPersistentAllocationsTableView)MemoryPersistentAllocationsTableView.this).tableComp.taskQueueSize = ((MemoryPersistentAllocationsTableView)MemoryPersistentAllocationsTableView.this).tableComp.taskQueueSize - 1;
            }

            private void subRun() {
                if (!(vdata instanceof DASelectionData)) {
                    return;
                }
                DASelectionData selData = (DASelectionData)vdata;
                if (selData.getStartTime() == selData.getEndTime()) {
                    MemoryPersistentAllocationsTableView.this.tableComp.setSelectionRange(0L, 0L);
                    if (DAState.isRunning()) {
                        MemoryPersistentAllocationsTableView.this.hide();
                        MemoryPersistentAllocationsTableView.this.tableComp.clear();
                        return;
                    }
                    MemoryPersistentAllocationsTableView.this.show();
                } else {
                    MemoryPersistentAllocationsTableView.this.tableComp.setSelectionRange(selData.getStartTime(), selData.getEndTime());
                    MemoryPersistentAllocationsTableView.this.show();
                }
                if (!MemoryPersistentAllocationsTableView.this.onlyLeaks) {
                    MemoryPersistentAllocationsTableView.this.setLeakColumnVisible(SettingDataManager.INSTANCE.isPreferenceSelected(FlatPreferences.LEAK_SANITIZER));
                }
                MemoryPersistentAllocationsTableView.this.tableComp.updateTable();
            }
        });
    }

    private void setLeakColumnVisible(boolean visible) {
        GridColumn col = this.tableComp.getTable().getColumn(MemoryPersistentAllocationsTableIndex.LEAK.getIndex());
        col.setVisible(visible);
    }

    public void clear() {
        this.tableComp.clear();
    }

    public Control getControl() {
        return this.tableComp;
    }
}

