/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory.chart;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.tizen.dynamicanalyzer.nl.TimelineChartLabels;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.ui.common.PopupRangeAnalysisMenuItemOnChartListener;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlot;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotTooltip;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeries;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoard;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenu;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenuItem;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenuListener;

public class MemoryChart {
    public DAChart chart;
    protected DAChartBoardItem chartBoardItem;
    protected int chartType;
    protected int chartStyle = 0;
    protected String chartName;
    protected Image chartIcon;
    protected Image addIcon;
    protected String pageID;
    protected DAPopupMenu popupMenu;
    protected int pid = 0;
    private List<MemoryChart> children = new ArrayList<MemoryChart>();

    public MemoryChart(String pageID) {
        this.pageID = pageID;
    }

    public MemoryChart(String pageID, String chartName, DAChartBoardItem chartBoardItem, DAChart chart) {
        this.pageID = pageID;
        this.chartName = chartName;
        this.chartBoardItem = chartBoardItem;
        this.chart = chart;
    }

    public DAChartBoardItem getChartItem() {
        return this.chartBoardItem;
    }

    public void setChartITem(DAChartBoardItem item) {
        this.chartBoardItem = item;
    }

    public int getChartType() {
        return this.chartType;
    }

    public String getChartName() {
        return this.chartName;
    }

    public void clear() {
        if (this.chart != null && !this.chart.isDisposed()) {
            this.chart.clear();
        }
    }

    public void clearSeries() {
        if (this.chart == null || this.chart.getSeriesList() == null) {
            return;
        }
        for (DAChartSeries series : this.chart.getSeriesList()) {
            series.clear();
        }
    }

    public DAPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public void update() {
        if (this.chart != null && !this.chart.isDisposed()) {
            this.chart.redraw();
        }
    }

    public void setPid(int pid) {
        this.pid = pid;
    }

    public int getPid() {
        return this.pid;
    }

    public void inputChartSeries(List<Object> dataList) {
    }

    public DAChartBoardItem createBoardItem(DAChartBoard chartBoard) {
        DAChartBoardItem item = new DAChartBoardItem(chartBoard, this.chartName, this.chartIcon, this.chartStyle);
        item.useExpand(false);
        this.chart = item.getChart();
        this.setChartStyle();
        this.popupMenu = new DAPopupMenu((Composite)this.chart);
        this.initPopupMenu(chartBoard, this.popupMenu);
        return item;
    }

    protected void setChartStyle() {
        DAChartPlot plot = this.chart.getPlot();
        if (plot == null) {
            return;
        }
        plot.setBackgroundImage(ImageResources.BG_GRADIENT);
        plot.setAutoHeightRange(DAChartPlot.AutoRangeType.SEMI_AUTO);
        DAChartPlotTooltip tooltip = new DAChartPlotTooltip(-1.0);
        tooltip.setFont(FontResources.CHART_TOOLTIP_FONT);
        plot.setTooltip(tooltip);
        plot.setAxisFont(FontResources.CHART_AXIS_FONT);
    }

    protected void initPopupMenu(DAChartBoard chartBoard, DAPopupMenu popupMenu) {
        popupMenu.setFont(FontResources.CONTEXT_MENU_ITEM_FONT);
        DAPopupMenuItem analysisItem = new DAPopupMenuItem(popupMenu);
        analysisItem.setText(TimelineChartLabels.RANGE_CONTEXT_ANALYSIS);
        analysisItem.addListener((DAPopupMenuListener)new PopupRangeAnalysisMenuItemOnChartListener(analysisItem, chartBoard, this.chart));
    }

    public void pushChild(MemoryChart child) {
        this.children.add(child);
    }

    public boolean isParentChart() {
        return this.children.size() > 0;
    }

    public DAChart getChart() {
        return this.chart;
    }
}

