/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory.data;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.util.Logger;

public class ProcessMemoryDBTable
extends DBTable {
    private static final String TABLENAME = "MEMORY_PROCESS_DATA";

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    public static String getTablename() {
        return TABLENAME;
    }

    public ProcessMemoryDBTable() {
        this.addColumn(new DBColumn(COLUMN.SAMPLING_TIME.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.PID.name, "", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.CPU_LOAD.name, "", "FLOAT"));
        this.addColumn(new DBColumn(COLUMN.MEMORY_VIRTUAL.name, "", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.MEMORY_RESIDENT.name, "", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.MEMORY_SHARED.name, "", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.MEMORY_PSS.name, "", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.MEMORY_THREED.name, "", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.MEMORY_GEM.name, "", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.THREAD_COUNT.name, "", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.HEAP_ALLOCATION_TOTAL_BYTE.name, "", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.HEAP_ALLOCATION_BINARY_ID.name, "", "INTEGER ARRAY"));
        this.addColumn(new DBColumn(COLUMN.HEAP_ALLOCATION_BYTE.name, "", "BIGINT ARRAY"));
        this.addColumn(new DBColumn(COLUMN.TID.name, "", "INTEGER ARRAY"));
        this.addColumn(new DBColumn(COLUMN.THREAD_LOAD.name, "", "DOUBLE ARRAY"));
        this.setIndexColumn(COLUMN.SAMPLING_TIME.index);
        this.setIndexColumn(COLUMN.PID.index);
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                prep.setLong(1, (Long)rowData.get(COLUMN.SAMPLING_TIME.index));
                prep.setInt(2, (Integer)rowData.get(COLUMN.PID.index));
                prep.setFloat(3, ((Float)rowData.get(COLUMN.CPU_LOAD.index)).floatValue());
                prep.setLong(4, (Long)rowData.get(COLUMN.MEMORY_VIRTUAL.index));
                prep.setLong(5, (Long)rowData.get(COLUMN.MEMORY_RESIDENT.index));
                prep.setLong(6, (Long)rowData.get(COLUMN.MEMORY_SHARED.index));
                prep.setLong(7, (Long)rowData.get(COLUMN.MEMORY_PSS.index));
                prep.setLong(8, (Long)rowData.get(COLUMN.MEMORY_THREED.index));
                prep.setLong(9, (Long)rowData.get(COLUMN.MEMORY_GEM.index));
                prep.setInt(10, (Integer)rowData.get(COLUMN.THREAD_COUNT.index));
                prep.setLong(11, (Long)rowData.get(COLUMN.HEAP_ALLOCATION_TOTAL_BYTE.index));
                this.setArrayToPreparedStatement(COLUMN.HEAP_ALLOCATION_BINARY_ID.index, "INTEGER", prep, rowData);
                this.setArrayToPreparedStatement(COLUMN.HEAP_ALLOCATION_BYTE.index, "BIGINT", prep, rowData);
                this.setArrayToPreparedStatement(COLUMN.TID.index, "INTEGER", prep, rowData);
                this.setArrayToPreparedStatement(COLUMN.THREAD_LOAD.index, "FLOAT", prep, rowData);
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }

    @Override
    public List<Object> extractDataFromResultSet(ResultSet rs) {
        ArrayList<Object> row = new ArrayList<Object>();
        try {
            int index = 1;
            row.add(rs.getLong(index++));
            row.add(rs.getInt(index++));
            row.add(Float.valueOf(rs.getFloat(index++)));
            row.add(rs.getLong(index++));
            row.add(rs.getLong(index++));
            row.add(rs.getLong(index++));
            row.add(rs.getLong(index++));
            row.add(rs.getLong(index++));
            row.add(rs.getLong(index++));
            row.add(rs.getInt(index++));
            row.add(rs.getLong(index++));
            row.add(this.getArrayFromResultSet(rs, index++, 0));
            row.add(this.getArrayFromResultSet(rs, index++, 0L));
            row.add(this.getArrayFromResultSet(rs, index++, 0));
            row.add(this.getArrayFromResultSet(rs, index++, Float.valueOf(0.0f)));
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
            return null;
        }
        return row;
    }

    public static enum COLUMN {
        SAMPLING_TIME(0, "SAMPLING_TIME"),
        PID(1, "PID"),
        CPU_LOAD(2, "CPU_LOAD"),
        MEMORY_VIRTUAL(3, "MEMORY_VIRTUAL"),
        MEMORY_RESIDENT(4, "MEMORY_RESIDENT"),
        MEMORY_SHARED(5, "MEMORY_SHARED"),
        MEMORY_PSS(6, "MEMORY_PSS"),
        MEMORY_THREED(7, "MEMORY_THREED"),
        MEMORY_GEM(8, "MEMORY_GEM"),
        THREAD_COUNT(9, "THREAD_COUNT"),
        HEAP_ALLOCATION_TOTAL_BYTE(10, "HEAP_ALLOCATION_TOTAL_BYTE"),
        HEAP_ALLOCATION_BINARY_ID(11, "HEAP_ALLOCATION_BINARY_ID"),
        HEAP_ALLOCATION_BYTE(12, "HEAP_ALLOCATION_BYTE"),
        TID(13, "TID"),
        THREAD_LOAD(14, "THREAD_LOAD");

        public final int index;
        public final String name;

        private COLUMN(int index, String name) {
            this.index = index;
            this.name = name;
        }
    }
}

