/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory.table;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.model.TableInput;
import org.tizen.dynamicanalyzer.nl.MemoryPageLabels;
import org.tizen.dynamicanalyzer.ui.memory.MemoryPersistentAllocationsTableView;
import org.tizen.dynamicanalyzer.ui.memory.data.HeapDataManager;
import org.tizen.dynamicanalyzer.ui.memory.table.MemoryPersistentAllocationsTableIndex;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.ui.widgets.table.DefaultTableComparator;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;
import org.tizen.dynamicanalyzer.widgets.timeline.MarkerManager;

public class MemoryPersistentAllocationsTable
extends DATableComposite {
    private Long StartTime = 0L;
    private Long EndTime = 0L;
    private boolean onlyLeaks;

    public MemoryPersistentAllocationsTable(Composite parent, int style, int tableStyle, boolean onlyLeaks) {
        super(parent, style, tableStyle);
        this.onlyLeaks = onlyLeaks;
        this.setTableName(MemoryPageLabels.MEMORY_ALLOCATION_TRACE_VIEW_TITLE);
        this.setComparator(new DefaultTableComparator());
        this.setSortTypes(MemoryPersistentAllocationsTableIndex.getSortTypes());
        this.setColumnAlignment(MemoryPersistentAllocationsTableIndex.getAlignments());
        this.setColumns(MemoryPersistentAllocationsTableIndex.getNames());
        int[] columnSizes = MemoryPersistentAllocationsTableIndex.getSizes();
        this.setColumnSize(columnSizes);
        this.setTableToolTipEnable(false);
        this.table.getColumn(MemoryPersistentAllocationsTableIndex.SEQ.getIndex()).setVisible(false);
        if (onlyLeaks) {
            this.table.getColumn(MemoryPersistentAllocationsTableIndex.LEAK.getIndex()).setVisible(false);
        }
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GridItem[] items = ((Grid)e.widget).getSelection();
                if (items == null || items.length == 0) {
                    return;
                }
                int size = items.length;
                List<Object> startData = ((DATableDataFormat)items[0].getData()).getData();
                List<Object> endData = ((DATableDataFormat)items[size - 1].getData()).getData();
                long startTime = (Long)startData.get(MemoryPersistentAllocationsTableIndex.TIMESTAMP.getIndex());
                long endTime = (Long)endData.get(MemoryPersistentAllocationsTableIndex.TIMESTAMP.getIndex());
                Toolbar.INSTANCE.setChartDragStartTime(startTime);
                Toolbar.INSTANCE.setChartDragEndTime(endTime);
                Toolbar.INSTANCE.setDlogSelection(false);
                Composite view = MemoryPersistentAllocationsTable.this.table.getParent();
                while (view != null && !(view instanceof MemoryPersistentAllocationsTableView)) {
                    view = view.getParent();
                }
                if (view == null) {
                    Logger.warning((Object)"Could not find parent view");
                    return;
                }
                DASelectionData data = new DASelectionData(((MemoryPersistentAllocationsTableView)view).getID(), startTime, endTime, items, (Control)MemoryPersistentAllocationsTable.this.table);
                AnalyzerManager.getCurrentPage().updateView((DAViewData)data);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.table.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                GridItem[] ti = ((Grid)e.widget).getSelection();
                if (ti == null || ti.length == 0) {
                    return;
                }
                List<Object> markerData = ((DATableDataFormat)ti[0].getData()).getData();
                long markerTime = (Long)markerData.get(MemoryPersistentAllocationsTableIndex.TIMESTAMP.getIndex());
                MarkerManager.INSTANCE.addMarker(markerTime);
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }

    public void setSelectionRange(Long start, Long end) {
        this.StartTime = start;
        this.EndTime = end;
    }

    public boolean isSelectionPerformed() {
        return this.StartTime != this.EndTime;
    }

    @Override
    protected List<TableInput> makeTableInput() {
        List<TableInput> wholedata;
        ArrayList<TableInput> output = new ArrayList<TableInput>();
        if (Global.getProject() == null) {
            return output;
        }
        if (!DAState.isRunning() && this.StartTime == 0L && this.EndTime == 0L && Toolbar.INSTANCE.getSelectedPid() <= 0 && (wholedata = this.onlyLeaks ? HeapDataManager.getInstance().getLeaksTableInput() : HeapDataManager.getInstance().getPersistentAllocsTableInput()).size() != 0) {
            return wholedata;
        }
        List<List<Object>> allocDataList = null;
        allocDataList = HeapDataManager.getInstance().remainedAllocatedListForRange(this.StartTime, this.EndTime, this.onlyLeaks);
        if (allocDataList == null || allocDataList.size() == 0) {
            return output;
        }
        int index = 0;
        int size = allocDataList.size();
        int j = 0;
        while (j < size) {
            List<Object> iAllocData = allocDataList.get(j);
            TableInput alloInput = HeapDataManager.getInstance().makePersistentAllocsTableInput(iAllocData, index++, this.onlyLeaks);
            if (alloInput != null) {
                output.add(alloInput);
            }
            ++j;
        }
        return output;
    }

    public void removeSelection() {
        this.table.removeAll();
        this.updateTable();
    }

    @Override
    public void clear() {
        this.table.removeAll();
        this.getSelectionIndex().clear();
        this.getSelections().clear();
        this.StartTime = 0L;
        this.EndTime = 0L;
    }

    public void cleanColumnsWeights() {
        this.columnWeights = null;
    }
}

