/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.network;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.widgets.Composite;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.nl.NetworkPageLabels;
import org.tizen.dynamicanalyzer.nl.ThreadPageLabels;
import org.tizen.dynamicanalyzer.nl.TimelineChartLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.ui.common.PopupRangeAnalysisMenuItemOnChartListener;
import org.tizen.dynamicanalyzer.ui.common.TimeLineChartKeyListener;
import org.tizen.dynamicanalyzer.ui.common.TimelineChartMouseEventListener;
import org.tizen.dynamicanalyzer.ui.common.TimelineChartMouseTrackAdapter;
import org.tizen.dynamicanalyzer.ui.network.NetworkChart;
import org.tizen.dynamicanalyzer.ui.network.NetworkChartRenderer;
import org.tizen.dynamicanalyzer.ui.network.NetworkPage;
import org.tizen.dynamicanalyzer.ui.network.data.NetworkDataManager;
import org.tizen.dynamicanalyzer.ui.network.data.type.NetworkAPIType;
import org.tizen.dynamicanalyzer.ui.network.data.type.NetworkSelectionType;
import org.tizen.dynamicanalyzer.ui.network.data.type.NetworkSeriesType;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.ui.widgets.DADefaultChartBoard;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlot;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotIntervalMarker;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotMarker;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotTooltip;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartRenderer;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeries;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoard;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenu;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenuItem;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenuListener;

public class NetworkChartBoard
extends DADefaultChartBoard {
    private List<NetworkChart> chartItemList = new ArrayList<NetworkChart>();
    private int statusSeriesListCount = -1;
    private boolean isFirstMakeChart = true;
    private int parentChartIndex = -1;
    private LinkedHashMap<Integer, Integer> lastChildChartIndexOfEachParent = new LinkedHashMap();
    private int preSelectionPId = -1;

    public NetworkChartBoard(Composite parent, String title) {
        super(parent, title);
        this.initIntervalMarkers();
    }

    public NetworkChartBoard(Composite parent, String title, int[] scaleValues) {
        super(parent, title, scaleValues);
    }

    public NetworkChartBoard(Composite parent, String title, int boardStyle) {
        super(parent, title, boardStyle);
    }

    protected void callBackScaleChanged() {
        super.callBackScaleChanged();
        this.updateChart();
    }

    protected void callBackScrollChanged() {
        super.callBackScrollChanged();
        this.updateChart();
    }

    protected void callBackSizeChanged() {
        this.layout(true, true);
        super.callBackSizeChanged();
    }

    public void updateChart() {
        this.createChartItem();
        this.clearSeries();
        this.updateSeries();
        this.updateApiSeries();
        this.chartFilteringByPId();
    }

    private void chartFilteringByPId() {
        if (this.getItemList() == null) {
            return;
        }
        int selectedPid = Toolbar.INSTANCE.getSelectedPid();
        if (this.preSelectionPId == selectedPid) {
            return;
        }
        int parentIndex = 0;
        for (NetworkChart chart : this.chartItemList) {
            if (!chart.isParentChartRow()) continue;
            if (selectedPid == 0) {
                this.showItem(parentIndex);
            } else if (selectedPid == chart.getpId()) {
                this.showItem(parentIndex);
            } else {
                this.hideItem(parentIndex);
            }
            ++parentIndex;
        }
        this.preSelectionPId = selectedPid;
    }

    public void clear() {
        super.clear();
        this.chartItemList.clear();
        this.statusSeriesListCount = -1;
        this.isFirstMakeChart = true;
        this.initIntervalMarkers();
        this.parentChartIndex = -1;
        this.lastChildChartIndexOfEachParent = new LinkedHashMap();
        this.preSelectionPId = -1;
    }

    public void initIntervalMarkers() {
        DAChartPlotIntervalMarker selectionMarker = new DAChartPlotIntervalMarker(-1.0, -1.0, 1);
        selectionMarker.setBackgroundColor(ColorResources.SELECTION_RANGE);
        selectionMarker.setAlpha(63);
        this.addIntervalMarker((DAChartPlotMarker)selectionMarker);
        DAChartPlotIntervalMarker rangeAnalyzeMarker = new DAChartPlotIntervalMarker(-1.0, -1.0, 1);
        rangeAnalyzeMarker.setBackgroundColor(ColorResources.YELLOW);
        rangeAnalyzeMarker.setAlpha(63);
        this.addIntervalMarker((DAChartPlotMarker)rangeAnalyzeMarker);
        DAChartPlotIntervalMarker rangeMarker = new DAChartPlotIntervalMarker(-1.0, -1.0, 0);
        rangeMarker.setForegroundColor(ColorResources.RED);
        rangeMarker.setAlpha(63);
        this.addIntervalMarker((DAChartPlotMarker)rangeMarker);
    }

    private void initNetworkChart(DAChart chart, boolean isParent) {
        if (chart == null) {
            return;
        }
        chart.setChartRenderer((DAChartRenderer)new NetworkChartRenderer());
        DAChartPlot plot = chart.getPlot();
        if (plot == null) {
            return;
        }
        if (isParent) {
            plot.setBackgroundImage(ImageResources.BG_GRADIENT);
        } else {
            plot.setBackgroundImage(ImageResources.BG_CHILD_GRADIENT);
        }
        plot.setAutoHeightRange(DAChartPlot.AutoRangeType.MANUAL);
        plot.setAxisFont(FontResources.CHART_AXIS_FONT);
        plot.setAxisRangeY(0.0, 101.0);
        plot.setAxisRangeX(this.getVisibleStartTime(), this.getVisibleEndTime());
        DAChartPlotTooltip tooltip = new DAChartPlotTooltip(-1.0);
        tooltip.setFont(FontResources.CHART_TOOLTIP_FONT);
        plot.setTooltip(tooltip);
        DAPopupMenu popupMenu = new DAPopupMenu((Composite)chart);
        popupMenu.setFont(FontResources.CONTEXT_MENU_ITEM_FONT);
        DAPopupMenuItem analysisItem = new DAPopupMenuItem(popupMenu);
        analysisItem.setText(TimelineChartLabels.RANGE_CONTEXT_ANALYSIS);
        analysisItem.addListener((DAPopupMenuListener)new PopupRangeAnalysisMenuItemOnChartListener(analysisItem, this, chart));
        TimelineChartMouseEventListener timelineChartMouseEventListener = new TimelineChartMouseEventListener(popupMenu, this.getTimeline(), NetworkPage.pageID);
        chart.addMouseListener((MouseListener)timelineChartMouseEventListener);
        chart.addMouseMoveListener((MouseMoveListener)timelineChartMouseEventListener);
        chart.addMouseTrackListener((MouseTrackListener)new TimelineChartMouseTrackAdapter(this.getTimeline()));
        TimeLineChartKeyListener timelineKeyListener = new TimeLineChartKeyListener(this);
        chart.addKeyListener((KeyListener)timelineKeyListener);
        plot.setMarkers(this.getMarkers());
    }

    private NetworkChart getParentChartData(String address, String fd) {
        for (NetworkChart chart : this.chartItemList) {
            if (!chart.getDestinationAddress().equals(address) || !chart.isParentChartRow()) continue;
            return chart;
        }
        return null;
    }

    private void addSeries(DAChart chart) {
        DAChartSeries apiSeries = new DAChartSeries(NetworkPageLabels.NETWORK_CHART_API, 8, ColorResources.YELLOW);
        DAChartSeries stateSeries = new DAChartSeries(NetworkPageLabels.NETWORK_CHART_SERIES, 13, ColorResources.WHITE);
        DAChartSeries accessSeries = new DAChartSeries(NetworkPageLabels.NETWORK_CHART_ACCESS, 9, ColorResources.WHITE);
        apiSeries.setSummarizeTooltipText(ThreadPageLabels.THREAD_TOOLTIP_APIS);
        chart.addSeries(stateSeries);
        chart.addSeries(apiSeries);
        chart.addSeries(accessSeries);
    }

    public boolean createChartItem() {
        this.updateStatusSeriesWhenOpen();
        if (this.statusSeriesListCount == NetworkDataManager.getInstance().getCheckStatusSeries().size()) {
            return true;
        }
        for (String fd : NetworkDataManager.getInstance().getCheckStatusSeries().keySet()) {
            String destinationAddress = NetworkDataManager.getInstance().getCheckStatusSeries().get(fd);
            if (this.isExistChartRow(destinationAddress, fd)) continue;
            this.addChartItemList(destinationAddress, fd);
        }
        this.statusSeriesListCount = NetworkDataManager.getInstance().getCheckStatusSeries().size();
        return true;
    }

    private void updateStatusSeriesWhenOpen() {
        if (!DAState.isStartable() || !this.isFirstMakeChart || NetworkDataManager.getInstance().getSeriesList() == null) {
            return;
        }
        for (NetworkSeriesType status : NetworkDataManager.getInstance().getSeriesList()) {
            NetworkDataManager.getInstance().getCheckStatusSeries().put(status.getFdValue(), status.getDestinationAddress());
        }
        this.isFirstMakeChart = false;
    }

    private boolean isExistChartRow(String destinationAddress, String fd) {
        for (NetworkChart chart : this.chartItemList) {
            if (!chart.getDestinationAddress().equals(destinationAddress) || !chart.getFdValue().equals(fd)) continue;
            return true;
        }
        return false;
    }

    private void addChartItemList(String destinationAddress, String fd) {
        NetworkChart parent = this.getParentChartData(destinationAddress, fd);
        if (parent == null) {
            this.addParentChartItemList(destinationAddress, fd);
        } else {
            this.addChildChartItemList(parent, destinationAddress, fd);
        }
    }

    private void addParentChartItemList(String destinationAddress, String fd) {
        ++this.parentChartIndex;
        this.lastChildChartIndexOfEachParent.put(this.parentChartIndex, 1);
        String[] addr = destinationAddress.split(":");
        StringBuffer chartName = new StringBuffer();
        if (addr.length > 1) {
            chartName.append(addr[0]);
            chartName.append("\n:");
            chartName.append(addr[addr.length - 1]);
            chartName.append("\n");
        } else {
            chartName = new StringBuffer(destinationAddress);
            if (chartName.length() > 10) {
                chartName.replace(10, chartName.length(), "");
                chartName.insert(chartName.length(), "...");
            }
            Logger.warning((Object)"Destination port number does not exist");
        }
        DAChartBoardItem parentItem = new DAChartBoardItem((DAChartBoard)this, chartName.toString());
        parentItem.setData((Object)new NetworkSelectionType(destinationAddress, fd, true));
        DAChart parentDAChart = parentItem.getChart();
        this.initNetworkChart(parentDAChart, true);
        this.addSeries(parentDAChart);
        NetworkChart parentChartData = new NetworkChart(chartName.toString(), destinationAddress, fd, parentItem, parentDAChart, this.parentChartIndex, 0);
        this.chartItemList.add(parentChartData);
        String childChartName = String.valueOf(NetworkPageLabels.NETWORK_CHILD_CHART_NAME) + fd;
        DAChartBoardItem childItem = new DAChartBoardItem(parentItem, childChartName);
        childItem.setData((Object)new NetworkSelectionType(destinationAddress, fd, false));
        DAChart childDAChart = childItem.getChart();
        this.initNetworkChart(childDAChart, false);
        this.addSeries(childDAChart);
        NetworkChart childChartData = new NetworkChart(childChartName, destinationAddress, fd, childItem, childDAChart, this.parentChartIndex, 0);
        parentChartData.pushChild(childChartData);
        this.chartItemList.add(childChartData);
    }

    private void addChildChartItemList(NetworkChart parent, String destinationAddress, String fd) {
        int childChartIndex = this.lastChildChartIndexOfEachParent.get(parent.getParentChartIndex());
        String childChartName = String.valueOf(NetworkPageLabels.NETWORK_CHILD_CHART_NAME) + fd;
        DAChartBoardItem parentItem = parent.getItem();
        DAChartBoardItem childItem = new DAChartBoardItem(parentItem, childChartName);
        childItem.setData((Object)new NetworkSelectionType(destinationAddress, fd, false));
        DAChart childDAChart = childItem.getChart();
        this.initNetworkChart(childDAChart, false);
        this.addSeries(childDAChart);
        NetworkChart childChartData = new NetworkChart(childChartName, destinationAddress, fd, childItem, childDAChart, parent.getParentChartIndex(), childChartIndex);
        parent.pushChild(childChartData);
        this.chartItemList.add(childChartData);
        this.lastChildChartIndexOfEachParent.put(parent.getParentChartIndex(), ++childChartIndex);
    }

    public void clearSeries() {
        if (this.chartItemList == null) {
            return;
        }
        for (NetworkChart chart : this.chartItemList) {
            chart.clearSeries();
        }
    }

    public void updateApiSeries() {
        List<NetworkAPIType> apiList = NetworkDataManager.getInstance().getAPIDBManger().selectAPISeries(this.getVisibleStartTime(), this.getVisibleEndTime());
        if (apiList == null) {
            return;
        }
        for (NetworkChart chart : this.chartItemList) {
            chart.updateApiSeries(apiList);
        }
    }

    public void updateSeries() {
        if (this.chartItemList == null) {
            return;
        }
        List<NetworkSeriesType> seriesList = this.filetirngSeriresList();
        if (seriesList == null) {
            return;
        }
        this.updateStatusSeries(seriesList);
        this.updateAccessSeries(seriesList);
    }

    private void updateStatusSeries(List<NetworkSeriesType> seriesList) {
        for (NetworkChart chart : this.chartItemList) {
            chart.updateStatusSeries(seriesList);
            this.setPIDOfChart(chart, seriesList);
        }
    }

    private void updateAccessSeries(List<NetworkSeriesType> seriesList) {
        for (NetworkChart chart : this.chartItemList) {
            chart.updateAccessSeries(seriesList);
        }
    }

    private void setPIDOfChart(NetworkChart chart, List<NetworkSeriesType> seriesList) {
        int i = 0;
        while (i < seriesList.size()) {
            if (chart.getDestinationAddress().equals(seriesList.get(i).getDestinationAddress()) && chart.getFdValue().equals(seriesList.get(i).getFdValue())) {
                chart.setpId(seriesList.get(i).getpId());
            }
            ++i;
        }
    }

    private List<NetworkSeriesType> filetirngSeriresList() {
        ArrayList<NetworkSeriesType> filterTimeList = new ArrayList<NetworkSeriesType>();
        if (NetworkDataManager.getInstance().getSeriesList() == null) {
            return null;
        }
        int i = 0;
        while (i < NetworkDataManager.getInstance().getSeriesList().size()) {
            this.addFilterTimeList(filterTimeList, i);
            ++i;
        }
        return filterTimeList;
    }

    private void addFilterTimeList(List<NetworkSeriesType> filterTimeList, int index) {
        double startTime = (double)NetworkDataManager.getInstance().getSeriesList().get(index).getStartTime() / 1000000.0;
        double endTime = (double)NetworkDataManager.getInstance().getSeriesList().get(index).getEndTime() / 1000000.0;
        if (this.getVisibleStartTime() <= startTime && startTime <= this.getVisibleEndTime()) {
            filterTimeList.add(NetworkDataManager.getInstance().getSeriesList().get(index));
        } else if (this.getVisibleStartTime() <= endTime && endTime <= this.getVisibleEndTime()) {
            filterTimeList.add(NetworkDataManager.getInstance().getSeriesList().get(index));
        } else if (endTime < 0.0) {
            filterTimeList.add(NetworkDataManager.getInstance().getSeriesList().get(index));
        }
    }

    public List<NetworkChart> getNetworkChartList() {
        return this.chartItemList;
    }
}

