/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.timeline.calltrace;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.util.Logger;

public class FunctionEntryDBTable
extends DBTable {
    public static final String TABLENAME = "FUNCTION_ENTRY";
    private static final String SELECT_COLUMN = String.valueOf(COLUMN.SEQUENCE_NUMBER.name) + "," + COLUMN.PID.name + "," + COLUMN.TID.name + "," + COLUMN.FUNCTION_ID.name + "," + COLUMN.BINARY_ID.name + "," + COLUMN.START_TIME.name + "," + COLUMN.CALLER_PC_ADDRESS.name + "," + COLUMN.START_PC_ADDRESS.name;
    public static final String SELECT_QUERY = "select " + SELECT_COLUMN + " from " + "FUNCTION_ENTRY" + "  where " + COLUMN.START_TIME.name + " between %s and %s";
    public static final String USERCALLSTACK_QUERY = "select " + COLUMN.SEQUENCE_NUMBER.name + " from " + "FUNCTION_ENTRY" + " where " + COLUMN.START_TIME.name + " = (select max( " + COLUMN.START_TIME.name + ") from " + "FUNCTION_ENTRY" + " where " + COLUMN.START_TIME.name + " <= %s )";
    public static final String FIND_ENTRY_TIME_QUERY = "select MAX(" + COLUMN.START_TIME.name + ") from " + "FUNCTION_ENTRY" + " where " + COLUMN.FUNCTION_ID.name + " = %s and " + COLUMN.SEQUENCE_NUMBER.name + " < %s";

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    public FunctionEntryDBTable() {
        this.addColumn(new DBColumn(COLUMN.SEQUENCE_NUMBER.name, "PRIMARY KEY", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.PID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.TID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.FUNCTION_ID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.BINARY_ID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.START_TIME.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.CALLER_PC_ADDRESS.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.START_PC_ADDRESS.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.ARGUMENT.name, "", "VARCHAR", 1024));
        this.setIndexColumn(COLUMN.START_TIME.index);
    }

    public List<List<Object>> getFunctionEntryFromDB() {
        return this.selectAllColumnData(null);
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                prep.setLong(COLUMN.SEQUENCE_NUMBER.index + 1, (Long)rowData.get(COLUMN.SEQUENCE_NUMBER.index));
                prep.setInt(COLUMN.PID.index + 1, (Integer)rowData.get(COLUMN.PID.index));
                prep.setInt(COLUMN.TID.index + 1, (Integer)rowData.get(COLUMN.TID.index));
                prep.setInt(COLUMN.FUNCTION_ID.index + 1, (Integer)rowData.get(COLUMN.FUNCTION_ID.index));
                prep.setInt(COLUMN.BINARY_ID.index + 1, (Integer)rowData.get(COLUMN.BINARY_ID.index));
                prep.setLong(COLUMN.START_TIME.index + 1, (Long)rowData.get(COLUMN.START_TIME.index));
                prep.setLong(COLUMN.CALLER_PC_ADDRESS.index + 1, (Long)rowData.get(COLUMN.CALLER_PC_ADDRESS.index));
                prep.setLong(COLUMN.START_PC_ADDRESS.index + 1, (Long)rowData.get(COLUMN.START_PC_ADDRESS.index));
                String argumentStr = this.clipString((String)rowData.get(COLUMN.ARGUMENT.index), 1024, rowData.get(COLUMN.SEQUENCE_NUMBER.index).toString());
                prep.setString(COLUMN.ARGUMENT.index + 1, argumentStr);
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }

    @Override
    public List<Object> extractDataFromResultSet(ResultSet rs) {
        ArrayList<Object> row = new ArrayList<Object>();
        try {
            row.add(rs.getLong(1));
            row.add(rs.getInt(2));
            row.add(rs.getInt(3));
            row.add(rs.getInt(4));
            row.add(rs.getInt(5));
            row.add(rs.getLong(6));
            row.add(rs.getLong(7));
            row.add(rs.getLong(8));
            row.add(rs.getString(9));
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
            return null;
        }
        return row;
    }

    public static enum COLUMN {
        SEQUENCE_NUMBER(0, "SEQUENCE_NUMBER"),
        PID(1, "PID"),
        TID(2, "TID"),
        FUNCTION_ID(3, "FUNCTION_ID"),
        BINARY_ID(4, "BINARY_ID"),
        START_TIME(5, "START_TIME"),
        CALLER_PC_ADDRESS(6, "CALLER_PC_ADDRESS"),
        START_PC_ADDRESS(7, "START_PC_ADDRESS"),
        ARGUMENT(8, "ARGUMENT");

        public final int index;
        public final String name;

        private COLUMN(int index, String name) {
            this.index = index;
            this.name = name;
        }
    }
}

