/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.timeline.calltrace;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.widgets.Composite;
import org.tizen.dynamicanalyzer.model.TableInput;
import org.tizen.dynamicanalyzer.nl.TimelinePageLabels;
import org.tizen.dynamicanalyzer.ui.range.RangeDataManager;
import org.tizen.dynamicanalyzer.ui.timeline.calltrace.CallTraceDataManager;
import org.tizen.dynamicanalyzer.ui.timeline.calltrace.WebFunctionEntryDBTable;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.utils.Formatter;

public class WebCallTraceTable
extends DATableComposite {
    private String[] columnNames = new String[]{TimelinePageLabels.CALL_TRACE_VIEW_TIME, TimelinePageLabels.CALL_TRACE_VIEW_TID, TimelinePageLabels.CALL_TRACE_VIEW_PID, TimelinePageLabels.CALL_TRACE_VIEW_NAME, TimelinePageLabels.CALL_TRACE_VIEW_FILE, TimelinePageLabels.CALL_TRACE_VIEW_LINE_NUMBER};
    private int[] columnSizes = new int[]{65, 45, 45, 300, 300, 100};
    private boolean[] columnVisibility = new boolean[]{true, true, true, true, true, true};
    private int[] sortTypes = new int[]{1, 1, 1, 2, 2, 1};

    public WebCallTraceTable(Composite parent, int compStyle, int tableStyle) {
        super(parent, compStyle, tableStyle);
        this.setSortTypes(this.sortTypes);
        this.setColumns(this.columnNames);
        this.setColumnSize(this.columnSizes);
        this.setColumnVisibility(this.columnVisibility);
        this.setItemHeightSize(16);
    }

    @Override
    protected List<TableInput> makeTableInput() {
        List<List<Object>> queriedData = this.getWebFunctionEntryData();
        ArrayList<TableInput> input = new ArrayList<TableInput>();
        if (queriedData == null) {
            return null;
        }
        int size = queriedData.size();
        int i = 0;
        while (i < size) {
            List<Object> rowData = queriedData.get(i);
            ArrayList<String> contentText = new ArrayList<String>();
            long time = (Long)rowData.get(WebFunctionEntryDBTable.COLUMN.START_TIME.index);
            contentText.add(Formatter.toTimeFormat(time));
            Integer tid = (Integer)rowData.get(WebFunctionEntryDBTable.COLUMN.TID.index);
            contentText.add(Integer.toString(tid));
            Integer pid = (Integer)rowData.get(WebFunctionEntryDBTable.COLUMN.PID.index);
            contentText.add(Integer.toString(pid));
            String functionName = (String)rowData.get(WebFunctionEntryDBTable.COLUMN.FUNCTION_NAME.index);
            contentText.add(functionName);
            String functionURL = (String)rowData.get(WebFunctionEntryDBTable.COLUMN.FUNCTION_URL.index);
            int lastIndex = functionURL.lastIndexOf("/");
            String fileName = functionURL.substring(lastIndex + 1);
            contentText.add(fileName);
            Integer functionLineNumber = (Integer)rowData.get(WebFunctionEntryDBTable.COLUMN.FUNCTION_LINE_NUMBER.index);
            contentText.add(Integer.toString(functionLineNumber));
            DATableDataFormat tableData = new DATableDataFormat((Long)rowData.get(WebFunctionEntryDBTable.COLUMN.SEQUENCE_NUMBER.index));
            tableData.getData().addAll(rowData);
            tableData.setType(1024);
            TableInput tableInput = new TableInput();
            tableInput.setText(contentText);
            tableInput.setData(tableData);
            input.add(tableInput);
            if (RangeDataManager.getInstance().isBeingAnalyzed()) {
                long analysisStartTime = RangeDataManager.getInstance().getAnalysisStartTime();
                long analysisEndTime = RangeDataManager.getInstance().getAnalysisEndTime();
                if (time >= analysisStartTime && time <= analysisEndTime) {
                    tableInput.setInRange(true);
                }
            }
            ++i;
        }
        return input;
    }

    private List<List<Object>> getWebFunctionEntryData() {
        return CallTraceDataManager.getInstance().getWebFunctionEntryTable().selectAllObjectData();
    }

    public void setSelectionByTime(final long selectionStartTime, final long selectionEndTime) {
        this.setSelectionByPredicate(new DATableComposite.Predicate<GridItem>(){

            @Override
            public boolean evaluate(GridItem item) {
                DATableDataFormat gridData = (DATableDataFormat)item.getData();
                if (gridData == null) {
                    return false;
                }
                long time = (Long)gridData.getData().get(WebFunctionEntryDBTable.COLUMN.START_TIME.index);
                return selectionStartTime <= time && time <= selectionEndTime;
            }
        });
    }
}

