/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.timeline.chart;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.nl.TimelineChartLabels;
import org.tizen.dynamicanalyzer.project.BinaryInfo;
import org.tizen.dynamicanalyzer.project.LibraryObject;
import org.tizen.dynamicanalyzer.project.ProcessInformation;
import org.tizen.dynamicanalyzer.project.ProcessMemoryMap;
import org.tizen.dynamicanalyzer.project.Project;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.swap.platform.BinarySettingData;
import org.tizen.dynamicanalyzer.swap.platform.BinarySettingManager;
import org.tizen.dynamicanalyzer.ui.common.TimelineChartMouseEventListener;
import org.tizen.dynamicanalyzer.ui.common.TimelineChartMouseTrackAdapter;
import org.tizen.dynamicanalyzer.ui.timeline.TargetProcessDBTable;
import org.tizen.dynamicanalyzer.ui.timeline.chart.TimelineChart;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.dynamicanalyzer.utils.Formatter;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlot;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeries;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeriesItem;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoard;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenu;

public class HeapChart
extends TimelineChart {
    private List<Integer> librarySequenceList = new ArrayList<Integer>();
    private Map<Integer, Map<Integer, DAChartSeries>> seriesPerProcessMap = new HashMap<Integer, Map<Integer, DAChartSeries>>();
    private DAChartBoardItem parentBoardItem;
    private List<DAChartBoardItem> childBoardItemList = new ArrayList<DAChartBoardItem>();
    private int rootPID;
    private static final int totalAllocSeriesID = -100;

    public HeapChart(String pageID) {
        super(pageID);
        this.chartType = -104;
        this.probeType = 5;
        this.chartName = TimelineChartLabels.HEAP_CHART_TITLE;
        this.chartDescriptor = TimelineChartLabels.HEAP_CHART_DESCRIPTOR;
        this.chartIcon = ImageResources.FEATURE_HEAPALLOC_SMALL;
        this.addIcon = ImageResources.FEATURE_HEAPALLOC_SMALL;
    }

    private Map<Integer, DAChartSeries> createChartSeries(int pid) {
        HashMap<Integer, DAChartSeries> chartSeriesMap = new HashMap<Integer, DAChartSeries>();
        DAChartSeries totalAllocationSeries = new DAChartSeries(TimelineChartLabels.HEAP_CHART_SERIES_NAME_TOTAL_ALLOCATION, 3, ColorResources.SERIES_COLOR_HEAP_SYSTEM);
        chartSeriesMap.put(-100, totalAllocationSeries);
        Project project = Global.getProject();
        List<BinarySettingData> binDataList = BinarySettingManager.getInstance().getBinarySettingList();
        ProcessInformation pinfo = project.getProcessInformation(pid);
        if (pinfo == null) {
            Logger.error((Object)("ProcessInformation is Null!! Invalid PID : " + pid));
            return null;
        }
        ProcessMemoryMap pmap = pinfo.getProcessMemoryMap(Toolbar.INSTANCE.getTime());
        if (pmap != null) {
            for (BinarySettingData binData : binDataList) {
                String libraryPath = binData.getBinaryPath();
                BinaryInfo binInfo = project.getDeviceStatusInfo().getBinaryInfo(libraryPath);
                LibraryObject libObj = pmap.getLibraryByBinaryID(binInfo.getID());
                if (libObj == null) continue;
                DAChartSeries libraryAllocSeries = new DAChartSeries(libraryPath, 3);
                chartSeriesMap.put(libObj.getBinaryID(), libraryAllocSeries);
            }
        }
        DAChartSeries targetAllocationSeries = new DAChartSeries(TimelineChartLabels.HEAP_CHART_SERIES_NAME_APP_ALLOCATION, 3, ColorResources.SERIES_COLOR_HEAP_USER);
        chartSeriesMap.put(-10, targetAllocationSeries);
        return chartSeriesMap;
    }

    @Override
    public DAChartBoardItem createBoardItem(DAChartBoard board) {
        this.parentBoardItem = super.createBoardItem(board);
        this.chart.getPlot().setAxisUnit("B");
        this.chart.getPlot().setAxisUnitType(DAChartPlot.UnitType.BINARY);
        this.chart.getPlot().setShowAxis(true);
        this.clear();
        return this.parentBoardItem;
    }

    public DAChartBoardItem createChildBoardItem(DAChartBoardItem parent) {
        DAChartBoardItem item = new DAChartBoardItem(parent, this.chartName, this.chartIcon, this.chartStyle);
        this.chart = item.getChart();
        this.setChartStyle();
        DAChartPlot parentPlot = parent.getChart().getPlot();
        this.chart.getPlot().setTooltip(parentPlot.getTooltip());
        this.chart.getPlot().setMarkers(parent.getChartBoard().getMarkers());
        this.chart.getPlot().setAxisUnit(parentPlot.getAxisUnit());
        this.chart.getPlot().setAxisUnitType(parentPlot.getAxisUnitType());
        this.chart.getPlot().setShowAxis(parentPlot.isShowAxis());
        this.popupMenu = new DAPopupMenu((Composite)this.chart);
        this.initPopupMenu(parent.getChartBoard(), this.popupMenu);
        TimelineChartMouseEventListener timelineChartMouseEventListener = new TimelineChartMouseEventListener(this.popupMenu, parent.getChartBoard().getTimeline(), this.pageID);
        this.chart.addMouseListener((MouseListener)timelineChartMouseEventListener);
        this.chart.addMouseMoveListener((MouseMoveListener)timelineChartMouseEventListener);
        this.chart.addMouseTrackListener((MouseTrackListener)new TimelineChartMouseTrackAdapter(parent.getChartBoard().getTimeline()));
        return item;
    }

    @Override
    public void inputChartSeries(List<Object> dataList) {
        Iterator<Map<Integer, DAChartSeries>> iterPerPID = this.seriesPerProcessMap.values().iterator();
        while (iterPerPID.hasNext()) {
            Iterator<DAChartSeries> iterSeries = iterPerPID.next().values().iterator();
            while (iterSeries.hasNext()) {
                iterSeries.next().clear();
            }
        }
        if (Global.getProject() == null) {
            return;
        }
        Map processDataMap = (Map)dataList.get(1);
        for (final Integer pid : processDataMap.keySet()) {
            Map<Integer, DAChartSeries> seriesMap;
            List data = (List)processDataMap.get(pid);
            if (this.seriesPerProcessMap.isEmpty()) {
                seriesMap = this.createChartSeries(pid);
                if (seriesMap == null) {
                    Logger.error((Object)("Invalid PID : " + pid));
                    return;
                }
                this.seriesPerProcessMap.put(pid, seriesMap);
                this.setChartSeries(this.chart, seriesMap);
                String processName = AnalyzerUtil.getProcessName(pid);
                this.parentBoardItem.getChart().setInformation(String.valueOf(processName) + " / PID : " + pid);
                this.rootPID = pid;
            } else if (this.seriesPerProcessMap.get(pid) == null) {
                seriesMap = this.createChartSeries(pid);
                if (seriesMap == null) {
                    Logger.error((Object)("Invalid PID : " + pid));
                    return;
                }
                this.seriesPerProcessMap.put(pid, seriesMap);
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        HeapChart childChart = new HeapChart(HeapChart.this.pageID);
                        DAChartBoardItem childBoardItem = childChart.createChildBoardItem(HeapChart.this.parentBoardItem);
                        HeapChart.this.setChartSeries(childBoardItem.getChart(), seriesMap);
                        String processName = AnalyzerUtil.getProcessName(pid);
                        childBoardItem.getChart().setInformation(String.valueOf(processName) + " / PID : " + pid);
                        HeapChart.this.childBoardItemList.add(childBoardItem);
                        HeapChart.this.parentBoardItem.unFoldChild();
                    }
                });
            }
            seriesMap = this.seriesPerProcessMap.get(pid);
            int selectedPID = Toolbar.INSTANCE.getSelectedPid();
            if (selectedPID > 0 && selectedPID != pid) continue;
            if (selectedPID > 0 && selectedPID == pid) {
                this.parentBoardItem.hideChildItems();
                this.parentBoardItem.getItemCell().hideChildFoldToggleButton();
                this.swapParentChartSeries(pid, seriesMap);
            } else {
                this.parentBoardItem.showChildItems();
                this.parentBoardItem.getItemCell().showChildFoldToggleButton();
                this.swapParentChartSeries(this.rootPID, this.seriesPerProcessMap.get(this.rootPID));
            }
            int i = 0;
            while (i < data.size()) {
                List row = (List)data.get(i);
                double time = (double)((Long)row.get(TargetProcessDBTable.COLUMN.SAMPLING_TIME.ordinal())).longValue() / 1000000.0;
                long totalAlloc = (Long)row.get(TargetProcessDBTable.COLUMN.HEAP_ALLOCATION_TOTAL_BYTE.ordinal());
                List binaryIDList = (List)row.get(TargetProcessDBTable.COLUMN.HEAP_ALLOCATION_BINARY_ID.ordinal());
                List binaryAllocList = (List)row.get(TargetProcessDBTable.COLUMN.HEAP_ALLOCATION_BYTE.ordinal());
                DAChartSeries totalAllocSeries = seriesMap.get(-100);
                totalAllocSeries.addSeriesItem(new DAChartSeriesItem(time, (double)totalAlloc, Formatter.toByteFormat(totalAlloc)));
                long targetAlloc = (Long)binaryAllocList.get(0);
                DAChartSeries appAllocSeries = seriesMap.get(-10);
                appAllocSeries.addSeriesItem(new DAChartSeriesItem(time, (double)targetAlloc, Formatter.toByteFormat(targetAlloc)));
                long totalUserAlloc = 0L;
                int ii = 0;
                while (ii < binaryAllocList.size()) {
                    totalUserAlloc += ((Long)binaryAllocList.get(ii)).longValue();
                    ++ii;
                }
                long beforeLibraryAlloc = 0L;
                int ii2 = 0;
                while (ii2 < this.librarySequenceList.size()) {
                    Integer libraryID = this.librarySequenceList.get(ii2);
                    DAChartSeries allocSeries = seriesMap.get(libraryID);
                    if (allocSeries != null) {
                        int index = binaryIDList.indexOf(libraryID);
                        long libraryAlloc = 0L;
                        if (index > 0) {
                            libraryAlloc = (Long)binaryAllocList.get(index);
                        }
                        allocSeries.addSeriesItem(new DAChartSeriesItem(time, (double)(totalUserAlloc - beforeLibraryAlloc), Formatter.toByteFormat(libraryAlloc)));
                        beforeLibraryAlloc = libraryAlloc;
                    }
                    ++ii2;
                }
                ++i;
            }
        }
    }

    private void swapParentChartSeries(int pid, Map<Integer, DAChartSeries> seriesMap) {
        this.parentBoardItem.getChart().getPlot().setAxisEndY(0.0);
        String processName = AnalyzerUtil.getProcessName(pid);
        this.parentBoardItem.getChart().setInformation(String.valueOf(processName) + " / PID : " + pid);
        this.parentBoardItem.getChart().getSeriesList().clear();
        this.setChartSeries(this.parentBoardItem.getChart(), seriesMap);
    }

    private void setChartSeries(DAChart chart, Map<Integer, DAChartSeries> seriesMap) {
        chart.addSeries(seriesMap.get(-100));
        for (Integer binaryID : seriesMap.keySet()) {
            if (binaryID < 0) continue;
            chart.addSeries(seriesMap.get(binaryID));
            if (this.librarySequenceList.indexOf(binaryID) >= 0) continue;
            this.librarySequenceList.add(binaryID);
        }
        chart.addSeries(seriesMap.get(-10));
    }

    @Override
    public void clear() {
        this.seriesPerProcessMap.clear();
        int i = 0;
        while (i < this.childBoardItemList.size()) {
            this.childBoardItemList.get(i).dispose();
            ++i;
        }
    }
}

