/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.toolbar.setting;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.nl.ConfigureLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.setting.FlatFeature;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.setting.TargetData;
import org.tizen.dynamicanalyzer.ui.toolbar.setting.FlatFeatureDialog;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.toggle.DACustomFeatureToggleButton;
import org.tizen.dynamicanalyzer.widgets.button.toggle.DACustomMultiToggleButtonGroup;
import org.tizen.dynamicanalyzer.widgets.da.view.DABaseComposite;
import org.tizen.dynamicanalyzer.widgets.tooltip.DACustomTooltip;

public class FlatFeatureDialogFeatureListPage
extends DABaseComposite {
    private FlatFeatureDialog featureDialog = null;
    private Composite featureListComp = null;
    private ScrolledComposite featureListScrolledComp = null;
    private Composite featureListInputComp = null;
    private Composite itemComp = null;
    private Label featureListLabel = null;
    private DACustomTooltip tooltip = null;
    private DACustomMultiToggleButtonGroup featuretoggleGroup = null;
    private Cursor daCursor = null;
    private int FEATURELIST_TITLE_FONT_SIZE = 0;
    private int FEATURELIST_ICON_SIZE = 0;
    private int FEATURELIST_TOOLTIP_SIZE = 0;
    private int FEATURELIST_TOOLTIP_BOX_WIDTH = 0;
    private int FEATURELIST_COMP_WIDTH = 0;
    private int FEATURELIST_COMP_MARGIN = 0;
    private int FEATURELIST_COMP_ITEM_LEFT_MARGIN = 0;
    private int FEATURELIST_TITLE_HEIGHT = 0;
    private int FEATURELIST_TITLE_MARGIN = 0;
    private int FEATURELIST_BODY_TOP = 0;
    private int FEATURELIST_BODY_ITEM_HEIGHT = 0;
    private int FEATURELIST_BODY_ITEM_MARGIN = 0;
    private int FEATURELIST_BODY_ITEM_WIDTH = 0;
    private int FEATURELIST_BODY_ITEM_TEXT_LARGE_HEIGHT = 0;
    private int FEATURELIST_BODY_ITEM_LARGE_VERT_MARGIN = 0;
    private int FEATURELIST_TOOLTIP_UPPER_MARGIN = 0;
    private Listener toggleDownListener = new Listener(){

        public void handleEvent(Event event) {
            DACustomFeatureToggleButton toggleButton = (DACustomFeatureToggleButton)event.widget;
            if (toggleButton.isToggled()) {
                toggleButton.getParent().setBackground(ColorResources.FEATURE_FEATURELISTCOMP_NORMAL_BACKGROUND);
                toggleButton.getTooltipButton().setBackground(ColorResources.FEATURE_FEATURELISTCOMP_NORMAL_BACKGROUND);
            }
        }
    };
    private Listener cursorListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.type == 6 || event.type == 7) {
                DACustomFeatureToggleButton toggleButton = (DACustomFeatureToggleButton)event.widget;
                toggleButton.setFocus();
                if (FlatFeatureDialogFeatureListPage.this.daCursor != null) {
                    FlatFeatureDialogFeatureListPage.this.daCursor.dispose();
                }
                if (event.type == 6) {
                    FlatFeatureDialogFeatureListPage.this.daCursor = new Cursor((Device)FlatFeatureDialogFeatureListPage.this.getShell().getDisplay(), 21);
                } else if (event.type == 7) {
                    FlatFeatureDialogFeatureListPage.this.daCursor = new Cursor((Device)FlatFeatureDialogFeatureListPage.this.getShell().getDisplay(), 0);
                } else {
                    return;
                }
                FlatFeatureDialogFeatureListPage.this.getShell().setCursor(FlatFeatureDialogFeatureListPage.this.daCursor);
            }
        }
    };
    private Listener toggleListener = new Listener(){

        public void handleEvent(Event event) {
            DACustomFeatureToggleButton toggleButton = (DACustomFeatureToggleButton)event.widget;
            TargetData target = SettingDataManager.INSTANCE.getTarget(null);
            if (!toggleButton.isToggled()) {
                target.removeSelectedFlatFeature(toggleButton.getText());
                toggleButton.getParent().setBackground(ColorResources.FEATURE_FEATURELISTCOMP_NORMAL_BACKGROUND);
                toggleButton.getTooltipButton().setBackground(ColorResources.FEATURE_FEATURELISTCOMP_NORMAL_BACKGROUND);
            } else {
                target.addSelectedFlatFeature(toggleButton.getText());
                toggleButton.getParent().setBackground(ColorResources.FEATURE_FEATURELISTCOMP_SELECT_BACKGROUND);
                toggleButton.getTooltipButton().setBackground(ColorResources.FEATURE_FEATURELISTCOMP_SELECT_BACKGROUND);
            }
            FlatFeatureDialogFeatureListPage.this.featureDialog.getSelectedFeaturePage().createSelectedFeatureComposite();
        }
    };

    public FlatFeatureDialogFeatureListPage(Composite parent, FlatFeatureDialog parentObject, int style) {
        super(parent, style);
        this.setLayout((Layout)new FormLayout());
        this.setBackground(ColorResources.CONFIGURATION_TABLE_COVER_BACKGROUND_COLOR);
        this.featureListComp = parent;
        this.featureDialog = parentObject;
        this.FEATURELIST_TITLE_FONT_SIZE = 16;
        this.FEATURELIST_ICON_SIZE = 70;
        this.FEATURELIST_TOOLTIP_SIZE = 20;
        this.FEATURELIST_TOOLTIP_BOX_WIDTH = 65;
        this.FEATURELIST_COMP_WIDTH = this.featureDialog.FEATURE_WIDTH;
        this.FEATURELIST_COMP_MARGIN = this.featureDialog.LINE;
        this.FEATURELIST_COMP_ITEM_LEFT_MARGIN = 22;
        this.FEATURELIST_TITLE_HEIGHT = this.featureDialog.TITLE_HEIGHT;
        this.FEATURELIST_TITLE_MARGIN = (this.FEATURELIST_TITLE_HEIGHT - this.FEATURELIST_TITLE_FONT_SIZE) / 2;
        this.FEATURELIST_BODY_TOP = this.FEATURELIST_TITLE_HEIGHT + this.FEATURELIST_COMP_MARGIN + 1;
        this.FEATURELIST_BODY_ITEM_HEIGHT = 119;
        this.FEATURELIST_BODY_ITEM_WIDTH = this.featureDialog.FEATURE_WIDTH;
        this.FEATURELIST_BODY_ITEM_MARGIN = 1;
        this.FEATURELIST_BODY_ITEM_TEXT_LARGE_HEIGHT = 75;
        this.FEATURELIST_BODY_ITEM_LARGE_VERT_MARGIN = (this.FEATURELIST_BODY_ITEM_HEIGHT - this.FEATURELIST_BODY_ITEM_TEXT_LARGE_HEIGHT) / 2;
        this.FEATURELIST_TOOLTIP_UPPER_MARGIN = this.FEATURELIST_BODY_ITEM_LARGE_VERT_MARGIN + (this.FEATURELIST_ICON_SIZE - this.FEATURELIST_TOOLTIP_SIZE) / 2;
        this.createFeatureListComposite();
    }

    private void initFeatureListWidget() {
        if (this.featureListLabel != null) {
            this.featureListLabel.dispose();
            this.featureListLabel = null;
        }
        if (this.featureListScrolledComp != null) {
            this.featureListScrolledComp.dispose();
            this.featureListScrolledComp = null;
        }
        if (this.featureListInputComp != null) {
            this.featureListInputComp.dispose();
            this.featureListInputComp = null;
        }
        if (this.itemComp != null) {
            this.itemComp.dispose();
            this.itemComp = null;
        }
        if (this.daCursor != null) {
            this.daCursor.dispose();
            this.daCursor = null;
        }
    }

    private DACustomFeatureToggleButton createToggleButton(Composite composit, Image normalImage, Image hoverImage, Image pushImage, Image disableImage, Point imagePoint, String title, Point fontPoint, int width, int height, int topPosition, int leftPosition) {
        DACustomFeatureToggleButton toggle = new DACustomFeatureToggleButton(composit, 0x40000000);
        toggle.setColors(ColorResources.SETTING_BUTTON_NORMAL_COLOR, ColorResources.SETTING_BUTTON_NORMAL_COLOR, ColorResources.SETTING_BUTTON_NORMAL_COLOR, ColorResources.SETTING_BUTTON_NORMAL_COLOR, ColorResources.FEATURE_FEATURELISTCOMP_SELECT_BACKGROUND, ColorResources.FEATURE_FEATURELISTCOMP_SELECT_BACKGROUND, ColorResources.FEATURE_FEATURELISTCOMP_SELECT_BACKGROUND);
        toggle.setButtonImages(normalImage, pushImage, hoverImage, disableImage, pushImage, pushImage, pushImage);
        toggle.setButtonImagePoint(imagePoint);
        toggle.setTitle(title);
        toggle.setFontPoint(fontPoint);
        toggle.setFontColors(ColorResources.SETTING_COLOR, ColorResources.SETTING_COLOR, ColorResources.SETTING_COLOR, ColorResources.SETTING_COLOR);
        toggle.setButtonFont(FontResources.SETTING_BUTTON_FONT);
        FormData data = new FormData();
        data.top = new FormAttachment(0, topPosition);
        data.left = new FormAttachment(0, leftPosition);
        data.width = width;
        data.height = height;
        toggle.setLayoutData((Object)data);
        return toggle;
    }

    public void featureToggleUnselect(String featurName) {
        if (this.featuretoggleGroup != null) {
            this.featuretoggleGroup.setSelection(featurName, false);
            this.featuretoggleGroup.getButton(featurName).getParent().setBackground(ColorResources.FEATURE_FEATURELISTCOMP_NORMAL_BACKGROUND);
            this.featuretoggleGroup.getButton(featurName).getTooltipButton().setBackground(ColorResources.FEATURE_FEATURELISTCOMP_NORMAL_BACKGROUND);
        }
    }

    public void createFeatureListComposite() {
        this.initFeatureListWidget();
        this.featureListLabel = new Label(this.featureListComp, 0x40000000);
        FormData data = new FormData();
        data.top = new FormAttachment(0, this.FEATURELIST_TITLE_MARGIN);
        data.left = new FormAttachment(0, this.FEATURELIST_COMP_ITEM_LEFT_MARGIN);
        data.width = this.FEATURELIST_COMP_WIDTH - this.FEATURELIST_COMP_ITEM_LEFT_MARGIN;
        data.height = this.FEATURELIST_TITLE_HEIGHT - this.FEATURELIST_TITLE_MARGIN - this.FEATURELIST_TITLE_FONT_SIZE + 6;
        this.featureListLabel.setLayoutData((Object)data);
        this.featureListLabel.setText(ConfigureLabels.SETTING_DIALOG_FEATURELIST_TITLE);
        this.featureListLabel.setBackground(ColorResources.FEATURE_TITLE_BACKGROUND);
        this.featureListLabel.setForeground(ColorResources.DEFAULT_FONT_COLOR);
        this.featureListLabel.setFont(FontResources.SETTING_TITLE_FONT);
        this.featureListLabel.setAlignment(16384);
        this.featureListComp.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setForeground(ColorResources.FEATURE_LINE);
                e.gc.drawLine(0, FlatFeatureDialogFeatureListPage.this.FEATURELIST_TITLE_HEIGHT + FlatFeatureDialogFeatureListPage.this.FEATURELIST_COMP_MARGIN, FlatFeatureDialogFeatureListPage.this.FEATURELIST_COMP_WIDTH, FlatFeatureDialogFeatureListPage.this.FEATURELIST_TITLE_HEIGHT + FlatFeatureDialogFeatureListPage.this.FEATURELIST_COMP_MARGIN);
            }
        });
        this.featureListScrolledComp = new ScrolledComposite(this.featureListComp, 512);
        this.featureListScrolledComp.setLayout((Layout)new FormLayout());
        data = new FormData();
        data.top = new FormAttachment(0, this.FEATURELIST_BODY_TOP);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        this.featureListScrolledComp.setLayoutData((Object)data);
        this.featureListScrolledComp.setExpandHorizontal(true);
        this.featureListScrolledComp.setExpandVertical(true);
        this.featureListScrolledComp.setBackground(ColorResources.FEATURE_FEATURELISTCOMP_NORMAL_BACKGROUND);
        this.featureListScrolledComp.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setForeground(ColorResources.GREEN);
                e.gc.drawLine(0, 0, FlatFeatureDialogFeatureListPage.this.FEATURELIST_COMP_WIDTH, 0);
            }
        });
        this.featureListInputComp = new Composite((Composite)this.featureListScrolledComp, 0);
        this.featureListScrolledComp.setContent((Control)this.featureListInputComp);
        this.featureListScrolledComp.setMinSize(this.featureListInputComp.computeSize(-1, -1));
        this.featureListScrolledComp.setShowFocusedControl(true);
        this.featureListInputComp.setLayout((Layout)new FormLayout());
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        this.featureListInputComp.setLayoutData((Object)data);
        this.featureListInputComp.setBackground(ColorResources.FEATURE_FEATURELISTCOMP_NORMAL_BACKGROUND);
        if (this.tooltip == null) {
            this.tooltip = new DACustomTooltip(){

                public void setTooltipMessage() {
                }

                public void setTooltipMessage(String name) {
                    this.tooltipMessage.clear();
                    this.tooltipMessage.add(name);
                }
            };
        }
        TargetData target = SettingDataManager.INSTANCE.getTarget(null);
        ArrayList<FlatFeature> features = new ArrayList<FlatFeature>();
        features.addAll(target.getAvailableFlatFeatures());
        Collections.sort(features, FlatFeature.getIndexComparator());
        Logger.debug((Object)("Available FlatFeature list: " + features));
        this.featuretoggleGroup = new DACustomMultiToggleButtonGroup();
        Point imagePoint = new Point(22, 24);
        int topPosition = 0;
        for (FlatFeature feature : features) {
            if (feature == null) continue;
            this.itemComp = new Composite(this.featureListInputComp, 0);
            this.itemComp.setLayout((Layout)new FormLayout());
            data = new FormData();
            data.top = new FormAttachment(0, topPosition);
            data.left = new FormAttachment(0, 0);
            data.width = this.FEATURELIST_BODY_ITEM_WIDTH;
            data.height = this.FEATURELIST_BODY_ITEM_HEIGHT;
            this.itemComp.setLayoutData((Object)data);
            DACustomButton infoButton = new DACustomButton(this.itemComp, 0x40000000);
            infoButton.setBackground(ColorResources.WHITE);
            infoButton.setImages(ImageResources.TOOLTIP_INFO_FEATURELIST_NORMAL, ImageResources.TOOLTIP_INFO_FEATURELIST_NORMAL, ImageResources.TOOLTIP_INFO_FEATURELIST_HOVER, ImageResources.TOOLTIP_INFO_FEATURELIST_HOVER);
            data = new FormData();
            data.top = new FormAttachment(0, this.FEATURELIST_TOOLTIP_UPPER_MARGIN);
            data.left = new FormAttachment(0, this.FEATURELIST_COMP_WIDTH - this.FEATURELIST_TOOLTIP_BOX_WIDTH);
            data.width = this.FEATURELIST_TOOLTIP_SIZE;
            data.height = this.FEATURELIST_TOOLTIP_SIZE;
            infoButton.setLayoutData((Object)data);
            infoButton.setData("tooltipmsg", (Object)feature.getOverheadRankingMessage());
            infoButton.addListener(32, new Listener(){

                public void handleEvent(Event event) {
                    DACustomButton tempButton = (DACustomButton)event.widget;
                    Point p = tempButton.toDisplay(tempButton.getLocation());
                    FlatFeatureDialogFeatureListPage.this.tooltip.open(FlatFeatureDialogFeatureListPage.this.featureListInputComp.getShell());
                    FlatFeatureDialogFeatureListPage.this.tooltip.setTooltipMessage((String)tempButton.getData("tooltipmsg"));
                    FlatFeatureDialogFeatureListPage.this.tooltip.setTooltipLocation(p, -50, -620);
                }
            });
            infoButton.addListener(7, new Listener(){

                public void handleEvent(Event event) {
                    if (FlatFeatureDialogFeatureListPage.this.tooltip != null) {
                        FlatFeatureDialogFeatureListPage.this.tooltip.close();
                    }
                }
            });
            if (this.featuretoggleGroup.getGroupLength() < features.size()) {
                DACustomFeatureToggleButton toggle = this.createToggleButton(this.itemComp, feature.getNormalImage(), feature.getOverImage(), feature.getFocusImage(), feature.getDimImage(), imagePoint, feature.getName(), null, this.FEATURELIST_BODY_ITEM_WIDTH - this.FEATURELIST_TOOLTIP_BOX_WIDTH, this.FEATURELIST_BODY_ITEM_HEIGHT, 0, 0);
                toggle.setDescription(feature.getDescription());
                toggle.setPage(feature.getPage());
                toggle.setOverhead(feature.getOverheadRankingMessage());
                toggle.setTitleFont(FontResources.SETTING_TITLE_FONT);
                toggle.setDescFont(FontResources.SETTING_DESCRIPTION_FONT);
                toggle.setPageFont(FontResources.SETTING_DESCRIPTION_FONT);
                toggle.setOverheadFont(FontResources.SETTING_DESCRIPTION_FONT);
                toggle.setTooltipButton(infoButton);
                this.featuretoggleGroup.addToggleButton(toggle);
                toggle.addListener(4, this.toggleListener);
                toggle.addListener(3, this.toggleDownListener);
                toggle.addListener(6, this.cursorListener);
                toggle.addListener(7, this.cursorListener);
            }
            if (target.isSelectedFlatFeature(feature.getName())) {
                this.featuretoggleGroup.setSelection(feature.getName(), true);
                this.featuretoggleGroup.getButton(feature.getName()).getParent().setBackground(ColorResources.FEATURE_FEATURELISTCOMP_SELECT_BACKGROUND);
                this.featuretoggleGroup.getButton(feature.getName()).getTooltipButton().setBackground(ColorResources.FEATURE_FEATURELISTCOMP_SELECT_BACKGROUND);
            } else {
                this.featuretoggleGroup.setSelection(feature.getName(), false);
                this.featuretoggleGroup.getButton(feature.getName()).getParent().setBackground(ColorResources.FEATURE_FEATURELISTCOMP_NORMAL_BACKGROUND);
                this.featuretoggleGroup.getButton(feature.getName()).getTooltipButton().setBackground(ColorResources.FEATURE_FEATURELISTCOMP_NORMAL_BACKGROUND);
            }
            topPosition += this.FEATURELIST_BODY_ITEM_HEIGHT + this.FEATURELIST_BODY_ITEM_MARGIN;
        }
        this.featureListComp.layout(true);
        this.featureListInputComp.layout(true);
        this.featureListScrolledComp.setMinSize(this.featureListInputComp.computeSize(-1, -1));
        this.featureListScrolledComp.getVerticalBar().setIncrement(this.FEATURELIST_BODY_ITEM_HEIGHT / 2);
        this.featureListScrolledComp.getVerticalBar().setPageIncrement(this.FEATURELIST_BODY_ITEM_HEIGHT * 2);
        if (!DAState.isStartable()) {
            this.featureListComp.setEnabled(false);
        }
    }
}

