/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.toolbar.setting;

import java.util.Map;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.nl.ConfigureLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.setting.TargetData;
import org.tizen.dynamicanalyzer.ui.toolbar.setting.FlatFeatureDialog;
import org.tizen.dynamicanalyzer.widgets.button.toggle.DACustomFeatureToggleButton;
import org.tizen.dynamicanalyzer.widgets.button.toggle.DACustomFeatureToggleButtonGroup;
import org.tizen.dynamicanalyzer.widgets.da.view.DABaseComposite;

public class FlatFeatureDialogTargetPage
extends DABaseComposite {
    private Composite targetComp = null;
    private FlatFeatureDialog featureDialog = null;
    private Label targetLabel = null;
    private ScrolledComposite targetScrolledComposite = null;
    private Composite targetInputComposite = null;
    private Cursor daCursor = null;
    private int TARGET_TITLE_FONT_SIZE = 0;
    private int TARGET_COMP_WIDTH = 0;
    private int TARGET_COMP_HEIGHT = 0;
    private int LINE = 0;
    private int TARGET_COMP_ITEM_LEFT_MARGIN = 0;
    private int TARGET_TITLE_HEIGHT = 0;
    private int TARGET_TITLE_MARGIN = 0;
    private int TARGET_LIST_TOP = 0;
    private int TARGET_LIST_HEIGHT = 0;
    private int TARGET_LIST_WIDTH = 0;
    private int TARGET_LIST_UPPER_MARGIN = 0;
    private int TARGET_LIST_ITEM_HEIGHT = 0;
    private int TARGET_LIST_ITEM_MARGIN = 0;
    private int TARGET_LIST_ITEM_LABEL_MARGIN = 0;
    private int TARGET_LIST_ITEM_TITLE_MARGIN = 0;
    private Listener cursorListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.type == 6 || event.type == 7) {
                DACustomFeatureToggleButton toggleButton = (DACustomFeatureToggleButton)event.widget;
                toggleButton.setFocus();
                if (event.type == 6) {
                    FlatFeatureDialogTargetPage.this.daCursor = new Cursor((Device)FlatFeatureDialogTargetPage.this.getShell().getDisplay(), 21);
                } else if (event.type == 7) {
                    FlatFeatureDialogTargetPage.this.daCursor = new Cursor((Device)FlatFeatureDialogTargetPage.this.getShell().getDisplay(), 0);
                } else {
                    return;
                }
                FlatFeatureDialogTargetPage.this.getShell().setCursor(FlatFeatureDialogTargetPage.this.daCursor);
            }
        }
    };
    private Listener clickListener = new Listener(){

        public void handleEvent(Event event) {
            DACustomFeatureToggleButton toggleButton = (DACustomFeatureToggleButton)event.widget;
            if (toggleButton.isToggled()) {
                SettingDataManager.INSTANCE.setSelectedTarget(toggleButton.getText());
                FlatFeatureDialogTargetPage.this.featureDialog.getFeatureListPage().createFeatureListComposite();
                FlatFeatureDialogTargetPage.this.featureDialog.getSelectedFeaturePage().createSelectedFeatureComposite();
            }
        }
    };

    public FlatFeatureDialogTargetPage(Composite parent, FlatFeatureDialog parentObject, int style) {
        super(parent, style);
        this.setLayout((Layout)new FormLayout());
        this.targetComp = parent;
        this.featureDialog = parentObject;
        this.TARGET_TITLE_FONT_SIZE = 16;
        ((Object)((Object)this.featureDialog)).getClass();
        this.TARGET_COMP_WIDTH = 180;
        ((Object)((Object)this.featureDialog)).getClass();
        this.TARGET_COMP_HEIGHT = 527;
        this.LINE = this.featureDialog.LINE;
        this.TARGET_COMP_ITEM_LEFT_MARGIN = 20;
        this.TARGET_TITLE_HEIGHT = this.featureDialog.TITLE_HEIGHT;
        this.TARGET_TITLE_MARGIN = (this.TARGET_TITLE_HEIGHT - this.TARGET_TITLE_FONT_SIZE) / 2;
        this.TARGET_LIST_TOP = this.TARGET_TITLE_HEIGHT + this.LINE + 1;
        this.TARGET_LIST_HEIGHT = this.TARGET_COMP_HEIGHT - this.TARGET_TITLE_HEIGHT;
        this.TARGET_LIST_WIDTH = this.TARGET_COMP_WIDTH - 17;
        this.TARGET_LIST_UPPER_MARGIN = 30;
        this.TARGET_LIST_ITEM_HEIGHT = 40;
        this.TARGET_LIST_ITEM_MARGIN = 23;
        this.TARGET_LIST_ITEM_LABEL_MARGIN = 15;
        this.TARGET_LIST_ITEM_TITLE_MARGIN = (this.TARGET_LIST_ITEM_HEIGHT - this.TARGET_TITLE_FONT_SIZE) / 2;
        this.createTargetComposite();
    }

    private void initTargetCompositeWidget() {
        if (this.targetLabel != null) {
            this.targetLabel.dispose();
            this.targetLabel = null;
        }
        if (this.targetScrolledComposite != null) {
            this.targetScrolledComposite.dispose();
            this.targetScrolledComposite = null;
        }
        if (this.targetInputComposite != null) {
            this.targetInputComposite.dispose();
            this.targetInputComposite = null;
        }
    }

    private DACustomFeatureToggleButton createToggleButton(Composite composit, Image image, Image pushImage, Image hoverImage, Point imagePoint, String title, Point fontPoint, int width, int height, int topPosition, int leftPosition) {
        DACustomFeatureToggleButton toggle = new DACustomFeatureToggleButton(composit, 0);
        toggle.setColors(ColorResources.FEATURE_TARGETCOMP_BACKGROUND, ColorResources.FEATURE_TARGETCOMP_BACKGROUND, ColorResources.FEATURE_TARGETCOMP_BACKGROUND, ColorResources.FEATURE_TARGETCOMP_BACKGROUND, ColorResources.FEATURE_TARGETCOMP_BACKGROUND, ColorResources.FEATURE_TARGETCOMP_BACKGROUND, ColorResources.FEATURE_TARGETCOMP_BACKGROUND);
        toggle.setButtonImages(image, pushImage, hoverImage, image, pushImage, hoverImage, pushImage);
        toggle.setButtonImagePoint(imagePoint);
        toggle.setTitle(title);
        toggle.setFontPoint(fontPoint);
        toggle.setFontColors(ColorResources.SETTING_COLOR, ColorResources.SETTING_COLOR, ColorResources.SETTING_COLOR, ColorResources.SETTING_COLOR);
        toggle.setButtonFont(FontResources.SETTING_BUTTON_FONT);
        FormData data = new FormData();
        data.top = new FormAttachment(0, topPosition);
        data.left = new FormAttachment(0, leftPosition);
        data.width = width;
        data.height = height;
        toggle.setLayoutData((Object)data);
        return toggle;
    }

    public void createTargetComposite() {
        this.initTargetCompositeWidget();
        this.targetLabel = new Label(this.targetComp, 0x40000000);
        FormData data = new FormData();
        data.top = new FormAttachment(0, this.TARGET_TITLE_MARGIN);
        data.left = new FormAttachment(0, this.TARGET_COMP_ITEM_LEFT_MARGIN);
        data.width = this.TARGET_COMP_WIDTH - this.TARGET_COMP_ITEM_LEFT_MARGIN;
        data.height = this.TARGET_TITLE_HEIGHT - this.TARGET_TITLE_MARGIN - this.TARGET_TITLE_FONT_SIZE + 6;
        this.targetLabel.setLayoutData((Object)data);
        this.targetLabel.setText(ConfigureLabels.SETTING_DIALOG_TARGET_TITLE);
        this.targetLabel.setBackground(ColorResources.FEATURE_TITLE_BACKGROUND);
        this.targetLabel.setForeground(ColorResources.DEFAULT_FONT_COLOR);
        this.targetLabel.setFont(FontResources.SETTING_TITLE_FONT);
        this.targetLabel.setAlignment(16384);
        this.targetComp.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setForeground(ColorResources.FEATURE_LINE);
                e.gc.setLineStyle(1);
                e.gc.drawLine(0, FlatFeatureDialogTargetPage.this.TARGET_TITLE_HEIGHT + FlatFeatureDialogTargetPage.this.LINE, FlatFeatureDialogTargetPage.this.TARGET_COMP_WIDTH, FlatFeatureDialogTargetPage.this.TARGET_TITLE_HEIGHT + FlatFeatureDialogTargetPage.this.LINE);
            }
        });
        this.targetScrolledComposite = new ScrolledComposite(this.targetComp, 512);
        this.targetScrolledComposite.setLayout((Layout)new FormLayout());
        data = new FormData();
        data.top = new FormAttachment(0, this.TARGET_LIST_TOP);
        data.left = new FormAttachment(0, 0);
        data.width = this.TARGET_LIST_WIDTH;
        data.height = this.TARGET_LIST_HEIGHT;
        this.targetScrolledComposite.setLayoutData((Object)data);
        this.targetScrolledComposite.setExpandHorizontal(true);
        this.targetScrolledComposite.setExpandVertical(true);
        this.targetScrolledComposite.setBackground(ColorResources.FEATURE_TARGETCOMP_BACKGROUND);
        this.targetInputComposite = new Composite((Composite)this.targetScrolledComposite, 0);
        this.targetScrolledComposite.setContent((Control)this.targetInputComposite);
        this.targetScrolledComposite.setMinSize(this.targetInputComposite.computeSize(-1, -1));
        this.targetScrolledComposite.setShowFocusedControl(true);
        this.targetInputComposite.setLayout((Layout)new FormLayout());
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.width = this.TARGET_LIST_WIDTH;
        data.height = this.TARGET_LIST_HEIGHT;
        this.targetInputComposite.setLayoutData((Object)data);
        this.targetInputComposite.setBackground(ColorResources.FEATURE_TARGETCOMP_BACKGROUND);
        Map<String, TargetData> targetList = SettingDataManager.INSTANCE.getTargetListMap();
        String selectedTarget = SettingDataManager.INSTANCE.getConnectedTargetOrSelected().getTargetName();
        SettingDataManager.INSTANCE.setSelectedTarget(selectedTarget);
        DACustomFeatureToggleButtonGroup targetGroup = new DACustomFeatureToggleButtonGroup();
        int topPosition = this.TARGET_LIST_UPPER_MARGIN;
        Point imagePoint = new Point(this.TARGET_COMP_ITEM_LEFT_MARGIN, 0);
        Point fontPoint = new Point(this.TARGET_COMP_ITEM_LEFT_MARGIN + ProfileDisplayInfo.imageWidth + this.TARGET_LIST_ITEM_LABEL_MARGIN, this.TARGET_LIST_ITEM_TITLE_MARGIN);
        for (Map.Entry<String, TargetData> entry : targetList.entrySet()) {
            TargetData target = entry.getValue();
            DACustomFeatureToggleButton toggle = this.createToggleButton(this.targetInputComposite, ProfileDisplayInfo.getImage(target.getTargetName()), ProfileDisplayInfo.getFocusImage(target.getTargetName()), ProfileDisplayInfo.getOverImage(target.getTargetName()), imagePoint, target.getTargetName(), fontPoint, this.TARGET_LIST_WIDTH, this.TARGET_LIST_ITEM_HEIGHT, topPosition, 0);
            toggle.setCapitalize(true);
            targetGroup.addToggleButton(toggle);
            toggle.addListener(4, this.clickListener);
            toggle.addListener(6, this.cursorListener);
            toggle.addListener(7, this.cursorListener);
            topPosition += this.TARGET_LIST_ITEM_HEIGHT + this.TARGET_LIST_ITEM_MARGIN;
            if (!selectedTarget.equals(entry.getKey())) continue;
            targetGroup.setSelection(toggle);
        }
        this.targetComp.layout(true);
        this.targetInputComposite.layout();
        this.targetScrolledComposite.setMinSize(this.targetInputComposite.computeSize(-1, -1));
        if (!DAState.isStartable()) {
            this.targetComp.setEnabled(false);
        }
    }

    private static enum ProfileDisplayInfo {
        PROFILE_NAME_MOBILE(0, ConfigureLabels.TARGET_NAME_FLAT_MOBILE_FOCUS, ImageResources.TARGET_NAME_FLAT_MOBILE_SEL, ImageResources.TARGET_NAME_FLAT_MOBILE_NORMAL, ImageResources.TARGET_NAME_FLAT_MOBILE_OVER),
        PROFILE_NAME_TV(1, ConfigureLabels.TARGET_NAME_FLAT_TV_FOCUS, ImageResources.TARGET_NAME_FLAT_TV_SEL, ImageResources.TARGET_NAME_FLAT_TV_NORMAL, ImageResources.TARGET_NAME_FLAT_TV_OVER),
        PROFILE_NAME_WEARABLE(2, ConfigureLabels.TARGET_NAME_FLAT_WEARABLE_FOCUS, ImageResources.TARGET_NAME_FLAT_WEARABLE_SEL, ImageResources.TARGET_NAME_FLAT_WEARABLE_NORMAL, ImageResources.TARGET_NAME_FLAT_WEARABLE_OVER);

        private String displayName = null;
        private Image focusImage = null;
        private Image normalImage = null;
        private Image overImage = null;
        public static int imageWidth;

        static {
            imageWidth = 40;
        }

        private ProfileDisplayInfo(int id, String displayName, Image focusImage, Image normalImage, Image overImage) {
            this.displayName = displayName;
            this.focusImage = focusImage;
            this.normalImage = normalImage;
            this.overImage = overImage;
        }

        public static Image getImage(String displayName) {
            ProfileDisplayInfo[] profiles;
            ProfileDisplayInfo[] profileDisplayInfoArray = profiles = ProfileDisplayInfo.values();
            int n = profiles.length;
            int n2 = 0;
            while (n2 < n) {
                ProfileDisplayInfo profile = profileDisplayInfoArray[n2];
                if (profile.displayName.equals(displayName)) {
                    return profile.normalImage;
                }
                ++n2;
            }
            return null;
        }

        public static Image getFocusImage(String displayName) {
            ProfileDisplayInfo[] profiles;
            ProfileDisplayInfo[] profileDisplayInfoArray = profiles = ProfileDisplayInfo.values();
            int n = profiles.length;
            int n2 = 0;
            while (n2 < n) {
                ProfileDisplayInfo profile = profileDisplayInfoArray[n2];
                if (profile.displayName.equals(displayName)) {
                    return profile.focusImage;
                }
                ++n2;
            }
            return null;
        }

        public static Image getOverImage(String displayName) {
            ProfileDisplayInfo[] profiles;
            ProfileDisplayInfo[] profileDisplayInfoArray = profiles = ProfileDisplayInfo.values();
            int n = profiles.length;
            int n2 = 0;
            while (n2 < n) {
                ProfileDisplayInfo profile = profileDisplayInfoArray[n2];
                if (profile.displayName.equals(displayName)) {
                    return profile.overImage;
                }
                ++n2;
            }
            return null;
        }
    }
}

