/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.tizen.dynamicanalyzer.common.DAResult;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.communicator.DACommunicator;
import org.tizen.dynamicanalyzer.constant.CommonConstants;
import org.tizen.dynamicanalyzer.util.CommonUtil;
import org.tizen.dynamicanalyzer.util.Logger;

public class DownloadContentfileManager {
    private static final int SPLIT_PATH_INDEX = 1;

    public static String getDowonloadFilePath(String contents) {
        String returnString = contents;
        if (contents.contains("SkWek2n3_File:")) {
            String[] strFile = contents.split("SkWek2n3_File:");
            if (strFile.length < 1) {
                return returnString;
            }
            String deviceFilePath = strFile[1];
            String[] fileNameSplit = deviceFilePath.split("/tmp/");
            if (fileNameSplit.length < 1) {
                return returnString;
            }
            String downloadFolderPath = String.valueOf(File.separator) + "download_file";
            DownloadContentfileManager.makeFolder(String.valueOf(Global.getProject().getSavePath()) + downloadFolderPath);
            String saveFilePath = String.valueOf(downloadFolderPath) + File.separator + fileNameSplit[1];
            if (DownloadContentfileManager.pullFile(deviceFilePath, String.valueOf(Global.getProject().getSavePath()) + saveFilePath)) {
                returnString = saveFilePath;
            }
        }
        return returnString;
    }

    public static boolean pullFile(String from, String to) {
        DAResult res = DACommunicator.pull(from, to);
        if (!res.isSuccess()) {
            Logger.debug((Object)("Failed to get " + from));
            return false;
        }
        Logger.debug((Object)(String.valueOf(from) + "file copying success!!"));
        DACommunicator.removeFile(from);
        return true;
    }

    public static String getFileContents(String contents) {
        String returnString = contents;
        if (contents.contains("download_file" + File.separator)) {
            StringBuffer contextsBuffer;
            block9: {
                contextsBuffer = new StringBuffer();
                String filePath = String.valueOf(Global.getProject().getSavePath()) + contents;
                File contentsFile = new File(filePath);
                if (contentsFile.isFile()) {
                    BufferedReader in = null;
                    try {
                        String content;
                        in = new BufferedReader(new FileReader(contentsFile));
                        while ((content = in.readLine()) != null) {
                            contextsBuffer.append(content).append(CommonConstants.NEW_LINE);
                        }
                    }
                    catch (FileNotFoundException e) {
                        Logger.exception((Throwable)e);
                        CommonUtil.tryClose((Object[])new Object[]{in});
                        break block9;
                    }
                    catch (IOException e) {
                        try {
                            Logger.exception((Throwable)e);
                        }
                        catch (Throwable throwable) {
                            CommonUtil.tryClose((Object[])new Object[]{in});
                            throw throwable;
                        }
                        CommonUtil.tryClose((Object[])new Object[]{in});
                        break block9;
                    }
                    CommonUtil.tryClose((Object[])new Object[]{in});
                }
            }
            returnString = contextsBuffer.toString();
        }
        return returnString;
    }

    private static void makeFolder(String folderPath) {
        File toDir = new File(folderPath);
        if (!toDir.exists() || !toDir.isDirectory()) {
            toDir.mkdirs();
        }
    }
}

