/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.formatter;

import java.util.List;
import org.eclipse.cdt.debug.edc.formatter.AbstractVariableConverter;
import org.eclipse.cdt.debug.edc.formatter.FormatUtils;
import org.eclipse.cdt.debug.edc.formatter.ITypeContentProvider;
import org.eclipse.cdt.debug.edc.formatter.IVariableFormatProvider;
import org.eclipse.cdt.debug.edc.formatter.IVariableValueConverter;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.IArrayDimensionType;
import org.eclipse.cdt.debug.edc.internal.symbols.IArrayType;
import org.eclipse.cdt.debug.edc.services.IEDCExpression;
import org.eclipse.cdt.debug.edc.services.IEDCExpressions;
import org.eclipse.cdt.debug.edc.symbols.IType;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.core.runtime.CoreException;

public class DefaultArrayFormatter
implements IVariableFormatProvider {
    public static boolean handlesType(IType type) {
        IType unqualifiedType = FormatUtils.getUnqualifiedTypeRemovePointers(type);
        return unqualifiedType instanceof IArrayType || unqualifiedType instanceof IArrayDimensionType;
    }

    @Override
    public ITypeContentProvider getTypeContentProvider(IType type) {
        return null;
    }

    @Override
    public IVariableValueConverter getDetailValueConverter(IType type) {
        if (DefaultArrayFormatter.handlesType(type)) {
            return new DefaultArrayConverter(type, true);
        }
        return null;
    }

    @Override
    public IVariableValueConverter getVariableValueConverter(IType type) {
        if (DefaultArrayFormatter.handlesType(type)) {
            return new DefaultArrayConverter(type, false);
        }
        return null;
    }

    public class DefaultArrayConverter
    extends AbstractVariableConverter {
        private static final int STOP_LENGTH = 300;

        public DefaultArrayConverter(IType type, boolean forDetails) {
            super(type, forDetails);
        }

        @Override
        protected String getSummaryValue(IExpressions.IExpressionDMContext variable) throws CoreException {
            IEDCExpressions expressions = ((IEDCExpression)variable).getExpressionsService();
            if (expressions == null) {
                return "";
            }
            StringBuilder sb = new StringBuilder("[");
            List<IExpressions.IExpressionDMContext> children = FormatUtils.getAllChildExpressions(variable);
            boolean skip = true;
            for (IExpressions.IExpressionDMContext child : children) {
                if (skip) {
                    skip = false;
                } else {
                    sb.append(", ");
                }
                String customString = this.getCustomValueString(child, this.getCurValueLength() + sb.length());
                if (customString != null) {
                    sb.append('{');
                    sb.append(customString);
                    sb.append('}');
                } else {
                    IEDCExpression childExpression = (IEDCExpression)child;
                    sb.append(FormatUtils.getVariableValue(childExpression));
                }
                if (this.getCurValueLength() + sb.length() <= 300) continue;
                if (children.get(children.size() - 1).equals(child)) break;
                sb.append(", ...");
                break;
            }
            return sb.append(']').toString();
        }

        private String getCustomValueString(IExpressions.IExpressionDMContext variable, int curValueLength) throws CoreException {
            IVariableValueConverter converter = FormatUtils.getCustomValueConverter(variable);
            if (converter != null) {
                if (converter instanceof AbstractVariableConverter) {
                    ((AbstractVariableConverter)converter).setCurValueLength(curValueLength);
                }
                return converter.getValue(variable);
            }
            return null;
        }

        @Override
        protected String getDetailsValue(IExpressions.IExpressionDMContext variable) throws CoreException {
            return this.getSummaryValue(variable);
        }
    }
}

