/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.da.view;

import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;
import org.tizen.dynamicanalyzer.widgets.da.view.DABaseComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAContainerComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public abstract class DAViewComposite
extends DABaseComposite {
    private static final int OFFSET = 5;
    protected Canvas titleBar = null;
    protected Composite contentArea = null;
    private Color titleFontColor = ColorResources.VIEW_TITLE_FONT_COLOR;
    private boolean isMaximized = false;
    private PaintListener titlePaintListener = new PaintListener(){

        public void paintControl(PaintEvent e) {
            GC gc = e.gc;
            Rectangle bounds = DAViewComposite.this.titleBar.getBounds();
            int width = bounds.width;
            int height = bounds.height;
            gc.setForeground(ColorResources.WHITE);
            gc.setBackground(ColorResources.WHITE);
            gc.fillGradientRectangle(bounds.x, bounds.y, width, height, true);
            gc.setFont(FontResources.VIEW_TITLE);
            gc.setForeground(DAViewComposite.this.titleFontColor);
            Point textSize = gc.textExtent(DAViewComposite.this.title, 8);
            gc.drawText(DAViewComposite.this.title, (width - textSize.x) / 2 - 5, (height - textSize.y) / 2, true);
        }
    };
    private Listener titleMouseListener = new Listener(){

        public void handleEvent(Event event) {
            DAViewComposite.this.isMaximized = !DAViewComposite.this.isMaximized;
            DAViewComposite.this.setMaxSize(DAViewComposite.this.isMaximized);
        }
    };

    public DAViewComposite(Composite parent, int style, boolean titleVisibility) {
        super(parent, style);
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)new FormLayout());
        this.titleBar = new Canvas(composite, 0x20000000);
        this.titleBar.addPaintListener(this.titlePaintListener);
        this.titleBar.addListener(8, this.titleMouseListener);
        Composite borderArea1 = new Composite(composite, 0);
        borderArea1.setLayout((Layout)new FormLayout());
        borderArea1.setBackground(ColorResources.GRAY_210);
        Composite borderArea2 = new Composite(borderArea1, 0);
        borderArea2.setLayout((Layout)new FormLayout());
        borderArea2.setBackground(ColorResources.GRAY_210);
        Composite borderArea3 = new Composite(borderArea2, 0);
        borderArea3.setLayout((Layout)new FormLayout());
        borderArea3.setBackground(ColorResources.GRAY_210);
        this.contentArea = new Composite(borderArea3, 0);
        this.contentArea.setLayout((Layout)new FormLayout());
        this.contentArea.setBackground(ColorResources.WHITE);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.height = titleVisibility ? 31 : 0;
        this.titleBar.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.titleBar, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        borderArea1.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        borderArea2.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        borderArea3.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, -1);
        this.contentArea.setLayoutData((Object)data);
    }

    public Canvas getTitleArea() {
        return this.titleBar;
    }

    public Composite getContentArea() {
        return this.contentArea;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
        this.titleBar.setToolTipText(title);
        this.titleBar.redraw();
    }

    public void setTitleFontColor(Color color) {
        this.titleFontColor = color;
    }

    protected void setMaxSize(boolean maximized) {
        DAViewComposite current = this;
        Composite parent = this.getParent();
        while (parent != null) {
            if (parent instanceof DAContainerComposite && ((DAContainerComposite)parent).isToplevel()) break;
            if (parent instanceof SashForm) {
                if (maximized) {
                    ((SashForm)parent).setMaximizedControl((Control)current);
                } else {
                    ((SashForm)parent).setMaximizedControl(null);
                }
            }
            current = parent;
            parent = parent.getParent();
        }
    }

    @Override
    public void updateView() {
    }

    @Override
    public void updateView(DAViewData data) {
    }

    @Override
    public void callUpdatePage(DAChartBoardItem selectedItem) {
    }

    @Override
    public void clear() {
    }

    public void showSearchSelection(int index) {
    }

    public Control getControl() {
        return null;
    }

    @Override
    protected boolean isContainer() {
        return false;
    }

    @Override
    public DABaseComposite getView(String viewid) {
        return null;
    }
}

