/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.project;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tizen.dynamicanalyzer.common.DAResult;
import org.tizen.dynamicanalyzer.common.ElfSymbolExtractor;
import org.tizen.dynamicanalyzer.common.path.PathManager;
import org.tizen.dynamicanalyzer.communicator.DACommunicator;
import org.tizen.dynamicanalyzer.communicator.UnsupportedProtocolException;
import org.tizen.dynamicanalyzer.constant.CommonConstants;
import org.tizen.dynamicanalyzer.handlers.UIActionHolder;
import org.tizen.dynamicanalyzer.model.AddrSymbolPair;
import org.tizen.dynamicanalyzer.nl.UserErrorWarningLabels;
import org.tizen.dynamicanalyzer.util.FileUtil;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.dynamicanalyzer.utils.RpmUtil;

public class AppInfo {
    public static final String LOCALPKGPATH = "LocalPackagePaths";
    public static final String APPTYPE_CPP = "c++";
    public static final String APPTYPE_CAPP = "capp";
    public static final String APPTYPE_WEB = "webapp";
    public static final String APPTYPE_RUNNING = "running";
    public static final String APPTYPE_EXEC = "executable";
    public static final String APPTYPE_NONE = "none";
    public static final String FLAG_ZERO = "0";
    public static final String FLAG_ONE = "1";
    private ElfSymbolExtractor symbolExtractor = new ElfSymbolExtractor();
    private String execPath = null;
    private String execFileName = null;
    private List<String> localPackagePath = null;
    private Map<Integer, String> runningProcesses = null;
    private List<String> properties = new ArrayList<String>();
    private boolean isPossibleToTrace = true;

    public AppInfo() {
        int propertyCount = PROPERTY.values().length;
        int i = 0;
        while (i < propertyCount) {
            this.properties.add("");
            ++i;
        }
    }

    public String getDebugFilePath() {
        return this.properties.get(PROPERTY.DEBUGPATH.index);
    }

    public void setDebugFilePath(String debugFilePath) {
        this.properties.set(PROPERTY.DEBUGPATH.index, debugFilePath);
    }

    public String getSourcePath() {
        return this.properties.get(PROPERTY.SRCPATH.index);
    }

    public void setSourcePath(String sourcePath) {
        this.properties.set(PROPERTY.SRCPATH.index, sourcePath);
    }

    public String getExecFileName() {
        if (this.execFileName == null) {
            String[] splitPath = this.getExecPath().split("/");
            this.execFileName = splitPath[splitPath.length - 1];
        }
        return this.execFileName;
    }

    public void setInfo(int index, String data) {
        this.properties.set(index, data);
        if (index == PROPERTY.EXEC.index) {
            this.execFileName = null;
            this.execPath = null;
        }
    }

    public String getInfo(int index) {
        return this.properties.get(index);
    }

    public boolean isPossibleToTrace() {
        return this.isPossibleToTrace;
    }

    public void setPossibleToTrace(boolean isPossibleToTrace) {
        this.isPossibleToTrace = isPossibleToTrace;
    }

    public Map<Integer, String> getRunningProcesses() {
        return this.runningProcesses;
    }

    public void setRunningProcesses(Map<Integer, String> runningProc) {
        this.runningProcesses = runningProc;
    }

    public List<AddrSymbolPair> getSymbols(String sourceBinaryPath) {
        List<AddrSymbolPair> symbols = null;
        if (this.localPackagePath != null) {
            int psize = this.localPackagePath.size();
            int i = 0;
            while (i < psize) {
                if (this.localPackagePath.get(i).contains("debuginfo")) {
                    this.getDebugFilePathFromDebugRpm(this.localPackagePath.get(i));
                } else if (this.localPackagePath.get(i).contains("debugsource")) {
                    this.getSourcePathFromSourceRpm(this.localPackagePath.get(i));
                }
                ++i;
            }
        }
        symbols = this.getSymbolsFromBinary(sourceBinaryPath);
        return symbols;
    }

    public List<AddrSymbolPair> getSymbolsFromBinary(String sourceBinaryPath) {
        if (sourceBinaryPath == null || sourceBinaryPath.isEmpty()) {
            return null;
        }
        this.symbolExtractor.clear();
        this.symbolExtractor.makeSymbol(sourceBinaryPath);
        return this.symbolExtractor.getAddrSymbolPairs();
    }

    public void getDebugFilePathFromDebugRpm(String debugRpmPath) {
        boolean extracted;
        String debugFilePath = null;
        if (debugRpmPath == null || debugRpmPath.isEmpty()) {
            return;
        }
        File debugInfoRpmFile = new File(debugRpmPath);
        if (!debugInfoRpmFile.exists() || debugInfoRpmFile.isDirectory()) {
            return;
        }
        String rpmPath = String.valueOf(PathManager.DA_RPM_PATH) + File.separator + this.properties.get(PROPERTY.LABEL.index);
        File rpms = new File(rpmPath);
        if (!rpms.exists() && !rpms.mkdirs()) {
            Logger.debug((Object)"rpm directory create failed...");
            return;
        }
        String copiedRpmPath = null;
        String destPath = String.valueOf(rpmPath) + File.separator + debugInfoRpmFile.getName();
        if (!AnalyzerUtil.copyFile(debugRpmPath, destPath)) {
            return;
        }
        copiedRpmPath = destPath;
        if (copiedRpmPath != null && !(extracted = RpmUtil.extractRpm(rpmPath, copiedRpmPath))) {
            return;
        }
        if (debugInfoRpmFile.getName().contains("debuginfo")) {
            List files = FileUtil.findFilesInDir((String)rpmPath, (String)(String.valueOf(this.getExecFileName()) + ".debug"), (boolean)true);
            if (files.size() == 0) {
                return;
            }
            debugFilePath = (String)files.get(0);
            Logger.debug((Object)("DEBUG PATH : " + debugFilePath));
        } else if (debugInfoRpmFile.getName().contains("debug-")) {
            List files = FileUtil.findFilesInDir((String)rpmPath, (String)this.getExecFileName(), (boolean)true);
            if (files.size() == 0) {
                return;
            }
            debugFilePath = (String)files.get(0);
            Logger.debug((Object)("DEBUG PATH : " + debugFilePath));
        } else {
            return;
        }
        if (debugFilePath != null && !debugFilePath.isEmpty()) {
            this.setDebugFilePath(debugFilePath);
        }
    }

    public void getSourcePathFromSourceRpm(String sourceRpmPath) {
        boolean extracted;
        if (sourceRpmPath == null || sourceRpmPath.isEmpty()) {
            return;
        }
        File debugsourceRpmFile = new File(sourceRpmPath);
        if (!debugsourceRpmFile.exists() || debugsourceRpmFile.isDirectory()) {
            return;
        }
        String debugsourceRpmFileName = debugsourceRpmFile.getName();
        int index = debugsourceRpmFileName.indexOf("debugsource");
        String project = debugsourceRpmFileName.substring(0, index);
        String[] splitSrcRpmFileName = debugsourceRpmFileName.split("-");
        String version = splitSrcRpmFileName[splitSrcRpmFileName.length - 2];
        String projectName = String.valueOf(project) + version;
        String rpmPath = String.valueOf(PathManager.DA_RPM_PATH) + File.separator + this.properties.get(PROPERTY.LABEL.index);
        File rpms = new File(rpmPath);
        if (!rpms.exists() && !rpms.mkdirs()) {
            Logger.debug((Object)"rpm directory create failed...");
            return;
        }
        String copiedRpmPath = null;
        String destPath = String.valueOf(rpmPath) + File.separator + debugsourceRpmFileName;
        if (!AnalyzerUtil.copyFile(sourceRpmPath, destPath)) {
            return;
        }
        copiedRpmPath = destPath;
        if (copiedRpmPath != null && !(extracted = RpmUtil.extractRpm(rpmPath, copiedRpmPath))) {
            return;
        }
        List files = FileUtil.findFilesInDir((String)rpmPath, (String)(String.valueOf(projectName) + "*"), (boolean)false);
        if (files.size() != 0) {
            this.setSourcePath(rpmPath);
            Logger.debug((Object)("SOURCE PATH : " + this.properties.get(PROPERTY.SRCPATH.index)));
        }
    }

    public String getAppID() {
        return this.properties.get(PROPERTY.APPID.index);
    }

    public String getPackageID() {
        return this.properties.get(PROPERTY.PACKAGE.index);
    }

    public String getLabel() {
        return this.properties.get(PROPERTY.LABEL.index);
    }

    public String getExecPath() {
        return this.properties.get(PROPERTY.EXEC.index);
    }

    public String getComponent() {
        return this.properties.get(PROPERTY.COMPONENT.index);
    }

    public String getAppComp() {
        return this.properties.get(PROPERTY.APPCOMP.index);
    }

    public boolean isSpecialApp() {
        return this.getAppID().startsWith("da.id.dummy.app");
    }

    public String getDistinguishedLabel() {
        if (this.isSpecialApp()) {
            return this.getLabel();
        }
        String[] appIdParts = this.getAppID().split("\\.");
        String detail = appIdParts.length == 0 ? this.getPackageID() : appIdParts[appIdParts.length - 1];
        return String.format("%s (%s)", this.getLabel(), detail);
    }

    public String getExecBinaryPath() {
        if (this.execPath != null) {
            return this.execPath;
        }
        String exec = this.properties.get(PROPERTY.EXEC.index);
        String realpath = DACommunicator.getRealpath(exec);
        if (realpath == null || realpath.isEmpty()) {
            if (this.getAppType().contains(APPTYPE_CPP)) {
                exec = exec.replaceFirst("/opt/apps", "/opt/usr/apps");
                exec = String.valueOf(exec) + ".exe";
            } else if (this.getAppType().contains(APPTYPE_CAPP)) {
                exec = exec.replaceFirst("/opt/apps", "/opt/usr/apps");
            }
            this.execPath = exec;
        } else {
            this.execPath = realpath;
        }
        return this.execPath;
    }

    public String getAppType() {
        return this.properties.get(PROPERTY.APPTYPE.index);
    }

    public List<String> getLocalPackagePath() {
        if (this.localPackagePath != null) {
            return Collections.unmodifiableList(this.localPackagePath);
        }
        return null;
    }

    public void setLocalPackagePath(List<String> localPackagePath) {
        this.localPackagePath = localPackagePath;
    }

    public void savePrimitive(BufferedWriter writer) throws IOException {
        PROPERTY[] property = PROPERTY.values();
        int propertyCount = property.length;
        int i = 0;
        while (i < propertyCount) {
            writer.write(String.valueOf(property[i].name) + "=" + this.properties.get(property[i].index) + CommonConstants.NEW_LINE);
            ++i;
        }
        if (this.localPackagePath != null) {
            writer.write("LocalPackagePaths=");
            int count = this.localPackagePath.size();
            int i2 = 0;
            while (i2 < count) {
                writer.write(this.localPackagePath.get(i2));
                if (i2 != count - 1) {
                    writer.write(";");
                }
                ++i2;
            }
            writer.write(CommonConstants.NEW_LINE);
        }
    }

    public void openPrimitive(BufferedReader in) throws IOException {
        String content;
        PROPERTY[] property = PROPERTY.values();
        int propertycount = property.length;
        while ((content = in.readLine()) != null) {
            String[] splitPkg;
            if (content.trim().isEmpty()) break;
            String[] splitData = content.split("=");
            if (2 != splitData.length) continue;
            String infoKey = splitData[0];
            String val = splitData[1];
            int i = 0;
            while (i < propertycount) {
                if (infoKey.equals(property[i].name)) {
                    this.setInfo(property[i].index, val);
                    break;
                }
                ++i;
            }
            if (!infoKey.equals(LOCALPKGPATH) || (splitPkg = val.split(";")).length <= 0) continue;
            if (this.localPackagePath == null) {
                this.localPackagePath = new ArrayList<String>();
            } else {
                this.localPackagePath.clear();
            }
            int k = 0;
            while (k < splitPkg.length) {
                this.localPackagePath.add(splitPkg[k]);
                ++k;
            }
        }
    }

    public List<String> getProcessInformation() {
        ArrayList<String> binPaths = new ArrayList<String>();
        String appID = this.getAppID();
        if ("da.id.dummy.app.running".equals(appID)) {
            Map<Integer, String> selProcess = this.getRunningProcesses();
            if (selProcess == null) {
                Logger.warning((Object)"There is no selected process");
                this.setPossibleToTrace(false);
            } else {
                for (Map.Entry<Integer, String> entry : selProcess.entrySet()) {
                    binPaths.add(entry.getValue());
                }
                this.setPossibleToTrace(true);
            }
        } else if (!"da.id.dummy.app.systemwide".equals(appID)) {
            if ("da.id.dummy.app.executable".equals(appID)) {
                String executablePath = this.getExecBinaryPath();
                if (executablePath == null || executablePath.isEmpty()) {
                    Logger.warning((Object)"There is no application in selected package");
                    this.setPossibleToTrace(false);
                } else {
                    binPaths.add(executablePath);
                    this.setPossibleToTrace(true);
                }
            } else {
                String execpath = this.getExecBinaryPath();
                this.setPossibleToTrace(execpath != null);
                if (execpath != null) {
                    binPaths.add(execpath);
                }
            }
        }
        return binPaths;
    }

    public DAResult.ErrorCode getBinaryInformation(List<String> binPaths) {
        if (!binPaths.isEmpty()) {
            DAResult hr = new DAResult(DAResult.ErrorCode.ERR_BIN_INFO_GET_FAIL);
            try {
                hr = DACommunicator.getBinaryInformation(binPaths);
            }
            catch (InterruptedException interruptedException) {
                Logger.warning((Object)"Interrupted during getting binary information about application binary");
            }
            catch (UnsupportedProtocolException unsupportedProtocolException) {
                Logger.warning((Object)"Message to get binary information is not supported by communicator");
            }
            if (hr.equals((Object)DAResult.ErrorCode.ERR_BY_SECURITY)) {
                UIActionHolder.getUIAction().showWarning(UserErrorWarningLabels.ERROR_APP_SELECT_BY_SECURITY);
                Logger.warning((Object)"Failed to get binary info by security reason");
                this.setPossibleToTrace(false);
                return DAResult.ErrorCode.ERR_BY_SECURITY;
            }
            if (!hr.isSuccess()) {
                UIActionHolder.getUIAction().showWarning(hr);
                Logger.warning((Object)("Failed to get binary info : " + hr.getMessage()));
                this.setPossibleToTrace(false);
                return hr.getErrorCode();
            }
            this.setPossibleToTrace(true);
            return DAResult.ErrorCode.SUCCESS;
        }
        return DAResult.ErrorCode.ERR_BIN_INFO_GET_FAIL;
    }

    public static enum PROPERTY {
        APPID(0, "Appid"),
        PACKAGE(1, "Package"),
        EXEC(2, "Exec"),
        ICON(3, "Icon"),
        LABEL(4, "Label"),
        APPTYPE(5, "Apptype"),
        COMPONENT(6, "component"),
        MULTI(7, "Multiple"),
        NODISPLAY(8, "Nodisplay"),
        TASKMANAGE(9, "Taskmanage"),
        HWACC(10, "hw-acceleration"),
        SCRREADER(11, "screenreader"),
        SUPPORT(12, "support-disable"),
        USERDATA(13, "user_data"),
        DEBUGPATH(14, "DebugFilePath"),
        SRCPATH(15, "SourcePath"),
        APPCOMP(16, "Appcomp");

        public final int index;
        public final String name;
        private static Map<String, PROPERTY> nameMap;

        static {
            nameMap = new HashMap<String, PROPERTY>();
            PROPERTY[] pROPERTYArray = PROPERTY.values();
            int n = pROPERTYArray.length;
            int n2 = 0;
            while (n2 < n) {
                PROPERTY p = pROPERTYArray[n2];
                nameMap.put(p.name, p);
                ++n2;
            }
        }

        private PROPERTY(int index, String name) {
            this.index = index;
            this.name = name;
        }

        public static PROPERTY get(String name) {
            return nameMap.get(name);
        }
    }
}

