/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.setting;

import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Image;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.nl.ConfigureLabels;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.setting.PrimitiveFeature;

public enum FlatFeature {
    CPU_USAGE(PrimitiveFeature.CPU_USAGE),
    CPU_USAGE_PER_CORE(PrimitiveFeature.CPU_USAGE_PER_CORE),
    CPU_FREQ_PER_CORE(PrimitiveFeature.CPU_FREQ_PER_CORE),
    SYSTEM_MEMORY(PrimitiveFeature.SYSTEM_MEMORY),
    PROCESS_MEMORY(PrimitiveFeature.PROCESS_MEMORY),
    MEMORY_ALLOC(PrimitiveFeature.MEMORY_ALLOC),
    DISK_IO(PrimitiveFeature.DISK_IO),
    FILE_ANALYSIS(PrimitiveFeature.FILE_ANALYSIS),
    OPENGLES_ANALYSIS(PrimitiveFeature.OPENGLES_ANALYSIS),
    NETWORK_IO(PrimitiveFeature.NETWORK_IO),
    NETWORK_ANALYSIS(PrimitiveFeature.NETWORK_ANALYSIS),
    UI_EVENT(PrimitiveFeature.UI_EVENT),
    SCREENSHOT(PrimitiveFeature.SCREENSHOT),
    UI_HIERARCHY_ANALYSIS(PrimitiveFeature.UI_HIERARCHY_ANALYSIS),
    THREAD_ANALYSIS(PrimitiveFeature.THREAD_ANALYSIS),
    PERIPHERAL_STATUS(PrimitiveFeature.PERIPHERAL_STATUS),
    POWER_ESTIMATION(PrimitiveFeature.POWER_ESTIMATION);

    private static final Map<Integer, FlatFeature> featureByIndex;
    private static final Map<String, FlatFeature> featureByName;
    private PrimitiveFeature primitive;
    private Image focusImg = null;
    private Image normalImg = null;
    private Image dimImg = null;
    private Image overImg = null;
    private Image smallImg = null;
    private int overheadRanking = 0;
    private static IndexComparator indexComparator;

    static {
        featureByIndex = new HashMap<Integer, FlatFeature>();
        featureByName = new HashMap<String, FlatFeature>();
        FlatFeature.setResources();
        FlatFeature[] flatFeatureArray = FlatFeature.values();
        int n = flatFeatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            FlatFeature feature = flatFeatureArray[n2];
            int index = feature.getIndex();
            String name = feature.getName();
            featureByIndex.put(index, feature);
            featureByName.put(name, feature);
            ++n2;
        }
        indexComparator = new IndexComparator();
    }

    private FlatFeature(PrimitiveFeature primitive) {
        this.primitive = primitive;
    }

    private static void setResources() {
        if (Global.isCLIMode()) {
            return;
        }
        CPU_USAGE.setResources(ImageResources.FEATURE_CPU_FOCUS, ImageResources.FEATURE_CPU_NORMAL, ImageResources.FEATURE_CPU_DIM, ImageResources.FEATURE_CPU_OVER, ImageResources.FEATURE_CPU_SMALL_SEL);
        CPU_USAGE_PER_CORE.setResources(ImageResources.FEATURE_CPUCORE_FOCUS, ImageResources.FEATURE_CPUCORE_NORMAL, ImageResources.FEATURE_CPUCORE_DIM, ImageResources.FEATURE_CPUCORE_OVER, ImageResources.FEATURE_CPUCORE_SMALL_SEL);
        CPU_FREQ_PER_CORE.setResources(ImageResources.FEATURE_CPUFREQ_FOCUS, ImageResources.FEATURE_CPUFREQ_NORMAL, ImageResources.FEATURE_CPUFREQ_DIM, ImageResources.FEATURE_CPUFREQ_OVER, ImageResources.FEATURE_CPUFREQ_SMALL_SEL);
        SYSTEM_MEMORY.setResources(ImageResources.FEATURE_MEM_SYSTEM_FOCUS, ImageResources.FEATURE_MEM_SYSTEM_NORMAL, ImageResources.FEATURE_MEM_SYSTEM_DIM, ImageResources.FEATURE_MEM_SYSTEM_OVER, ImageResources.FEATURE_MEM_SYSTEM_SMALL_SEL);
        PROCESS_MEMORY.setResources(ImageResources.FEATURE_MEM_PROCESS_FOCUS, ImageResources.FEATURE_MEM_PROCESS_NORMAL, ImageResources.FEATURE_MEM_PROCESS_DIM, ImageResources.FEATURE_MEM_PROCESS_OVER, ImageResources.FEATURE_MEM_PROCESS_SMALL_SEL);
        MEMORY_ALLOC.setResources(ImageResources.FEATURE_HEAPALLOC_FOCUS, ImageResources.FEATURE_HEAPALLOC_NORMAL, ImageResources.FEATURE_HEAPALLOC_DIM, ImageResources.FEATURE_HEAPALLOC_OVER, ImageResources.FEATURE_HEAPALLOC_SMALL_SEL);
        DISK_IO.setResources(ImageResources.FEATURE_DISKIO_FOCUS, ImageResources.FEATURE_DISKIO_NORMAL, ImageResources.FEATURE_DISKIO_DIM, ImageResources.FEATURE_DISKIO_OVER, ImageResources.FEATURE_DISKIO_SMALL_SEL);
        FILE_ANALYSIS.setResources(ImageResources.FEATURE_FILE_FOCUS, ImageResources.FEATURE_FILE_NORMAL, ImageResources.FEATURE_FILE_DIM, ImageResources.FEATURE_FILE_OVER, ImageResources.FEATURE_FILE_SMALL_SEL);
        OPENGLES_ANALYSIS.setResources(ImageResources.FEATURE_OPENGL_FOCUS, ImageResources.FEATURE_OPENGL_NORMAL, ImageResources.FEATURE_OPENGL_DIM, ImageResources.FEATURE_OPENGL_OVER, ImageResources.FEATURE_OPENGL_SMALL_SEL);
        NETWORK_IO.setResources(ImageResources.FEATURE_NETWORKIO_FOCUS, ImageResources.FEATURE_NETWORKIO_NORMAL, ImageResources.FEATURE_NETWORKIO_DIM, ImageResources.FEATURE_NETWORKIO_OVER, ImageResources.FEATURE_NETWORKIO_SMALL_SEL);
        NETWORK_ANALYSIS.setResources(ImageResources.FEATURE_NETWORKTRAFFIC_FOCUS, ImageResources.FEATURE_NETWORKTRAFFIC_NORMAL, ImageResources.FEATURE_NETWORKTRAFFIC_DIM, ImageResources.FEATURE_NETWORKTRAFFIC_OVER, ImageResources.FEATURE_NETWORKTRAFFIC_SMALL_SEL);
        UI_EVENT.setResources(ImageResources.FEATURE_UIEVENT_FOCUS, ImageResources.FEATURE_UIEVENT_NORMAL, ImageResources.FEATURE_UIEVENT_DIM, ImageResources.FEATURE_UIEVENT_OVER, ImageResources.FEATURE_UIEVENT_SMALL_SEL);
        SCREENSHOT.setResources(ImageResources.FEATURE_SNAPSHOT_FOCUS, ImageResources.FEATURE_SNAPSHOT_NORMAL, ImageResources.FEATURE_SNAPSHOT_DIM, ImageResources.FEATURE_SNAPSHOT_OVER, ImageResources.FEATURE_SNAPSHOT_SMALL_SEL);
        UI_HIERARCHY_ANALYSIS.setResources(ImageResources.FEATURE_UIHV_FOCUS, ImageResources.FEATURE_UIHV_NORMAL, ImageResources.FEATURE_UIHV_DIM, ImageResources.FEATURE_UIHV_OVER, ImageResources.FEATURE_UIHV_SMALL_SEL);
        THREAD_ANALYSIS.setResources(ImageResources.FEATURE_THREADACTIVITY_FOCUS, ImageResources.FEATURE_THREADACTIVITY_NORMAL, ImageResources.FEATURE_THREADACTIVITY_DIM, ImageResources.FEATURE_THREADACTIVITY_OVER, ImageResources.FEATURE_THREADACTIVITY_SMALL_SEL);
        PERIPHERAL_STATUS.setResources(ImageResources.FEATURE_DEVICE_FOCUS, ImageResources.FEATURE_DEVICE_NORMAL, ImageResources.FEATURE_DEVICE_DIM, ImageResources.FEATURE_DEVICE_OVER, ImageResources.FEATURE_DEVICE_SMALL_SEL);
        POWER_ESTIMATION.setResources(ImageResources.FEATURE_CURRENT_FOCUS, ImageResources.FEATURE_CURRENT_NORMAL, ImageResources.FEATURE_CURRENT_DIM, ImageResources.FEATURE_CURRENT_OVER, ImageResources.FEATURE_CURRENT_SMALL_SEL);
    }

    private void setResources(Image focusImg, Image normalImg, Image dimImg, Image overImg, Image smallImg) {
        this.focusImg = focusImg;
        this.normalImg = normalImg;
        this.dimImg = dimImg;
        this.overImg = overImg;
        this.smallImg = smallImg;
    }

    public int getIndex() {
        return this.primitive.getIndex();
    }

    public String getName() {
        return this.primitive.getName();
    }

    public String getDescription() {
        return this.primitive.getDescription();
    }

    public String getPage() {
        return this.primitive.getPage();
    }

    public String getChart() {
        return this.primitive.getChart();
    }

    public static FlatFeature getFlatFeature(String name) {
        return featureByName.get(name);
    }

    public static FlatFeature getFlatFeature(int featureIndex) {
        return featureByIndex.get(featureIndex);
    }

    public Image getFocusImage() {
        return this.focusImg;
    }

    public Image getNormalImage() {
        return this.normalImg;
    }

    public Image getDimImage() {
        return this.dimImg;
    }

    public Image getOverImage() {
        return this.overImg;
    }

    public Image getSmallImage() {
        return this.smallImg;
    }

    public int getOverheadRanking() {
        return this.overheadRanking;
    }

    public void setOverheadRanking(String overheadRanking) {
        if (overheadRanking != null && !overheadRanking.isEmpty()) {
            this.overheadRanking = Integer.parseInt(overheadRanking);
        }
    }

    public String getOverheadRankingMessage() {
        String ret = "";
        switch (this.overheadRanking) {
            case 1: {
                ret = ConfigureLabels.FEATURE_OVERHEAD_RANKING_NORMAL;
                break;
            }
            case 2: {
                ret = ConfigureLabels.FEATURE_OVERHEAD_RANKING_MIDDLE;
                break;
            }
            case 3: {
                ret = ConfigureLabels.FEATURE_OVERHEAD_RANKING_HIGH;
                break;
            }
            default: {
                ret = ConfigureLabels.FEATURE_OVERHEAD_RANKING_NORMAL;
            }
        }
        return ret;
    }

    public static IndexComparator getIndexComparator() {
        return indexComparator;
    }

    private static class IndexComparator
    implements Comparator<FlatFeature>,
    Serializable {
        private static final long serialVersionUID = 7911468647564611213L;

        private IndexComparator() {
        }

        @Override
        public int compare(FlatFeature arg0, FlatFeature arg1) {
            if (arg0 == arg1) {
                return 0;
            }
            return arg0.getIndex() > arg1.getIndex() ? 1 : -1;
        }
    }
}

