/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.interactive.table;

import java.util.List;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.model.ColumnData;
import org.tizen.dynamicanalyzer.nl.InteractivePageLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.ui.interactive.model.InteractiveInfo;
import org.tizen.dynamicanalyzer.ui.interactive.table.InteractiveTable;
import org.tizen.dynamicanalyzer.ui.widgets.DAAdvancedViewComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class InteractiveTableView
extends DAAdvancedViewComposite {
    public static final String ID = InteractiveTableView.class.getName();
    protected InteractiveTable treeComp = null;
    protected List<ColumnData> columnData = null;
    protected String[] columnNames = new String[]{InteractivePageLabels.INTERACTIVE_TABLE_TIME, InteractivePageLabels.INTERACTIVE_TABLE_TYPE, InteractivePageLabels.INTERACTIVE_TABLE_VALUE};
    protected int[] columnSizes;
    private int[] columnAlignment;
    protected boolean[] columnVisibility;
    protected int[] sortTypes;

    public InteractiveTableView(Composite parent, int style) {
        super(parent, style, true, true);
        int[] nArray = new int[3];
        nArray[0] = 200;
        nArray[1] = 150;
        this.columnSizes = nArray;
        this.columnAlignment = new int[]{16384, 131072, 16384};
        this.columnVisibility = new boolean[]{true, true, true};
        int[] nArray2 = new int[4];
        nArray2[0] = 3;
        nArray2[1] = 1;
        this.sortTypes = nArray2;
        this.setLayout((Layout)new FillLayout());
        this.setTitle(InteractivePageLabels.INTERACTIVE_TABLE_VIEW_TITLE);
        Composite contents = this.getContentArea();
        contents.setBackground(ColorResources.WINDOW_BG_COLOR);
        contents.setLayout((Layout)new FillLayout());
        this.treeComp = new InteractiveTable(contents, 0, 2818);
        this.treeComp.setTree(true);
        this.treeComp.setSortTypes(this.sortTypes);
        this.treeComp.setColumnAlignment(this.columnAlignment);
        this.treeComp.setColumns(this.columnNames);
        this.treeComp.setColumnSize(this.columnSizes);
        this.treeComp.setColumnVisibility(this.columnVisibility);
        this.treeComp.setTableToolTipEnable(false);
        this.setTable(this.treeComp);
    }

    public void updateView() {
        this.treeComp.updateTree();
    }

    public void updateView(DAViewData data) {
        if (data instanceof DASelectionData) {
            DASelectionData selData = (DASelectionData)data;
            long start = selData.getStartTime();
            long end = selData.getEndTime();
            if (data.getData() instanceof InteractiveInfo) {
                this.setTitle(((InteractiveInfo)data.getData()).getDescription());
                this.treeComp.setInteractiveInfo((InteractiveInfo)data.getData());
                this.treeComp.updateTree(start, end);
            } else {
                this.treeComp.deselectAll();
            }
        }
    }

    public void clear() {
        this.treeComp.clear();
    }

    public Control getControl() {
        return this.treeComp;
    }
}

