/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.kernel;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.widgets.Composite;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.nl.KernelPageLabels;
import org.tizen.dynamicanalyzer.nl.TimelineChartLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.ui.common.PopupAnalysisMenuItemClickListener;
import org.tizen.dynamicanalyzer.ui.common.PopupClearMenuItemClickListener;
import org.tizen.dynamicanalyzer.ui.common.PopupEndMenuItemClickListener;
import org.tizen.dynamicanalyzer.ui.common.PopupFromSelectionMenuItemClickListener;
import org.tizen.dynamicanalyzer.ui.common.PopupStartMenuItemClickListener;
import org.tizen.dynamicanalyzer.ui.common.TimelineChartMouseEventListener;
import org.tizen.dynamicanalyzer.ui.common.TimelineChartMouseTrackAdapter;
import org.tizen.dynamicanalyzer.ui.kernel.ContextSwitchingChartRenderer;
import org.tizen.dynamicanalyzer.ui.kernel.ContextSwitchingChartSeriesItem;
import org.tizen.dynamicanalyzer.ui.kernel.KernelPage;
import org.tizen.dynamicanalyzer.ui.kernel.data.ContextDataDBTable;
import org.tizen.dynamicanalyzer.ui.kernel.data.FunctionDataDBTable;
import org.tizen.dynamicanalyzer.ui.kernel.data.KernelDataMaker;
import org.tizen.dynamicanalyzer.ui.kernel.data.KernelDataManager;
import org.tizen.dynamicanalyzer.ui.kernel.data.KernelDataPerThread;
import org.tizen.dynamicanalyzer.ui.kernel.data.KernelDataPerThreadComparator;
import org.tizen.dynamicanalyzer.ui.kernel.data.KernelSelectionData;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.ui.widgets.DADefaultChartBoard;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlot;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotTooltip;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartRenderer;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeries;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeriesItem;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoard;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardHeightChangeableItem;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItemList;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenu;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenuItem;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenuListener;

public class ContextSwitchingChart
extends DADefaultChartBoard {
    public static final String KERNEL_CHART_DATA_TYPE = "kernel_data_type";
    private final KernelDataMaker dataMaker = KernelDataManager.getInstance().getDataMaker();
    private int savedSelectedPid = 0;

    public ContextSwitchingChart(Composite parent, String title) {
        super(parent, title);
    }

    public ContextSwitchingChart(Composite parent, String title, int[] scaleValues) {
        super(parent, title, scaleValues);
    }

    public ContextSwitchingChart(Composite parent, String title, int boardStyle) {
        super(parent, title, boardStyle);
    }

    protected void callBackScaleChanged() {
        this.updateChart();
        super.callBackScaleChanged();
    }

    protected void callBackScrollChanged() {
        this.updateChart();
        super.callBackScrollChanged();
    }

    protected void callBackSizeChanged() {
        this.layout(true, true);
        this.updateChart();
        super.callBackSizeChanged();
    }

    public void updateChart() {
        int tid;
        List<Object> idata;
        int i;
        List<KernelDataPerThread> threads = this.dataMaker.getThreadData();
        int thread_size = threads.size();
        boolean isDirty = false;
        int i2 = 0;
        while (i2 < thread_size) {
            DAChartSeries series;
            KernelDataPerThread kdata = threads.get(i2);
            DAChartBoardItem bitem = kdata.getContextChart();
            if (bitem == null) {
                DAChartBoardHeightChangeableItem coreItem = new DAChartBoardHeightChangeableItem((DAChartBoard)this, this.getChartName(kdata));
                this.initContextSwitchChart(coreItem, true);
                DAChart coreChart = coreItem.getChart();
                DAChartSeries coreSeries = new DAChartSeries(KernelPageLabels.CONTEXT_SWITCH_SERIES_NAME, -1, ColorResources.BLUE);
                coreChart.addSeries(coreSeries);
                coreItem.setData((Object)new KernelSelectionData(kdata, 1));
                kdata.setContextChart((DAChartBoardItem)coreItem);
                isDirty = true;
            } else {
                series = bitem.getChart().getSeries(0);
                if (series != null) {
                    series.clear();
                }
            }
            bitem = kdata.getFunctionChart();
            if (kdata.getFunclog() != null && bitem == null) {
                DAChartBoardHeightChangeableItem functionItem = new DAChartBoardHeightChangeableItem(kdata.getContextChart(), KernelPageLabels.CONTEXT_SWITCH_BOARD_NAME_FUNC_CHILD);
                this.initContextSwitchChart(functionItem, false);
                DAChart functionChart = functionItem.getChart();
                DAChartSeries functionSeries = new DAChartSeries(KernelPageLabels.CONTEXT_SWITCH_SERIES_NAME_CHILD, -1, ColorResources.RED);
                functionChart.addSeries(functionSeries);
                functionItem.setData((Object)new KernelSelectionData(kdata, 2));
                kdata.setFunctionChart((DAChartBoardItem)functionItem);
            } else if (bitem != null && (series = bitem.getChart().getSeries(0)) != null) {
                series.clear();
            }
            ++i2;
        }
        if (isDirty) {
            this.rearrangeChart();
        }
        int selectedPid = Toolbar.INSTANCE.getSelectedPid();
        if (isDirty || this.savedSelectedPid != selectedPid) {
            DAChartBoardItemList itemlist = this.getItemList();
            thread_size = itemlist.getItemSize();
            int i3 = 0;
            while (i3 < thread_size) {
                if (selectedPid != 0) {
                    DAChartBoardItem item = itemlist.get(i3);
                    KernelSelectionData seldata = (KernelSelectionData)item.getData();
                    if (seldata.getData().getPid() == selectedPid) {
                        this.showItem(i3);
                    } else {
                        this.hideItem(i3);
                    }
                } else {
                    this.showItem(i3);
                }
                ++i3;
            }
            this.savedSelectedPid = selectedPid;
        }
        long starttime = (long)(this.getVisibleStartTime() * 1000000.0);
        long endtime = (long)(this.getVisibleEndTime() * 1000000.0);
        List<List<Object>> contextData = this.dataMaker.getContextDataFromDB(starttime, endtime);
        List<List<Object>> functionData = this.dataMaker.getFunctionDataFromDB(starttime, endtime, -1);
        if (contextData != null) {
            int csize = contextData.size();
            i = 0;
            while (i < csize) {
                idata = contextData.get(i);
                tid = (Integer)idata.get(ContextDataDBTable.COLUMN.TID.index);
                int cpunum = (Integer)idata.get(ContextDataDBTable.COLUMN.CPUNUM.index);
                double contextStart = (double)((Long)idata.get(ContextDataDBTable.COLUMN.STARTTIME.index)).longValue() / 1000000.0;
                double contextEnd = (double)((Long)idata.get(ContextDataDBTable.COLUMN.ENDTIME.index)).longValue() / 1000000.0;
                DAChartBoardItem coreItem = this.findCoreBoardItem(threads, tid);
                assert (coreItem != null);
                DAChartSeries coreSeries = coreItem.getChart().getSeries(0);
                if (coreSeries != null) {
                    coreSeries.addSeriesItem((DAChartSeriesItem)new ContextSwitchingChartSeriesItem(String.valueOf(KernelPageLabels.CONTEXT_SWITCH_SERIES_ITEM_NAME) + " " + Integer.toString(cpunum), contextStart, contextEnd));
                }
                ++i;
            }
        }
        if (functionData != null) {
            int fsize = functionData.size();
            i = 0;
            while (i < fsize) {
                idata = functionData.get(i);
                tid = (Integer)idata.get(FunctionDataDBTable.COLUMN.TID.index);
                int funcId = (Integer)idata.get(FunctionDataDBTable.COLUMN.FUNCID.index);
                String funcname = Global.getFunctionName(funcId);
                double funcStart = (double)((Long)idata.get(FunctionDataDBTable.COLUMN.STARTTIME.index)).longValue() / 1000000.0;
                double funcEnd = (double)((Long)idata.get(FunctionDataDBTable.COLUMN.ENDTIME.index)).longValue() / 1000000.0;
                int type = (Integer)idata.get(FunctionDataDBTable.COLUMN.STARTTYPE.index) + (Integer)idata.get(FunctionDataDBTable.COLUMN.ENDTYPE.index);
                DAChartBoardItem functionItem = this.findFunctionBoardItem(threads, tid);
                assert (functionItem != null);
                DAChartSeries funcSeries = functionItem.getChart().getSeries(0);
                if (funcSeries != null) {
                    int style;
                    switch (type) {
                        case 21: 
                        case 31: {
                            style = 2;
                            break;
                        }
                        case 12: 
                        case 13: {
                            style = 3;
                            break;
                        }
                        case 22: 
                        case 23: 
                        case 32: 
                        case 33: {
                            style = 1;
                            break;
                        }
                        default: {
                            style = 0;
                        }
                    }
                    funcSeries.addSeriesItem((DAChartSeriesItem)new ContextSwitchingChartSeriesItem(funcname, funcStart, funcEnd, style));
                }
                ++i;
            }
        }
        this.redraw();
        this.update();
    }

    private String getChartName(KernelDataPerThread data) {
        String name = String.valueOf(KernelPageLabels.CONTEXT_SWITCH_BOARD_NAME_PID) + " " + data.getPid() + "\n" + KernelPageLabels.CONTEXT_SWITCH_BOARD_NAME_TID + " " + data.getTid();
        return name;
    }

    private DAChartBoardItem findCoreBoardItem(List<KernelDataPerThread> threads, int tid) {
        int size = threads.size();
        int i = 0;
        while (i < size) {
            if (threads.get(i).getTid() == tid) {
                return threads.get(i).getContextChart();
            }
            ++i;
        }
        return null;
    }

    private DAChartBoardItem findFunctionBoardItem(List<KernelDataPerThread> threads, int tid) {
        int size = threads.size();
        int i = 0;
        while (i < size) {
            if (threads.get(i).getTid() == tid) {
                return threads.get(i).getFunctionChart();
            }
            ++i;
        }
        return null;
    }

    private void rearrangeChart() {
        Map.Entry entry;
        DAChartBoardItemList itemList = this.getItemList();
        int listsize = itemList.getItemSize();
        TreeMap<KernelDataPerThread, Integer> sortedmap = new TreeMap<KernelDataPerThread, Integer>(new KernelDataPerThreadComparator());
        int i = 0;
        while (i < listsize) {
            DAChartBoardItem item = itemList.get(i);
            KernelDataPerThread gdata = ((KernelSelectionData)item.getData()).getData();
            sortedmap.put(gdata, i);
            ++i;
        }
        ArrayList<Integer> arranged = new ArrayList<Integer>();
        while ((entry = sortedmap.pollFirstEntry()) != null) {
            arranged.add((Integer)entry.getValue());
        }
        this.reArrangeItem(arranged.toArray(new Integer[listsize]));
    }

    private void initContextSwitchChart(DAChartBoardHeightChangeableItem chartItem, boolean isParent) {
        DAChart chart = chartItem.getChart();
        if (chart == null) {
            return;
        }
        DAChartPlot plot = chart.getPlot();
        if (plot == null) {
            return;
        }
        chartItem.useExpand(false);
        chartItem.setHeightRatio(1.0);
        chart.getPlot().setAutoHeightRange(DAChartPlot.AutoRangeType.MANUAL);
        chart.getPlot().setShowAxis(false);
        chart.setChartRenderer((DAChartRenderer)new ContextSwitchingChartRenderer());
        if (isParent) {
            plot.setBackgroundImage(ImageResources.BG_GRADIENT);
        } else {
            plot.setBackgroundImage(ImageResources.BG_CHILD_GRADIENT);
        }
        DAChartPlotTooltip tooltip = new DAChartPlotTooltip(-1.0);
        tooltip.setFont(FontResources.CHART_TOOLTIP_FONT);
        plot.setTooltip(tooltip);
        DAPopupMenu popupMenu = new DAPopupMenu((Composite)chart);
        popupMenu.setFont(FontResources.CONTEXT_MENU_ITEM_FONT);
        DAPopupMenuItem startItem = new DAPopupMenuItem(popupMenu, 0);
        startItem.setText(TimelineChartLabels.RANGE_CONTEXT_SET_START);
        startItem.addListener((DAPopupMenuListener)new PopupStartMenuItemClickListener(startItem, this));
        DAPopupMenuItem endItem = new DAPopupMenuItem(popupMenu, 0);
        endItem.setText(TimelineChartLabels.RANGE_CONTEXT_SET_END);
        endItem.addListener((DAPopupMenuListener)new PopupEndMenuItemClickListener(endItem, this));
        DAPopupMenuItem fromSelectionItem = new DAPopupMenuItem(popupMenu, 0);
        fromSelectionItem.setText(TimelineChartLabels.RANGE_CONTEXT_SET_FROM_SELECTION);
        fromSelectionItem.addListener((DAPopupMenuListener)new PopupFromSelectionMenuItemClickListener(fromSelectionItem, this));
        DAPopupMenuItem analysisItem = new DAPopupMenuItem(popupMenu, 0);
        analysisItem.setText(TimelineChartLabels.RANGE_CONTEXT_ANALYSIS);
        analysisItem.addListener((DAPopupMenuListener)new PopupAnalysisMenuItemClickListener());
        DAPopupMenuItem clearItem = new DAPopupMenuItem(popupMenu, 0);
        clearItem.setText(TimelineChartLabels.RANGE_CONTEXT_CLEAR);
        clearItem.addListener((DAPopupMenuListener)new PopupClearMenuItemClickListener());
        TimelineChartMouseEventListener timelineChartMouseEventListener = new TimelineChartMouseEventListener(popupMenu, this.getTimeline(), KernelPage.pageID);
        chart.addMouseListener((MouseListener)timelineChartMouseEventListener);
        chart.addMouseMoveListener((MouseMoveListener)timelineChartMouseEventListener);
        chart.addMouseTrackListener((MouseTrackListener)new TimelineChartMouseTrackAdapter(this.getTimeline()));
        plot.setMarkers(this.getMarkers());
    }
}

