/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory.chart;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.widgets.Composite;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.nl.MemoryPageLabels;
import org.tizen.dynamicanalyzer.nl.TimelineChartLabels;
import org.tizen.dynamicanalyzer.project.BinaryInfo;
import org.tizen.dynamicanalyzer.project.Project;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.setting.SettingDataManager;
import org.tizen.dynamicanalyzer.setting.TargetData;
import org.tizen.dynamicanalyzer.ui.common.PopupRangeAnalysisMenuItemOnChartListener;
import org.tizen.dynamicanalyzer.ui.common.TimeLineChartKeyListener;
import org.tizen.dynamicanalyzer.ui.common.TimelineChartMouseEventListener;
import org.tizen.dynamicanalyzer.ui.common.TimelineChartMouseTrackAdapter;
import org.tizen.dynamicanalyzer.ui.memory.MemoryPage;
import org.tizen.dynamicanalyzer.ui.memory.chart.HeapMemoryChart;
import org.tizen.dynamicanalyzer.ui.memory.chart.MemoryChart;
import org.tizen.dynamicanalyzer.ui.memory.chart.ProcessMemoryChart;
import org.tizen.dynamicanalyzer.ui.memory.chart.SystemMemoryChart;
import org.tizen.dynamicanalyzer.ui.memory.data.HeapDataManager;
import org.tizen.dynamicanalyzer.ui.memory.data.MemoryDataManager;
import org.tizen.dynamicanalyzer.ui.memory.data.ProcessMemoryDBTable;
import org.tizen.dynamicanalyzer.ui.page.MenuBar;
import org.tizen.dynamicanalyzer.ui.timeline.common.TimelineChartManager;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.ui.widgets.DADefaultChartBoard;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlot;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotIntervalMarker;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotMarker;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotTooltip;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartRenderer;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoard;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenu;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenuItem;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenuListener;

public class MemoryChartBoard
extends DADefaultChartBoard {
    private int allProcessPID = 0;
    private int preSelectedPID = -1;
    private Set<String> targetChartList = null;
    private List<List<Object>> persistentData = null;
    private boolean showPersistentSeries = false;
    private List<MemoryChart> memoryChartList = new ArrayList<MemoryChart>();

    public MemoryChartBoard(Composite parent, String title, int boardStyle) {
        super(parent, title, boardStyle);
        this.showPersistentSeries = MenuBar.getInstance().getPersistentAllocationsSelection();
    }

    public void initalizeChart() {
        this.initIntervalMarkers();
        this.initializeMemoryCharts();
    }

    public void showPersistentSeries(boolean show) {
        if (this.showPersistentSeries == show) {
            return;
        }
        this.showPersistentSeries = show;
        this.updateChartBoard();
    }

    public List<MemoryChart> getMemoryChartList() {
        return this.memoryChartList;
    }

    private void initializeMemoryCharts() {
        this.memoryChartList.clear();
        TargetData target = SettingDataManager.INSTANCE.getConnectedTargetOrSelected();
        this.targetChartList = SettingDataManager.INSTANCE.getSelectedChartSet(target.getTargetName());
        int i = 0;
        while (i < this.memoryChartList.size()) {
            MemoryChart memoryChart = this.memoryChartList.get(i);
            DAChartBoardItem item = memoryChart.createBoardItem(this);
            item.setHeight(80);
            DAChart chartWidget = item.getChart();
            chartWidget.getPlot().setAxisRangeX(this.getVisibleStartTime(), this.getVisibleEndTime());
            chartWidget.getPlot().setMarkers(this.getMarkers());
            TimelineChartMouseEventListener chartMouseEventListener = new TimelineChartMouseEventListener(memoryChart.getPopupMenu(), this.getTimeline(), MemoryPage.pageID);
            chartWidget.addMouseListener((MouseListener)chartMouseEventListener);
            chartWidget.addMouseMoveListener((MouseMoveListener)chartMouseEventListener);
            chartWidget.addMouseTrackListener((MouseTrackListener)new TimelineChartMouseTrackAdapter(this.getTimeline()));
            TimeLineChartKeyListener timelineKeyListener = new TimeLineChartKeyListener(this);
            chartWidget.addKeyListener((KeyListener)timelineKeyListener);
            ++i;
        }
    }

    private void initIntervalMarkers() {
        DAChartPlotIntervalMarker selectionMarker = new DAChartPlotIntervalMarker(-1.0, -1.0, 1);
        selectionMarker.setBackgroundColor(ColorResources.SELECTION_RANGE);
        selectionMarker.setAlpha(63);
        this.addIntervalMarker((DAChartPlotMarker)selectionMarker);
        DAChartPlotIntervalMarker rangeAnalyzeMarker = new DAChartPlotIntervalMarker(-1.0, -1.0, 1);
        rangeAnalyzeMarker.setBackgroundColor(ColorResources.YELLOW);
        rangeAnalyzeMarker.setAlpha(63);
        this.addIntervalMarker((DAChartPlotMarker)rangeAnalyzeMarker);
        DAChartPlotIntervalMarker rangeMarker = new DAChartPlotIntervalMarker(-1.0, -1.0, 0);
        rangeMarker.setForegroundColor(ColorResources.RED);
        rangeMarker.setAlpha(63);
        this.addIntervalMarker((DAChartPlotMarker)rangeMarker);
    }

    public void updateChartBoard() {
        this.createChartItem();
        this.clearSeries();
        this.updateSeries();
        this.chartFilteringByPID();
    }

    private void createChartItem() {
        Object[] pidList;
        boolean processMemChartEnable = false;
        long startTime = AnalyzerUtil.translateSecToMicroSec(this.getVisibleStartTime());
        long endTime = AnalyzerUtil.translateSecToMicroSec(this.getVisibleEndTime());
        String pidliststring = this.getTargetPIDString();
        List<String> selectedChartByFile = TimelineChartManager.getInstance().getSelectedChartListByFile();
        if (selectedChartByFile.contains(TimelineChartLabels.SYSTEM_MEMORY_CHART_TITLE)) {
            this.targetChartList.add(TimelineChartLabels.SYSTEM_MEMORY_CHART_TITLE);
        }
        if (selectedChartByFile.contains(TimelineChartLabels.PROCESS_MEMORY_CHART_TITLE)) {
            this.targetChartList.add(TimelineChartLabels.PROCESS_MEMORY_CHART_TITLE);
        }
        if (this.targetChartList.contains(TimelineChartLabels.SYSTEM_MEMORY_CHART_TITLE) && !this.isExistSystemChart()) {
            this.addSystemChart();
        }
        if (this.targetChartList.contains(TimelineChartLabels.PROCESS_MEMORY_CHART_TITLE)) {
            processMemChartEnable = true;
        }
        Map<Integer, List<List<Object>>> allProcessDBData = MemoryDataManager.getInstance().getTargetProcessDataMapFromDB(startTime, endTime, pidliststring);
        Set<Integer> pidSet = allProcessDBData.keySet();
        Object[] objectArray = pidList = pidSet.toArray();
        int n = pidList.length;
        int n2 = 0;
        while (n2 < n) {
            Object oPid = objectArray[n2];
            int pid = (Integer)oPid;
            if (processMemChartEnable && !this.isExistProcessChart(pid)) {
                this.addProcessChartItemList(pid);
            }
            List<List<Object>> targetProcessDBData = allProcessDBData.get(pid);
            ArrayList<Integer> libIDSet = new ArrayList<Integer>();
            for (List<Object> targetProcessDBDataBy1Sec : targetProcessDBData) {
                Object tmp = targetProcessDBDataBy1Sec.get(ProcessMemoryDBTable.COLUMN.HEAP_ALLOCATION_BINARY_ID.index);
                List tmplibIDList = (List)tmp;
                for (Object oLibID : tmplibIDList) {
                    libIDSet.add((Integer)oLibID);
                }
            }
            for (Integer libId : libIDSet) {
                if (this.isExistHeapChart(pid, libId)) continue;
                this.addHeapChartItemList(pid, libId);
            }
            ++n2;
        }
    }

    private String getLibNameByID(int id) {
        if (id == -10) {
            return MemoryPageLabels.MEMORY_MAIN_EXCUTABLE;
        }
        Project project = Global.getProject();
        BinaryInfo binaryInfo = project.getDeviceStatusInfo().getBinaryInfo(id);
        if (binaryInfo == null) {
            return "unknown";
        }
        return binaryInfo.getTargetBinaryPath();
    }

    private boolean isExistSystemChart() {
        for (MemoryChart chart : this.memoryChartList) {
            if (!(chart instanceof SystemMemoryChart)) continue;
            return true;
        }
        return false;
    }

    private boolean isExistProcessChart(int pid) {
        for (MemoryChart chart : this.memoryChartList) {
            if (!(chart instanceof ProcessMemoryChart) || chart.getPid() != pid) continue;
            return true;
        }
        return false;
    }

    private boolean isExistHeapChart(int pid, int libId) {
        String libName = this.getLibNameByID(libId);
        for (MemoryChart chart : this.memoryChartList) {
            HeapMemoryChart heapChart;
            if (!(chart instanceof HeapMemoryChart) || (heapChart = (HeapMemoryChart)chart).getPid() != pid || !heapChart.getLibName().equals(libName)) continue;
            return true;
        }
        return false;
    }

    private void addSystemChart() {
        String chartName = MemoryPageLabels.MEMORY_CHART_SYSTEM_MEMORY;
        DAChartBoardItem parentItem = new DAChartBoardItem((DAChartBoard)this, chartName, ImageResources.FEATURE_MEM_SYSTEM_SMALL_NOR, 0);
        DAChart parentDAChart = parentItem.getChart();
        SystemMemoryChart chart = new SystemMemoryChart(MemoryPage.pageID, chartName, parentItem, parentDAChart);
        this.initMemoryChart(chart);
        chart.setChartStyle();
        chart.chart.getPlot().setAxisUnit("B");
        chart.chart.getPlot().setAxisUnitType(DAChartPlot.UnitType.BINARY);
        chart.chart.getPlot().setShowAxis(true);
        this.memoryChartList.add(chart);
    }

    private void addProcessChartItemList(int pid) {
        String chartName = MemoryPageLabels.MEMORY_CHART_PROCESS_MEMORY;
        DAChartBoardItem parentItem = new DAChartBoardItem((DAChartBoard)this, chartName, ImageResources.FEATURE_MEM_PROCESS_SMALL_NOR, 0);
        parentItem.useExpand(true);
        DAChart parentDAChart = parentItem.getChart();
        ProcessMemoryChart processMemoryChart = new ProcessMemoryChart(MemoryPage.pageID, chartName, parentItem, parentDAChart);
        this.initMemoryChart(processMemoryChart);
        processMemoryChart.setPid(pid);
        processMemoryChart.setChartStyle();
        processMemoryChart.chart.getPlot().setAxisUnit("B");
        processMemoryChart.chart.getPlot().setAxisUnitType(DAChartPlot.UnitType.BINARY);
        processMemoryChart.chart.getPlot().setShowAxis(true);
        processMemoryChart.chart.setInformation(String.valueOf(AnalyzerUtil.getProcessName(pid)) + " / PID : " + pid);
        this.memoryChartList.add(processMemoryChart);
    }

    private void addHeapChartItemList(int pid, int libId) {
        if (libId == -10) {
            this.addHeapParentChartItemList(pid, libId);
        } else {
            MemoryChart parent = this.getParentHeapChart(pid, libId);
            if (parent != null) {
                this.addHeapChildChartItemList(parent, pid, libId);
            }
        }
    }

    private MemoryChart getParentHeapChart(int pid, int libId) {
        for (MemoryChart chart : this.memoryChartList) {
            if (!(chart instanceof HeapMemoryChart) || chart.getPid() != pid || ((HeapMemoryChart)chart).getLibId() != -10) continue;
            return chart;
        }
        return null;
    }

    private void addHeapParentChartItemList(int pid, int libId) {
        String chartName = MemoryPageLabels.MEMORY_CHART_HEAP_MEMORY;
        DAChartBoardItem parentItem = new DAChartBoardItem((DAChartBoard)this, chartName, ImageResources.FEATURE_HEAPALLOC_SMALL_NOR, 0);
        DAChart parentDAChart = parentItem.getChart();
        String libName = this.getLibNameByID(libId);
        HeapMemoryChart parentHeapMemoryChart = new HeapMemoryChart(MemoryPage.pageID, chartName, libId, libName, parentItem, parentDAChart);
        this.initMemoryChart(parentHeapMemoryChart);
        parentHeapMemoryChart.setPid(pid);
        parentHeapMemoryChart.setChartStyle();
        parentHeapMemoryChart.chart.getPlot().setAxisUnit("B");
        parentHeapMemoryChart.chart.getPlot().setAxisUnitType(DAChartPlot.UnitType.BINARY);
        parentHeapMemoryChart.chart.getPlot().setShowAxis(true);
        parentHeapMemoryChart.chartBoardItem.useExpand(true);
        parentHeapMemoryChart.chart.setInformation(String.valueOf(AnalyzerUtil.getProcessName(pid)) + " / PID : " + pid);
        this.memoryChartList.add(parentHeapMemoryChart);
    }

    private void addHeapChildChartItemList(MemoryChart parent, int pid, int libId) {
        String libName = this.getLibNameByID(libId);
        String chartName = this.getChartName(libName);
        DAChartBoardItem parentItem = parent.getChartItem();
        DAChartBoardItem childItem = new DAChartBoardItem(parentItem, chartName);
        DAChart childDAChart = childItem.getChart();
        HeapMemoryChart childHeapMemoryChart = new HeapMemoryChart(MemoryPage.pageID, chartName, libId, libName, childItem, childDAChart);
        this.initMemoryChart(childHeapMemoryChart);
        childHeapMemoryChart.setPid(pid);
        childHeapMemoryChart.setChartStyle();
        childHeapMemoryChart.chart.getPlot().setAxisUnit("B");
        childHeapMemoryChart.chart.getPlot().setAxisUnitType(DAChartPlot.UnitType.BINARY);
        childHeapMemoryChart.chart.getPlot().setShowAxis(true);
        childHeapMemoryChart.chartBoardItem.useExpand(false);
        childHeapMemoryChart.chart.setInformation(String.valueOf(AnalyzerUtil.getProcessName(pid)) + " / PID : " + pid);
        parent.pushChild(childHeapMemoryChart);
        this.memoryChartList.add(childHeapMemoryChart);
    }

    public String getChartName(String libPath) {
        int index = libPath.lastIndexOf("/");
        if (index < 1) {
            return libPath;
        }
        return String.valueOf(libPath.substring(0, index)) + "\n" + libPath.substring(index + 1);
    }

    public MemoryChart getChart(DAChartBoardItem item) {
        for (MemoryChart chart : this.memoryChartList) {
            if (chart.getChartItem() != item) continue;
            return chart;
        }
        return null;
    }

    private void initMemoryChart(MemoryChart chart) {
        if (chart == null) {
            return;
        }
        chart.getChart().setChartRenderer(new DAChartRenderer());
        DAChartPlot plot = chart.getChart().getPlot();
        if (plot == null) {
            return;
        }
        plot.setBackgroundImage(ImageResources.BG_GRADIENT);
        plot.setAxisFont(FontResources.CHART_AXIS_FONT);
        plot.setAxisRangeX(this.getVisibleStartTime(), this.getVisibleEndTime());
        DAChartPlotTooltip tooltip = new DAChartPlotTooltip(-1.0);
        tooltip.setFont(FontResources.CHART_TOOLTIP_FONT);
        plot.setTooltip(tooltip);
        MemoryChart tmp = chart;
        DAPopupMenu popupMenu = new DAPopupMenu((Composite)chart.getChart());
        popupMenu.setFont(FontResources.CONTEXT_MENU_ITEM_FONT);
        DAPopupMenuItem analysisItem = new DAPopupMenuItem(popupMenu);
        analysisItem.setText(TimelineChartLabels.RANGE_CONTEXT_ANALYSIS);
        analysisItem.addListener((DAPopupMenuListener)new PopupRangeAnalysisMenuItemOnChartListener(analysisItem, this, tmp.getChart()));
        chart.popupMenu = popupMenu;
        TimelineChartMouseEventListener memoryChartMouseEventListener = new TimelineChartMouseEventListener(chart.getPopupMenu(), this.getTimeline(), MemoryPage.pageID);
        chart.getChart().addMouseListener((MouseListener)memoryChartMouseEventListener);
        chart.getChart().addMouseMoveListener((MouseMoveListener)memoryChartMouseEventListener);
        chart.getChart().addMouseTrackListener((MouseTrackListener)new TimelineChartMouseTrackAdapter(this.getTimeline()));
        TimeLineChartKeyListener timelineKeyListener = new TimeLineChartKeyListener(this);
        chart.getChart().addKeyListener((KeyListener)timelineKeyListener);
        plot.setMarkers(this.getMarkers());
    }

    private void clearSeries() {
        if (this.memoryChartList == null) {
            return;
        }
        for (MemoryChart chart : this.memoryChartList) {
            chart.clearSeries();
        }
    }

    private void updateSeries() {
        if (this.memoryChartList == null) {
            return;
        }
        long start = 0L;
        long end = 0L;
        int targetPID = Toolbar.INSTANCE != null && Toolbar.INSTANCE.getSelectedPid() != 0 ? Toolbar.INSTANCE.getSelectedPid() : this.allProcessPID;
        List<List<Object>> systemDBData = MemoryDataManager.getInstance().getSystemDataFromDB(start, end);
        Map<Integer, List<List<Object>>> targetProcessDBData = MemoryDataManager.getInstance().getTargetProcessDataMapFromDB(start, end, targetPID);
        for (MemoryChart chart : this.memoryChartList) {
            ArrayList<Object> dataList = new ArrayList<Object>();
            dataList.add(systemDBData);
            dataList.add(targetProcessDBData);
            chart.inputChartSeries(dataList);
            if (!(chart instanceof HeapMemoryChart)) continue;
            HeapMemoryChart heapChart = (HeapMemoryChart)chart;
            heapChart.chart.getPlot().setAxisRangeY(0.0, this.getNormalizedHeight(targetProcessDBData));
            if (!DAState.isRunning() && this.showPersistentSeries) {
                if (this.persistentData == null) {
                    this.persistentData = HeapDataManager.getInstance().remainedAllocatedListForRange(start, end, false);
                }
                heapChart.showPersistentSeries();
                heapChart.updatePersistentSeries(this.persistentData);
                continue;
            }
            heapChart.hidePersistentSeries();
            this.persistentData = null;
        }
    }

    private double getNormalizedHeight(Map<Integer, List<List<Object>>> targetProcessDBData) {
        double max = 0.0;
        for (Integer pid : targetProcessDBData.keySet()) {
            List<List<Object>> processData = targetProcessDBData.get(pid);
            int i = 0;
            while (i < processData.size()) {
                List<Object> row = processData.get(i);
                List libByteList = (List)row.get(ProcessMemoryDBTable.COLUMN.HEAP_ALLOCATION_BYTE.index);
                for (Long libByte : libByteList) {
                    if (!(max < (double)libByte.longValue())) continue;
                    max = libByte.longValue();
                }
                ++i;
            }
        }
        return max * 1.1;
    }

    private void chartFilteringByPID() {
        if (this.getItemList() == null) {
            return;
        }
        int selectedPid = Toolbar.INSTANCE.getSelectedPid();
        if (this.preSelectedPID == selectedPid) {
            return;
        }
        for (MemoryChart chart : this.memoryChartList) {
            if (chart instanceof SystemMemoryChart) continue;
            if (selectedPid == this.allProcessPID || chart.getPid() == selectedPid) {
                chart.chartBoardItem.setHeight(80);
                continue;
            }
            chart.chartBoardItem.setHeight(0);
        }
        this.preSelectedPID = selectedPid;
    }

    private String getTargetPIDString() {
        ArrayList<Integer> pidlist = new ArrayList<Integer>();
        if (Global.getProject() == null) {
            return "(0)";
        }
        int[] pids = Global.getProject().getProcessIDs();
        int targetPID = Toolbar.INSTANCE.getSelectedPid();
        if (targetPID > 0) {
            pidlist.add(targetPID);
        } else {
            int i = 0;
            while (i < pids.length) {
                pidlist.add(pids[i]);
                ++i;
            }
        }
        String pidliststring = "(";
        int i = 0;
        while (i < pidlist.size()) {
            pidliststring = String.valueOf(pidliststring) + Integer.toString((Integer)pidlist.get(i));
            if (i != pidlist.size() - 1) {
                pidliststring = String.valueOf(pidliststring) + ", ";
            }
            ++i;
        }
        pidliststring = String.valueOf(pidliststring) + ")";
        return pidliststring;
    }
}

