/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.timeline;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.util.Logger;

public class SystemDataDBTable
extends DBTable {
    private static final String TABLENAME = "TIMELINE_SYSTEM_DATA";
    public static final String SAMPLING_TIME = "SAMPLING_TIME";
    public static final String CPU_LOAD_TOTAL = "CPU_LOAD_TOTAL";
    public static final String PROCESS_COUNT_OTHER = "PROCESS_COUNT_OTHER";
    public static final String PROCESS_COUNT_TARGET = "PROCESS_COUNT_TARGET";
    public static final String MEMORY_USAGE_SYSTEM = "MEMORY_USAGE_SYSTEM";
    public static final String NETWORK_SIZE_SEND = "NETWORK_SIZE_SEND";
    public static final String NETWORK_SIZE_RECEIVE = "NETWORK_SIZE_RECEIVE";
    public static final String DISK_TOTAL_USAGE = "DISK_TOTAL_USAGE";
    public static final String DISK_IO_READ_SIZE = "DISK_IO_READ_SIZE";
    public static final String DISK_IO_READ_SECTOR = "DISK_IO_READ_SECTOR";
    public static final String DISK_IO_WRITE_SIZE = "DISK_IO_WRITE_SIZE";
    public static final String DISK_IO_WRITE_SECTOR = "DISK_IO_WRITE_SECTOR";
    public static final String ENERGY_USAGE = "ENERGY_USAGE";
    public static final String ENERGY_USAGE_DEVICE = "ENERGY_USAGE_DEVICE";
    public static final String ENERGY_USAGE_APP = "ENERGY_USAGE_APP";
    public static final String CPU_LOAD = "CPU_LOAD";
    public static final String CPU_FREQUENCY = "CPU_FREQUENCY";
    public static final String PROCESS_PID_OTHER = "PROCESS_PID_OTHER";
    public static final String PROCESS_LOAD_OTHER = "PROCESS_LOAD_OTHER";
    public static final String DEVICE_STATUS = "DEVICE_STATUS";

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    public SystemDataDBTable() {
        this.addColumn(new DBColumn(SAMPLING_TIME, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(CPU_LOAD_TOTAL, "", "FLOAT"));
        this.addColumn(new DBColumn(PROCESS_COUNT_OTHER, "", "INTEGER"));
        this.addColumn(new DBColumn(PROCESS_COUNT_TARGET, "", "INTEGER"));
        this.addColumn(new DBColumn(MEMORY_USAGE_SYSTEM, "", "BIGINT"));
        this.addColumn(new DBColumn(NETWORK_SIZE_SEND, "", "BIGINT"));
        this.addColumn(new DBColumn(NETWORK_SIZE_RECEIVE, "", "BIGINT"));
        this.addColumn(new DBColumn(DISK_TOTAL_USAGE, "", "BIGINT"));
        this.addColumn(new DBColumn(DISK_IO_READ_SIZE, "", "BIGINT"));
        this.addColumn(new DBColumn(DISK_IO_READ_SECTOR, "", "BIGINT"));
        this.addColumn(new DBColumn(DISK_IO_WRITE_SIZE, "", "BIGINT"));
        this.addColumn(new DBColumn(DISK_IO_WRITE_SECTOR, "", "BIGINT"));
        this.addColumn(new DBColumn(ENERGY_USAGE, "", "BIGINT"));
        this.addColumn(new DBColumn(ENERGY_USAGE_DEVICE, "", "BIGINT ARRAY"));
        this.addColumn(new DBColumn(ENERGY_USAGE_APP, "", "BIGINT ARRAY"));
        this.addColumn(new DBColumn(CPU_LOAD, "", "DOUBLE ARRAY"));
        this.addColumn(new DBColumn(CPU_FREQUENCY, "", "DOUBLE ARRAY"));
        this.addColumn(new DBColumn(PROCESS_PID_OTHER, "", "INTEGER ARRAY"));
        this.addColumn(new DBColumn(PROCESS_LOAD_OTHER, "", "DOUBLE ARRAY"));
        this.addColumn(new DBColumn(DEVICE_STATUS, "", "INTEGER ARRAY"));
        this.setIndexColumn(COLUMN.SAMPLING_TIME.ordinal());
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                int index = 1;
                prep.setLong(index++, (Long)rowData.get(COLUMN.SAMPLING_TIME.ordinal()));
                prep.setFloat(index++, ((Float)rowData.get(COLUMN.CPU_LOAD_TOTAL.ordinal())).floatValue());
                prep.setInt(index++, (Integer)rowData.get(COLUMN.PROCESS_COUNT_OTHER.ordinal()));
                prep.setInt(index++, (Integer)rowData.get(COLUMN.PROCESS_COUNT_TARGET.ordinal()));
                prep.setLong(index++, (Long)rowData.get(COLUMN.MEMORY_USAGE_SYSTEM.ordinal()));
                prep.setLong(index++, (Long)rowData.get(COLUMN.NETWORK_SIZE_SEND.ordinal()));
                prep.setLong(index++, (Long)rowData.get(COLUMN.NETWORK_SIZE_RECEIVE.ordinal()));
                prep.setLong(index++, (Long)rowData.get(COLUMN.DISK_TOTAL_USAGE.ordinal()));
                prep.setLong(index++, (Long)rowData.get(COLUMN.DISK_IO_READ_OP_COUNT.ordinal()));
                prep.setLong(index++, (Long)rowData.get(COLUMN.DISK_IO_READ_BYTE_SIZE.ordinal()));
                prep.setLong(index++, (Long)rowData.get(COLUMN.DISK_IO_WRITE_OP_COUNT.ordinal()));
                prep.setLong(index++, (Long)rowData.get(COLUMN.DISK_IO_WRITE_BYTE_SIZE.ordinal()));
                prep.setLong(index++, (Long)rowData.get(COLUMN.ENERGY_USAGE.ordinal()));
                this.setArrayToPreparedStatement(COLUMN.ENERGY_USAGE_DEVICE.ordinal(), "BIGINT", prep, rowData);
                this.setArrayToPreparedStatement(COLUMN.ENERGY_USAGE_APP.ordinal(), "BIGINT", prep, rowData);
                this.setArrayToPreparedStatement(COLUMN.CPU_LOAD.ordinal(), "FLOAT", prep, rowData);
                this.setArrayToPreparedStatement(COLUMN.CPU_FREQUENCY.ordinal(), "FLOAT", prep, rowData);
                this.setArrayToPreparedStatement(COLUMN.PROCESS_PID_OTHER.ordinal(), "INTEGER", prep, rowData);
                this.setArrayToPreparedStatement(COLUMN.PROCESS_LOAD_OTHER.ordinal(), "FLOAT", prep, rowData);
                this.setArrayToPreparedStatement(COLUMN.DEVICE_STATUS.ordinal(), "INTEGER", prep, rowData);
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }

    @Override
    public List<Object> extractDataFromResultSet(ResultSet rs) {
        ArrayList<Object> row = new ArrayList<Object>();
        try {
            row.add(rs.getLong(1));
            row.add(Float.valueOf(rs.getFloat(2)));
            row.add(rs.getInt(3));
            row.add(rs.getInt(4));
            row.add(rs.getLong(5));
            row.add(rs.getLong(6));
            row.add(rs.getLong(7));
            row.add(rs.getLong(8));
            row.add(rs.getLong(9));
            row.add(rs.getLong(10));
            row.add(rs.getLong(11));
            row.add(rs.getLong(12));
            row.add(rs.getLong(13));
            row.add(this.getArrayFromResultSet(rs, 14, 0L));
            row.add(this.getArrayFromResultSet(rs, 15, 0L));
            row.add(this.getArrayFromResultSet(rs, 16, Float.valueOf(0.0f)));
            row.add(this.getArrayFromResultSet(rs, 17, Float.valueOf(0.0f)));
            row.add(this.getArrayFromResultSet(rs, 18, 0));
            row.add(this.getArrayFromResultSet(rs, 19, Float.valueOf(0.0f)));
            row.add(this.getArrayFromResultSet(rs, 20, 0));
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
            return null;
        }
        return row;
    }

    public static enum COLUMN {
        SAMPLING_TIME,
        CPU_LOAD_TOTAL,
        PROCESS_COUNT_OTHER,
        PROCESS_COUNT_TARGET,
        MEMORY_USAGE_SYSTEM,
        NETWORK_SIZE_SEND,
        NETWORK_SIZE_RECEIVE,
        DISK_TOTAL_USAGE,
        DISK_IO_READ_OP_COUNT,
        DISK_IO_READ_BYTE_SIZE,
        DISK_IO_WRITE_OP_COUNT,
        DISK_IO_WRITE_BYTE_SIZE,
        ENERGY_USAGE,
        ENERGY_USAGE_DEVICE,
        ENERGY_USAGE_APP,
        CPU_LOAD,
        CPU_FREQUENCY,
        PROCESS_PID_OTHER,
        PROCESS_LOAD_OTHER,
        DEVICE_STATUS;

    }
}

