/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.timeline.common;

import java.util.List;
import java.util.Set;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.nl.TimelineChartLabels;
import org.tizen.dynamicanalyzer.project.ProcessInformation;
import org.tizen.dynamicanalyzer.project.ProcessMemoryMap;
import org.tizen.dynamicanalyzer.project.Project;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.setting.UILayoutDataManager;
import org.tizen.dynamicanalyzer.ui.common.TimeLineChartKeyListener;
import org.tizen.dynamicanalyzer.ui.common.TimelineChartMouseEventListener;
import org.tizen.dynamicanalyzer.ui.common.TimelineChartMouseTrackAdapter;
import org.tizen.dynamicanalyzer.ui.page.BaseView;
import org.tizen.dynamicanalyzer.ui.range.RangeDataManager;
import org.tizen.dynamicanalyzer.ui.timeline.TimelinePage;
import org.tizen.dynamicanalyzer.ui.timeline.chart.TimelineChart;
import org.tizen.dynamicanalyzer.ui.timeline.common.TimelineChartManager;
import org.tizen.dynamicanalyzer.ui.timeline.logparser.LifecycleLogParser;
import org.tizen.dynamicanalyzer.ui.toolbar.DAToolBarCustomCombo;
import org.tizen.dynamicanalyzer.ui.toolbar.ToolBarComboListener;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.ui.widgets.DADefaultChartBoard;
import org.tizen.dynamicanalyzer.util.WorkbenchUtil;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonRenderer;
import org.tizen.dynamicanalyzer.widgets.button.IDACustomButtonRenderer;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotIntervalMarker;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotMarker;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoard;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;
import org.tizen.dynamicanalyzer.widgets.chartBoard.IDAChartSeriesMaker;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;
import org.tizen.dynamicanalyzer.widgets.scale.DAScaleSelectionListener;
import org.tizen.dynamicanalyzer.widgets.timeline.DATimeline;

public class TimelineChartView
extends DAViewComposite {
    private final DAChartBoard chartBoard;
    private DAToolBarCustomCombo processCombo;
    private final TimelineChartManager timelineChartManager = TimelineChartManager.getInstance();
    private final RangeDataManager rangeDataManager = RangeDataManager.getInstance();
    private final LifecycleLogParser lifecycleLogParser = LifecycleLogParser.getInstance();

    public TimelineChartView(Composite parent, int style) {
        super(parent, style, false);
        this.setLayout((Layout)new FillLayout());
        AnalyzerUtil.setLatestTraceMode(TimelinePage.pageID, true);
        Composite contents = this.getContentArea();
        contents.setBackground(ColorResources.WHITE);
        this.chartBoard = new DADefaultChartBoard(contents, "Timeline");
        this.chartBoard.setChartSeriesMaker((IDAChartSeriesMaker)this.timelineChartManager);
        this.chartBoard.setNameFont(FontResources.CHART_NAME_FONT);
        this.timelineChartManager.setChartTimelineChartBoard(this.chartBoard);
        this.chartBoard.setSelectable(false);
        ScrollBar hScrollBar = this.chartBoard.getHScrollBar();
        hScrollBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TimelineChartView.this.chartBoard.isMaximumScrolled()) {
                    AnalyzerUtil.setLatestTraceMode(TimelinePage.pageID, true);
                } else {
                    AnalyzerUtil.setLatestTraceMode(TimelinePage.pageID, false);
                }
            }
        });
        StackLayout stackLayout = new StackLayout();
        stackLayout.topControl = this.chartBoard;
        contents.setLayout((Layout)stackLayout);
        this.initializeCharts();
        this.setBackground(ColorResources.WHITE);
        DATimeline timeline = this.chartBoard.getTimeline();
        this.lifecycleLogParser.registerLifecycleBar(this.chartBoard.getLifecycleBar());
        this.lifecycleLogParser.registerTimeline(timeline);
        AnalyzerUtil.setTimelineComposite(this);
        timeline.setTimeTickFont(FontResources.TIMELINE_TICK_FONT);
        timeline.setTimeBalloonFont(FontResources.TIMELINE_BALLOON_FONT);
        this.processCombo = this.makeDACustomCombo(this.chartBoard.getTitleComp());
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.width = 190;
        data.height = 20;
        this.processCombo.setLayoutData(data);
        this.initProcessCombo();
        this.updateScale();
        this.chartBoard.getScale().addSelectionListener(new DAScaleSelectionListener(){

            public void widgetSelected() {
                Toolbar.INSTANCE.setScaleSelection(TimelineChartView.this.chartBoard.getScale().getSelection());
                TimelineChartView.this.updateScale();
            }
        });
        this.chartBoard.getListComposite().addListener(37, new Listener(){

            public void handleEvent(Event event) {
                Toolbar.INSTANCE.setScaleSelection(TimelineChartView.this.chartBoard.getScale().getSelection());
            }
        });
    }

    private DAToolBarCustomCombo makeDACustomCombo(Composite parent) {
        int PROCESS_COMBO = 2;
        DAToolBarCustomCombo returnCombo = new DAToolBarCustomCombo(parent, 0);
        returnCombo.setComboGradation(ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE);
        returnCombo.setOutlineColors(ColorResources.GRAY_130, ColorResources.GRAY_130, ColorResources.GRAY_130, ColorResources.GRAY_130);
        returnCombo.setComboImages(ImageResources.DROP_ARROW_DOWN_NOR, ImageResources.DROP_ARROW_DOWN_SEL, ImageResources.DROP_ARROW_DOWN_HOVER, ImageResources.DROP_ARROW_DOWN_DIM);
        returnCombo.setComboImagePoint(new Point(160, 9));
        returnCombo.setComboButtonColor(ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE, ColorResources.WHITE);
        returnCombo.setArrowOutlineColors(ColorResources.GRAY_220, ColorResources.GRAY_220, ColorResources.GRAY_220, ColorResources.GRAY_220);
        returnCombo.setButtonImages(ImageResources.COMBO_DROPDOWN_UP, ImageResources.COMBO_DROPDOWN_DOWN);
        returnCombo.setFontPoint(new Point(5, 5));
        returnCombo.setEnabled(true);
        returnCombo.setComboFont(FontResources.COMBO);
        returnCombo.setItemFont(FontResources.DROPDOWN);
        returnCombo.setFontColors(ColorResources.BLACK, ColorResources.BLACK, ColorResources.BLACK, ColorResources.GRAY_170);
        returnCombo.setButtonRenderer((IDACustomButtonRenderer)new DACustomButtonRenderer());
        returnCombo.setDeviceCombo(PROCESS_COMBO);
        return returnCombo;
    }

    public void initProcessCombo() {
        this.processCombo.initCombo();
        this.processCombo.add("All Processes");
        this.processCombo.select(0);
        this.processCombo.addSelectionListener(new ToolBarComboListener(){

            @Override
            public void selectionEvent(DAToolBarCustomCombo combo) {
                int i = 0;
                while (i < Toolbar.INSTANCE.getProcessCombo().getItems().size()) {
                    if (combo.getText().equals(Toolbar.INSTANCE.getProcessCombo().getItem(i))) {
                        Toolbar.INSTANCE.getProcessCombo().select(i);
                    }
                    ++i;
                }
                BaseView baseView = (BaseView)WorkbenchUtil.getViewPart((String)BaseView.ID);
                baseView.getTopComposite().updateView();
            }
        });
        this.processCombo.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Project project = Global.getProject();
                if (project == null) {
                    return;
                }
                TimelineChartView.this.processCombo.initCombo();
                TimelineChartView.this.processCombo.add("All Processes");
                Toolbar.INSTANCE.getProcessCombo().initCombo();
                Toolbar.INSTANCE.getProcessCombo().add("All Processes");
                int[] pids = project.getProcessIDs();
                int pcount = pids.length;
                int i = 0;
                while (i < pcount) {
                    ProcessMemoryMap map;
                    ProcessInformation process = project.getProcessInformation(pids[i]);
                    String binName = process.getProcessName();
                    if ((binName == null || binName.isEmpty()) && (map = process.getLastProcessMemoryMap()) != null) {
                        int bid = map.getMainbinary().getBinaryID();
                        String binPath = project.getDeviceStatusInfo().getBinaryInfo(bid).getTargetBinaryPath();
                        if (binPath != null && !binPath.isEmpty()) {
                            int index = binPath.lastIndexOf("/");
                            binName = binPath.substring(index + 1, binPath.length());
                        }
                    }
                    StringBuffer buffer = new StringBuffer();
                    buffer.append(process.getPid()).append(" : ");
                    buffer.append(binName);
                    TimelineChartView.this.processCombo.add(buffer.toString());
                    Toolbar.INSTANCE.getProcessCombo().add(buffer.toString());
                    ++i;
                }
            }
        });
    }

    private void addProcessListToProcessCombo() {
        Project project = Global.getProject();
        if (project == null) {
            return;
        }
        int[] pids = project.getProcessIDs();
        int pcount = pids.length;
        int i = 0;
        while (i < pcount) {
            ProcessMemoryMap map;
            ProcessInformation process = project.getProcessInformation(pids[i]);
            String binName = process.getProcessName();
            if ((binName == null || binName.isEmpty()) && (map = process.getLastProcessMemoryMap()) != null) {
                int bid = map.getMainbinary().getBinaryID();
                String binPath = project.getDeviceStatusInfo().getBinaryInfo(bid).getTargetBinaryPath();
                if (binPath != null && !binPath.isEmpty()) {
                    int index = binPath.lastIndexOf("/");
                    binName = binPath.substring(index + 1, binPath.length());
                }
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append(process.getPid()).append(" : ");
            buffer.append(binName);
            this.processCombo.add(buffer.toString());
            Toolbar.INSTANCE.getProcessCombo().add(buffer.toString());
            ++i;
        }
    }

    private void updateProcessCombo() {
        int index = Toolbar.INSTANCE.getProcessCombo().getSelectionIndex();
        if (index + 1 > this.processCombo.getItems().size()) {
            this.addProcessListToProcessCombo();
        }
        this.processCombo.select(index);
    }

    public void ScaleChanged(boolean zoom) {
        this.chartBoard.getScale().changeScale(zoom);
    }

    private void updateScale() {
        int scaleSelection = Toolbar.INSTANCE.getScaleSelection();
        this.chartBoard.getBoardManager().scaleChanged(scaleSelection);
        this.chartBoard.setScaleVal(scaleSelection);
    }

    public void reArrangeChart(List<Integer> order, List<Boolean> showInfo) {
        if (order != null) {
            this.chartBoard.reArrangeItem(order.toArray(new Integer[order.size()]));
        }
        int i = 0;
        while (i < showInfo.size()) {
            if (showInfo.get(i).booleanValue()) {
                this.chartBoard.showItem(i);
            } else {
                this.chartBoard.hideItem(i);
            }
            ++i;
        }
    }

    public void updateView(DAViewData data) {
        this.updateScale();
        this.updateProcessCombo();
        if (data instanceof DASelectionData) {
            DASelectionData selData = (DASelectionData)data;
            long start = selData.getStartTime();
            long end = selData.getEndTime();
            Double startTime = (double)start / 1000000.0;
            Double endTime = (double)end / 1000000.0;
            double middleTime = (startTime + endTime) / 2.0;
            if (startTime.equals(endTime)) {
                middleTime = startTime;
            }
            this.chartBoard.setVisibleMiddleTime(middleTime);
            DAChartPlotIntervalMarker intervalMarker = (DAChartPlotIntervalMarker)this.chartBoard.getMarkers().get(0);
            intervalMarker.setInterval(startTime.doubleValue(), endTime.doubleValue());
            this.timelineChartManager.makeChartSeries(AnalyzerUtil.translateSecToMicroSec(this.chartBoard.getVisibleStartTime()), AnalyzerUtil.translateSecToMicroSec(this.chartBoard.getVisibleEndTime()));
        }
    }

    public void updateView() {
        this.updateScale();
        this.updateProcessCombo();
        this.timelineChartManager.makeChartSeries(AnalyzerUtil.translateSecToMicroSec(this.chartBoard.getVisibleStartTime()), AnalyzerUtil.translateSecToMicroSec(this.chartBoard.getVisibleEndTime()));
        long time = Toolbar.INSTANCE.getTime();
        if (AnalyzerUtil.isLatestTraceMode(TimelinePage.pageID)) {
            DAChartPlotIntervalMarker intervalMarker = (DAChartPlotIntervalMarker)this.chartBoard.getMarkers().get(0);
            intervalMarker.setInterval((double)time / 1000000.0, (double)time / 1000000.0);
            this.chartBoard.updateVisibleStartTime();
            this.chartBoard.setTotalEndTime(time, true);
        } else {
            this.chartBoard.setTotalEndTime(time, false);
        }
        if (RangeDataManager.getInstance().isBeingAnalyzed()) {
            ((DAChartPlotIntervalMarker)this.chartBoard.getMarkers().get(1)).setInterval((double)this.rangeDataManager.getAnalysisStartTime() / 1000000.0, (double)this.rangeDataManager.getAnalysisEndTime() / 1000000.0);
        } else {
            ((DAChartPlotIntervalMarker)this.chartBoard.getMarkers().get(1)).setInterval(-1.0, -1.0);
        }
        ((DAChartPlotIntervalMarker)this.chartBoard.getMarkers().get(2)).setInterval((double)this.rangeDataManager.getMarkerStartTime() / 1000000.0, (double)this.rangeDataManager.getMarkerEndTime() / 1000000.0);
        this.timelineChartManager.addNewCustomChart();
    }

    public void clear() {
        this.chartBoard.contentsClear();
        this.chartBoard.clear();
        this.initializeCharts();
    }

    private void initializeCharts() {
        this.initIntervalMarkers(this.chartBoard);
        List<TimelineChart> chartList = this.timelineChartManager.getChartList();
        Set<String> selectedChartSet = UILayoutDataManager.INSTANCE.getSelectedChartSet();
        int i = 0;
        while (i < chartList.size()) {
            TimelineChart timelineChart = chartList.get(i);
            DAChartBoardItem item = timelineChart.createBoardItem(this.chartBoard);
            DAChart chartWidget = item.getChart();
            chartWidget.getPlot().setAxisRangeX(this.chartBoard.getVisibleStartTime(), this.chartBoard.getVisibleEndTime());
            chartWidget.getPlot().setMarkers(this.chartBoard.getMarkers());
            TimelineChartMouseEventListener timelineChartMouseEventListener = new TimelineChartMouseEventListener(timelineChart.getPopupMenu(), this.chartBoard.getTimeline(), TimelinePage.pageID);
            chartWidget.addMouseListener((MouseListener)timelineChartMouseEventListener);
            chartWidget.addMouseMoveListener((MouseMoveListener)timelineChartMouseEventListener);
            chartWidget.addMouseTrackListener((MouseTrackListener)new TimelineChartMouseTrackAdapter(this.chartBoard.getTimeline()));
            TimeLineChartKeyListener timelineKeyListener = new TimeLineChartKeyListener(this.chartBoard);
            chartWidget.addKeyListener((KeyListener)timelineKeyListener);
            if (selectedChartSet.contains(timelineChart.getChartName())) {
                this.chartBoard.showItem(i);
            } else {
                this.chartBoard.hideItem(i);
            }
            ++i;
        }
    }

    public void showScreenshotChart(boolean show) {
        List<TimelineChart> chartList = this.timelineChartManager.getChartList();
        int i = 0;
        while (i < chartList.size()) {
            TimelineChart timelineChart = chartList.get(i);
            if (timelineChart.getChartName().equals(TimelineChartLabels.SCREENSHOT_CHART_TITLE)) {
                if (show) {
                    this.chartBoard.showItem(i);
                    break;
                }
                this.chartBoard.hideItem(i);
                break;
            }
            ++i;
        }
    }

    public Control getControl() {
        return this.chartBoard;
    }

    private void initIntervalMarkers(DAChartBoard board) {
        DAChartPlotIntervalMarker selectionMarker = new DAChartPlotIntervalMarker(-1.0, -1.0, 1);
        selectionMarker.setBackgroundColor(ColorResources.SELECTION_RANGE);
        selectionMarker.setAlpha(63);
        board.addIntervalMarker((DAChartPlotMarker)selectionMarker);
        DAChartPlotIntervalMarker rangeAnalyzeMarker = new DAChartPlotIntervalMarker(-1.0, -1.0, 1);
        rangeAnalyzeMarker.setBackgroundColor(ColorResources.YELLOW);
        rangeAnalyzeMarker.setAlpha(63);
        board.addIntervalMarker((DAChartPlotMarker)rangeAnalyzeMarker);
        DAChartPlotIntervalMarker rangeMarker = new DAChartPlotIntervalMarker(-1.0, -1.0, 0);
        rangeMarker.setForegroundColor(ColorResources.SELECTION_LINE);
        rangeMarker.setAlpha(63);
        board.addIntervalMarker((DAChartPlotMarker)rangeMarker);
    }

    public void setRangeMarker(double starttime, double endtime) {
        ((DAChartPlotIntervalMarker)this.chartBoard.getMarkers().get(2)).setInterval(starttime, endtime);
    }

    public DAChartBoard getChartBoard() {
        if (this.chartBoard == null) {
            return null;
        }
        return this.chartBoard;
    }
}

