/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.token;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.cdt.core.parser.KeywordSetKey;
import org.eclipse.cdt.core.parser.ParserLanguage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeywordSets {
    private static final Set<String> EMPTY_TABLE = new HashSet<String>(0);
    private static final Set<String> NAMESPACE_ONLY_SET = new HashSet<String>(1);
    private static final Set<String> MACRO_ONLY;
    private static final Set<String> DECL_SPECIFIER_SEQUENCE_C;
    private static final Set<String> DECL_SPECIFIER_SEQUENCE_CPP;
    private static final Map<ParserLanguage, Set<String>> DECL_SPECIFIER_SEQUENCE_TABLE;
    private static final Set<String> DECLARATION_CPP;
    private static final Set<String> DECLARATION_C;
    private static final Map<ParserLanguage, Set<String>> DECLARATION_TABLE;
    private static final Set<String> EXPRESSION_C;
    private static final Set<String> EXPRESSION_CPP;
    private static final Map<ParserLanguage, Set<String>> EXPRESSION_TABLE;
    private static final Set<String> STATEMENT_C;
    private static final Set<String> STATEMENT_CPP;
    private static final Map<ParserLanguage, Set<String>> STATEMENT_TABLE;
    private static final Set<String> BASE_SPECIFIER_CPP;
    private static final Set<String> CLASS_MEMBER;
    private static final Set<String> POST_USING_CPP;
    private static final Set<String> FUNCTION_MODIFIER_C;
    private static final Set<String> FUNCTION_MODIFIER_CPP;
    private static final Map<ParserLanguage, Set<String>> FUNCTION_MODIFIER_TABLE;
    private static final Set<String> PP_DIRECTIVES_C;
    private static final Set<String> PP_DIRECTIVES_CPP;
    private static final Set<String> ALL_C;
    private static final Set<String> ALL_CPP;
    private static final Map<ParserLanguage, Set<String>> ALL_TABLE;
    private static final Set<String> KEYWORDS_CPP;
    private static Set<String> KEYWORDS_C;
    private static final Map<ParserLanguage, Set<String>> KEYWORDS_TABLE;
    private static final Set<String> TYPES_C;
    private static final Set<String> TYPES_CPP;
    private static Map<ParserLanguage, Set<String>> TYPES_TABLE;
    private static Map<ParserLanguage, Set<String>> PP_DIRECTIVES_TABLE;

    static {
        NAMESPACE_ONLY_SET.add("namespace");
        MACRO_ONLY = new HashSet<String>(1);
        MACRO_ONLY.add("defined()");
        DECL_SPECIFIER_SEQUENCE_C = new TreeSet<String>();
        DECL_SPECIFIER_SEQUENCE_C.add("inline");
        DECL_SPECIFIER_SEQUENCE_C.add("auto");
        DECL_SPECIFIER_SEQUENCE_C.add("register");
        DECL_SPECIFIER_SEQUENCE_C.add("static");
        DECL_SPECIFIER_SEQUENCE_C.add("extern");
        DECL_SPECIFIER_SEQUENCE_C.add("mutable");
        DECL_SPECIFIER_SEQUENCE_C.add("typedef");
        DECL_SPECIFIER_SEQUENCE_C.add("const");
        DECL_SPECIFIER_SEQUENCE_C.add("volatile");
        DECL_SPECIFIER_SEQUENCE_C.add("signed");
        DECL_SPECIFIER_SEQUENCE_C.add("unsigned");
        DECL_SPECIFIER_SEQUENCE_C.add("short");
        DECL_SPECIFIER_SEQUENCE_C.add("long");
        DECL_SPECIFIER_SEQUENCE_C.add("_Complex");
        DECL_SPECIFIER_SEQUENCE_C.add("_Imaginary");
        DECL_SPECIFIER_SEQUENCE_C.add("char");
        DECL_SPECIFIER_SEQUENCE_C.add("_Bool");
        DECL_SPECIFIER_SEQUENCE_C.add("int");
        DECL_SPECIFIER_SEQUENCE_C.add("float");
        DECL_SPECIFIER_SEQUENCE_C.add("double");
        DECL_SPECIFIER_SEQUENCE_C.add("void");
        DECL_SPECIFIER_SEQUENCE_C.add("struct");
        DECL_SPECIFIER_SEQUENCE_C.add("union");
        DECL_SPECIFIER_SEQUENCE_C.add("enum");
        DECL_SPECIFIER_SEQUENCE_CPP = new TreeSet<String>();
        DECL_SPECIFIER_SEQUENCE_CPP.addAll(DECL_SPECIFIER_SEQUENCE_C);
        DECL_SPECIFIER_SEQUENCE_CPP.remove("_Complex");
        DECL_SPECIFIER_SEQUENCE_CPP.remove("_Imaginary");
        DECL_SPECIFIER_SEQUENCE_CPP.remove("_Bool");
        DECL_SPECIFIER_SEQUENCE_CPP.add("wchar_t");
        DECL_SPECIFIER_SEQUENCE_CPP.add("char16_t");
        DECL_SPECIFIER_SEQUENCE_CPP.add("char32_t");
        DECL_SPECIFIER_SEQUENCE_CPP.add("virtual");
        DECL_SPECIFIER_SEQUENCE_CPP.add("mutable");
        DECL_SPECIFIER_SEQUENCE_CPP.add("explicit");
        DECL_SPECIFIER_SEQUENCE_CPP.add("friend");
        DECL_SPECIFIER_SEQUENCE_CPP.add("bool");
        DECL_SPECIFIER_SEQUENCE_CPP.add("typename");
        DECL_SPECIFIER_SEQUENCE_CPP.add("class");
        DECL_SPECIFIER_SEQUENCE_TABLE = new HashMap<ParserLanguage, Set<String>>();
        DECL_SPECIFIER_SEQUENCE_TABLE.put(ParserLanguage.CPP, DECL_SPECIFIER_SEQUENCE_CPP);
        DECL_SPECIFIER_SEQUENCE_TABLE.put(ParserLanguage.C, DECL_SPECIFIER_SEQUENCE_C);
        DECLARATION_CPP = new TreeSet<String>();
        DECLARATION_CPP.addAll(DECL_SPECIFIER_SEQUENCE_CPP);
        DECLARATION_CPP.add("asm");
        DECLARATION_CPP.add("template");
        DECLARATION_CPP.add("using");
        DECLARATION_CPP.add("namespace");
        DECLARATION_CPP.add("export");
        DECLARATION_CPP.add("static_assert");
        DECLARATION_C = new TreeSet<String>();
        DECLARATION_C.addAll(DECL_SPECIFIER_SEQUENCE_C);
        DECLARATION_C.add("asm");
        DECLARATION_TABLE = new HashMap<ParserLanguage, Set<String>>();
        DECLARATION_TABLE.put(ParserLanguage.CPP, DECLARATION_CPP);
        DECLARATION_TABLE.put(ParserLanguage.C, DECLARATION_C);
        EXPRESSION_C = new TreeSet<String>();
        EXPRESSION_C.add("char");
        EXPRESSION_C.add("short");
        EXPRESSION_C.add("int");
        EXPRESSION_C.add("long");
        EXPRESSION_C.add("signed");
        EXPRESSION_C.add("unsigned");
        EXPRESSION_C.add("float");
        EXPRESSION_C.add("double");
        EXPRESSION_C.add("sizeof");
        EXPRESSION_CPP = new TreeSet<String>(EXPRESSION_C);
        EXPRESSION_CPP.add("bool");
        EXPRESSION_CPP.add("char16_t");
        EXPRESSION_CPP.add("char32_t");
        EXPRESSION_CPP.add("wchar_t");
        EXPRESSION_CPP.add("new");
        EXPRESSION_CPP.add("delete");
        EXPRESSION_CPP.add("typename");
        EXPRESSION_CPP.add("dynamic_cast");
        EXPRESSION_CPP.add("static_cast");
        EXPRESSION_CPP.add("reinterpret_cast");
        EXPRESSION_CPP.add("const_cast");
        EXPRESSION_CPP.add("typeid");
        EXPRESSION_CPP.add("true");
        EXPRESSION_CPP.add("false");
        EXPRESSION_CPP.add("this");
        EXPRESSION_CPP.add("operator");
        EXPRESSION_CPP.add("throw");
        EXPRESSION_TABLE = new HashMap<ParserLanguage, Set<String>>();
        EXPRESSION_TABLE.put(ParserLanguage.CPP, EXPRESSION_CPP);
        EXPRESSION_TABLE.put(ParserLanguage.C, EXPRESSION_C);
        STATEMENT_C = new TreeSet<String>();
        STATEMENT_C.addAll(DECLARATION_C);
        STATEMENT_C.addAll(EXPRESSION_C);
        STATEMENT_C.add("for");
        STATEMENT_C.add("break");
        STATEMENT_C.add("case");
        STATEMENT_C.add("goto");
        STATEMENT_C.add("switch");
        STATEMENT_C.add("while");
        STATEMENT_C.add("if");
        STATEMENT_C.add("continue");
        STATEMENT_C.add("default");
        STATEMENT_C.add("return");
        STATEMENT_C.add("else");
        STATEMENT_C.add("do");
        STATEMENT_CPP = new TreeSet<String>(DECLARATION_CPP);
        STATEMENT_CPP.addAll(EXPRESSION_CPP);
        STATEMENT_CPP.add("try");
        STATEMENT_CPP.add("for");
        STATEMENT_CPP.add("break");
        STATEMENT_CPP.add("case");
        STATEMENT_CPP.add("catch");
        STATEMENT_CPP.add("goto");
        STATEMENT_CPP.add("switch");
        STATEMENT_CPP.add("while");
        STATEMENT_CPP.add("if");
        STATEMENT_CPP.add("continue");
        STATEMENT_CPP.add("default");
        STATEMENT_CPP.add("return");
        STATEMENT_CPP.add("else");
        STATEMENT_CPP.add("do");
        STATEMENT_TABLE = new HashMap<ParserLanguage, Set<String>>();
        STATEMENT_TABLE.put(ParserLanguage.CPP, STATEMENT_CPP);
        STATEMENT_TABLE.put(ParserLanguage.C, STATEMENT_C);
        BASE_SPECIFIER_CPP = new TreeSet<String>();
        BASE_SPECIFIER_CPP.add("public");
        BASE_SPECIFIER_CPP.add("protected");
        BASE_SPECIFIER_CPP.add("private");
        BASE_SPECIFIER_CPP.add("virtual");
        CLASS_MEMBER = new TreeSet<String>(DECL_SPECIFIER_SEQUENCE_CPP);
        CLASS_MEMBER.add("public");
        CLASS_MEMBER.add("protected");
        CLASS_MEMBER.add("private");
        POST_USING_CPP = new TreeSet<String>();
        POST_USING_CPP.add("namespace");
        POST_USING_CPP.add("typename");
        FUNCTION_MODIFIER_C = EMPTY_TABLE;
        FUNCTION_MODIFIER_CPP = new TreeSet<String>(FUNCTION_MODIFIER_C);
        FUNCTION_MODIFIER_CPP.add("throw");
        FUNCTION_MODIFIER_CPP.add("try");
        FUNCTION_MODIFIER_CPP.add("volatile");
        FUNCTION_MODIFIER_TABLE = new HashMap<ParserLanguage, Set<String>>(2);
        FUNCTION_MODIFIER_TABLE.put(ParserLanguage.CPP, FUNCTION_MODIFIER_CPP);
        FUNCTION_MODIFIER_TABLE.put(ParserLanguage.C, FUNCTION_MODIFIER_C);
        PP_DIRECTIVES_C = new TreeSet<String>();
        PP_DIRECTIVES_C.add("#");
        PP_DIRECTIVES_C.add("#define");
        PP_DIRECTIVES_C.add("#undef");
        PP_DIRECTIVES_C.add("#if");
        PP_DIRECTIVES_C.add("#ifdef");
        PP_DIRECTIVES_C.add("#ifndef");
        PP_DIRECTIVES_C.add("#else");
        PP_DIRECTIVES_C.add("#endif");
        PP_DIRECTIVES_C.add("#include");
        PP_DIRECTIVES_C.add("#line");
        PP_DIRECTIVES_C.add("#error");
        PP_DIRECTIVES_C.add("#pragma");
        PP_DIRECTIVES_C.add("#elif");
        PP_DIRECTIVES_C.add("_Pragma");
        PP_DIRECTIVES_C.add("defined");
        PP_DIRECTIVES_CPP = new TreeSet<String>();
        PP_DIRECTIVES_CPP.add("#");
        PP_DIRECTIVES_CPP.add("#define");
        PP_DIRECTIVES_CPP.add("#undef");
        PP_DIRECTIVES_CPP.add("#if");
        PP_DIRECTIVES_CPP.add("#ifdef");
        PP_DIRECTIVES_CPP.add("#ifndef");
        PP_DIRECTIVES_CPP.add("#else");
        PP_DIRECTIVES_CPP.add("#endif");
        PP_DIRECTIVES_CPP.add("#include");
        PP_DIRECTIVES_CPP.add("#line");
        PP_DIRECTIVES_CPP.add("#error");
        PP_DIRECTIVES_CPP.add("#pragma");
        PP_DIRECTIVES_CPP.add("#elif");
        PP_DIRECTIVES_CPP.add("_Pragma");
        PP_DIRECTIVES_CPP.add("defined");
        ALL_C = new TreeSet<String>(PP_DIRECTIVES_CPP);
        ALL_C.add("auto");
        ALL_C.add("break");
        ALL_C.add("case");
        ALL_C.add("char");
        ALL_C.add("const");
        ALL_C.add("continue");
        ALL_C.add("default");
        ALL_C.add("delete");
        ALL_C.add("do");
        ALL_C.add("double");
        ALL_C.add("else");
        ALL_C.add("enum");
        ALL_C.add("extern");
        ALL_C.add("float");
        ALL_C.add("for");
        ALL_C.add("goto");
        ALL_C.add("if");
        ALL_C.add("inline");
        ALL_C.add("int");
        ALL_C.add("long");
        ALL_C.add("register");
        ALL_C.add("restrict");
        ALL_C.add("return");
        ALL_C.add("short");
        ALL_C.add("signed");
        ALL_C.add("sizeof");
        ALL_C.add("static");
        ALL_C.add("struct");
        ALL_C.add("switch");
        ALL_C.add("typedef");
        ALL_C.add("union");
        ALL_C.add("unsigned");
        ALL_C.add("void");
        ALL_C.add("volatile");
        ALL_C.add("while");
        ALL_C.add("_Bool");
        ALL_C.add("_Complex");
        ALL_C.add("_Imaginary");
        ALL_CPP = new TreeSet<String>(PP_DIRECTIVES_CPP);
        ALL_CPP.add("and");
        ALL_CPP.add("and_eq");
        ALL_CPP.add("asm");
        ALL_CPP.add("auto");
        ALL_CPP.add("bitand");
        ALL_CPP.add("bitor");
        ALL_CPP.add("bool");
        ALL_CPP.add("break");
        ALL_CPP.add("case");
        ALL_CPP.add("catch");
        ALL_CPP.add("char");
        ALL_CPP.add("char16_t");
        ALL_CPP.add("char32_t");
        ALL_CPP.add("class");
        ALL_CPP.add("compl");
        ALL_CPP.add("const");
        ALL_CPP.add("const_cast");
        ALL_CPP.add("continue");
        ALL_CPP.add("decltype");
        ALL_CPP.add("default");
        ALL_CPP.add("delete");
        ALL_CPP.add("do");
        ALL_CPP.add("double");
        ALL_CPP.add("dynamic_cast");
        ALL_CPP.add("else");
        ALL_CPP.add("enum");
        ALL_CPP.add("explicit");
        ALL_CPP.add("export");
        ALL_CPP.add("extern");
        ALL_CPP.add("false");
        ALL_CPP.add("float");
        ALL_CPP.add("for");
        ALL_CPP.add("friend");
        ALL_CPP.add("goto");
        ALL_CPP.add("if");
        ALL_CPP.add("inline");
        ALL_CPP.add("int");
        ALL_CPP.add("long");
        ALL_CPP.add("mutable");
        ALL_CPP.add("namespace");
        ALL_CPP.add("new");
        ALL_CPP.add("not");
        ALL_CPP.add("not_eq");
        ALL_CPP.add("operator");
        ALL_CPP.add("or");
        ALL_CPP.add("or_eq");
        ALL_CPP.add("private");
        ALL_CPP.add("protected");
        ALL_CPP.add("public");
        ALL_CPP.add("register");
        ALL_CPP.add("reinterpret_cast");
        ALL_CPP.add("return");
        ALL_CPP.add("short");
        ALL_CPP.add("signed");
        ALL_CPP.add("sizeof");
        ALL_CPP.add("static");
        ALL_CPP.add("static_assert");
        ALL_CPP.add("static_cast");
        ALL_CPP.add("struct");
        ALL_CPP.add("switch");
        ALL_CPP.add("template");
        ALL_CPP.add("this");
        ALL_CPP.add("throw");
        ALL_CPP.add("true");
        ALL_CPP.add("try");
        ALL_CPP.add("typedef");
        ALL_CPP.add("typeid");
        ALL_CPP.add("typename");
        ALL_CPP.add("union");
        ALL_CPP.add("unsigned");
        ALL_CPP.add("using");
        ALL_CPP.add("virtual");
        ALL_CPP.add("void");
        ALL_CPP.add("volatile");
        ALL_CPP.add("wchar_t");
        ALL_CPP.add("while");
        ALL_CPP.add("xor");
        ALL_CPP.add("xor_eq");
        ALL_TABLE = new HashMap<ParserLanguage, Set<String>>(2);
        ALL_TABLE.put(ParserLanguage.C, ALL_C);
        ALL_TABLE.put(ParserLanguage.CPP, ALL_CPP);
        KEYWORDS_CPP = new TreeSet<String>();
        KEYWORDS_CPP.add("and");
        KEYWORDS_CPP.add("and_eq");
        KEYWORDS_CPP.add("asm");
        KEYWORDS_CPP.add("auto");
        KEYWORDS_CPP.add("bitand");
        KEYWORDS_CPP.add("bitor");
        KEYWORDS_CPP.add("break");
        KEYWORDS_CPP.add("case");
        KEYWORDS_CPP.add("catch");
        KEYWORDS_CPP.add("class");
        KEYWORDS_CPP.add("compl");
        KEYWORDS_CPP.add("const");
        KEYWORDS_CPP.add("const_cast");
        KEYWORDS_CPP.add("continue");
        KEYWORDS_CPP.add("decltype");
        KEYWORDS_CPP.add("default");
        KEYWORDS_CPP.add("delete");
        KEYWORDS_CPP.add("do");
        KEYWORDS_CPP.add("dynamic_cast");
        KEYWORDS_CPP.add("else");
        KEYWORDS_CPP.add("enum");
        KEYWORDS_CPP.add("explicit");
        KEYWORDS_CPP.add("export");
        KEYWORDS_CPP.add("extern");
        KEYWORDS_CPP.add("false");
        KEYWORDS_CPP.add("for");
        KEYWORDS_CPP.add("friend");
        KEYWORDS_CPP.add("goto");
        KEYWORDS_CPP.add("if");
        KEYWORDS_CPP.add("inline");
        KEYWORDS_CPP.add("mutable");
        KEYWORDS_CPP.add("namespace");
        KEYWORDS_CPP.add("new");
        KEYWORDS_CPP.add("not");
        KEYWORDS_CPP.add("not_eq");
        KEYWORDS_CPP.add("operator");
        KEYWORDS_CPP.add("or");
        KEYWORDS_CPP.add("or_eq");
        KEYWORDS_CPP.add("private");
        KEYWORDS_CPP.add("protected");
        KEYWORDS_CPP.add("public");
        KEYWORDS_CPP.add("register");
        KEYWORDS_CPP.add("reinterpret_cast");
        KEYWORDS_CPP.add("restrict");
        KEYWORDS_CPP.add("return");
        KEYWORDS_CPP.add("sizeof");
        KEYWORDS_CPP.add("static");
        KEYWORDS_CPP.add("static_assert");
        KEYWORDS_CPP.add("static_cast");
        KEYWORDS_CPP.add("struct");
        KEYWORDS_CPP.add("switch");
        KEYWORDS_CPP.add("template");
        KEYWORDS_CPP.add("this");
        KEYWORDS_CPP.add("throw");
        KEYWORDS_CPP.add("true");
        KEYWORDS_CPP.add("try");
        KEYWORDS_CPP.add("typedef");
        KEYWORDS_CPP.add("typeid");
        KEYWORDS_CPP.add("typename");
        KEYWORDS_CPP.add("union");
        KEYWORDS_CPP.add("using");
        KEYWORDS_CPP.add("virtual");
        KEYWORDS_CPP.add("volatile");
        KEYWORDS_CPP.add("while");
        KEYWORDS_CPP.add("xor");
        KEYWORDS_CPP.add("xor_eq");
        KEYWORDS_C = new TreeSet<String>();
        KEYWORDS_C.add("asm");
        KEYWORDS_C.add("auto");
        KEYWORDS_C.add("break");
        KEYWORDS_C.add("case");
        KEYWORDS_C.add("const");
        KEYWORDS_C.add("continue");
        KEYWORDS_C.add("default");
        KEYWORDS_C.add("do");
        KEYWORDS_C.add("else");
        KEYWORDS_C.add("enum");
        KEYWORDS_C.add("extern");
        KEYWORDS_C.add("for");
        KEYWORDS_C.add("goto");
        KEYWORDS_C.add("if");
        KEYWORDS_C.add("inline");
        KEYWORDS_C.add("register");
        KEYWORDS_C.add("return");
        KEYWORDS_C.add("restrict");
        KEYWORDS_C.add("sizeof");
        KEYWORDS_C.add("static");
        KEYWORDS_C.add("struct");
        KEYWORDS_C.add("switch");
        KEYWORDS_C.add("typedef");
        KEYWORDS_C.add("union");
        KEYWORDS_C.add("volatile");
        KEYWORDS_C.add("while");
        KEYWORDS_TABLE = new HashMap<ParserLanguage, Set<String>>(2);
        KEYWORDS_TABLE.put(ParserLanguage.C, KEYWORDS_C);
        KEYWORDS_TABLE.put(ParserLanguage.CPP, KEYWORDS_CPP);
        TYPES_C = new TreeSet<String>();
        TYPES_C.add("char");
        TYPES_C.add("double");
        TYPES_C.add("float");
        TYPES_C.add("int");
        TYPES_C.add("long");
        TYPES_C.add("short");
        TYPES_C.add("signed");
        TYPES_C.add("unsigned");
        TYPES_C.add("void");
        TYPES_C.add("_Bool");
        TYPES_C.add("_Complex");
        TYPES_C.add("_Imaginary");
        TYPES_CPP = new TreeSet<String>();
        TYPES_CPP.add("bool");
        TYPES_CPP.add("char");
        TYPES_CPP.add("char16_t");
        TYPES_CPP.add("char32_t");
        TYPES_CPP.add("double");
        TYPES_CPP.add("float");
        TYPES_CPP.add("int");
        TYPES_CPP.add("long");
        TYPES_CPP.add("short");
        TYPES_CPP.add("signed");
        TYPES_CPP.add("unsigned");
        TYPES_CPP.add("void");
        TYPES_CPP.add("wchar_t");
        TYPES_TABLE = new HashMap<ParserLanguage, Set<String>>(2);
        TYPES_TABLE.put(ParserLanguage.C, TYPES_C);
        TYPES_TABLE.put(ParserLanguage.CPP, TYPES_CPP);
        PP_DIRECTIVES_TABLE = new HashMap<ParserLanguage, Set<String>>(2);
        PP_DIRECTIVES_TABLE.put(ParserLanguage.C, PP_DIRECTIVES_C);
        PP_DIRECTIVES_TABLE.put(ParserLanguage.CPP, PP_DIRECTIVES_CPP);
    }

    public static Set<String> getKeywords(KeywordSetKey kind, ParserLanguage language) {
        if (kind == KeywordSetKey.EMPTY) {
            return EMPTY_TABLE;
        }
        if (kind == KeywordSetKey.DECL_SPECIFIER_SEQUENCE) {
            return DECL_SPECIFIER_SEQUENCE_TABLE.get((Object)language);
        }
        if (kind == KeywordSetKey.DECLARATION) {
            return DECLARATION_TABLE.get((Object)language);
        }
        if (kind == KeywordSetKey.STATEMENT) {
            return STATEMENT_TABLE.get((Object)language);
        }
        if (kind == KeywordSetKey.BASE_SPECIFIER) {
            return BASE_SPECIFIER_CPP;
        }
        if (kind == KeywordSetKey.MEMBER) {
            if (language == ParserLanguage.CPP) {
                return CLASS_MEMBER;
            }
            return EMPTY_TABLE;
        }
        if (kind == KeywordSetKey.POST_USING) {
            return POST_USING_CPP;
        }
        if (kind == KeywordSetKey.FUNCTION_MODIFIER) {
            return FUNCTION_MODIFIER_TABLE.get((Object)language);
        }
        if (kind == KeywordSetKey.NAMESPACE_ONLY) {
            return NAMESPACE_ONLY_SET;
        }
        if (kind == KeywordSetKey.MACRO) {
            return MACRO_ONLY;
        }
        if (kind == KeywordSetKey.PP_DIRECTIVE) {
            return PP_DIRECTIVES_TABLE.get((Object)language);
        }
        if (kind == KeywordSetKey.EXPRESSION) {
            return EXPRESSION_TABLE.get((Object)language);
        }
        if (kind == KeywordSetKey.ALL) {
            return ALL_TABLE.get((Object)language);
        }
        if (kind == KeywordSetKey.KEYWORDS) {
            return KEYWORDS_TABLE.get((Object)language);
        }
        if (kind == KeywordSetKey.TYPES) {
            return TYPES_TABLE.get((Object)language);
        }
        return null;
    }
}

