/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.swap.model.data;

import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.communicator.UnsupportedProtocolException;
import org.tizen.dynamicanalyzer.model.DATime;
import org.tizen.dynamicanalyzer.protocol.Protocol;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.util.Logger;

public class ProfileData
extends LogData {
    public static int logCount = 0;
    protected int pid = 0;
    protected int tid = 0;
    protected long pcAddr = 0L;
    protected int cpuNum = 0;
    protected int probeType = 0;
    protected int probeSubType = 0;
    protected long callerPcAddr = 0L;
    protected String args = null;
    protected String ret = null;
    protected int apiId = -1;
    protected long entrySeq = -1L;
    protected int buildType = -1;
    protected int binaryId = -1;

    public ProfileData() {
    }

    public ProfileData(int id, long seq, int pid, int tid, int apiId, int binaryId, long time, long callerPcAddr, long pcAddr) {
        this.msgID = id;
        this.seq = seq;
        this.pid = pid;
        this.tid = tid;
        this.apiId = apiId;
        this.binaryId = binaryId;
        this.time = time;
        this.callerPcAddr = callerPcAddr;
        this.pcAddr = pcAddr;
    }

    public ProfileData(long time, int pid, int tid, long pcAddr) {
        this.msgID = 4;
        this.time = time;
        this.pid = pid;
        this.tid = tid;
        this.pcAddr = pcAddr;
    }

    @Override
    public ProfileData clone() throws CloneNotSupportedException {
        ProfileData log = (ProfileData)super.clone();
        log.pcAddr = this.pcAddr;
        log.callerPcAddr = this.callerPcAddr;
        log.probeType = this.probeType;
        log.probeSubType = this.probeSubType;
        log.pid = this.pid;
        log.tid = this.tid;
        log.cpuNum = this.cpuNum;
        log.args = this.args;
        log.ret = this.ret;
        log.apiId = this.apiId;
        log.buildType = this.buildType;
        log.binaryId = this.binaryId;
        return log;
    }

    @Override
    protected boolean parse(DATime startTime) {
        super.parse(startTime);
        switch (this.msgID) {
            case 8: {
                ++logCount;
                this.pid = this.getInt();
                this.tid = this.getInt();
                if (this.protocolVersion == Protocol.VERSION_30 || this.protocolVersion == Protocol.VERSION_30A || this.protocolVersion == Protocol.VERSION_30_UIHV) {
                    this.probeType = this.getShort();
                    this.probeSubType = this.getShort();
                }
                this.pcAddr = this.getLong();
                this.callerPcAddr = this.getLong();
                this.cpuNum = this.getInt();
                this.args = this.parseArgs();
                break;
            }
            case 9: {
                ++logCount;
                this.pid = this.getInt();
                this.tid = this.getInt();
                if (this.protocolVersion == Protocol.VERSION_30 || this.protocolVersion == Protocol.VERSION_30A || this.protocolVersion == Protocol.VERSION_30_UIHV) {
                    this.probeType = this.getShort();
                    this.probeSubType = this.getShort();
                }
                this.pcAddr = this.getLong();
                this.callerPcAddr = this.getLong();
                this.cpuNum = this.getInt();
                this.ret = this.parseReturn();
                break;
            }
            case 4: {
                this.pid = this.getInt();
                this.pcAddr = this.getLong();
                this.tid = this.getInt();
                this.cpuNum = this.getInt();
                break;
            }
        }
        if (this.protocolVersion != Protocol.VERSION_30 && this.protocolVersion != Protocol.VERSION_30A && this.protocolVersion != Protocol.VERSION_30_UIHV || this.probeType != 4) {
            this.binaryId = Global.getBinaryID(this.pid, this.time, this.pcAddr);
            if (this.binaryId == -2) {
                Logger.error((String)"ProfileData of %s is from wrong process(%d) or wrong address(%d)", (Object[])new Object[]{Protocol.getDataMessageName(this.msgID), this.pid, this.pcAddr});
                return false;
            }
        }
        return true;
    }

    public long getPcAddr() {
        return this.pcAddr;
    }

    public void setPcAddr(long pcAddr) {
        this.pcAddr = pcAddr;
    }

    public long getCallerPcAddr() {
        return this.callerPcAddr;
    }

    public void setCallerPcAddr(long callerPcAddr) {
        this.callerPcAddr = callerPcAddr;
    }

    public int getProbeType() {
        return this.probeType;
    }

    public int getProbeSubType() throws UnsupportedProtocolException {
        if (this.protocolVersion == Protocol.VERSION_30 || this.protocolVersion == Protocol.VERSION_30A || this.protocolVersion == Protocol.VERSION_30_UIHV) {
            return this.probeSubType;
        }
        throw new UnsupportedProtocolException();
    }

    public void setProbeSubType(int probeSubType) {
        this.probeSubType = probeSubType;
    }

    @Override
    public int getPid() {
        return this.pid;
    }

    public void setPid(int pid) {
        this.pid = pid;
    }

    public int getTid() {
        return this.tid;
    }

    public void setTid(int tid) {
        this.tid = tid;
    }

    public int getCpuNum() {
        return this.cpuNum;
    }

    public void setCpuNum(int cpuNum) {
        this.cpuNum = cpuNum;
    }

    public String getArgs() {
        return this.args;
    }

    public void setArgs(String args) {
        this.args = args;
    }

    public String getReturn() {
        return this.ret;
    }

    public void setReturn(String ret) {
        this.ret = ret;
    }

    public int getApiId() {
        return this.apiId;
    }

    public void setApiId(int apiId) {
        this.apiId = apiId;
    }

    public long getEntrySeq() {
        return this.entrySeq;
    }

    public void setEntrySeq(long seq) {
        this.entrySeq = seq;
    }

    public int getBuildType() {
        return this.buildType;
    }

    public void setBuildType(int buildType) {
        this.buildType = buildType;
    }

    public boolean isPieBuild() {
        return this.buildType == 1;
    }

    public int getBinaryId() {
        return this.binaryId;
    }

    public void setBinaryPath(int binaryId) {
        this.binaryId = binaryId;
    }
}

