/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.hierarchy.layout;

import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.HierarchyUIObject;
import org.tizen.dynamicanalyzer.ui.hierarchy.tree.figure.HierarchyTreeFigure;

public class HierarchyLayoutFigure
extends Figure {
    private static final int MARGIN_X = 14;
    private static final int MARGIN_Y = 14;
    private static final int MAX_WIDTH = 10000;
    private static final int MAX_HEIGHT = 10000;
    private IFigure sourceFigure;
    private HierarchyUIObject selectedUIObj;

    public void setSource(IFigure sourceFigure) {
        this.sourceFigure = sourceFigure;
    }

    public void setSelectedUIObj(HierarchyUIObject selectedUIObj) {
        this.selectedUIObj = selectedUIObj;
    }

    public void paintFigure(Graphics graphics) {
        List children = this.sourceFigure.getChildren();
        if (children.isEmpty()) {
            return;
        }
        HierarchyTreeFigure rootFigure = (HierarchyTreeFigure)((Object)children.get(0));
        Rectangle unionArea = new Rectangle();
        this.getUIObjUnionSize(rootFigure, unionArea);
        Dimension realWindowSize = unionArea.getSize();
        Dimension windowSize = this.getAdjustWindowSize(this.getBounds().getSize(), realWindowSize);
        int windowX = this.getClientArea().x + (this.getClientArea().width - windowSize.width) / 2;
        int windowY = this.getClientArea().y + (this.getClientArea().height - windowSize.height) / 2;
        graphics.setForegroundColor(ColorResources.LAYOUTVIEW_NORMAL_STROKE);
        this.paintContents(rootFigure, graphics, realWindowSize, windowSize, windowX, windowY);
        if (this.selectedUIObj != null) {
            this.paintHighlight(graphics, realWindowSize, windowSize, windowX, windowY);
        }
    }

    private void getUIObjUnionSize(HierarchyTreeFigure treeFigure, Rectangle unionArea) {
        HierarchyUIObject uiObj = treeFigure.getNode().getUIObject();
        int x = uiObj.getGeometry()[0];
        int y = uiObj.getGeometry()[1];
        int width = uiObj.getGeometry()[2];
        int height = uiObj.getGeometry()[3];
        if (width < 10000 && height < 10000) {
            unionArea.union(x, y, width, height);
        }
        List children = treeFigure.getBranch().getChildren();
        int i = 0;
        while (i < children.size()) {
            this.getUIObjUnionSize((HierarchyTreeFigure)((Object)children.get(i)), unionArea);
            ++i;
        }
    }

    private void paintContents(HierarchyTreeFigure treeFigure, Graphics graphics, Dimension realWindowSize, Dimension windowSize, int windowX, int windowY) {
        HierarchyUIObject uiObj = treeFigure.getNode().getUIObject();
        double uiObjX = uiObj.getGeometry()[0];
        double uiObjY = uiObj.getGeometry()[1];
        int adjustedX = windowX + (int)Math.round(uiObjX * (double)windowSize.width / (double)realWindowSize.width);
        int adjustedY = windowY + (int)Math.round(uiObjY * (double)windowSize.height / (double)realWindowSize.height);
        int adjustedWidth = windowSize.width * uiObj.getGeometry()[2] / realWindowSize.width;
        int adjustedHeight = windowSize.height * uiObj.getGeometry()[3] / realWindowSize.height;
        graphics.drawRectangle(adjustedX, adjustedY, adjustedWidth, adjustedHeight);
        List children = treeFigure.getBranch().getChildren();
        int i = 0;
        while (i < children.size()) {
            this.paintContents((HierarchyTreeFigure)((Object)children.get(i)), graphics, realWindowSize, windowSize, windowX, windowY);
            ++i;
        }
    }

    private void paintHighlight(Graphics gc, Dimension realWindowSize, Dimension windowSize, int windowX, int windowY) {
        gc.setForegroundColor(ColorResources.LAYOUTVIEW_SELECTED_STROKE);
        int uiObjX = this.selectedUIObj.getGeometry()[0];
        int uiObjY = this.selectedUIObj.getGeometry()[1];
        int uiObjWidth = this.selectedUIObj.getGeometry()[2];
        int uiObjHeight = this.selectedUIObj.getGeometry()[3];
        int adjustedX = windowX + (int)Math.round((double)uiObjX * (double)windowSize.width / (double)realWindowSize.width);
        int adjustedY = windowY + (int)Math.round((double)uiObjY * (double)windowSize.height / (double)realWindowSize.height);
        int adjustedWidth = windowSize.width * uiObjWidth / realWindowSize.width;
        int adjustedHeight = windowSize.height * uiObjHeight / realWindowSize.height;
        gc.setLineWidth(2);
        gc.drawRectangle(adjustedX, adjustedY, adjustedWidth, adjustedHeight);
        String imagePath = this.selectedUIObj.getImageFilePath();
        if (this.selectedUIObj.getStatus() == HierarchyUIObject.STATUS.OK && imagePath != null) {
            Image image = new Image((Device)Display.getDefault(), imagePath);
            gc.drawImage(image, 0, 0, image.getBounds().width, image.getBounds().height, adjustedX, adjustedY, adjustedWidth, adjustedHeight);
        }
    }

    private Dimension getAdjustWindowSize(Dimension viewSize, Dimension sourceSize) {
        Dimension adjustedSize = new Dimension(viewSize.width - 28, viewSize.height - 28);
        adjustedSize.width = Math.min(adjustedSize.width, (int)((double)((float)(adjustedSize.height * sourceSize.width) / (float)sourceSize.height) + 0.5));
        adjustedSize.height = Math.min(adjustedSize.height, (int)((double)((float)(adjustedSize.width * sourceSize.height) / (float)sourceSize.width) + 0.5));
        return adjustedSize;
    }
}

