/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory;

import java.util.List;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.tizen.dynamicanalyzer.ui.memory.MemoryPage;
import org.tizen.dynamicanalyzer.ui.memory.chart.MemoryChartBoard;
import org.tizen.dynamicanalyzer.ui.memory.table.MemoryPersistentAllocationsTableIndex;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlot;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotIntervalMarker;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotMarker;

public class PersistentAllocationsSelectionListener
extends SelectionAdapter {
    MemoryPage page;

    public PersistentAllocationsSelectionListener(MemoryPage memoryPage) {
        this.page = memoryPage;
    }

    public void widgetSelected(SelectionEvent e) {
        if (!(e.widget instanceof Grid)) {
            return;
        }
        GridItem[] items = ((Grid)e.widget).getSelection();
        if (items == null || items.length == 0) {
            return;
        }
        int size = items.length;
        double eventStartTime_sec = 0.0;
        double eventEndTime_sec = 0.0;
        if (size == 1) {
            List<Object> data = ((DATableDataFormat)items[0].getData()).getData();
            long time_micSec = (Long)data.get(MemoryPersistentAllocationsTableIndex.TIMESTAMP.getIndex());
            eventEndTime_sec = eventStartTime_sec = (double)time_micSec / 1000000.0;
        } else {
            List<Object> startData = ((DATableDataFormat)items[0].getData()).getData();
            List<Object> endData = ((DATableDataFormat)items[size - 1].getData()).getData();
            long startTime_micSec = (Long)startData.get(MemoryPersistentAllocationsTableIndex.TIMESTAMP.getIndex());
            eventStartTime_sec = (double)startTime_micSec / 1000000.0;
            long endTime_micSec = (Long)endData.get(MemoryPersistentAllocationsTableIndex.TIMESTAMP.getIndex());
            eventEndTime_sec = (double)endTime_micSec / 1000000.0;
        }
        MemoryChartBoard chartBoard = (MemoryChartBoard)this.page.memoryChartView.getChartBoard();
        DAChartPlot plot = chartBoard.getMemoryChartList().get(0).getChart().getPlot();
        DAChartPlotMarker marker = (DAChartPlotMarker)plot.getMarkers().get(0);
        if (!(marker instanceof DAChartPlotIntervalMarker)) {
            return;
        }
        DAChartPlotIntervalMarker intervalMarker = (DAChartPlotIntervalMarker)marker;
        intervalMarker.setInterval(eventStartTime_sec, eventEndTime_sec);
        chartBoard.getMemoryChartList().get(0).getChart().redraw();
    }
}

