/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.timeline.chart;

import java.util.List;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.tizen.dynamicanalyzer.ui.timeline.chart.DeviceChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartRenderer;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeries;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeriesItem;
import org.tizen.dynamicanalyzer.widgets.helper.ColorResources;

public class DeviceChartRenderer
extends DAChartRenderer {
    private static final int WIFI_STATE = DeviceChart.WIFI_STATES.length;
    private static final int BLUETOOTH_STATE = DeviceChart.BLUETOOTH_STATES.length;
    private static final int GPS_STATE = DeviceChart.GPS_STATES.length;
    private static final int DNET_STATE = DeviceChart.DNET_STATES.length;
    private static final int CAMERA_STATE = DeviceChart.CAMERA_STATES.length;
    private static final int[] states = new int[]{WIFI_STATE, BLUETOOTH_STATE, GPS_STATE, DNET_STATE, CAMERA_STATE};

    protected void drawToGc(GC gc, DAChart chart) {
        if (!this.preDraw(gc, chart)) {
            return;
        }
        int i = 0;
        while (i < this.seriesList.size()) {
            int seriesSize = this.seriesList.size();
            Rectangle rect = new Rectangle(this.r.x, this.r.y + this.r.height * i / seriesSize, this.r.width, this.r.height / seriesSize);
            if (i != 0) {
                gc.setForeground(ColorResources.CHART_SEPERATE_LINE);
                gc.drawLine(rect.x, this.r.height * i / seriesSize, rect.width, this.r.height * i / seriesSize);
            }
            ++i;
        }
        i = 0;
        while (i < this.seriesList.size()) {
            this.drawSeries(gc, (DAChartSeries)this.seriesList.get(i), i);
            ++i;
        }
    }

    private void drawSeries(GC gc, DAChartSeries series, int seriesIndex) {
        DAChartSeriesItem seriesItem;
        int seriesSize = this.seriesList.size();
        Rectangle rect = new Rectangle(this.r.x, this.r.y + this.r.height * seriesIndex / seriesSize, this.r.width, this.r.height / seriesSize);
        gc.setForeground(ColorResources.SERIES_NAME_ANNOTATION);
        Font oriFont = gc.getFont();
        Font nameAnnotationFont = series.getFont();
        gc.setFont(nameAnnotationFont);
        gc.drawText(series.getName(), rect.x + 3, rect.y + rect.height / 2 - gc.stringExtent((String)series.getName()).y / 2, true);
        gc.setFont(oriFont);
        List seriesItems = series.getSeriesItemList();
        if (seriesItems == null) {
            return;
        }
        int seriesItemSize = seriesItems.size();
        if (seriesItemSize <= 1) {
            return;
        }
        int index = series.getPrevIndexByXvalue(this.plot.getVisibleStartX());
        if (index < 0) {
            index = 0;
        }
        int newPixelX = 0;
        double newY = 0.0;
        if (index > 0) {
            seriesItem = (DAChartSeriesItem)seriesItems.get(index - 1);
            newPixelX = this.plot.getXPixelFromX(seriesItem.getX(), this.r);
            newY = seriesItem.getY();
        }
        gc.setForeground(series.getColor());
        gc.setAlpha(204);
        int i = index;
        while (i < seriesItemSize) {
            int oldPixelX = newPixelX;
            double oldY = newY;
            seriesItem = (DAChartSeriesItem)seriesItems.get(i);
            double x = seriesItem.getX();
            newPixelX = this.plot.getXPixelFromX(x, this.r);
            newY = seriesItem.getY();
            if (seriesItem.getColor() != null) {
                gc.setForeground(seriesItem.getColor());
            }
            if (oldY != newY) {
                gc.drawLine(oldPixelX, (int)((double)rect.y + (double)rect.height * (1.0 - oldY / (double)states[seriesIndex])), oldPixelX, (int)((double)rect.y + (double)rect.height * (1.0 - newY / (double)states[seriesIndex])));
                oldY = newY;
            }
            gc.drawLine(oldPixelX, (int)((double)rect.y + (double)rect.height * (1.0 - oldY / (double)states[seriesIndex])), newPixelX, (int)((double)rect.y + (double)rect.height * (1.0 - newY / (double)states[seriesIndex])));
            if (x > this.plot.getVisibleEndX()) {
                return;
            }
            ++i;
        }
    }
}

