/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.util.io;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.io.BufferPool;

public class Buffer
implements Closeable {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected BufferPool pool;
    protected LinkedList<ByteBuffer> useds = new LinkedList();
    protected ByteBuffer readBuffer;
    protected ByteBuffer writeBuffer;
    protected LinkedList<ByteBuffer> usings = new LinkedList();
    protected int nReaded = 0;
    protected int size = 0;
    protected int index;

    public Buffer(BufferPool pool) {
        this.pool = pool;
    }

    public int size() {
        return this.size;
    }

    public int getBufferSize() {
        return this.useds.size() + this.usings.size() + (this.readBuffer == null ? 0 : 1) + (this.writeBuffer == null ? 0 : 1);
    }

    public ByteBuffer getBufferForWrite() throws IOException {
        if (this.writeBuffer == null) {
            this.writeBuffer = this.pool.borrow();
        } else if (this.writeBuffer.remaining() <= 0) {
            this.writeBuffer.flip();
            this.usings.addLast(this.writeBuffer);
            this.writeBuffer = this.pool.borrow();
        }
        return this.writeBuffer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ByteBuffer getBufferForRead() throws IOException {
        if (this.readBuffer != null && this.readBuffer.remaining() == 0) {
            this.readBuffer.position(0);
            this.useds.add(this.readBuffer);
            this.readBuffer = null;
        }
        if (this.readBuffer != null) return this.readBuffer;
        if (this.usings.isEmpty()) {
            if (this.writeBuffer == null) return null;
            this.readBuffer = this.writeBuffer;
            this.readBuffer.flip();
            this.writeBuffer = null;
            return this.readBuffer;
        } else {
            this.readBuffer = this.usings.removeFirst();
        }
        return this.readBuffer;
    }

    public int readFrom(SocketChannel channel) throws IOException {
        int sum = 0;
        int nCnt = 0;
        while (true) {
            ByteBuffer buffer;
            int nRead;
            if ((nRead = channel.read(buffer = this.getBufferForWrite())) < 0) {
                throw new EOFException();
            }
            if (nRead == 0) {
                this.size += sum;
                if (sum > 0) {
                    this.logger.info("{} bytes[{}] read from {}", new Object[]{sum, nCnt, channel});
                }
                return sum;
            }
            sum += nRead;
            ++nCnt;
        }
    }

    public int writeTo(SocketChannel channel) throws IOException {
        int sum = 0;
        while (this.size > 0) {
            ByteBuffer buffer = this.getBufferForRead();
            int nWrite = channel.write(buffer);
            if (nWrite <= 0) continue;
            this.size -= nWrite;
            sum += nWrite;
        }
        this.nReaded += sum;
        this.logger.info("Send {} bytes to {}", (Object)sum, (Object)channel);
        return sum;
    }

    public int read() throws IOException {
        ByteBuffer buffer = this.getBufferForRead();
        if (buffer == null) {
            return -1;
        }
        int ch = 0xFF & buffer.get();
        --this.size;
        ++this.nReaded;
        return ch;
    }

    public int readInt() throws IOException {
        int i1 = this.read();
        int i2 = this.read();
        int i3 = this.read();
        int i4 = this.read();
        return (0xFF & i1) << 24 | (0xFF & i2) << 16 | (0xFF & i3) << 8 | 0xFF & i4;
    }

    public void write(int value) throws IOException {
        ByteBuffer buffer = this.getBufferForWrite();
        buffer.put((byte)value);
        ++this.size;
    }

    public void write(byte[] bytes) throws IOException {
        int i = 0;
        int n = bytes.length;
        while (i < n) {
            ByteBuffer buffer = this.getBufferForWrite();
            int remaingSize = buffer.remaining();
            int writeSize = Math.min(remaingSize, bytes.length - i);
            buffer.put(bytes, i, writeSize);
            i += writeSize;
        }
    }

    public void writeInt(int value) throws IOException {
        this.write(0xFF & value >> 24);
        this.write(0xFF & value >> 16);
        this.write(0xFF & value >> 8);
        this.write(0xFF & value);
    }

    public void reset() {
        if (this.readBuffer != null) {
            this.readBuffer.position();
            this.useds.add(this.readBuffer);
        }
        this.useds.addAll(this.usings);
        if (this.writeBuffer != null) {
            this.writeBuffer.flip();
            this.useds.add(this.writeBuffer);
            this.writeBuffer = null;
        }
        this.usings = this.useds;
        this.useds = new LinkedList();
        this.size += this.nReaded;
        this.nReaded = 0;
    }

    public synchronized void pack() throws IOException {
        for (ByteBuffer buffer : this.useds) {
            this.nReaded -= buffer.remaining();
            this.pool.release(buffer);
        }
        this.useds.clear();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.readBuffer != null) {
            this.pool.release(this.readBuffer);
            this.readBuffer = null;
        }
        for (ByteBuffer buffer : this.usings) {
            this.pool.release(buffer);
        }
        this.usings.clear();
        if (this.writeBuffer != null) {
            this.pool.release(this.writeBuffer);
            this.writeBuffer = null;
        }
        for (ByteBuffer buffer : this.useds) {
            this.pool.release(buffer);
        }
        this.useds.clear();
    }

    public static Buffer concatenate(Buffer ... buffers) {
        Buffer ret = new Buffer(null);
        boolean bInit = false;
        Buffer[] bufferArray = buffers;
        int n = buffers.length;
        int n2 = 0;
        while (n2 < n) {
            Buffer buffer = bufferArray[n2];
            if (bInit && ret.pool != buffer.pool) {
                throw new IllegalArgumentException("Unmatching buffer pool");
            }
            ret.pool = buffer.pool;
            bInit = true;
            buffer.reset();
            ret.usings.addAll(buffer.usings);
            ret.size += buffer.size;
            ++n2;
        }
        return ret;
    }

    public String toString() {
        return "Buffer[" + this.size + "]";
    }
}

