/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementVisitor;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IOpenable;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.Openable;
import org.eclipse.cdt.internal.core.model.Parent;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.cdt.internal.core.util.MementoTokenizer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CElement
extends PlatformObject
implements ICElement {
    public static final char CEM_ESCAPE = '\\';
    public static final char CEM_CPROJECT = '=';
    public static final char CEM_SOURCEROOT = '/';
    public static final char CEM_SOURCEFOLDER = '<';
    public static final char CEM_TRANSLATIONUNIT = '{';
    public static final char CEM_SOURCEELEMENT = '[';
    public static final char CEM_PARAMETER = '(';
    public static final char CEM_ELEMENTTYPE = '#';
    protected static final CElement[] NO_ELEMENTS = new CElement[0];
    protected int fType;
    protected ICElement fParent;
    protected String fName;

    protected CElement(ICElement parent, String name, int type) {
        this.fParent = parent;
        this.fName = name;
        this.fType = type;
    }

    public Object getAdapter(Class adapter) {
        IResource r;
        if (IResource.class.isAssignableFrom(adapter) && (r = this.getResource()) != null && adapter.isAssignableFrom(r.getClass())) {
            return r;
        }
        return super.getAdapter(adapter);
    }

    public void setElementType(int type) {
        this.fType = type;
    }

    public void setElementName(String name) {
        this.fName = name;
    }

    public void setParent(ICElement parent) {
        this.fParent = parent;
    }

    @Override
    public int getElementType() {
        return this.fType;
    }

    @Override
    public String getElementName() {
        return this.fName;
    }

    @Override
    public ICElement getParent() {
        return this.fParent;
    }

    @Override
    public IPath getPath() {
        IResource res = this.getUnderlyingResource();
        if (res != null) {
            return res.getFullPath();
        }
        return new Path(this.getElementName());
    }

    @Override
    public URI getLocationURI() {
        IResource res = this.getUnderlyingResource();
        if (res != null) {
            return res.getLocationURI();
        }
        return null;
    }

    @Override
    public boolean exists() {
        try {
            return this.getElementInfo() != null;
        }
        catch (CModelException cModelException) {
            return false;
        }
    }

    protected ICElement getSourceElementAtOffset(int offset) throws CModelException {
        if (this instanceof ISourceReference && this instanceof Parent) {
            ICElement[] children;
            ICElement[] iCElementArray = children = ((Parent)this).getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                ISourceReference child;
                ISourceRange range;
                int startPos;
                int endPos;
                ICElement aChild = iCElementArray[n2];
                if (aChild instanceof ISourceReference && offset < (endPos = (startPos = (range = (child = (ISourceReference)((Object)aChild)).getSourceRange()).getStartPos()) + range.getLength()) && offset >= startPos) {
                    if (child instanceof Parent) {
                        return ((Parent)((Object)child)).getSourceElementAtOffset(offset);
                    }
                    return (ICElement)((Object)child);
                }
                ++n2;
            }
        }
        return this;
    }

    protected ICElement[] getSourceElementsAtOffset(int offset) throws CModelException {
        if (this instanceof ISourceReference && this instanceof Parent) {
            ICElement[] children;
            ArrayList<Object> list = new ArrayList<Object>();
            ICElement[] iCElementArray = children = ((Parent)this).getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                ISourceReference child;
                ISourceRange range;
                int startPos;
                int endPos;
                ICElement aChild = iCElementArray[n2];
                if (aChild instanceof ISourceReference && offset < (endPos = (startPos = (range = (child = (ISourceReference)((Object)aChild)).getSourceRange()).getStartPos()) + range.getLength()) && offset >= startPos) {
                    if (child instanceof Parent) {
                        ICElement[] elements = ((Parent)((Object)child)).getSourceElementsAtOffset(offset);
                        list.addAll(Arrays.asList(elements));
                    }
                    list.add(child);
                }
                ++n2;
            }
            children = new ICElement[list.size()];
            list.toArray(children);
            return children;
        }
        return new ICElement[]{this};
    }

    @Override
    public boolean isReadOnly() {
        ResourceAttributes attributes;
        IResource r = this.getUnderlyingResource();
        if (r != null && (attributes = r.getResourceAttributes()) != null) {
            return attributes.isReadOnly();
        }
        return false;
    }

    @Override
    public boolean isStructureKnown() throws CModelException {
        return this.getElementInfo().isStructureKnown();
    }

    @Override
    public ICModel getCModel() {
        ICElement current = this;
        do {
            if (!(current instanceof ICModel)) continue;
            return (ICModel)current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    @Override
    public ICProject getCProject() {
        ICElement current = this;
        do {
            if (!(current instanceof ICProject)) continue;
            return (ICProject)current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    protected void addChild(ICElement e) throws CModelException {
    }

    @Override
    public IResource getUnderlyingResource() {
        ICElement p;
        IResource res = this.getResource();
        if (res == null && (p = this.getParent()) != null) {
            res = p.getUnderlyingResource();
        }
        return res;
    }

    @Override
    public abstract IResource getResource();

    protected abstract CElementInfo createElementInfo();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ICElement) {
            return CElement.equals(this, (ICElement)o);
        }
        return false;
    }

    public static boolean equals(ICElement lhs, ICElement rhs) {
        ICElement rhsParent;
        if (lhs == rhs) {
            return true;
        }
        if (lhs.getElementType() != rhs.getElementType()) {
            return false;
        }
        String lhsName = lhs.getElementName();
        String rhsName = rhs.getElementName();
        if (lhsName == null || rhsName == null || lhsName.length() != rhsName.length() || !lhsName.equals(rhsName)) {
            return false;
        }
        if (lhs instanceof ISourceReference && rhs instanceof ISourceReference && ((ISourceReference)((Object)lhs)).getIndex() != ((ISourceReference)((Object)rhs)).getIndex()) {
            return false;
        }
        ICElement lhsParent = lhs.getParent();
        if (lhsParent == (rhsParent = rhs.getParent())) {
            return true;
        }
        return lhsParent != null && lhsParent.equals(rhsParent);
    }

    public CElementInfo getElementInfo() throws CModelException {
        return this.getElementInfo(null);
    }

    public CElementInfo getElementInfo(IProgressMonitor monitor) throws CModelException {
        CModelManager manager = CModelManager.getDefault();
        CElementInfo info = (CElementInfo)manager.getInfo(this);
        if (info != null) {
            return info;
        }
        info = this.createElementInfo();
        this.openWhenClosed(info, monitor);
        return info;
    }

    public String toString() {
        return this.getElementName();
    }

    public String toDebugString() {
        return String.valueOf(this.getElementName()) + " " + this.getTypeString();
    }

    public String getTypeString() {
        switch (this.getElementType()) {
            case 10: {
                return "CMODEL";
            }
            case 11: {
                return "CPROJECT";
            }
            case 12: {
                if (this instanceof ISourceRoot) {
                    return "SOURCE_ROOT";
                }
                return "CCONTAINER";
            }
            case 60: {
                if (this instanceof IWorkingCopy) {
                    return "WORKING_UNIT";
                }
                return "TRANSLATION_UNIT";
            }
            case 74: {
                return "C_FUNCTION";
            }
            case 73: {
                return "C_FUNCTION_DECLARATION";
            }
            case 76: {
                return "C_VARIABLE";
            }
            case 77: {
                return "C_VARIABLE_DECLARATION";
            }
            case 75: {
                return "C_INCLUDE";
            }
            case 79: {
                return "C_MACRO";
            }
            case 67: {
                return "C_STRUCT";
            }
            case 65: {
                return "C_CLASS";
            }
            case 69: {
                return "C_UNION";
            }
            case 72: {
                return "C_FIELD";
            }
            case 70: {
                return "C_METHOD";
            }
            case 61: {
                return "C_NAMESPACE";
            }
            case 62: {
                return "C_USING";
            }
            case 30: {
                return "C_CONTAINER";
            }
            case 14: {
                return "C_BINARY";
            }
            case 18: {
                return "C_ARCHIVE";
            }
        }
        return "UNKNOWN";
    }

    public void close() throws CModelException {
        CModelManager.getDefault().releaseCElement(this);
    }

    protected void closing(Object info) throws CModelException {
    }

    protected void opening(Object info) {
    }

    public IOpenable getOpenableParent() {
        if (this.fParent instanceof IOpenable) {
            return (IOpenable)((Object)this.fParent);
        }
        return null;
    }

    protected abstract void generateInfos(CElementInfo var1, Map<ICElement, CElementInfo> var2, IProgressMonitor var3) throws CModelException;

    protected void openWhenClosed(CElementInfo info, IProgressMonitor pm) throws CModelException {
        CModelManager manager = CModelManager.getDefault();
        boolean hadTemporaryCache = manager.hasTemporaryCache();
        try {
            Map<ICElement, CElementInfo> newElements = manager.getTemporaryCache();
            this.generateInfos(info, newElements, pm);
            if (info == null) {
                info = newElements.get(this);
            }
            if (info == null) {
                for (ICElement element : newElements.keySet()) {
                    if (!(element instanceof Openable)) continue;
                    ((Openable)element).closeBuffer();
                }
                throw this.newNotPresentException();
            }
            if (!hadTemporaryCache) {
                manager.putInfos(this, newElements);
            }
        }
        finally {
            if (!hadTemporaryCache) {
                manager.resetTemporaryCache();
            }
        }
    }

    @Override
    public ICElement getAncestor(int ancestorType) {
        ICElement element = this;
        while (element != null) {
            if (element.getElementType() == ancestorType) {
                return element;
            }
            element = element.getParent();
        }
        return null;
    }

    public boolean isAncestorOf(ICElement e) {
        ICElement parent = e.getParent();
        while (parent != null && !parent.equals(this)) {
            parent = parent.getParent();
        }
        return parent != null;
    }

    protected CModelException newNotPresentException() {
        return new CModelException(new CModelStatus(969, this));
    }

    public int hashCode() {
        return CElement.hashCode(this);
    }

    public static int hashCode(ICElement elem) {
        ICElement parent = elem.getParent();
        if (parent == null) {
            return System.identityHashCode(elem);
        }
        return Util.combineHashCodes(elem.getElementName().hashCode(), parent.hashCode());
    }

    public boolean isIdentical(CElement otherElement) {
        return this.equals(otherElement);
    }

    @Override
    public void accept(ICElementVisitor visitor) throws CoreException {
        if (!visitor.visit(this)) {
            return;
        }
        if (this instanceof IParent) {
            ICElement[] children = ((IParent)((Object)this)).getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].accept(visitor);
                ++i;
            }
        }
    }

    @Override
    public String getHandleIdentifier() {
        return this.getHandleMemento();
    }

    public String getHandleMemento() {
        StringBuilder buff = new StringBuilder();
        this.getHandleMemento(buff);
        return buff.toString();
    }

    public void getHandleMemento(StringBuilder buff) {
        ((CElement)this.getParent()).getHandleMemento(buff);
        buff.append(this.getHandleMementoDelimiter());
        CElement.escapeMementoName(buff, this.getElementName());
    }

    protected abstract char getHandleMementoDelimiter();

    public ICElement getHandleFromMemento(MementoTokenizer memento) {
        if (!memento.hasMoreTokens()) {
            return this;
        }
        String token = memento.nextToken();
        return this.getHandleFromMemento(token, memento);
    }

    public abstract ICElement getHandleFromMemento(String var1, MementoTokenizer var2);

    public static void escapeMementoName(StringBuilder buffer, String mementoName) {
        int i = 0;
        int length = mementoName.length();
        while (i < length) {
            char character = mementoName.charAt(i);
            switch (character) {
                case '#': 
                case '(': 
                case '/': 
                case '<': 
                case '=': 
                case '[': 
                case '\\': 
                case '{': {
                    buffer.append('\\');
                }
            }
            buffer.append(character);
            ++i;
        }
    }
}

