/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.symbols;

import java.math.BigInteger;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.IArrayDimensionType;
import org.eclipse.cdt.debug.edc.internal.symbols.IAggregate;
import org.eclipse.cdt.debug.edc.internal.symbols.IArrayBoundType;
import org.eclipse.cdt.debug.edc.internal.symbols.IArrayType;
import org.eclipse.cdt.debug.edc.internal.symbols.ICompositeType;
import org.eclipse.cdt.debug.edc.internal.symbols.IConstType;
import org.eclipse.cdt.debug.edc.internal.symbols.IForwardTypeReference;
import org.eclipse.cdt.debug.edc.internal.symbols.IPointerType;
import org.eclipse.cdt.debug.edc.internal.symbols.IQualifierType;
import org.eclipse.cdt.debug.edc.internal.symbols.IReferenceType;
import org.eclipse.cdt.debug.edc.internal.symbols.ISubroutineType;
import org.eclipse.cdt.debug.edc.internal.symbols.ITypedef;
import org.eclipse.cdt.debug.edc.symbols.IType;

public class TypeUtils {
    public static final int BASIC_TYPE_CHAR = 1;
    public static final int BASIC_TYPE_CHAR_UNSIGNED = 2;
    public static final int BASIC_TYPE_CHAR_SIGNED = 3;
    public static final int BASIC_TYPE_SHORT = 4;
    public static final int BASIC_TYPE_SHORT_UNSIGNED = 5;
    public static final int BASIC_TYPE_INT = 6;
    public static final int BASIC_TYPE_INT_UNSIGNED = 7;
    public static final int BASIC_TYPE_LONG = 8;
    public static final int BASIC_TYPE_LONG_UNSIGNED = 9;
    public static final int BASIC_TYPE_LONG_LONG = 10;
    public static final int BASIC_TYPE_LONG_LONG_UNSIGNED = 11;
    public static final int BASIC_TYPE_FLOAT = 12;
    public static final int BASIC_TYPE_FLOAT_COMPLEX = 13;
    public static final int BASIC_TYPE_DOUBLE = 14;
    public static final int BASIC_TYPE_DOUBLE_COMPLEX = 15;
    public static final int BASIC_TYPE_LONG_DOUBLE = 16;
    public static final int BASIC_TYPE_LONG_DOUBLE_COMPLEX = 17;
    public static final int BASIC_TYPE_BOOL = 18;
    public static final int BASIC_TYPE_BOOL_C9X = 19;
    public static final int BASIC_TYPE_WCHAR_T = 20;
    public static final int BASIC_TYPE_POINTER = 21;

    public static boolean isPointerType(IType type) {
        return TypeUtils.getStrippedType(type) instanceof IPointerType;
    }

    public static boolean isReferenceType(IType type) {
        return TypeUtils.getStrippedType(type) instanceof IReferenceType;
    }

    public static boolean isAggregateType(IType type) {
        return TypeUtils.getStrippedType(type) instanceof IAggregate;
    }

    public static boolean isCompositeType(IType type) {
        return TypeUtils.getStrippedType(type) instanceof ICompositeType;
    }

    public static boolean isConstType(IType type) {
        if (type instanceof IForwardTypeReference) {
            type = ((IForwardTypeReference)type).getReferencedType();
        }
        while (type instanceof ITypedef || type instanceof IQualifierType || type instanceof IReferenceType || type instanceof IArrayType) {
            if (type instanceof IConstType) {
                return true;
            }
            if (!((type = type.getType()) instanceof IForwardTypeReference)) continue;
            type = ((IForwardTypeReference)type).getReferencedType();
        }
        return false;
    }

    public static IType getStrippedType(IType type) {
        if (type instanceof IForwardTypeReference) {
            type = ((IForwardTypeReference)type).getReferencedType();
        }
        while (type instanceof ITypedef || type instanceof IQualifierType) {
            if (!((type = type.getType()) instanceof IForwardTypeReference)) continue;
            type = ((IForwardTypeReference)type).getReferencedType();
        }
        return type;
    }

    public static IType getUnRefStrippedType(IType type) {
        if (type instanceof IForwardTypeReference) {
            type = ((IForwardTypeReference)type).getReferencedType();
        }
        while (type instanceof ITypedef || type instanceof IQualifierType || type instanceof IReferenceType) {
            if (!((type = type.getType()) instanceof IForwardTypeReference)) continue;
            type = ((IForwardTypeReference)type).getReferencedType();
        }
        return type;
    }

    public static IType getBaseType(Object type) {
        if (!(type instanceof IType)) {
            return null;
        }
        if (type instanceof IForwardTypeReference) {
            type = ((IForwardTypeReference)type).getReferencedType();
        }
        while (type instanceof ITypedef || type instanceof IQualifierType || type instanceof IPointerType) {
            if (!((type = ((IType)type).getType()) instanceof IForwardTypeReference)) continue;
            type = ((IForwardTypeReference)type).getReferencedType();
        }
        return (IType)type;
    }

    public static IType getBaseTypePreservingTypedef(IType type) {
        if (type instanceof IForwardTypeReference) {
            type = ((IForwardTypeReference)type).getReferencedType();
        }
        while (type instanceof IQualifierType || type instanceof IPointerType || type instanceof IArrayType) {
            if (!((type = type.getType()) instanceof IForwardTypeReference)) continue;
            type = ((IForwardTypeReference)type).getReferencedType();
        }
        return type;
    }

    public static Number extractBitField(Number value, int byteSize, int bitSize, int bitOffset, boolean isSignedInt) {
        if (bitSize <= 0 || value == null || !(value instanceof Long) && !(value instanceof Integer) && !(value instanceof BigInteger)) {
            return value;
        }
        if (value instanceof Long) {
            long longValue = (Long)value;
            longValue >>= byteSize * 8 - (bitOffset + bitSize);
            if (isSignedInt && ((longValue &= (long)(-1 >>> 64 - bitSize)) & (long)(1 << bitSize - 1)) != 0L) {
                longValue |= (long)(-1 >>> bitSize << bitSize);
            }
            return new Long(longValue);
        }
        if (value instanceof Integer) {
            int intValue = (Integer)value;
            intValue >>= byteSize * 8 - (bitOffset + bitSize);
            if (isSignedInt && ((intValue &= -1 >>> 32 - bitSize) & 1 << bitSize - 1) != 0) {
                intValue |= -1 >>> bitSize << bitSize;
            }
            return new Integer(intValue);
        }
        if (value instanceof BigInteger) {
            BigInteger bigValue = (BigInteger)value;
            bigValue = bigValue.shiftRight(byteSize * 8 - (bitOffset + bitSize));
            byte[] bytes = new byte[8];
            int mask = -1 >>> 32 - bitSize;
            int i = 0;
            while (i < 8) {
                bytes[i] = (byte)(mask >>> (7 - i) * 8 & 0xFF);
                ++i;
            }
            BigInteger bigMask = new BigInteger(bytes);
            bigValue = bigValue.and(bigMask);
            if (isSignedInt && bigValue.testBit(bitSize - 1)) {
                mask = -1 >>> bitSize << bitSize;
                i = 0;
                while (i < 8) {
                    bytes[i] = (byte)(mask >>> (7 - i) * 8 & 0xFF);
                    ++i;
                }
                bigMask = new BigInteger(bytes);
                bigValue = bigValue.or(bigMask);
            }
            return bigValue;
        }
        return value;
    }

    public static String getFullTypeName(IType type) {
        if (type == null) {
            return "";
        }
        if (type instanceof IReferenceType) {
            return String.valueOf(TypeUtils.getFullTypeName(((IReferenceType)type).getType())) + " &";
        }
        if (type instanceof IPointerType) {
            IType pointedTo = ((IPointerType)type).getType();
            if (pointedTo instanceof ISubroutineType) {
                return "(*)(...)";
            }
            return String.valueOf(TypeUtils.getFullTypeName(pointedTo)) + " *";
        }
        if (type instanceof IArrayType) {
            IArrayType arrayType = (IArrayType)type;
            IType subtype = null;
            String dimensions = "";
            do {
                IArrayBoundType[] iArrayBoundTypeArray = arrayType.getBounds();
                int n = iArrayBoundTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IArrayBoundType bound = iArrayBoundTypeArray[n2];
                    dimensions = String.valueOf(dimensions) + "[" + bound.getBoundCount() + "]";
                    ++n2;
                }
                subtype = TypeUtils.getStrippedType(arrayType.getType());
                if (!(subtype instanceof IArrayType)) continue;
                arrayType = (IArrayType)subtype;
            } while (subtype instanceof IArrayType);
            return String.valueOf(TypeUtils.getFullTypeName(arrayType.getType())) + dimensions;
        }
        if (type instanceof IArrayDimensionType) {
            IArrayDimensionType arrayDimensionType = (IArrayDimensionType)((Object)type);
            IArrayType arrayType = arrayDimensionType.getArrayType();
            String returnType = TypeUtils.getFullTypeName(arrayType.getType());
            IArrayBoundType[] bounds = arrayType.getBounds();
            int i = arrayDimensionType.getDimensionCount();
            while (i < arrayType.getBoundsCount()) {
                returnType = String.valueOf(returnType) + "[" + bounds[i].getBoundCount() + "]";
                ++i;
            }
            return returnType;
        }
        if (type instanceof ITypedef) {
            return ((ITypedef)type).getName();
        }
        if (type instanceof ICompositeType) {
            return ((ICompositeType)type).getName();
        }
        if (type instanceof IQualifierType) {
            return String.valueOf(((IQualifierType)type).getName()) + " " + TypeUtils.getFullTypeName(((IQualifierType)type).getType());
        }
        if (type instanceof ISubroutineType) {
            return TypeUtils.getFullTypeName(((ISubroutineType)type).getType());
        }
        return String.valueOf(type.getName()) + TypeUtils.getFullTypeName(type.getType());
    }
}

