/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.location;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.osgi.internal.location.Locker;
import org.eclipse.osgi.internal.location.Locker_JavaIo;
import org.eclipse.osgi.internal.location.Locker_JavaNio;

public class LocationHelper {
    public static final String PROP_OSGI_LOCKING = "osgi.locking";
    public static final String LOCKING_NONE = "none";
    public static final String LOCKING_IO = "java.io";
    public static final String LOCKING_NIO = "java.nio";

    public static URL buildURL(String spec, boolean trailingSlash) {
        if (spec == null) {
            return null;
        }
        if (File.separatorChar == '\\') {
            spec = spec.trim();
        }
        boolean isFile = spec.startsWith("file:");
        try {
            if (isFile) {
                return LocationHelper.adjustTrailingSlash(new File(spec.substring(5)).toURL(), trailingSlash);
            }
            return new URL(spec);
        }
        catch (MalformedURLException malformedURLException) {
            if (isFile) {
                return null;
            }
            try {
                return LocationHelper.adjustTrailingSlash(new File(spec).toURL(), trailingSlash);
            }
            catch (MalformedURLException malformedURLException2) {
                return null;
            }
        }
    }

    private static URL adjustTrailingSlash(URL url, boolean trailingSlash) throws MalformedURLException {
        String file = url.getFile();
        if (trailingSlash == file.endsWith("/")) {
            return url;
        }
        file = trailingSlash ? String.valueOf(file) + "/" : file.substring(0, file.length() - 1);
        return new URL(url.getProtocol(), url.getHost(), file);
    }

    public static Locker createLocker(File lock, String lockMode, boolean debug) {
        if (lockMode == null) {
            lockMode = System.getProperty(PROP_OSGI_LOCKING);
        }
        if (LOCKING_NONE.equals(lockMode)) {
            return new Locker.MockLocker();
        }
        if (LOCKING_IO.equals(lockMode)) {
            return new Locker_JavaIo(lock);
        }
        if (LOCKING_NIO.equals(lockMode)) {
            return new Locker_JavaNio(lock, debug);
        }
        return new Locker_JavaNio(lock, debug);
    }
}

