/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.opengl.data.DB;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.database.SqlConnectionManager;
import org.tizen.dynamicanalyzer.ui.opengl.data.GLDataManager;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLStateTextureType;
import org.tizen.dynamicanalyzer.util.Logger;

public class GLStateTextureDBTableManager
extends DBTable {
    private static final String TABLENAME = "GL_TEXTURE";
    public static final String CONTEXT_ID = "CONTEXT_ID";
    public static final String CHANGE_SEQ = "CHANGE_SEQUENCE_NUMBER";
    public static final String TEXTURE_UNIT_TYPE = "TEXTURE_UNIT_TYPE";
    public static final String TEXTURE_OBJ_ID = "TEXTURE_OBJ_ID";
    public static final String TEXTURE_OBJ_MAG_FUNC = "TEXTURE_OBJ_MAG_FUNC";
    public static final String TEXTURE_OBJ_MIN_FUNC = "TEXTURE_OBJ_MIN_FUNC";
    public static final String TEXTURE_OBJ_WRAP_S = "TEXTURE_OBJ_WRAP_S";
    public static final String TEXTURE_OBJ_WRAP_T = "TEXTURE_OBJ_WRAP_T";
    public static final int TABLE_CONTEXT_ID_INDEX = 0;
    public static final int TABLE_CHANGE_SEQ_INDEX = 1;
    public static final int TABLE_TEXTURE_UNIT_TYPE_INDEX = 2;
    public static final int TABLE_TEXTURE_OBJ_ID_INDEX = 3;
    public static final int TABLE_TEXTURE_OBJ_MAG_FUNC_INDEX = 4;
    public static final int TABLE_TEXTURE_OBJ_MIN_FUNC_INDEX = 5;
    public static final int TABLE_TEXTURE_OBJ_WRAP_S_INDEX = 6;
    public static final int TABLE_TEXTURE_OBJ_WRAP_T_INDEX = 7;
    private static final String SELECT_QUERY = "select CONTEXT_ID,CHANGE_SEQUENCE_NUMBER,TEXTURE_UNIT_TYPE,TEXTURE_OBJ_ID,TEXTURE_OBJ_MAG_FUNC,TEXTURE_OBJ_MIN_FUNC,TEXTURE_OBJ_WRAP_S,TEXTURE_OBJ_WRAP_T from GL_TEXTURE";

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    public GLStateTextureDBTableManager() {
        this.addColumn(new DBColumn(CONTEXT_ID, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(CHANGE_SEQ, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(TEXTURE_UNIT_TYPE, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(TEXTURE_OBJ_ID, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(TEXTURE_OBJ_MAG_FUNC, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(TEXTURE_OBJ_MIN_FUNC, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(TEXTURE_OBJ_WRAP_S, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(TEXTURE_OBJ_WRAP_T, "NOT NULL", "INTEGER"));
    }

    public void insertData(GLStateTextureType data) {
        ArrayList<List<Object>> insertList = new ArrayList<List<Object>>();
        ArrayList<Number> objectList = new ArrayList<Number>();
        objectList.add(data.getContextID());
        objectList.add(data.getSeq());
        objectList.add(data.getType());
        objectList.add(data.getObjID());
        objectList.add(data.getMagFilter());
        objectList.add(data.getMinFilter());
        objectList.add(data.getWrapS());
        objectList.add(data.getWrapT());
        insertList.add(objectList);
        this.insertData(insertList);
    }

    public void initTextureDataAtOpen() {
        List<GLStateTextureType> selectedList = this.select();
        if (selectedList == null) {
            return;
        }
        for (GLStateTextureType type : selectedList) {
            GLDataManager.getInstance().getStateDataManager().getTextureMakeObject().addTextureList(type);
        }
    }

    public void insertTextureData() {
        List<GLStateTextureType> insertList = GLDataManager.getInstance().getStateDataManager().getTextureMakeObject().getTextureList();
        for (GLStateTextureType type : insertList) {
            this.insertData(type);
        }
    }

    public List<GLStateTextureType> select() {
        ResultSet rs = SqlConnectionManager.executeQueryRS(SELECT_QUERY);
        if (rs == null) {
            SqlConnectionManager.releaseResultSet(rs);
            return null;
        }
        ArrayList<GLStateTextureType> textureList = new ArrayList<GLStateTextureType>();
        try {
            while (rs.next()) {
                long contextID = rs.getLong(1);
                long seq = rs.getLong(2);
                int unitType = rs.getInt(3);
                int textureId = rs.getInt(4);
                int magFilter = rs.getInt(5);
                int minFilter = rs.getInt(6);
                int wrapS = rs.getInt(7);
                int wrapT = rs.getInt(8);
                GLStateTextureType textureType = new GLStateTextureType(textureId, contextID, seq);
                textureType.setMagFilter(magFilter);
                textureType.setMinFilter(minFilter);
                textureType.setWrapS(wrapS);
                textureType.setWrapT(wrapT);
                textureType.setType(unitType);
                textureList.add(textureType);
            }
            SqlConnectionManager.releaseResultSet(rs);
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
        }
        return textureList;
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                prep.setLong(1, (Long)rowData.get(0));
                prep.setLong(2, (Long)rowData.get(1));
                prep.setInt(3, (Integer)rowData.get(2));
                prep.setInt(4, (Integer)rowData.get(3));
                prep.setInt(5, (Integer)rowData.get(4));
                prep.setInt(6, (Integer)rowData.get(5));
                prep.setInt(7, (Integer)rowData.get(6));
                prep.setInt(8, (Integer)rowData.get(7));
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }
}

